/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.EnrollBillEntryCollection;
import com.kingdee.eas.hr.affair.EnrollBillEntryFactory;
import com.kingdee.eas.hr.affair.EnrollBillEntryInfo;
import com.kingdee.eas.hr.affair.EnrollBillInfo;
import com.kingdee.eas.hr.base.app.AbstractPlugInBean;
import com.kingdee.eas.hr.rec.PersonStateEnum;
import com.kingdee.eas.hr.rec.ResumeStateEnum;
import com.kingdee.eas.hr.rec.util.ResumeEntryHelper;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class AppEnrollBillPlugInBean
extends AbstractPlugInBean {
    private Logger logger = Logger.getLogger(AppEnrollBillPlugInBean.class);

    public void afterAddnew() throws BOSException, EASBizException {
        if (!this.isMethod(new Class[]{Context.class, IObjectValue.class})) {
            return;
        }
        Object[] param = this.plugInParam.getCurrentMethod().getParams();
        EnrollBillInfo info = null;
        Context ctx = null;
        if (param != null) {
            info = (EnrollBillInfo)param[1];
            ctx = (Context)param[0];
        }
        if (info != null && info.isIsFromResume()) {
            try {
                ResumeEntryHelper.setBillToResume(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (List)info.get("resumeIds"));
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            this.logger.info((Object)("Anti-write EnrollBill ID : '" + info.getId() + "' to the resume [" + (List)info.get("resumeIds") + "]"));
        }
    }

    private void personStateComplete(Context ctx, EnrollBillInfo info) throws BOSException, EASBizException {
        String sql = null;
        boolean flag = false;
        if (info != null && info.isIsFromResume()) {
            EnrollBillEntryCollection entries = info.getEntries();
            if (entries != null && !entries.isEmpty()) {
                HashSet<String> rsSet = new HashSet<String>();
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    Date createPersonDate;
                    EnrollBillEntryInfo entry = entries.get(i);
                    Date now = new Date();
                    if (entry == null || (createPersonDate = entry.getEnrollDate()) == null) continue;
                    if (entry.getResumeId() != null && entry.getResumeId().trim().length() != 0) {
                        rsSet.add(entry.getResumeId().trim());
                    }
                    if (now.before(createPersonDate)) {
                        sql = "update T_HR_ResumeBase set FPersonState = 2,FResumeState = 7";
                        continue;
                    }
                    flag = true;
                    sql = "update T_HR_ResumeBase set FPersonState = 3,FResumeState = 6";
                }
                if (rsSet.size() > 0) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", rsSet, CompareType.INCLUDE));
                    if (sql != null) {
                        sql = sql + " where f" + filter.toSql();
                        DbUtil.execute((Context)ctx, (String)sql);
                    }
                    DbUtil.execute((Context)ctx, sql);
                }
            }
            if (!flag) {
                this.logger.info((Object)("After EnrollBill Entry  Effect : '" + info.getId() + "' ResumeState AS " + (Object)((Object)ResumeStateEnum.entrying) + " ,PersonState AS " + (Object)((Object)PersonStateEnum.confirm)));
            } else {
                this.logger.info((Object)("After EnrollBill Entry  Effect : '" + info.getId() + "' ResumeState AS " + (Object)((Object)ResumeStateEnum.entryed) + " ,PersonState AS " + (Object)((Object)PersonStateEnum.entryed)));
            }
        }
    }

    public void afterDelete() throws BOSException, EASBizException {
        Object[] param = this.plugInParam.getCurrentMethod().getParams();
        Context ctx = null;
        ObjectUuidPK pk = null;
        if (param != null) {
            ctx = (Context)param[0];
            pk = new ObjectUuidPK(param[1].toString());
        }
        this.updateResumeOnEnrollBillDeleted(ctx, (IObjectPK)pk);
    }

    private void updateResumeOnEnrollBillDeleted(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        if (billId != null) {
            try {
                ResumeEntryHelper.updateResumeOnEnrollBillDeleted(ctx, billId);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            this.logger.info((Object)("After EnrollBill Delete : '" + billId + "' ResumeState AS " + (Object)((Object)ResumeStateEnum.pass) + " ,PersonState AS " + (Object)((Object)PersonStateEnum.noEntry)));
        }
    }

    public void afterEntryEffect() throws BOSException, EASBizException {
        Object[] param = this.plugInParam.getCurrentMethod().getParams();
        Context ctx = null;
        BOSUuid entryID = null;
        if (param != null) {
            ctx = (Context)param[0];
            entryID = (BOSUuid)param[1];
        }
        if (entryID != null) {
            EnrollBillInfo info = EnrollBillEntryFactory.getLocalInstance(ctx).getEnrollBillEntryInfo((IObjectPK)new ObjectUuidPK(entryID)).getBill();
            this.personStateComplete(ctx, info);
        }
    }
}

