/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.FluctuationBillEntryCollection;
import com.kingdee.eas.hr.affair.FluctuationBillEntryInfo;
import com.kingdee.eas.hr.affair.FluctuationBillFactory;
import com.kingdee.eas.hr.affair.FluctuationBillInfo;
import com.kingdee.eas.hr.base.app.AbstractPlugInBean;
import com.kingdee.eas.hr.rec.PersonStateEnum;
import com.kingdee.eas.hr.rec.ResumeStateEnum;
import com.kingdee.eas.hr.rec.util.ResumeEntryHelper;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class AppFluctuationBillPlugInBean
extends AbstractPlugInBean {
    private Logger logger = Logger.getLogger(AppFluctuationBillPlugInBean.class);

    public void afterAddnew() throws BOSException, EASBizException {
        FluctuationBillEntryCollection entries;
        if (!this.isMethod(new Class[]{Context.class, IObjectValue.class})) {
            return;
        }
        Object[] param = this.plugInParam.getCurrentMethod().getParams();
        FluctuationBillInfo info = null;
        Context ctx = null;
        if (param != null) {
            info = (FluctuationBillInfo)param[1];
            ctx = (Context)param[0];
        }
        if (info != null && info.isIsChangesWorkFlow() && (entries = info.getEntries()) != null) {
            HashSet<String> rsSet = new HashSet<String>();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                FluctuationBillEntryInfo entry = entries.get(i);
                if (entry.getResumeBaseID() == null || entry.getResumeBaseID().trim().length() == 0) continue;
                rsSet.add(entry.getResumeBaseID().trim());
            }
            if (rsSet.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", rsSet, CompareType.INCLUDE));
                String sql = "update T_HR_ResumeBase set FEnrollBillId = '" + info.getId() + "', FPersonState = " + 6 + ",FResumeState = " + 9 + " where f" + filter.toSql();
                DbUtil.execute((Context)ctx, (String)sql);
            }
            this.logger.info((Object)("Anti-write FluctuationBill ID : '" + info.getId() + "' to the resume [" + rsSet + "]"));
        }
    }

    private void personStateComplete(Context ctx, FluctuationBillInfo info) throws BOSException, EASBizException {
        FluctuationBillEntryCollection entries;
        String sql = null;
        boolean flag = false;
        if (info != null && info.isIsChangesWorkFlow() && (entries = info.getEntries()) != null) {
            HashSet<String> rsSet = new HashSet<String>();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                Date createPersonDate;
                FluctuationBillEntryInfo entry = entries.get(i);
                Date now = new Date();
                if (entry == null || (createPersonDate = entry.getEffectDate()) == null) continue;
                if (entry.getResumeBaseID() != null && entry.getResumeBaseID().trim().length() != 0) {
                    rsSet.add(entry.getResumeBaseID().trim());
                }
                if (now.before(createPersonDate)) {
                    sql = "update T_HR_ResumeBase set FPersonState = 6,FResumeState = 9";
                    continue;
                }
                flag = true;
                sql = "update T_HR_ResumeBase set FPersonState = 7,FResumeState = 10";
            }
            if (rsSet.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", rsSet, CompareType.INCLUDE));
                if (sql != null) {
                    sql = sql + " where f" + filter.toSql();
                    DbUtil.execute((Context)ctx, (String)sql);
                }
            }
            if (!flag) {
                this.logger.info((Object)("Modify ResumeBaseInfo : '" + rsSet + "' PersonState AS " + (Object)((Object)PersonStateEnum.onChanging) + "\uff0c ResumeState AS " + (Object)((Object)ResumeStateEnum.onChanging)));
            } else {
                this.logger.info((Object)("Modify ResumeBaseInfo : '" + rsSet + "' PersonState AS " + (Object)((Object)PersonStateEnum.changed) + "\uff0c ResumeState AS " + (Object)((Object)ResumeStateEnum.changed)));
            }
        }
    }

    public void afterDelete() throws BOSException, EASBizException {
        Object[] param = this.plugInParam.getCurrentMethod().getParams();
        Context ctx = null;
        ObjectUuidPK pk = null;
        if (param != null) {
            ctx = (Context)param[0];
            pk = new ObjectUuidPK(param[1].toString());
        }
        this.updateResumeOnFluctuationBillDeleted(ctx, (IObjectPK)pk);
    }

    private void updateResumeOnFluctuationBillDeleted(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        if (billId != null) {
            try {
                ResumeEntryHelper.updateResumeOnEnrollBillDeleted(ctx, billId);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            this.logger.info((Object)("After FluctuationBill Delete : '" + billId + "' ResumeState AS " + (Object)((Object)ResumeStateEnum.pass) + " ,PersonState AS " + (Object)((Object)PersonStateEnum.noEntry)));
        }
    }

    public void afterBatchPassAudit() throws BOSException, EASBizException {
        Object[] param = this.plugInParam.getCurrentMethod().getParams();
        Context ctx = null;
        String entryID = null;
        if (param != null) {
            ctx = (Context)param[0];
            if (param[1] != null) {
                entryID = ((String[])param[1])[0].toString();
            }
        }
        if (entryID != null) {
            FluctuationBillInfo info = FluctuationBillFactory.getLocalInstance(ctx).getFluctuationBillInfo((IObjectPK)new ObjectUuidPK(entryID));
            this.personStateComplete(ctx, info);
        }
    }
}

