/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.FluctuationBizBillEntryCollection;
import com.kingdee.eas.hr.affair.FluctuationBizBillEntryInfo;
import com.kingdee.eas.hr.affair.FluctuationBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.app.AbstractPlugInBean;
import com.kingdee.eas.hr.rec.HRRecState;
import com.kingdee.eas.hr.rec.IRequireApplyBill;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.InterviewActivityEntryCollection;
import com.kingdee.eas.hr.rec.InterviewActivityEntryFactory;
import com.kingdee.eas.hr.rec.InterviewActivityEntryInfo;
import com.kingdee.eas.hr.rec.PersonStateEnum;
import com.kingdee.eas.hr.rec.RequireApplyBillCollection;
import com.kingdee.eas.hr.rec.RequireApplyBillEntryCollection;
import com.kingdee.eas.hr.rec.RequireApplyBillEntryFactory;
import com.kingdee.eas.hr.rec.RequireApplyBillEntryInfo;
import com.kingdee.eas.hr.rec.RequireApplyBillFactory;
import com.kingdee.eas.hr.rec.RequireApplyBillInfo;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeStateEnum;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AppFluctuationPlugInBean
extends AbstractPlugInBean {
    private Logger logger = Logger.getLogger(AppFluctuationPlugInBean.class);

    public void beforeAddnew() throws BOSException, EASBizException {
        if (!this.isMethod(new Class[]{Context.class, IObjectValue.class})) {
            return;
        }
        Object[] param = this.plugInParam.getCurrentMethod().getParams();
        FluctuationBizBillInfo info = null;
        if (param != null) {
            info = (FluctuationBizBillInfo)param[1];
        }
        if (info != null) {
            FluctuationBizBillEntryCollection entrys = info.getEntrys();
            FluctuationBizBillEntryInfo entryInfo2 = null;
            if (entrys != null && !entrys.isEmpty()) {
                for (FluctuationBizBillEntryInfo entryInfo2 : entrys) {
                    if ("FROM_INTER_RECRUITMENT".equals(entryInfo2.get("isInter"))) continue;
                    info.remove("PersonID");
                    break;
                }
            }
        }
    }

    public void afterAddnew() throws BOSException, EASBizException {
        if (!this.isMethod(new Class[]{Context.class, IObjectValue.class})) {
            return;
        }
        Object[] param = this.plugInParam.getCurrentMethod().getParams();
        FluctuationBizBillInfo info = null;
        Context ctx = null;
        if (param != null) {
            info = (FluctuationBizBillInfo)param[1];
            ctx = (Context)param[0];
        }
        Map rsMap = null;
        if (info != null) {
            rsMap = info.get("PersonID") != null ? (Map)info.get("PersonID") : null;
        }
        ArrayList rsIdsForPerson = new ArrayList();
        if (rsMap != null && !rsMap.isEmpty()) {
            Iterator it = rsMap.keySet().iterator();
            while (it.hasNext()) {
                rsIdsForPerson.add(it.next());
            }
        }
        if (info != null && !rsIdsForPerson.isEmpty()) {
            this.setBillToResume(ctx, info, rsIdsForPerson);
            this.logger.info((Object)("Anti-write FluctuationBizBill ID : '" + info.getId() + "' to the resume [" + rsIdsForPerson + "]"));
        }
    }

    public void after_setBillState(Context ctx, BOSUuid billID, HRBillStateEnum state) throws BOSException, EASBizException {
        if (billID != null && state != null) {
            IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
            EntityViewInfo evInfo = new EntityViewInfo();
            FilterInfo fInfo = new FilterInfo();
            fInfo.getFilterItems().add(new FilterItemInfo("enrollBillId", (Object)billID));
            evInfo.setFilter(fInfo);
            ResumeBaseCollection rbc = resumeBase.getResumeBaseCollection(evInfo);
            HRAffairState hrAffaState = AppFluctuationPlugInBean.getHRAffairState(state);
            if (rbc != null && rbc.size() > 0) {
                for (int i = 0; i < rbc.size(); ++i) {
                    ResumeBaseInfo info = rbc.get(i);
                    PersonStateEnum oldPersonState = info.getPersonState();
                    if (hrAffaState.equals((Object)HRAffairState.APPROVE)) {
                        this.changeReusmePersonState(ctx, info, PersonStateEnum.onChanging);
                        continue;
                    }
                    if (hrAffaState.equals((Object)HRAffairState.STOP)) {
                        this.changeReusmePersonState(ctx, info, PersonStateEnum.unChanged);
                        continue;
                    }
                    if (!hrAffaState.equals((Object)HRAffairState.EDIT)) continue;
                    this.changeReusmePersonState(ctx, info, PersonStateEnum.edit);
                }
            }
        }
    }

    private static HRAffairState getHRAffairState(HRBillStateEnum state) {
        if (HRBillStateEnum.SAVED.equals((Object)state)) {
            return HRAffairState.TEMP;
        }
        if (HRBillStateEnum.AUDITING.equals((Object)state)) {
            return HRAffairState.APPROVE;
        }
        if (HRBillStateEnum.AUDITED.equals((Object)state)) {
            return HRAffairState.COMPLETE;
        }
        if (HRBillStateEnum.AUDITEND.equals((Object)state)) {
            return HRAffairState.STOP;
        }
        if (HRBillStateEnum.SUBMITED.equals((Object)state)) {
            return HRAffairState.EDIT;
        }
        return null;
    }

    private void changeReusmePersonState(Context ctx, ResumeBaseInfo resumeBaseInfo, PersonStateEnum state) throws BOSException, EASBizException {
        IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
        resumeBaseInfo.setPersonState(state);
        if (state.equals((Object)PersonStateEnum.onChanging)) {
            resumeBaseInfo.setResumeState(ResumeStateEnum.onChanging);
        } else if (state.equals((Object)PersonStateEnum.changed)) {
            resumeBaseInfo.setResumeState(ResumeStateEnum.changed);
        }
        SelectorItemCollection sic = RecServerUtils.getSic(new String[]{"personState", "resumeState"});
        resumeBase.updatePartial((CoreBaseInfo)resumeBaseInfo, sic);
        try {
            boolean paramVal;
            if (state.equals((Object)PersonStateEnum.changed) && (paramVal = AppFluctuationPlugInBean.getParamValue(ctx, "REC006"))) {
                this.setRequireApplyBillState(ctx, resumeBaseInfo);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        this.logger.info((Object)("Modify ResumeBaseInfo : '" + resumeBaseInfo.getName() + "' ResumeState AS " + (Object)((Object)state)));
    }

    public static boolean getParamValue(Context ctx, String number) throws Exception {
        String HRO_ID;
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()), number);
        return "true".equals(val);
    }

    public void after_entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        BOSUuid billId = ((FluctuationBizBillEntryInfo)entry).getBill().getId();
        this.personStateComplete(ctx, (IObjectPK)new ObjectUuidPK(billId));
    }

    private void personStateComplete(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        IResumeBase iResumeBase = ResumeBaseFactory.getLocalInstance(ctx);
        EntityViewInfo evInfo = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("enrollBillId", (Object)billId));
        evInfo.setFilter(fInfo);
        ResumeBaseCollection rbc = iResumeBase.getResumeBaseCollection(evInfo);
        try {
            if (rbc != null && !rbc.isEmpty()) {
                boolean paramVal = AppFluctuationPlugInBean.getParamValue(ctx, "REC006");
                ResumeBaseInfo resumeInfo = null;
                Iterator it = rbc.iterator();
                while (it.hasNext()) {
                    resumeInfo = (ResumeBaseInfo)it.next();
                    resumeInfo.setPersonState(PersonStateEnum.changed);
                    resumeInfo.setResumeState(ResumeStateEnum.changed);
                    SelectorItemCollection sicc = RecServerUtils.getSic(new String[]{"resumeState", "personState"});
                    iResumeBase.updatePartial((CoreBaseInfo)resumeInfo, sicc);
                    if (!paramVal) continue;
                    this.setRequireApplyBillState(ctx, resumeInfo);
                }
                this.logger.info((Object)("After FluctuationBizBill Entry  Effect : '" + billId + "' ResumeState AS " + (Object)((Object)ResumeStateEnum.changed) + " ,PersonState AS " + (Object)((Object)PersonStateEnum.changed)));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    private void setRequireApplyBillState(Context ctx, ResumeBaseInfo resumeInfo) {
        String activityId = resumeInfo.getInterviewActivity().getId().toString();
        String positionId = resumeInfo.getPosition().getId().toString();
        int inviteCompassNumber = this.getInviteCompassNumber(ctx, activityId, positionId);
        Map needMap = this.getRequireNumberByPosition(ctx, activityId, positionId);
        int needNumber = 0;
        if (needMap != null && needMap.get("needNumber") != null && !"".equals(needMap.get("needNumber").toString())) {
            needNumber = Integer.parseInt(needMap.get("needNumber").toString());
        }
        String requrieAppBillNum = "";
        if (needMap != null && needMap.get("requrieAppBillNum") != null) {
            requrieAppBillNum = needMap.get("requrieAppBillNum").toString();
        }
        boolean otherPositionIsEnd = this.getRequrieAppBillOtherPositionEnd(ctx, requrieAppBillNum, positionId);
        if (inviteCompassNumber >= needNumber && !"".equals(requrieAppBillNum) && otherPositionIsEnd) {
            this.setRequireAppBillEnd(ctx, requrieAppBillNum);
        }
    }

    private boolean getRequrieAppBillOtherPositionEnd(Context ctx, String requrieAppBillNum, String positionId) {
        if (!"".equals(requrieAppBillNum)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("sourceNumber", (Object)requrieAppBillNum));
            view.setFilter(filter);
            try {
                RequireApplyBillEntryCollection entryCol = this.getRequrieAppBillEntryByPositionAndNumber(ctx, positionId, requrieAppBillNum);
                if (entryCol == null || entryCol.size() == 0) {
                    return true;
                }
                InterviewActivityEntryCollection ActivityEntryCol = InterviewActivityEntryFactory.getLocalInstance(ctx).getInterviewActivityEntryCollection(view);
                if (ActivityEntryCol == null || ActivityEntryCol.size() == 0) {
                    return false;
                }
                for (int i = 0; i < ActivityEntryCol.size(); ++i) {
                    InterviewActivityEntryInfo entryInfo = ActivityEntryCol.get(i);
                    String activityId = entryInfo.getInterviewActivity().getId().toString();
                    String positiontempId = entryInfo.getPosition().getId().toString();
                    int inviteCompassNumber = this.getInviteCompassNumber(ctx, activityId, positiontempId);
                    Map needMap = this.getRequireNumberByPosition(ctx, activityId, positiontempId);
                    int needNumber = 0;
                    if (needMap != null && needMap.get("needNumber") != null && !"".equals(needMap.get("needNumber").toString())) {
                        needNumber = Integer.parseInt(needMap.get("needNumber").toString());
                    }
                    if (needNumber <= inviteCompassNumber) continue;
                    return false;
                }
            }
            catch (BOSException e) {
                this.logger.error((Object)e);
            }
        } else {
            return false;
        }
        return true;
    }

    private RequireApplyBillEntryCollection getRequrieAppBillEntryByPositionAndNumber(Context ctx, String positionId, String requrieAppBillNum) {
        RequireApplyBillEntryCollection entryCol = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent.number", (Object)requrieAppBillNum));
            view.setFilter(filter);
            entryCol = RequireApplyBillEntryFactory.getLocalInstance(ctx).getRequireApplyBillEntryCollection(view);
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage());
        }
        return entryCol;
    }

    private Map getRequireNumberByPosition(Context ctx, String activityId, String positionId) {
        HashMap<String, String> needMap = new HashMap<String, String>();
        int needNumber = 0;
        String requrieAppBillNum = "";
        try {
            String sql = null;
            sql = "select FAmount,FSourceNumber from T_HR_InterviewActivityEntry where FInterviewActivityId='" + activityId + "' and FPositionId='" + positionId + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                requrieAppBillNum = rowSet.getString("FSourceNumber");
                String requriedAppBillId = "";
                if (requrieAppBillNum != null && !"".equals(requrieAppBillNum)) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)requrieAppBillNum));
                    view.setFilter(filter);
                    RequireApplyBillCollection appCol = RequireApplyBillFactory.getLocalInstance(ctx).getRequireApplyBillCollection(view);
                    if (appCol != null && appCol.size() > 0) {
                        RequireApplyBillInfo appInfo = appCol.get(0);
                        requriedAppBillId = appInfo.getId().toString();
                    }
                }
                if (!"".equals(requriedAppBillId)) {
                    needNumber = this.getNeedNumberByAppBillId(ctx, requriedAppBillId, positionId);
                }
            }
            needMap.put("needNumber", needNumber + "");
            needMap.put("requrieAppBillNum", requrieAppBillNum);
        }
        catch (BOSException e) {
            this.logger.error((Object)e);
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)e);
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
        }
        return needMap;
    }

    private int getNeedNumberByAppBillId(Context ctx, String requriedAppBillId, String positionId) {
        int needNumber = 0;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)requriedAppBillId));
        filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId));
        view.setFilter(filter);
        try {
            RequireApplyBillEntryCollection entryCol = RequireApplyBillEntryFactory.getLocalInstance(ctx).getRequireApplyBillEntryCollection(view);
            if (entryCol != null && entryCol.size() > 0) {
                for (int i = 0; i < entryCol.size(); ++i) {
                    RequireApplyBillEntryInfo entryInfo = entryCol.get(i);
                    if (!"".equals(entryInfo.getAdjustNumber() == null ? "" : entryInfo.getAdjustNumber())) {
                        needNumber += Integer.parseInt(entryInfo.getAdjustNumber());
                        continue;
                    }
                    if (entryInfo.getNeedNumber() == 0 || "".equals(entryInfo.getNeedNumber() + "")) continue;
                    needNumber += entryInfo.getNeedNumber();
                }
            }
        }
        catch (BOSException e) {
            this.logger.error((Object)e);
        }
        return needNumber;
    }

    private void setRequireAppBillEnd(Context ctx, String requrieAppBillNum) {
        try {
            IRequireApplyBill appBillFac = RequireApplyBillFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)requrieAppBillNum));
            view.setFilter(filter);
            RequireApplyBillCollection appBillCol = appBillFac.getRequireApplyBillCollection(view);
            if (appBillCol != null && appBillCol.size() > 0) {
                RequireApplyBillInfo appBill = appBillCol.get(0);
                appBill.setBizState(HRRecState.OVER);
                appBillFac.update((IObjectPK)new ObjectUuidPK(appBill.getId().toString()), appBill);
            }
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage());
        }
        catch (EASBizException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    private int getInviteCompassNumber(Context ctx, String activityId, String positionId) {
        int inviteCompassNumber = 0;
        try {
            String sql = null;
            sql = "select count(*) as sum from T_HR_ResumeBase where FinterviewActivityId='" + activityId + "' and FPositionId='" + positionId + "' and ( FpersonState=3 or FpersonState=7 ) ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next() && rowSet.getString("sum") != null && !"".equals(rowSet.getString("sum").toString())) {
                inviteCompassNumber = Integer.parseInt(rowSet.getString("sum").toString());
            }
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage());
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)e.getMessage());
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        return inviteCompassNumber;
    }

    public void after_addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        try {
            FluctuationBizBillInfo info = (FluctuationBizBillInfo)model;
            FluctuationBizBillEntryCollection entryCollection = info.getEntrys();
            for (int i = 0; i < entryCollection.size(); ++i) {
                String sql = "update T_HR_ResumeBase set FEnrollBillId = '" + info.getId() + "', FPersonState = " + 6 + ",FResumeState = " + 9 + " where fpersonid='" + entryCollection.get(i).getPerson().getId() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    public void after_delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.updateResumeOnFluctuationBillDeleted(ctx, pk);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    private void setBillToResume(Context ctx, FluctuationBizBillInfo flucInfo, List resumeIds) throws BOSException, EASBizException {
        if (flucInfo != null && flucInfo instanceof FluctuationBizBillInfo && resumeIds != null && resumeIds.size() > 0) {
            IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = RecServerUtils.getSic(new String[]{"enrollBillId", "personState", "resumeState", "inFluctuationResumeID"});
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            HashSet set = new HashSet(resumeIds);
            fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            evi.setFilter(fi);
            ResumeBaseCollection resumes = resumeBase.getResumeBaseCollection(evi);
            ResumeStateEnum rState = null;
            PersonStateEnum pState = null;
            if (flucInfo.getBillState().equals((Object)HRBillStateEnum.SUBMITED)) {
                rState = ResumeStateEnum.onChanging;
                pState = PersonStateEnum.onChanging;
            } else if (flucInfo.getBillState().equals((Object)HRBillStateEnum.SAVED)) {
                pState = PersonStateEnum.edit;
            }
            int j = resumes.size();
            for (int i = 0; i < j; ++i) {
                ResumeBaseInfo info = resumes.get(i);
                info.setEnrollBillId(flucInfo.getId().toString());
                if (pState != null) {
                    info.setPersonState(pState);
                }
                info.setInFluctuationResumeID(info.getId());
                if (rState != null) {
                    info.setResumeState(rState);
                }
                resumeBase.updatePartial((CoreBaseInfo)info, sic);
            }
        }
    }

    private void updateResumeOnFluctuationBillDeleted(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        if (billId != null) {
            IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
            EntityViewInfo evInfo = new EntityViewInfo();
            FilterInfo fInfo = new FilterInfo();
            fInfo.getFilterItems().add(new FilterItemInfo("enrollBillId", (Object)billId));
            evInfo.setFilter(fInfo);
            ResumeBaseCollection rbc = resumeBase.getResumeBaseCollection(evInfo);
            if (rbc != null && rbc.size() > 0) {
                for (int i = 0; i < rbc.size(); ++i) {
                    ResumeBaseInfo info = rbc.get(i);
                    info.setEnrollBillId(null);
                    info.setPersonState(PersonStateEnum.noEntry);
                    info.setResumeState(ResumeStateEnum.pass);
                    resumeBase.update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
                }
                this.logger.info((Object)("After FluctuationBizBill Delete : '" + billId + "' ResumeState AS " + (Object)((Object)ResumeStateEnum.pass) + " ,PersonState AS " + (Object)((Object)PersonStateEnum.noEntry)));
            }
        }
    }
}

