/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.affair.IEmpEnrollFromOtherSys;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.PositionRelatedInfo;
import com.kingdee.eas.hr.base.RelatedInfoGetFacadeFactory;
import com.kingdee.eas.hr.rec.HireApplyBillEntryCollection;
import com.kingdee.eas.hr.rec.HireApplyBillEntryFactory;
import com.kingdee.eas.hr.rec.IHireApplyBillEntry;
import com.kingdee.eas.hr.rec.IResumeEntryFacade;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeEntryFacadeFactory;
import com.kingdee.eas.hr.rec.util.ResumeEntryHelper;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ResumeEnroll
implements IEmpEnrollFromOtherSys {
    private static Logger logger = Logger.getLogger(ResumeEnroll.class);
    private ResumeBaseCollection resumes = null;

    public void doWhenAddNewBill(Context ctx, IObjectPK pk, BOSUuid[] sourceIDs) throws BOSException, EASBizException {
        if (sourceIDs == null) {
            return;
        }
        IResumeEntryFacade resumeEntryFacade = ResumeEntryFacadeFactory.getLocalInstance(ctx);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < sourceIDs.length; ++i) {
            list.add(sourceIDs[i].toString());
        }
        resumeEntryFacade.setBillToResume(pk, list);
    }

    public void doWhenDeleteBill(Context ctx, IObjectPK billPk) throws BOSException, EASBizException {
        try {
            ResumeEntryHelper.updateResumeOnEnrollBillDeleted(ctx, billPk);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    public void doWhenEntryEffect(Context ctx, String entryID) throws BOSException, EASBizException {
        IResumeEntryFacade resumeEntryFacade = ResumeEntryFacadeFactory.getLocalInstance(ctx);
        resumeEntryFacade.personStateComplete((IObjectPK)new ObjectUuidPK(entryID));
    }

    public static HRAffairState getHRAffairState(HRBillStateEnum state) {
        if (HRBillStateEnum.SAVED.equals((Object)state)) {
            return HRAffairState.TEMP;
        }
        if (HRBillStateEnum.AUDITING.equals((Object)state)) {
            return HRAffairState.APPROVE;
        }
        if (HRBillStateEnum.AUDITED.equals((Object)state)) {
            return HRAffairState.COMPLETE;
        }
        if (HRBillStateEnum.AUDITEND.equals((Object)state)) {
            return HRAffairState.STOP;
        }
        if (HRBillStateEnum.SUBMITED.equals((Object)state)) {
            return HRAffairState.EDIT;
        }
        return null;
    }

    public void doWhenSetBillState(Context ctx, String billID, HRBillStateEnum state) throws BOSException, EASBizException {
        IResumeEntryFacade resumeEntryFacade = ResumeEntryFacadeFactory.getLocalInstance(ctx);
        resumeEntryFacade.setResumePersonState((IObjectPK)new ObjectUuidPK(billID), ResumeEnroll.getHRAffairState(state));
    }

    public EmpEnrollBizBillInfo getEmpEnrollBizBillInfo() throws Exception {
        return this.convertResumeToEmpEnroll(this.resumes);
    }

    public void setResumes(ResumeBaseCollection resumes) {
        this.resumes = resumes;
    }

    public EmpEnrollBizBillInfo convertResumeToEmpEnroll(ResumeBaseCollection col) throws Exception {
        EmpEnrollBizBillInfo info = new EmpEnrollBizBillInfo();
        if (col == null || col.size() <= 0) {
            return info;
        }
        EmpEnrollBizBillEntryInfo entry = null;
        ResumeBaseInfo resume = null;
        EmpEnrollBizBillEntryCollection entryCol = info.getEntrys();
        String number = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            PositionRelatedInfo pRelatedInfo;
            entry = new EmpEnrollBizBillEntryInfo();
            resume = col.get(i);
            number = this.getNumberForEmpEnrollBizbillEntryInfo();
            entry.setEmpName(resume.getName());
            entry.setEmpNumber(number);
            entry.setGender(resume.getGender());
            entry.setBirthday(resume.getBirthday());
            entry.setIDCardNo(resume.getIdCardNO());
            entry.setPassportNo(resume.getPassportNO());
            entry.setPosition(resume.getPosition());
            if (resume.getPosition() != null) {
                entry.setPosition(resume.getPosition());
                entry.setAdminOrg(resume.getPosition().getAdminOrgUnit());
            } else {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("resumeBase", (Object)resume.getId().toString(), CompareType.EQUALS));
                viewInfo.setFilter(filter);
                viewInfo.getSelector().add(new SelectorItemInfo("hirePosition.*"));
                viewInfo.getSelector().add(new SelectorItemInfo("hirePosition.adminOrgUnit.*"));
                IHireApplyBillEntry hireapplyEntry = HireApplyBillEntryFactory.getRemoteInstance();
                HireApplyBillEntryCollection hireApplyEntryColl = hireapplyEntry.getHireApplyBillEntryCollection(viewInfo);
                if (hireApplyEntryColl.size() > 0) {
                    entry.setPosition(hireApplyEntryColl.get(0).getHirePosition());
                    entry.setAdminOrg(hireApplyEntryColl.get(0).getHirePosition().getAdminOrgUnit());
                }
            }
            if (entry.getPosition() != null && (pRelatedInfo = RelatedInfoGetFacadeFactory.getRemoteInstance().getPositionRelatedInfo(entry.getPosition().getId().toString())) != null) {
                entry.setJob(pRelatedInfo.getJob());
            }
            entry.setDescription(resume.getRemark());
            entry.setResumeID(resume.getId());
            entryCol.add(entry);
        }
        return info;
    }

    public String getNumberForEmpEnrollBizbillEntryInfo() {
        String number = null;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            HROrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentHRUnit();
            String orgUnitId = orgUnit.getId().toString();
            PersonInfo personInfo = new PersonInfo();
            if (codingRuleManager.isExist((IObjectValue)personInfo, orgUnitId)) {
                personInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                if (codingRuleManager.getCodingRule((IObjectValue)personInfo, orgUnitId) != null && Boolean.TRUE.equals(codingRuleManager.getCodingRule((IObjectValue)personInfo, orgUnitId).get("isaddview"))) {
                    number = codingRuleManager.getNumber((IObjectValue)personInfo, orgUnitId);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        return number;
    }
}

