/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.tobacco.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.tobacco.HROrgViewFactory;
import com.kingdee.eas.hr.tobacco.HROrgViewInfo;
import com.kingdee.eas.hr.tobacco.OrgPropertyEnum;
import com.kingdee.eas.hr.tobacco.client.AbstractHROrgViewEditUI;
import com.kingdee.eas.hr.tobacco.client.HROrgViewListUI;
import com.kingdee.eas.hr.tobacco.client.OrgTypePromptBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class HROrgViewEditUI
extends AbstractHROrgViewEditUI {
    private static final Logger logger = CoreUIObject.getLogger(HROrgViewEditUI.class);
    HROrgViewListUI listUI = null;

    public void onLoad() throws Exception {
        HROrgViewInfo hROrgViewInfo;
        String orgId = this.getUIContext().get("hrOrgUnit").toString();
        if (this.getOprtState().equals(OprtState.EDIT) && (hROrgViewInfo = HROrgViewFactory.getRemoteInstance().getHROrgViewInfo(" where hrOrgUnit.id='" + orgId + "'")) != null) {
            this.getUIContext().put("ID", hROrgViewInfo.getId().toString());
        }
        super.onLoad();
        AdminOrgUnitInfo org = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        this.txtName.setText(org.getName());
        this.txtNumber.setText(org.getNumber());
        this.txtSimpleName.setText(org.getSimpleName());
        this.prmtOrgCategory.setRequired(true);
        this.prmtOrgType.setRequired(true);
        this.prmtOrgGrade.setRequired(true);
        this.prmtOrgType.setSelector((KDPromptSelector)new OrgTypePromptBox());
        this.listUI = (HROrgViewListUI)((Object)this.getUIContext().get("ListUI"));
        boolean canEdit = false;
        try {
            SysContext context = SysContext.getSysContext();
            PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(context.getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(context.getCurrentCtrlUnit().getId()), "HRORGVIEW_Update");
            canEdit = true;
        }
        catch (PermissionException pe) {
            canEdit = false;
        }
        if (!canEdit) {
            this.prmtOrgCategory.setEnabled(false);
            this.prmtOrgType.setEnabled(false);
            this.prmtOrgGrade.setEnabled(false);
            this.prmtArea.setEnabled(false);
            this.prmtdepartmentKind.setEnabled(false);
            this.txtAuthorizeOrg.setEnabled(false);
            this.orgProperty.setEnabled(false);
            this.txtFileName.setEnabled(false);
            this.pkAuthorizeDate.setEnabled(false);
            this.txtAddress.setEnabled(false);
            this.txtPostCode.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        }
        if (OprtState.VIEW.equals(this.getUIContext().get("ope"))) {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuEdit.setVisible(false);
        this.menuBiz.setVisible(false);
        if (this.getUIContext().get("OprtState") != null && OprtState.EDIT.equals(this.getUIContext().get("OprtState"))) {
            this.setOprtState(OprtState.VIEW);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        HROrgViewInfo hROrgViewInfo = new HROrgViewInfo();
        String fid = this.getUIContext().get("hrOrgUnit").toString();
        try {
            AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectStringPK(fid));
            hROrgViewInfo.setOrgProperty(OrgPropertyEnum.Department);
            hROrgViewInfo.setHrOrgUnit(adminOrgUnitInfo);
            hROrgViewInfo.setCU(adminOrgUnitInfo.getCU());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return hROrgViewInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return HROrgViewFactory.getRemoteInstance();
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
        try {
            this.listUI.refreshTbl();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.editData.getOrgCategory() == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.contOrgCategory.getBoundLabelText()});
        }
        if (this.editData.getOrgGrade() == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.contOrgGrade.getBoundLabelText()});
        }
        if (this.editData.getOrgType() == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.contOrgType.getBoundLabelText()});
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        SysContext context = SysContext.getSysContext();
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(context.getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(context.getCurrentCtrlUnit().getId()), "HRORGVIEW_Update");
        super.actionSubmit_actionPerformed(e);
    }
}

