/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.tobacco.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.tobacco.HROrgViewFactory;
import com.kingdee.eas.hr.tobacco.HRTobaccoFacadeFactory;
import com.kingdee.eas.hr.tobacco.OrgPropertyEnum;
import com.kingdee.eas.hr.tobacco.client.AbstractHROrgViewListUI;
import com.kingdee.eas.hr.tobacco.client.HROrgViewEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class HROrgViewListUI
extends AbstractHROrgViewListUI {
    private static final Logger logger = CoreUIObject.getLogger(HROrgViewListUI.class);
    private int defaultLevel = 2;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void levelSpinner_stateChanged(ChangeEvent e) throws Exception {
        int level = (Integer)this.levelSpinner.getValue();
        if (level <= 1) {
            this.levelSpinner.setValue((Object)1, false);
        }
        if (level >= 20) {
            this.levelSpinner.setValue((Object)20, false);
        }
        this.setTblData();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.levelSpinner.setValue((Object)this.defaultLevel);
        this.initHRTree();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.initTable();
        this.tblMain.setEditable(false);
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
    }

    public void initHRTree() throws BOSException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("methodName", "getAllHRTreeList");
        List treeList = (List)HRTobaccoFacadeFactory.getRemoteInstance().exeMethod(param);
        if (treeList.size() == 0) {
            DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
            this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        } else {
            HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
            DefaultKingdeeTreeNode rootTreeNode = null;
            for (int i = 0; i < treeList.size(); ++i) {
                String fParentID;
                Map row = (Map)treeList.get(i);
                String fid = row.get("fid").toString();
                String hrName = row.get("hrName") != null ? row.get("hrName").toString() : "";
                Object obj = row.get("FParentID");
                String string = fParentID = obj == null ? null : obj.toString();
                if (rootTreeNode == null) {
                    rootTreeNode = new DefaultKingdeeTreeNode((Object)hrName);
                    rootTreeNode.setUserObject((Object)row);
                    nodeMap.put(fid, rootTreeNode);
                    continue;
                }
                DefaultKingdeeTreeNode subTreeNode = new DefaultKingdeeTreeNode((Object)hrName);
                if (fParentID != null && nodeMap.containsKey(fParentID)) {
                    ((DefaultKingdeeTreeNode)nodeMap.get(fParentID)).add((MutableTreeNode)subTreeNode);
                }
                subTreeNode.setUserObject((Object)row);
                nodeMap.put(fid, subTreeNode);
            }
            this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootTreeNode));
            this.treeMain.setShowsRootHandles(true);
        }
    }

    public void initTable() {
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            this.setTblData(selectNode);
        } else {
            this.setTblData((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
        }
    }

    @Override
    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            this.setTblData(selectNode);
        }
    }

    private void setTblData(DefaultKingdeeTreeNode selectNode) {
        int level = (Integer)this.levelSpinner.getValue();
        this.tblMain.removeRows();
        ArrayList rowList = new ArrayList();
        this.getAllChild(selectNode, level, rowList);
        for (int i = 0; i < rowList.size(); ++i) {
            Map row = (Map)rowList.get(i);
            IRow iRow = this.tblMain.addRow();
            this.setRowData(iRow, row);
        }
    }

    private void setTblData() {
        TreePath path = this.treeMain.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        int level = (Integer)this.levelSpinner.getValue();
        this.tblMain.removeRows();
        ArrayList rowList = new ArrayList();
        this.getAllChild(selectNode, level, rowList);
        for (int i = 0; i < rowList.size(); ++i) {
            Map row = (Map)rowList.get(i);
            IRow iRow = this.tblMain.addRow();
            this.setRowData(iRow, row);
        }
    }

    private void getAllChild(DefaultKingdeeTreeNode node, int level, List list) {
        list.add(node.getUserObject());
        if (level == 0 || level == 1 || node.getLevel() >= level) {
            return;
        }
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultKingdeeTreeNode tNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            tNode.setUserObject(tNode.getUserObject());
            this.getAllChild(tNode, level - 1, list);
        }
    }

    private void setRowData(IRow iRow, Map row) {
        iRow.getCell("id").setValue(row.get("fid"));
        iRow.getCell("number").setValue(row.get("fnumber"));
        iRow.getCell("name").setValue(row.get("hrName"));
        iRow.getCell("orgCategory").setValue(row.get("orgCName"));
        iRow.getCell("orgType").setValue(row.get("orgTName"));
        iRow.getCell("orgGrade").setValue(row.get("orgGName"));
        iRow.getCell("area").setValue(row.get("areaName"));
        iRow.getCell("authorizeDate").setValue(row.get("FAuthorizeDate"));
        iRow.getCell("authorizeOrg").setValue(row.get("FAuthorizeOrg"));
        iRow.getCell("postCode").setValue(row.get("fPostCode"));
        iRow.getCell("address").setValue(row.get("fAddress"));
        iRow.getCell("fileName").setValue(row.get("FFileName"));
        OrgPropertyEnum orgPropEnum = null;
        orgPropEnum = row.get("FOrgProperty") == null ? OrgPropertyEnum.Department : OrgPropertyEnum.getEnum(row.get("FOrgProperty").toString());
        iRow.getCell("orgProperty").setValue((Object)orgPropEnum.getAlias());
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            KDTSelectBlock block = this.tblMain.getSelectManager().get();
            IRow iRow = this.tblMain.getRow(block.getBeginRow());
            String id = iRow.getCell("id").getValue().toString();
            boolean exist = HROrgViewFactory.getRemoteInstance().exists(" where hrOrgUnit.id='" + id + "'");
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"hrOrgUnit", (Object)id);
            uiContext.put((Object)"ListUI", (Object)this);
            String oprtState = exist ? OprtState.EDIT : OprtState.ADDNEW;
            uiContext.put((Object)"OprtState", (Object)oprtState);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(HROrgViewEditUI.class.getName(), (Map)uiContext, null, oprtState);
            uiWindow.show();
        }
    }

    public void refreshTbl() throws BOSException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("methodName", "getAllHRTreeList");
        List treeList = (List)HRTobaccoFacadeFactory.getRemoteInstance().exeMethod(param);
        HashMap idMap = new HashMap();
        for (int i = 0; i < treeList.size(); ++i) {
            Map row = (Map)treeList.get(i);
            idMap.put(row.get("fid"), row);
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
        this.setTreeValue(root, idMap);
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            this.setTblData(selectNode);
        } else {
            this.setTblData(root);
        }
    }

    private void setTreeValue(DefaultKingdeeTreeNode node, Map idMap) {
        Map nRow;
        Map row = (Map)node.getUserObject();
        if (idMap.containsKey(row.get("fid")) && (nRow = (Map)idMap.get(row.get("fid"))) != null) {
            node.setUserObject((Object)nRow);
        }
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.setTreeValue(child, idMap);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initHRTree();
        this.initTable();
    }

    @Override
    protected void btnEdit_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        IRow iRow = this.tblMain.getRow(block.getBeginRow());
        String id = iRow.getCell("id").getValue().toString();
        boolean exist = HROrgViewFactory.getRemoteInstance().exists(" where hrOrgUnit.id='" + id + "'");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"hrOrgUnit", (Object)id);
        uiContext.put((Object)"ListUI", (Object)this);
        IUIWindow uiWindow = null;
        String oprtState = exist ? OprtState.EDIT : OprtState.ADDNEW;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(HROrgViewEditUI.class.getName(), (Map)uiContext, null, oprtState);
        uiWindow.show();
    }

    @Override
    protected void btnView_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        IRow iRow = this.tblMain.getRow(block.getBeginRow());
        String id = iRow.getCell("id").getValue().toString();
        boolean exist = HROrgViewFactory.getRemoteInstance().exists(" where hrOrgUnit.id='" + id + "'");
        String oprtState = exist ? OprtState.EDIT : OprtState.ADDNEW;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"hrOrgUnit", (Object)id);
        uiContext.put((Object)"ListUI", (Object)this);
        uiContext.put((Object)"OprtState", (Object)oprtState);
        IUIWindow uiWindow = null;
        uiContext.put((Object)"ope", (Object)OprtState.VIEW);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(HROrgViewEditUI.class.getName(), (Map)uiContext, null, oprtState);
        uiWindow.show();
    }

    @Override
    protected void menuItemEdit_actionPerformed(ActionEvent e) throws Exception {
        this.btnEdit_actionPerformed(e);
    }

    @Override
    protected void menuItemView_actionPerformed(ActionEvent e) throws Exception {
        this.btnView_actionPerformed(e);
    }
}

