/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.tobacco.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.tobacco.PersonPageInfo;
import com.kingdee.eas.hr.tobacco.TobaccoException;
import com.kingdee.eas.hr.tobacco.client.AbstractPersonPageEditUI;
import com.kingdee.eas.hr.tobacco.client.PostCategoriesListUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PersonPageEditUI
extends AbstractPersonPageEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonPageEditUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        ClientVerifyHelper.verifyRequire((CoreUIObject)this);
        if (this.editData.getInnerCode() < 0) {
            throw new TobaccoException(TobaccoException.INVALID_INNERCODE);
        }
        if (this.editData.getJoinPolity() == null) {
            throw new TobaccoException(TobaccoException.JOINPOLITY_IS_NULL);
        }
        if (this.editData.getContractLength() == null || this.editData.getContractLength().trim().length() == 0) {
            throw new TobaccoException(TobaccoException.CHECKBLANK, new String[]{this.kDLabelContainer4.getBoundLabelText()});
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.txtInnerCode.setRequired(true);
        this.contractLength.setRequired(true);
        this.prmtJoinPolity.setRequired(true);
        this.prmtCurSpecDuty.setValue((Object)this.editData.getCurSpecDuty());
        this.prmtCurCertifyCompetency.setValue((Object)this.editData.getCurCertifyCompetency());
        PostCategoriesListUI list = new PostCategoriesListUI();
        list.setF7Use(true, new HashMap());
        this.prmtpostCategory.setSelector((KDPromptSelector)list);
    }

    @Override
    public void loadFields() {
        try {
            this.getValueByPK(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
    }

    protected IObjectValue getValueByPK(IObjectPK pk) throws Exception {
        String recordId = null;
        if (this.getUIContext().get("CUR_OBJ_ID") != null) {
            recordId = this.getUIContext().get("CUR_OBJ_ID").toString();
        }
        if (recordId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)recordId));
            view.put("selector", (Object)this.getMergedSelector());
            view.setFilter(filter);
            CoreBaseCollection pcmCol = this.getBizInterface().getCollection(view);
            if (pcmCol.size() <= 0) {
                this.editData = (PersonPageInfo)this.createNewData();
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)recordId));
                this.editData.setPerson(person);
            } else {
                this.editData = (PersonPageInfo)pcmCol.get(0);
            }
            this.setDataObject((IObjectValue)this.editData);
        }
        return this.editData;
    }
}

