/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.tobacco.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.hr.tobacco.PostCategoriesFactory;
import com.kingdee.eas.hr.tobacco.PostCategoriesInfo;
import com.kingdee.eas.hr.tobacco.PostCategoriesTreeFactory;
import com.kingdee.eas.hr.tobacco.client.AbstractPostCategoriesListUI;
import com.kingdee.eas.hr.tobacco.client.PostCategoriesTreeEditUI;
import com.kingdee.eas.hr.tobacco.util.F7RenderUtil;
import com.kingdee.eas.hr.tobacco.util.TobaccoUtil;
import com.kingdee.eas.util.SysUtil;
import java.awt.Dimension;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PostCategoriesListUI
extends AbstractPostCategoriesListUI
implements KDPromptSelector {
    private static final Logger logger = CoreUIObject.getLogger(PostCategoriesListUI.class);
    private boolean isF7Use;
    private F7RenderUtil f7Delegate;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PostCategoriesFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return PostCategoriesTreeFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        return PostCategoriesTreeEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return "\u5c97\u4f4d\u7c7b\u522b";
    }

    @Override
    protected IObjectValue createNewData() {
        PostCategoriesInfo objectValue = new PostCategoriesInfo();
        return objectValue;
    }

    public Object getData() {
        return this.f7Delegate.getF7Data();
    }

    public boolean isCanceled() {
        return this.f7Delegate.isF7Cancel();
    }

    public void setF7Use(boolean isF7Use, HashMap ctx) {
        this.isF7Use = isF7Use;
        if (isF7Use) {
            try {
                this.setPreferredSize(new Dimension(700, 400));
                if (ctx == null) {
                    ctx = new HashMap();
                }
                this.f7Delegate = new F7RenderUtil((ListUI)this, ctx);
                this.f7Delegate.init();
                this.initLayout();
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
    }

    public void show() {
        if (this.isF7Use) {
            this.lockAction();
            this.f7Delegate.show();
        } else {
            super.show();
        }
    }

    protected void lockAction() {
        super.lockAction();
        if (this.isF7Use) {
            ItemAction[] itemActions = new ItemAction[]{this.actionImportData, this.actionExportData};
            TobaccoUtil.setActionsEnabledStatus(itemActions, false);
            itemActions = new ItemAction[]{this.actionRefresh, this.actionQuery, this.actionLocate};
            TobaccoUtil.setActionsEnabledStatus(itemActions, true);
            TobaccoUtil.setVisibleToolBarStatus(this.toolBar);
            this.menuBar.setVisible(false);
        }
    }

    protected void beforeExcutQuery(EntityViewInfo queryFilter) {
        super.beforeExcutQuery(queryFilter);
        if (this.isF7Use) {
            this.f7Delegate.mergeF7Filter(queryFilter);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.isF7Use) {
            this.f7Delegate.actionConfirm();
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor f7QueryExecutor;
        if (this.isF7Use && this.mainQueryPK.equals(queryPK) && (f7QueryExecutor = this.f7Delegate.getF7QueryExecutor(queryPK, viewInfo)) != null) {
            return f7QueryExecutor;
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected boolean isIgnoreCUFilter() {
        if (this.isF7Use) {
            return !this.f7Delegate.isF7HasCuDefaultFilter();
        }
        return super.isIgnoreCUFilter();
    }
}

