/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.tobacco.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.client.TechnicalPostPromptBox;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.tobacco.client.AbstractSpecialTechPageEditUI;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SpecialTechPageEditUI
extends AbstractSpecialTechPageEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SpecialTechPageEditUI.class);
    private HROrgUnitInfo hroInfo = null;

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.editData.getSpecDuty() == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.contSpecDuty.getBoundLabelText()});
        }
        Date startDate = (Date)this.empStartDate.getValue();
        Date endDate = (Date)this.empEndDate.getValue();
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            throw new EmployeeException(EmployeeException.BEGINDATE_AFTER_ENDDATE);
        }
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        this.editData.setPerson(pInfo);
    }

    @Override
    public void onLoad() throws Exception {
        this.hroInfo = (HROrgUnitInfo)this.getUIContext().get("currentHRO");
        this.prmtSpecDuty.setDisplayFormat("$name$");
        this.prmtSpecDuty.setCommitFormat("$name$;$number$");
        this.prmtSpecDuty.setEditFormat("$name$");
        super.onLoad();
        this.prmtSpecDuty.setRequired(true);
        this.specialTechLevel.setRequired(true);
        this.initPrompt();
    }

    private void initPrompt() {
        TechnicalPostPromptBox tpBox = new TechnicalPostPromptBox((IUIObject)this);
        CtrlUnitInfo ctrl = this.getCurrentCU();
        HashSet<CtrlUnitInfo> set = new HashSet<CtrlUnitInfo>();
        set.add(ctrl);
        tpBox.changeContextByCUSet(set);
        this.prmtSpecDuty.setSelector((KDPromptSelector)tpBox);
        this.prmtSpecDuty.setCurrentCtrlUnit(ctrl);
        this.prmtSpecDuty.setQueryInfo("com.kingdee.eas.hr.base.app.TechPostQuery");
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.hroInfo != null) {
            return this.hroInfo.getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    @Override
    protected void prmtSpecDuty_dataChanged(DataChangeEvent e) throws Exception {
    }
}

