/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.tobacco.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.rec.util.DateUtil;
import com.kingdee.eas.hr.tobacco.PersonPageFactory;
import com.kingdee.eas.hr.tobacco.PersonPageInfo;
import com.kingdee.eas.hr.tobacco.client.AbstractWorkSphereListUI;
import com.kingdee.eas.hr.tobacco.client.WorkSphereQueryPanlUI;
import com.kingdee.eas.hr.tobacco.util.TobaccoUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class WorkSphereListUI
extends AbstractWorkSphereListUI {
    private static final Logger logger = CoreUIObject.getLogger(WorkSphereListUI.class);
    String posiSpeci = "";
    private String title = "";

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PersonFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIName() {
        return EmployeeTreeEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        this.checkShow();
        super.onLoad();
        this.initControl();
    }

    private void checkShow() throws BOSException {
        PersonInfo person = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        if (person == null || person.getId() == null) {
            MsgBox.showInfo((String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u4eba\u5458!");
            SysUtil.abort();
            return;
        }
        String personID = person.getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("person.id", (Object)personID);
        evi.getSelector().add("posiSpeci_name");
        evi.setFilter(filter);
        PersonPageInfo personPageInfo = PersonPageFactory.getRemoteInstance().getPersonPageCollection(evi).get(0);
        this.posiSpeci = personPageInfo.getPosiSpeci_name();
        if (this.posiSpeci == null || this.posiSpeci.trim().length() == 0) {
            MsgBox.showInfo((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8bbe\u7f6e\u5de5\u4f5c\u9886\u57df!");
            SysUtil.abort();
            return;
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            WorkSphereQueryPanlUI ui = new WorkSphereQueryPanlUI(this);
            ui.getUIContext().put("posiSpeci", this.posiSpeci);
            this.setTitle();
            dialog.addUserPanel((KDPanel)ui);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.tblMain.gerGroupManager().setGroup(true);
        this.tblMain.getColumn("hr.name").setGroup(true);
        this.tblMain.getColumn("AdminOrgUnit.name").setGroup(true);
        return dialog;
    }

    private void setTitle() {
        Date date = DateUtil.getCurrentDate();
        String dateStr = DateUtil.format((Date)date, (String)"yyyy\u5e74MM\u6708dd\u65e5");
        this.lblDate.setText("\u65e5\u671f:" + dateStr);
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    private void initControl() {
        this.tblMain.getColumn("AdminOrgUnit.name").setWidth(150);
        this.tblMain.getColumn("position.name").setWidth(150);
        this.tblMain.getColumn("gender").setWidth(50);
        TobaccoUtil.setActionsEnabledStatus(new ItemAction[]{this.actionImportData, this.actionExportData, this.actionView}, false);
        super.lockAction();
        TobaccoUtil.setActionsEnabledStatus(new ItemAction[]{this.actionRefresh, this.actionQuery, this.actionLocate, this.actionPrint, this.actionPrintPreview}, true);
        TobaccoUtil.setVisibleMenuBarStatus(this.menuBar);
        TobaccoUtil.setVisibleToolBarStatus(this.toolBar);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return super.getDefaultFilterForQuery();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.getQuerySolutionInfo().setPrintSolution(null);
        super.actionPrintPreview_actionPerformed(e);
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        super.preparePrintPageHeader(headerModel);
        StyleAttributes sty = Styles.getDefaultSA();
        StringBuffer sbFirst = new StringBuffer();
        sbFirst.append("");
        sbFirst.append("&|");
        sbFirst.append(this.lblDate.getText());
        sty.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        headerModel.addRow(sbFirst.toString(), sty);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.getQuerySolutionInfo().setPrintSolution(null);
        super.actionPrint_actionPerformed(e);
    }

    public String getPrintTitle() {
        return this.getTitle();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }
}

