/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.client.TechnicalPostPromptBox;
import com.kingdee.eas.hr.emp.PersonTechnicalPostCollection;
import com.kingdee.eas.hr.emp.PersonTechnicalPostInfo;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainRecordFacadeFactory;
import com.kingdee.eas.hr.train.TrainRecordIsPassedEnum;
import com.kingdee.eas.hr.train.client.AbstractBatchAddPostUI;
import com.kingdee.eas.hr.train.client.LocateAssistant;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BatchAddPostUI
extends AbstractBatchAddPostUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchAddPostUI.class);
    private static String RES = "com.kingdee.eas.hr.train.client.TrainRecordResource";
    protected KDCheckBox postMAX;
    private PersonTechnicalPostCollection deleteTechnicalPosts = new PersonTechnicalPostCollection();
    private PersonTechnicalPostCollection historyTechnicalPosts = null;
    private Set clearPostIds = new HashSet();
    private LocateAssistant locateAssistant;
    private String userID = null;

    public void onLoad() throws Exception {
        super.onLoad();
        TrainActivityHelper.initTrainActivity(this.prmtTrainActivity, TrainActivityHelper.getActSelectors());
        this.tblmain.checkParsed();
        this.comboPass.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.hr.train.TrainRecordIsPassedEnum").toArray());
        KDBizPromptBox kdtEntries_Unit_PromptBox = new KDBizPromptBox();
        TechnicalPostPromptBox tpBox = new TechnicalPostPromptBox((IUIObject)this);
        kdtEntries_Unit_PromptBox.setSelector((KDPromptSelector)tpBox);
        kdtEntries_Unit_PromptBox.setQueryInfo("com.kingdee.eas.hr.base.app.TechPostQuery");
        kdtEntries_Unit_PromptBox.setVisible(true);
        kdtEntries_Unit_PromptBox.setEditable(true);
        kdtEntries_Unit_PromptBox.setDisplayFormat("$name$");
        kdtEntries_Unit_PromptBox.setEditFormat("$name$");
        kdtEntries_Unit_PromptBox.setCommitFormat("$name$");
        KDTDefaultCellEditor kdtEntries_Unit_CellEditor = new KDTDefaultCellEditor((IKDEditor)kdtEntries_Unit_PromptBox);
        this.tblmain.getColumn("post").setEditor((ICellEditor)kdtEntries_Unit_CellEditor);
        TrainUtils.setTableCellEditorByDatePicker(this.tblmain, "postTime");
        TrainUtils.setTableCellEditorByTextField(this.tblmain, "postMain", 200);
        TrainUtils.setTableCellEditorByTextField(this.tblmain, "postUnit", 200);
        TrainUtils.setTableCellEditorByTextField(this.tblmain, "postNum", 200);
        TrainUtils.setTableCellEditorByTextField(this.tblmain, "other", 200);
        TrainClientUtil.setDisableColor(this.tblmain);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.comboPass.getModel();
        model.insertElementAt(EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource", (String)"ComboBox_Item_All"), 0);
        TrainUtils.setTableCellEditorByCheckBox(this.tblmain, "postMAX");
        TrainUtils.setTableCellEditorByCheckBox(this.tblmain, "postC");
        TrainUtils.setKDTableSortable(this.tblmain);
        this.tblmain.getViewManager().setFreezeView(0, this.tblmain.getColumnIndex("personname") + 1);
        this.userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnColumnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.btnSelectCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.btnSave.setEnabled(true);
        JButton btnRemoveRecord = this.PostContainer1.add((Action)((Object)new ActionRemoveRecord()));
        btnRemoveRecord.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnRemoveRecord.setToolTipText(EASResource.getString((String)RES, (String)"delete_row"));
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"syncTechnicalPost")) == 2) {
            return;
        }
        IProgTask prog = new IProgTask(){

            public Object exec() throws Exception {
                BatchAddPostUI.this.handleSubmit();
                return "";
            }

            public void afterExec(Object result) throws Exception {
            }
        };
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        ProgDialog dialog = null;
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        } else {
            throw new Exception("unknown win's type");
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
    }

    private void handleSubmit() throws BOSException, EASBizException, Exception {
        PersonTechnicalPostCollection submitTechnicalPosts = this.storeDatas();
        String trainActivityId = ((TrainActivityInfo)this.prmtTrainActivity.getValue()).getId().toString();
        PersonTechnicalPostCollection errorTechnicalPosts = (PersonTechnicalPostCollection)TrainRecordFacadeFactory.getRemoteInstance().handleTechnicalPost((IObjectPK)new ObjectUuidPK(trainActivityId), submitTechnicalPosts, this.deleteTechnicalPosts, this.clearPostIds);
        this.showMessage(errorTechnicalPosts);
        this.loadData(false);
    }

    private void showMessage(PersonTechnicalPostCollection errorTechnicalPosts) {
        String message = null;
        if (errorTechnicalPosts != null && errorTechnicalPosts.size() > 0) {
            StringBuffer sb = new StringBuffer();
            int size = errorTechnicalPosts.size();
            for (int i = 0; i < size; ++i) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(errorTechnicalPosts.get(i).getPerson().getName());
                MessageFormat format = new MessageFormat(EASResource.getString((String)RES, (String)"technicalPostSavaMessage"));
                message = format.format(new Object[]{sb.toString()});
            }
        } else {
            message = EASResource.getString((String)RES, (String)"save_success");
        }
        MsgBox.showInfo((String)message);
    }

    private void verifyInput() {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtTrainActivity);
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.tblmain, "post");
    }

    private PersonTechnicalPostCollection storeDatas() {
        PersonTechnicalPostCollection collection = null;
        if (this.tblmain.getRowCount() > 0) {
            collection = new PersonTechnicalPostCollection();
            PersonTechnicalPostInfo personTechnicalPostInfo = null;
            IRow row = null;
            int count = this.tblmain.getRowCount();
            for (int i = 0; i < count; ++i) {
                row = this.tblmain.getRow(i);
                personTechnicalPostInfo = this.assembleTechnicalPostInfo(row);
                collection.add(personTechnicalPostInfo);
            }
        }
        return collection;
    }

    private PersonTechnicalPostInfo assembleTechnicalPostInfo(IRow row) {
        PersonTechnicalPostInfo personTechnicalPostInfo = new PersonTechnicalPostInfo();
        PersonInfo personInfo = new PersonInfo();
        personInfo.setId(BOSUuid.read((String)row.getCell("personId").getValue().toString()));
        personInfo.setName(row.getCell("personname").getValue().toString());
        personInfo.setNumber(row.getCell("personnum").getValue().toString());
        personTechnicalPostInfo.setPerson(personInfo);
        if (row.getCell("personTechnicalPostId").getValue() != null) {
            personTechnicalPostInfo.setId((BOSUuid)row.getCell("personTechnicalPostId").getValue());
        } else {
            personTechnicalPostInfo.setId(null);
        }
        if (row.getCell("post").getValue() != null) {
            personTechnicalPostInfo.setTechnicalPost((TechnicalPostInfo)row.getCell("post").getValue());
        } else {
            personTechnicalPostInfo.setTechnicalPost(null);
        }
        if (row.getCell("postMAX").getValue() != null) {
            personTechnicalPostInfo.setIsHighTechnical(((Boolean)row.getCell("postMAX").getValue()).booleanValue());
        } else {
            personTechnicalPostInfo.setIsHighTechnical(false);
        }
        if (row.getCell("postC").getValue() != null) {
            personTechnicalPostInfo.setIsEmploy(((Boolean)row.getCell("postC").getValue()).booleanValue());
        } else {
            personTechnicalPostInfo.setIsEmploy(false);
        }
        if (row.getCell("postMain").getValue() != null) {
            personTechnicalPostInfo.setTechnicalCont(row.getCell("postMain").getValue().toString());
        } else {
            personTechnicalPostInfo.setTechnicalCont(null);
        }
        if (row.getCell("postUnit").getValue() != null) {
            personTechnicalPostInfo.setGradeUnit(row.getCell("postUnit").getValue().toString());
        } else {
            personTechnicalPostInfo.setGradeUnit(null);
        }
        if (row.getCell("postTime").getValue() != null) {
            personTechnicalPostInfo.setConferDate((Date)row.getCell("postTime").getValue());
        } else {
            personTechnicalPostInfo.setConferDate(null);
        }
        if (row.getCell("postNum").getValue() != null) {
            personTechnicalPostInfo.setCertificateNo(row.getCell("postNum").getValue().toString());
        } else {
            personTechnicalPostInfo.setCertificateNo(null);
        }
        if (row.getCell("other").getValue() != null) {
            personTechnicalPostInfo.setDescription(row.getCell("other").getValue().toString());
        } else {
            personTechnicalPostInfo.setDescription(null);
        }
        return personTechnicalPostInfo;
    }

    public void actionColumnCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblmain.getRowCount() == 0) {
            return;
        }
        int size = this.tblmain.getSelectManager().size();
        if (size > 0) {
            KDTSelectBlock sb = this.tblmain.getSelectManager().get(0);
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.tblmain.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.tblmain.getCell(row, column).getValue();
            int length = this.tblmain.getRowCount();
            for (int i = 0; i < length; ++i) {
                if (i == row) continue;
                this.tblmain.getCell(i, column).setValue(value);
            }
        }
    }

    public void actionSelectCopy_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.selectedCopy(this.tblmain);
    }

    protected void prmtTrainActivity_dataChanged(DataChangeEvent e) throws Exception {
        this.loadData(true);
    }

    private void loadData(boolean includeEmpty) throws Exception {
        this.tblmain.removeRows();
        this.clearPostIds.clear();
        String activityId = null;
        if (this.prmtTrainActivity.getValue() == null) {
            return;
        }
        activityId = ((TrainActivityInfo)this.prmtTrainActivity.getValue()).getId().toString();
        FilterInfo fi = new FilterInfo();
        if (activityId != null && activityId.length() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)activityId));
        }
        if (this.comboPass.getSelectedItem() != null && this.comboPass.getSelectedItem() instanceof TrainRecordIsPassedEnum) {
            TrainRecordIsPassedEnum item = (TrainRecordIsPassedEnum)((Object)this.comboPass.getSelectedItem());
            fi.getFilterItems().add(new FilterItemInfo("actIsPassed", (Object)item.getValue()));
        }
        if (!includeEmpty) {
            fi.getFilterItems().add(new FilterItemInfo("technicalPost.id", null, CompareType.NOTEQUALS));
        }
        fi.getFilterItems().add(new FilterItemInfo("TrainCoReExt.actIsApproved", (Object)Boolean.FALSE));
        fi.getFilterItems().add(TrainCommonUtils.getAdminRangeFilterItemInfo(this.userID, "recordExtends.OrgStudent.id"));
        CacheServiceFactory.getInstance().discardQuery((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainRecordPostQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(fi);
        SorterItemInfo item = new SorterItemInfo("Employee.number");
        item.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(item);
        IRowSet rowSet = TrainActivityHelper.getRowSet("TrainRecordPostQuery", viewInfo);
        this.historyTechnicalPosts = this.putDataToTable(rowSet);
        this.deleteTechnicalPosts.clear();
    }

    private PersonTechnicalPostCollection putDataToTable(IRowSet rowSet) throws SQLException {
        if (rowSet == null) {
            return null;
        }
        IRow row = null;
        PersonTechnicalPostCollection technicalPostCollection = new PersonTechnicalPostCollection();
        PersonTechnicalPostInfo technicalPostInfo = null;
        rowSet.beforeFirst();
        while (rowSet.next()) {
            row = this.tblmain.addRow();
            technicalPostInfo = this.assembleTechnicalPostInfo(rowSet);
            technicalPostCollection.add(technicalPostInfo);
            row.getCell("personname").setValue((Object)rowSet.getString("Employee.name"));
            row.getCell("personnum").setValue((Object)rowSet.getString("Employee.number"));
            row.getCell("personId").setValue((Object)rowSet.getString("Employee.id"));
            if (rowSet.getString("post.id") != null) {
                if (rowSet.getString("technicalPost.id") != null) {
                    row.getCell("personTechnicalPostId").setValue((Object)technicalPostInfo.getId());
                    row.getCell("post").setValue((Object)technicalPostInfo.getTechnicalPost());
                    row.getCell("postMAX").setValue((Object)technicalPostInfo.isIsHighTechnical());
                    row.getCell("postC").setValue((Object)technicalPostInfo.isIsEmploy());
                    row.getCell("postMain").setValue((Object)technicalPostInfo.getTechnicalCont());
                    row.getCell("postUnit").setValue((Object)technicalPostInfo.getGradeUnit());
                    row.getCell("postTime").setValue((Object)technicalPostInfo.getConferDate());
                    row.getCell("postNum").setValue((Object)technicalPostInfo.getCertificateNo());
                    row.getCell("other").setValue((Object)technicalPostInfo.getDescription());
                    continue;
                }
                this.clearPostIds.add(rowSet.getString("post.id"));
                row.getCell("postMAX").setValue((Object)Boolean.FALSE);
                row.getCell("postC").setValue((Object)Boolean.FALSE);
                continue;
            }
            row.getCell("postMAX").setValue((Object)Boolean.FALSE);
            row.getCell("postC").setValue((Object)Boolean.FALSE);
        }
        return technicalPostCollection;
    }

    private PersonTechnicalPostInfo assembleTechnicalPostInfo(IRowSet rowSet) throws SQLException {
        PersonTechnicalPostInfo info = new PersonTechnicalPostInfo();
        if (rowSet.getString("technicalPost.id") != null) {
            TechnicalPostInfo postInfo = new TechnicalPostInfo();
            postInfo.setId(BOSUuid.read((String)rowSet.getString("technicalPost.id")));
            postInfo.setName(rowSet.getString("technicalPost.name"));
            info.setTechnicalPost(postInfo);
            if (rowSet.getString("post.id") != null) {
                info.setId(BOSUuid.read((String)rowSet.getString("post.id")));
            }
            if (rowSet.getString("post.isHighTechnical") != null) {
                info.setIsHighTechnical(rowSet.getBoolean("post.isHighTechnical"));
            }
            if (rowSet.getString("post.isEmploy") != null) {
                info.setIsEmploy(rowSet.getBoolean("post.isEmploy"));
            }
            if (rowSet.getString("post.technicalCont") != null) {
                info.setTechnicalCont(rowSet.getString("post.technicalCont"));
            }
            if (rowSet.getString("post.gradeUnit") != null) {
                info.setGradeUnit(rowSet.getString("post.gradeUnit"));
            }
            if (rowSet.getString("post.conferDate") != null) {
                info.setConferDate((Date)rowSet.getDate("post.conferDate"));
            }
            if (rowSet.getString("post.certificateNo") != null) {
                info.setCertificateNo(rowSet.getString("post.certificateNo"));
            }
            if (rowSet.getString("post.description") != null) {
                info.setDescription(rowSet.getString("post.description"));
            }
        }
        if (rowSet.getString("Employee.id") != null) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)rowSet.getString("Employee.id")));
            personInfo.setName(rowSet.getString("Employee.name"));
            personInfo.setNumber(rowSet.getString("Employee.number"));
            info.setPerson(personInfo);
        }
        return info;
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
        if (this.locateAssistant == null) {
            this.locateAssistant = new LocateAssistant((CoreUIObject)this, this.tblmain, this.getLocateNames());
        }
        this.locateAssistant.actionLocate();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"personnum", "personname"};
        return locateNames;
    }

    protected void comboPass_actionPerformed(ActionEvent e) throws Exception {
        this.loadData(true);
    }

    protected boolean checkBeforeWindowClosing() {
        this.checkModify(null);
        return super.checkBeforeWindowClosing();
    }

    private void checkModify(PreChangeEvent event) {
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.operateYes();
            } else if (result == 2) {
                if (event != null) {
                    event.setResult(0);
                } else {
                    SysUtil.abort();
                }
            }
        }
    }

    private void operateYes() {
        ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
        this.actionSave.actionPerformed(event);
        if (this.actionSave.isInvokeFailed()) {
            SysUtil.abort();
        }
    }

    private boolean isModify() {
        int i;
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        if (this.tblmain.getRowCount() == 0) {
            return false;
        }
        PersonTechnicalPostCollection submitTechnicalPosts = this.storeDatas();
        if (this.historyTechnicalPosts == null || this.historyTechnicalPosts.size() != submitTechnicalPosts.size()) {
            return true;
        }
        PersonTechnicalPostInfo info = null;
        HashMap<String, PersonTechnicalPostInfo> map = new HashMap<String, PersonTechnicalPostInfo>();
        int size = submitTechnicalPosts.size();
        for (i = 0; i < size; ++i) {
            info = submitTechnicalPosts.get(i);
            map.put(info.getPerson().getId().toString(), info);
        }
        size = this.historyTechnicalPosts.size();
        for (i = 0; i < size; ++i) {
            info = this.historyTechnicalPosts.get(i);
            if (ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)info, (AbstractObjectValue)((AbstractObjectValue)map.get(info.getPerson().getId().toString())))) continue;
            return true;
        }
        return false;
    }

    private class ActionRemoveRecord
    extends ItemAction {
        public ActionRemoveRecord() {
            this(null);
        }

        public ActionRemoveRecord(IUIObject uiObj) {
            super(uiObj);
            String _tempStr = "";
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift r"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)BatchAddPostUI.this.tblmain);
            Arrays.sort(rowIndexs);
            IRow row = null;
            for (int i = rowIndexs.length - 1; i >= 0; --i) {
                row = BatchAddPostUI.this.tblmain.getRow(rowIndexs[i]);
                if (row == null) continue;
                if (row.getCell("personTechnicalPostId").getValue() != null) {
                    BatchAddPostUI.this.deleteTechnicalPosts.add(BatchAddPostUI.this.assembleTechnicalPostInfo(row));
                }
                BatchAddPostUI.this.tblmain.removeRow(rowIndexs[i]);
            }
        }
    }
}

