/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.hr.emp.ContractTempletCollection;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.client.BatchContractEditUI;
import com.kingdee.eas.hr.emp.client.ContractTempletF7;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.train.client.AbstractBatchWizardUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.DefaultListModel;

public class BatchWizardUI
extends AbstractBatchWizardUI {
    boolean isZTCustomer = EmployeeContractFactory.getRemoteInstance().isZhongTianCustomer();
    private boolean isStrideHRO = false;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void actionInsertEmployee_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox person = new EmployeeMultiF7PromptBox((IUIObject)this);
        HROrgUnitInfo hrOrgUnitInfo = this.getCurrentHRO();
        HashSet<String> set = null;
        if (hrOrgUnitInfo != null) {
            set = new HashSet<String>();
            set.add(hrOrgUnitInfo.getId().toString());
        }
        person.setIsSingleSelect(false);
        if (this.isZTCustomer) {
            person.setIsShowAllAdmin(true);
        } else if (this.isStrideHRO) {
            person.setIsShowAllAdmin(true);
        } else {
            person.setHROFilter(set);
        }
        person.show();
        if (!person.isCanceled() && person.getData() != null) {
            Object[] obj = (Object[])person.getData();
            for (int i = 0; i < obj.length; ++i) {
                if (this.checkIsExistInListEmployee((PersonInfo)obj[i])) continue;
                ((DefaultListModel)this.listEmployee.getModel()).addElement((PersonInfo)obj[i]);
            }
        }
    }

    public boolean checkIsExistInListEmployee(PersonInfo pInfo) {
        DefaultListModel model = (DefaultListModel)this.listEmployee.getModel();
        for (int i = 0; i < model.size(); ++i) {
            if (!pInfo.getId().toString().equals(((PersonInfo)model.getElementAt(i)).getId().toString())) continue;
            return true;
        }
        return false;
    }

    public void actionDeleteEmployee_actionPerformed(ActionEvent e) throws Exception {
        Object[] objs = this.listEmployee.getSelectedValues();
        for (int i = 0; i < objs.length; ++i) {
            this.listEmployee.removeElement(objs[i]);
        }
    }

    public void actionInsertContract_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        IUIFactory uiFactory = null;
        IUIWindow uiWindow = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            HashSet<CtrlUnitInfo> set = new HashSet<CtrlUnitInfo>();
            set.add(this.getCurrentCU());
            uiContext.put((Object)"HRCU", set);
            uiWindow = uiFactory.create(ContractTempletF7.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
        ContractTempletCollection tempInfos = ((ContractTempletF7)uiWindow.getUIObject()).getReturnContractTemplet();
        if (tempInfos != null && tempInfos.size() != 0) {
            for (int i = 0; i < tempInfos.size(); ++i) {
                if (this.checkIsExistInListContract(tempInfos.get(i))) continue;
                ((DefaultListModel)this.listContract.getModel()).addElement(tempInfos.get(i));
            }
        }
    }

    public boolean checkIsExistInListContract(ContractTempletInfo cInfo) {
        DefaultListModel model = (DefaultListModel)this.listContract.getModel();
        for (int i = 0; i < model.size(); ++i) {
            if (!cInfo.getId().toString().equals(((ContractTempletInfo)model.getElementAt(i)).getId().toString())) continue;
            return true;
        }
        return false;
    }

    public void actionDeleteContract_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteContract_actionPerformed(e);
        Object[] objs = this.listContract.getSelectedValues();
        for (int i = 0; i < objs.length; ++i) {
            this.listContract.removeElement(objs[i]);
        }
    }

    public void actionYes_actionPerformed(ActionEvent e) throws Exception {
        super.actionYes_actionPerformed(e);
        this.checkInput();
        UIContext uiContext = new UIContext();
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        uiContext.put((Object)"OwnerWindow", (Object)ownerWindow);
        IMainUIObject mainObject = SystemEntry.instance.getMainUIObject();
        uiContext.put((Object)"IMainUIObject", (Object)mainObject);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BatchContractEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        this.getUIWindow().close();
        uiWindow.show();
    }

    public void checkInput() throws EmployeeException {
        if (this.prmtHRO.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"HRORG_NOT_NULL"));
            this.prmtHRO.requestFocusInWindow();
            SysUtil.abort();
        }
        if (((DefaultListModel)this.listEmployee.getModel()).getSize() == 0) {
            this.btnInsertEmployee.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.PLEASE_SELECT_EMPLOYEE);
        }
        if (((DefaultListModel)this.listContract.getModel()).getSize() == 0) {
            this.btnInsertContract.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.PLEASE_SELECT_CONTRACTTEMPLET);
        }
        if (this.prmtToUnit.getText() == null || "".equals(this.prmtToUnit.getText())) {
            this.prmtToUnit.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_TOUNIT_NOT_NULL);
        }
        if (this.recordDate.getValue() == null) {
            this.recordDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_STARTDATE_NOT_NULL);
        }
        if (this.effectDate.getValue() == null) {
            this.effectDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_EFFECTDATE_NOT_NULL);
        }
        if (this.freeDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.recordDate.getValue()), (Date)((Date)this.freeDate.getValue()))) {
            this.freeDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.STARTDATE_NOT_DY_INEFFECTDATE);
        }
        if (this.endDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.recordDate.getValue()), (Date)((Date)this.endDate.getValue()))) {
            this.endDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.STARTDATE_NOT_DY_ENDDATE);
        }
        if (this.endDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.effectDate.getValue()), (Date)((Date)this.endDate.getValue()))) {
            this.endDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATE);
        }
        if (this.freeDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.effectDate.getValue()), (Date)((Date)this.freeDate.getValue()))) {
            this.freeDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_INEFFECTDATE);
        }
    }

    public void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"personInfos", (Object)this.getCollectionFromEmployeeList());
        uiContext.put((Object)"contractTempletInfos", (Object)this.getCollectionFromContractTempletList());
        uiContext.put((Object)"toUnit", (Object)((AdminOrgUnitInfo)this.prmtToUnit.getData()));
        uiContext.put((Object)"delegatePerson", (Object)((PersonInfo)this.prmtDelegatePerson.getData()));
        uiContext.put((Object)"recordDate", this.recordDate.getValue());
        uiContext.put((Object)"effectDate", this.effectDate.getValue());
        uiContext.put((Object)"freeDate", this.freeDate.getValue());
        uiContext.put((Object)"endDate", this.endDate.getValue());
    }

    public PersonCollection getCollectionFromEmployeeList() {
        PersonCollection personInfos = new PersonCollection();
        DefaultListModel model = (DefaultListModel)this.listEmployee.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            personInfos.add((PersonInfo)model.get(i));
        }
        return personInfos;
    }

    public ContractTempletCollection getCollectionFromContractTempletList() {
        ContractTempletCollection tempInfos = new ContractTempletCollection();
        DefaultListModel model = (DefaultListModel)this.listContract.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            tempInfos.add((ContractTempletInfo)model.get(i));
        }
        return tempInfos;
    }

    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void onLoad() throws Exception {
        this.isStrideHRO = HRParamUtil.getParamOfHR(null, (String)"IS_CONTRACT_ALLHR", null);
        super.onLoad();
        this.setMainBizOrgF7(this.prmtHRO);
        this.prmtHRO.setRequired(true);
        this.initPrompt();
        this.prmtHRO.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                OrgChangeVO orgChg = new OrgChangeVO(eventObj.getOldValue(), eventObj.getNewValue());
                OrgUnitInfo org = (OrgUnitInfo)orgChg.getNewOrg();
                if (orgChg.isDiffrent() && org != null) {
                    BatchWizardUI.this.switchOrg(org.getId().toString());
                }
            }
        });
        this.initButtonState();
        this.initButtonIcon();
        if (this.getUIContext().get("PersonPositionCollection") != null) {
            PersonPositionCollection perPosCol = (PersonPositionCollection)this.getUIContext().get("PersonPositionCollection");
            int size = perPosCol.size();
            for (int i = 0; i < size; ++i) {
                PersonInfo pInfo = perPosCol.get(i).getPerson();
                pInfo.put("primaryAdminOrg", (Object)perPosCol.get(i).getPersonDep());
                pInfo.put("primaryPosition", (Object)perPosCol.get(i).getPrimaryPosition());
                ((DefaultListModel)this.listEmployee.getModel()).addElement(pInfo);
            }
        }
    }

    private void switchOrg(String pk) {
        if (pk != null) {
            this.initUIMainOrgContext(pk.toString());
        }
        this.initPrompt();
    }

    public void initButtonIcon() {
        this.btnDeleteContract.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDeleteEmployee.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnInsertContract.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnInsertEmployee.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
    }

    public void initButtonState() {
        this.btnDeleteContract.setEnabled(true);
        this.btnInsertContract.setEnabled(true);
        this.btnDeleteEmployee.setEnabled(true);
        this.btnInsertEmployee.setEnabled(true);
        this.btnYes.setEnabled(true);
        this.btnExit.setEnabled(true);
        this.recordDate.setValue((Object)new Date());
        this.effectDate.setValue((Object)new Date());
        this.freeDate.setValue(null);
        this.endDate.setValue(null);
    }

    public void initPrompt() {
        HashSet<String> set;
        HROrgUnitInfo hrOrgUnitInfo;
        if (this.isZTCustomer) {
            this.prmtToUnit.setSelector((KDPromptSelector)new AdminF7());
        } else {
            AdminByOrgRangePromptBox adminPrmt = new AdminByOrgRangePromptBox();
            hrOrgUnitInfo = this.getCurrentHRO();
            if (hrOrgUnitInfo != null) {
                set = new HashSet<String>();
                set.add(hrOrgUnitInfo.getId().toString());
                adminPrmt.setHROFilter(set);
            }
            this.prmtToUnit.setSelector((KDPromptSelector)adminPrmt);
        }
        this.prmtToUnit.setEditFormat("$number$");
        this.prmtToUnit.setCommitFormat("$number$");
        this.prmtToUnit.setDisplayFormat("$name$");
        this.prmtToUnit.setData((Object)SysContext.getSysContext().getCurrentAdminUnit());
        EmployeeMultiF7PromptBox personPrmt = new EmployeeMultiF7PromptBox();
        personPrmt.setIsSingleSelect(true);
        if (this.isZTCustomer) {
            personPrmt.setIsShowAllAdmin(true);
        } else {
            hrOrgUnitInfo = this.getCurrentHRO();
            if (hrOrgUnitInfo != null) {
                set = new HashSet();
                set.add(hrOrgUnitInfo.getId().toString());
                personPrmt.setHROFilter(set);
            }
        }
        this.prmtDelegatePerson.setSelector((KDPromptSelector)personPrmt);
        this.prmtDelegatePerson.setDisplayFormat("$name$");
        this.prmtDelegatePerson.setEditFormat("$number$");
        this.prmtDelegatePerson.setCommitFormat("$number$");
        this.prmtDelegatePerson.setEditable(false);
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.getMainOrgContext() == null) {
            return SysContext.getSysContext().getCurrentHRUnit();
        }
        if (FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.ControlUnit) != null) {
            return (HROrgUnitInfo)FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.HRO);
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.getMainOrgContext() == null) {
            return SysContext.getSysContext().getCurrentCtrlUnit();
        }
        if (FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.ControlUnit) != null) {
            return (CtrlUnitInfo)FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.ControlUnit);
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox) {
        if (bizOrgUnitBox != null) {
            OrgUnitFilterInfoProducer iProducer = null;
            String permissionItem = "empcontract_view";
            iProducer = (OrgUnitFilterInfoProducer)FilterInfoProducerFactory.getOrgUnitFilterInfoProducer((OrgType)OrgType.HRO);
            if (iProducer != null) {
                if (permissionItem != null) {
                    iProducer.getModel().setPermissionItem(permissionItem);
                }
                bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
                if (iProducer.getModel() != null) {
                    bizOrgUnitBox.setSelector((KDPromptSelector)iProducer.getModel());
                    iProducer.getModel().setMultiSelect(false);
                }
            }
            bizOrgUnitBox.setCommitFormat("$number$;$code$");
            bizOrgUnitBox.setEditFormat("$number$");
            bizOrgUnitBox.setDisplayFormat("$name$");
            bizOrgUnitBox.setEnabledMultiSelection(false);
        }
    }
}

