/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.EquipmentByTrainActCollection;
import com.kingdee.eas.hr.train.EquipmentByTrainActFactory;
import com.kingdee.eas.hr.train.EquipmentByTrainActInfo;
import com.kingdee.eas.hr.train.IEquipmentByTrainAct;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainEquipmentInfo;
import com.kingdee.eas.hr.train.client.AbstractEquipmentByTrainActListUI;
import com.kingdee.eas.hr.train.client.EquipmentByTrainActEditUI;
import com.kingdee.eas.hr.train.client.TrainEquipmentMultiPromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EquipmentByTrainActListUI
extends AbstractEquipmentByTrainActListUI {
    private static final Logger logger = CoreUIObject.getLogger(EquipmentByTrainActListUI.class);
    private String trainActivityId;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.trainActivityId = (String)this.getUIContext().get("ID");
        this.setDataObject(this.getEntityViewInfo());
        this.initWorkButton();
        TrainUtils.setTableNumberFormat(this.tblMain, "count", 0);
    }

    private IObjectValue getEntityViewInfo() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((String)this.getUIContext().get("ID"))));
        evi.setFilter(fi);
        return evi;
    }

    protected String getEditUIName() {
        return EquipmentByTrainActEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EquipmentByTrainActFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        EquipmentByTrainActInfo objectValue = new EquipmentByTrainActInfo();
        return objectValue;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        TrainEquipmentMultiPromptBox trainEquipment = new TrainEquipmentMultiPromptBox((IUIObject)this);
        trainEquipment.show();
        if (!trainEquipment.isCanceled() && trainEquipment.getData() instanceof Object[]) {
            Object[] obj = (Object[])trainEquipment.getData();
            TrainEquipmentInfo equipmentInfo = null;
            EquipmentByTrainActCollection equipmentByTrainActCollection = new EquipmentByTrainActCollection();
            EquipmentByTrainActInfo equipmentByTrainActInfo = null;
            TrainActivityInfo activityInfo = new TrainActivityInfo();
            activityInfo.setId(BOSUuid.read((String)this.trainActivityId));
            for (int i = 0; i < obj.length; ++i) {
                equipmentByTrainActInfo = new EquipmentByTrainActInfo();
                equipmentInfo = (TrainEquipmentInfo)obj[i];
                equipmentByTrainActInfo.setTrainEquipment(equipmentInfo);
                equipmentByTrainActInfo.setTrainActivity(activityInfo);
                equipmentByTrainActCollection.add(equipmentByTrainActInfo);
            }
            this.fillTable(equipmentByTrainActCollection);
            this.submit();
        }
    }

    private void submit() throws Exception {
        Map idMap;
        IEquipmentByTrainAct equipmentByTrainAct = EquipmentByTrainActFactory.getRemoteInstance();
        EquipmentByTrainActCollection equipmentByTrainActCollection = new EquipmentByTrainActCollection();
        EquipmentByTrainActInfo equipmentByTrainActInfo = null;
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("id").getValue() != null) continue;
            equipmentByTrainActInfo = (EquipmentByTrainActInfo)row.getUserObject();
            equipmentByTrainActCollection.add(equipmentByTrainActInfo);
        }
        if (equipmentByTrainActCollection.size() != 0 && (idMap = equipmentByTrainAct.batchSubmit(equipmentByTrainActCollection)) != null && idMap.size() > 0) {
            int size2 = this.tblMain.getRowCount();
            for (int i = 0; i < size2; ++i) {
                row = this.tblMain.getRow(i);
                if (row.getCell("id").getValue() != null) continue;
                row.getCell("id").setValue(idMap.get((String)row.getCell("equipmentId").getValue()));
            }
        }
    }

    private void fillTable(EquipmentByTrainActCollection equipmentByTrainActCollection) throws Exception {
        EquipmentByTrainActInfo equipmentByTrainActInfo = null;
        int size = equipmentByTrainActCollection.size();
        for (int i = 0; i < size; ++i) {
            equipmentByTrainActInfo = equipmentByTrainActCollection.get(i);
            TrainEquipmentInfo trainEquipment = equipmentByTrainActInfo.getTrainEquipment();
            if (this.checkIfRefered(trainEquipment.getId().toString())) continue;
            IRow row = this.tblMain.addRow();
            row.setUserObject((Object)equipmentByTrainActInfo);
            if (equipmentByTrainActInfo.getId() != null) {
                row.getCell("id").setValue((Object)equipmentByTrainActInfo.getId().toString());
            }
            row.getCell("equipmentId").setValue((Object)trainEquipment.getId().toString());
            row.getCell("number").setValue((Object)trainEquipment.getNumber());
            row.getCell("name").setValue((Object)trainEquipment.getName());
            row.getCell("unit").setValue((Object)trainEquipment.getUnit());
            row.getCell("count").setValue((Object)trainEquipment.getCount());
            row.getCell("trainChannel").setValue(trainEquipment.getTrainChannel() == null ? null : trainEquipment.getTrainChannel().getName());
            row.getCell("introduce").setValue((Object)trainEquipment.getIntroduce());
            row.getCell("keepAddress").setValue((Object)trainEquipment.getKeepAddress());
            row.getCell("keeper").setValue((Object)trainEquipment.getKeeper());
            row.getCell("trainEquipmentCate").setValue((Object)trainEquipment.getTreeid().getName());
        }
    }

    private boolean checkIfRefered(String equipmentId) {
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            String equipmentIdInTable = (String)row.getCell("equipmentId").getValue();
            if (equipmentIdInTable == null || !equipmentIdInTable.equals(equipmentId)) continue;
            return true;
        }
        return false;
    }

    public void actionRemove_actionPerformed(ActionEvent arg0) throws Exception {
        IEquipmentByTrainAct equipmentByTrainAct = EquipmentByTrainActFactory.getRemoteInstance();
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        if (this.confirmRemove()) {
            List selectRowList = TrainUtils.getSelectedRows(this.tblMain);
            Arrays.sort(selectRowList.toArray());
            IRow row = null;
            HashSet<String> idSet = new HashSet<String>();
            for (int i = selectRowList.size() - 1; i >= 0; --i) {
                int rowIndex = (Integer)selectRowList.get(i);
                row = this.tblMain.getRow(rowIndex);
                String id = (String)row.getCell("id").getValue();
                if (id != null) {
                    idSet.add(id);
                }
                this.tblMain.removeRow(rowIndex);
            }
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            equipmentByTrainAct.delete(fi);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }
}

