/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.InstructorResumeFactory;
import com.kingdee.eas.hr.train.InstructorResumeInfo;
import com.kingdee.eas.hr.train.InstructorResumeRecordCollection;
import com.kingdee.eas.hr.train.InstructorResumeRecordInfo;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.client.AbstractInstructorResumeEditUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class InstructorResumeEditUI
extends AbstractInstructorResumeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(InstructorResumeEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.TrainResource";

    public void onLoad() throws Exception {
        this.kdtRecord.checkParsed();
        super.onLoad();
        this.actionAddLine.putValue("Name", "");
        this.actionInsertLine.putValue("Name", "");
        this.actionRemoveLine.putValue("Name", "");
        TrainUtils.setMutilTableFromBIM(this.conRecord, this.kdtRecord);
        TrainUtils.initMutilTableFromBIM(this.conRecord, (Action)((Object)this.actionAddLine), (Action)((Object)this.actionInsertLine), (Action)((Object)this.actionRemoveLine));
        this.txtinstructorAge.setHorizontalAlignment(4);
        TrainUtils.setTableCellEditorByTextField(this.kdtRecord, "companyName", 40);
        TrainUtils.setTableCellEditorByDatePicker(this.kdtRecord, "hireDate");
        TrainUtils.setTableCellEditorByDatePicker(this.kdtRecord, "fireDate");
        TrainUtils.setTableCellEditorByTextField(this.kdtRecord, "hireLevel", 40);
        TrainUtils.setTableCellEditorByTextField(this.kdtRecord, "hireNumber", 40);
        TrainUtils.setTableCellEditorByTextField(this.kdtRecord, "assessInfo", 100);
        TrainUtils.setNumberMaximumValue(this.txtinstructorAge);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setActionState(false);
            this.kdtRecord.getStyleAttributes().setLocked(true);
        } else {
            this.setActionState(true);
        }
    }

    private void setActionState(boolean flag) {
        this.actionAddLine.setEnabled(flag);
        this.actionInsertLine.setEnabled(flag);
        this.actionRemoveLine.setEnabled(flag);
    }

    private boolean isNullObject(Object object) {
        InstructorResumeRecordInfo record = (InstructorResumeRecordInfo)object;
        boolean result = record.getCompanyName() == null && record.getHireDate() == null && record.getFireDate() == null && record.getAssessInfo() == null && record.getHireLevel() == null && record.getHireNumber() == null;
        return result;
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.addLine(this.kdtRecord);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.insertLine(this.kdtRecord);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine(this.kdtRecord);
    }

    protected void txtinstructorAge_keyReleased(KeyEvent e) throws Exception {
        TrainUtils.numberMustPositive((JTextField)this.txtinstructorAge);
    }

    protected String getEditUIName() {
        return InstructorResumeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InstructorResumeFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        InstructorResumeInfo objectValue = new InstructorResumeInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setInstructor((TrainInstructorInfo)this.getUIContext().get("InstructorResume"));
        return objectValue;
    }

    public IObjectPK runSubmit() throws Exception {
        InstructorResumeRecordCollection records = this.editData.getRecord();
        if (records != null && records.size() > 0) {
            Iterator it = records.iterator();
            while (it.hasNext()) {
                if (!this.isNullObject(it.next())) continue;
                it.remove();
            }
        }
        IObjectPK pk = super.runSubmit();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
        return pk;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkbeginWorkDate);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtinstructorAge);
        this.checkDate();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        this.checkDate();
    }

    private void checkDate() {
        for (int i = 0; i < this.kdtRecord.getRowCount(); ++i) {
            if (!this.fireDateLessHireDate(i)) continue;
            MessageFormat format = new MessageFormat(EASResource.getString((String)RESOURCE, (String)"HireDateMustLessThanFireDate"));
            String message = format.format(new Object[]{String.valueOf(i + 1)});
            MsgBox.showInfo((String)message);
            int columnIndex = this.kdtRecord.getColumn("hireDate").getColumnIndex();
            this.kdtRecord.getEditManager().editCellAt(i, columnIndex, true);
            SysUtil.abort();
        }
    }

    protected void kdtRecord_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int curColIndex = e.getColIndex();
        int hireDateColumnIndex = this.kdtRecord.getColumnIndex("hireDate");
        int fireDateColumnIndex = this.kdtRecord.getColumnIndex("fireDate");
        if ((curColIndex == hireDateColumnIndex || curColIndex == fireDateColumnIndex) && this.fireDateLessHireDate(rowIndex)) {
            StringBuffer message = new StringBuffer();
            message.append(this.kdtRecord.getHeadRow(0).getCell(fireDateColumnIndex).getValue());
            message.append(EASResource.getString((String)"com.kingdee.eas.hr.train.TrainVerifyResource", (String)"BigThanOrEqual"));
            message.append(this.kdtRecord.getHeadRow(0).getCell(hireDateColumnIndex).getValue());
            MsgBox.showInfo((String)message.toString());
            SysUtil.abort();
        }
    }

    private boolean fireDateLessHireDate(int rowIndex) {
        boolean result = false;
        IRow row = this.kdtRecord.getRow(rowIndex);
        Date hireDate = (Date)row.getCell("hireDate").getValue();
        Date fireDate = (Date)row.getCell("fireDate").getValue();
        if (hireDate != null && fireDate != null && fireDate.before(hireDate)) {
            result = true;
        }
        return result;
    }
}

