/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.NewEmployeeCollection;
import com.kingdee.eas.hr.emp.NewEmployeeInfo;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.client.AbstractNewEmpAddListUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class NewEmpAddListUI
extends AbstractNewEmpAddListUI {
    private static final Logger logger = CoreUIObject.getLogger(NewEmpAddListUI.class);
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSignResource";
    private static String RECORD_RESOURCE = "com.kingdee.eas.hr.train.client.TrainRecordResource";
    private boolean isCanceled = true;
    private Collection selectedCollection;
    Set personIds;

    public void onLoad() throws Exception {
        this.setIsNeedDefaultFilter(false);
        this.initTable();
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.tblSelected.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblSelected.getSelectManager().setSelectMode(10);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        JButton btnAddOne = this.contSelectedStudent.add((Action)((Object)this.actionAddOne));
        JButton btnDelOne = this.contSelectedStudent.add((Action)((Object)this.actionDelOne));
        JButton btnAddAll = this.contSelectedStudent.add((Action)((Object)this.actionAddAll));
        JButton btnDelAll = this.contSelectedStudent.add((Action)((Object)this.actionDelAll));
        btnAddOne.setText(EASResource.getString((String)RES, (String)"addLine"));
        btnDelOne.setText(EASResource.getString((String)RES, (String)"removeLine"));
        btnAddAll.setText(EASResource.getString((String)RES, (String)"addAll"));
        btnDelAll.setText(EASResource.getString((String)RES, (String)"removeAll"));
        btnAddOne.setToolTipText(EASResource.getString((String)RES, (String)"addLine"));
        btnDelOne.setToolTipText(EASResource.getString((String)RES, (String)"removeLine"));
        btnAddAll.setToolTipText(EASResource.getString((String)RES, (String)"addAll"));
        btnDelAll.setToolTipText(EASResource.getString((String)RES, (String)"removeAll"));
        JButton btnRemoveRecord = this.contNewStudent.add((Action)((Object)new ActionRemoveRecord()));
        btnRemoveRecord.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnRemoveRecord.setToolTipText(EASResource.getString((String)RECORD_RESOURCE, (String)"delete_row"));
    }

    private NewEmployeeInfo assembleEmpInfo(IRow row) {
        NewEmployeeInfo newEmployeeInfo = new NewEmployeeInfo();
        if (row != null && row.getCell("trainComplete").getValue() != null) {
            newEmployeeInfo.setTrainComplete(true);
            newEmployeeInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
        }
        return newEmployeeInfo;
    }

    public boolean isCancel() {
        return this.isCanceled;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.actionAddOne_actionPerformed(null);
        }
    }

    protected void tblSelected_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.actionDelOne_actionPerformed(null);
        } else {
            super.tblSelected_tableClicked(e);
        }
    }

    public Object getData() {
        Object[] objs = null;
        if (this.selectedCollection != null && this.selectedCollection.size() > 0) {
            objs = this.selectedCollection.toArray();
        }
        return objs;
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        int size = this.tblSelected.getRowCount();
        if (size > 0) {
            this.selectedCollection = new ArrayList();
            IRow row = null;
            for (int i = 0; i < size; ++i) {
                row = this.tblSelected.getRow(i);
                PersonInfo info = new PersonInfo();
                info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
                this.selectedCollection.add(info);
            }
            this.isCanceled = false;
        }
        this.getUIWindow().close();
    }

    protected void btnCancelOP_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = TrainUtils.getHRAndAdminRangeFilterInfo("adminOrgUnit.id");
        filterInfo.getFilterItems().add(new FilterItemInfo("trainComplete", (Object)Boolean.FALSE));
        this.personIds = (Set)this.getUIContext().get("person.id");
        int count = this.tblSelected.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblSelected.getRow(i);
            String str = row.getCell("id").getValue().toString();
            this.personIds.add(str);
        }
        if (this.personIds != null && !this.personIds.isEmpty()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.personIds, CompareType.NOTINCLUDE));
        }
        return filterInfo;
    }

    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        IRow row = null;
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            row = this.tblMain.getRow(i);
            if (this.existInSelectedPerson(row.getCell("id").getValue().toString())) continue;
            this.tblSelected.addRow(this.tblSelected.getRowCount(), row);
            this.tblMain.removeRow(i);
        }
    }

    private boolean existInSelectedPerson(String personId) {
        IRow row = null;
        int count = this.tblSelected.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblSelected.getRow(i);
            if (!personId.equals(row.getCell("id").getValue().toString())) continue;
            return true;
        }
        return false;
    }

    public void actionAddOne_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddOne_actionPerformed(e);
        List rowIndexList = TrainUtils.getSelectedRows(this.tblMain);
        IRow row = null;
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int rowIndex = (Integer)rowIndexList.get(i);
            row = this.tblMain.getRow(rowIndex);
            if (this.existInSelectedPerson(row.getCell("id").getValue().toString())) continue;
            this.tblSelected.addRow(this.tblSelected.getRowCount(), row);
            this.tblMain.removeRow(rowIndex);
        }
    }

    public void actionDelAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelAll_actionPerformed(e);
        IRow row = null;
        for (int i = this.tblSelected.getRowCount() - 1; i >= 0; --i) {
            row = this.tblSelected.getRow(i);
            String str = row.getCell("id").getValue().toString();
            this.tblMain.addRow(this.tblMain.getRowCount(), row);
            this.tblSelected.removeRow(i);
            this.personIds.remove(str);
        }
        this.tblMain.getSelectManager().select(0, 0);
    }

    public void actionDelOne_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelOne_actionPerformed(e);
        List rowIndexList = TrainUtils.getSelectedRows(this.tblSelected);
        IRow row = null;
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int rowIndex = (Integer)rowIndexList.get(i);
            row = this.tblSelected.getRow(rowIndex);
            if (row == null) continue;
            String str = row.getCell("id").getValue().toString();
            this.tblMain.addRow(this.tblMain.getRowCount(), row);
            this.tblSelected.removeRow(rowIndex);
            this.personIds.remove(str);
        }
        this.tblMain.getSelectManager().select(0, 0);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"person.number", "person.name"};
        return locateNames;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private class ActionRemoveRecord
    extends ItemAction {
        public ActionRemoveRecord() {
            this(null);
        }

        public ActionRemoveRecord(IUIObject uiObj) {
            super(uiObj);
            String _tempStr = "";
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift r"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)NewEmpAddListUI.this.tblMain);
            NewEmployeeCollection collection = null;
            Arrays.sort(rowIndexs);
            IRow row = null;
            if (MsgBox.showConfirm2((String)EASResource.getString((String)NewEmpAddListUI.RES, (String)"delNewEmp")) == 2) {
                return;
            }
            for (int i = rowIndexs.length - 1; i >= 0; --i) {
                row = NewEmpAddListUI.this.tblMain.getRow(rowIndexs[i]);
                if (row == null) continue;
                collection = new NewEmployeeCollection();
                NewEmployeeInfo empInfo = null;
                NewEmpAddListUI.this.tblMain.removeRow(rowIndexs[i]);
                empInfo = NewEmpAddListUI.this.assembleEmpInfo(row);
                collection.add(empInfo);
                try {
                    TrainActivityFacadeFactory.getRemoteInstance().change_newEmployeeState(collection);
                    continue;
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        }
    }
}

