/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.CodingRuleHelper;
import com.kingdee.eas.hr.train.OuterTrainApplyEntryCollection;
import com.kingdee.eas.hr.train.OuterTrainApplyEntryInfo;
import com.kingdee.eas.hr.train.OuterTrainApplyFactory;
import com.kingdee.eas.hr.train.OuterTrainApplyInfo;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainPlanInfo;
import com.kingdee.eas.hr.train.client.AbstractOuterTrainApplyEditUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class OuterTrainApplyEditUI
extends AbstractOuterTrainApplyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OuterTrainApplyEditUI.class);
    static String RES = "com.kingdee.eas.hr.train.client.TrainApplyResource";
    TrainAuditStateEnum state = TrainAuditStateEnum.UNSUBMIT;
    String ITEM = "ChargeItem";
    String AMOUNT = "Amount";
    private HashMap hmUIState = new HashMap();
    int PRECISION = 2;
    HashSet itemSet;
    JButton btnAddRuleNew;
    JButton btnDelRuleNew;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAttach.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.btnMultiapprove.setText(TrainClientUtil.getResource(RES, "multiapprove"));
        this.setButtonDefaultStyl(this.btnAuditResult);
        this.setButtonDefaultStyl(this.btnAttach);
        this.setButtonDefaultStyl(this.btnMultiapprove);
        this.menuBiz.setVisible(false);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.menuItemMultiapprove.setEnabled(false);
            this.kDMenuItemSendMessage.setEnabled(false);
            this.menuTable1.setVisible(false);
        } else {
            this.menuItemMultiapprove.setEnabled(true);
            this.kDMenuItemSendMessage.setEnabled(true);
            this.menuTable1.setVisible(true);
        }
    }

    public void actionAttach_actionPerformed(ActionEvent e) throws Exception {
        if (TrainClientUtil.objectIsNull(this.editData.getId())) {
            TrainClientUtil.showErrorMessage(RES, "mustSaveCanAttachment", (CoreUI)this);
        }
        super.actionAttach_actionPerformed(e);
        AttachmentClientManager am = AttachmentManagerFactory.getClientManager();
        am.showAttachmentListUIByBoID(this.editData.getId().toString(), (Object)this);
    }

    public void loadFields() {
        super.loadFields();
        this.state = this.editData.getAuditState();
        this.loadPositionAndAdmin();
        this.initWorkButtonState();
        this.countItemAmount();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            TrainClientUtil.lockUI((CoreUI)this, this.hmUIState);
        }
    }

    private void initWorkButtonState() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnAttach.setEnabled(false);
            this.btnAuditResult.setEnabled(false);
            this.btnMultiapprove.setEnabled(false);
        } else {
            this.btnAttach.setEnabled(true);
            this.btnAuditResult.setEnabled(true);
            this.btnMultiapprove.setEnabled(true);
        }
    }

    private void loadPositionAndAdmin() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.editData.getApplier().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.number"));
        try {
            PositionMemberCollection collection = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                PositionMemberInfo info = collection.get(0);
                this.prmtPosition.setValue((Object)info.getPosition());
                this.prmtOrgUnit.setValue((Object)info.getPosition().getAdminOrgUnit());
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void storeFields() {
        super.storeFields();
        this.truncateDate();
        this.editData.setAuditState(this.state);
        this.removeEmptyRow();
    }

    private void removeEmptyRow() {
        OuterTrainApplyEntryInfo info = new OuterTrainApplyEntryInfo();
        OuterTrainApplyEntryCollection collection = this.editData.getEntrys();
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (!ObjectValueUtil.objectValueEquals((AbstractObjectValue)collection.get(i), (AbstractObjectValue)info)) continue;
            collection.removeObject(i);
        }
    }

    private void truncateDate() {
        this.editData.setApplyDate(DateTimeUtils.truncateDate((Date)this.editData.getApplyDate()));
        this.editData.setStartDate(DateTimeUtils.truncateDate((Date)this.editData.getStartDate()));
        this.editData.setEndDate(DateTimeUtils.truncateDate((Date)this.editData.getEndDate()));
    }

    protected void showSubmitSuccess() {
        this.setMessageText(TrainClientUtil.getResource(RES, "outertrainapplySubmitSuccess"));
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    protected void showSaveSuccess() {
        this.setMessageText(TrainClientUtil.getResource(RES, "outerTrainApplySaveSuccess"));
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    protected String getEditUIName() {
        return OuterTrainApplyEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OuterTrainApplyFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new OuterTrainApplyEntryInfo();
    }

    protected IObjectValue createNewData() {
        OuterTrainApplyInfo objectValue = new OuterTrainApplyInfo();
        objectValue.setApplier(SysContext.getSysContext().getCurrentUserInfo().getPerson());
        objectValue.setName(TrainClientUtil.getResource(RES, "outerTrainApplyName"));
        objectValue.setAuditState(TrainAuditStateEnum.UNSUBMIT);
        objectValue.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        objectValue.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return objectValue;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("AuditState"));
        sic.add(new SelectorItemInfo("HrOrgUnit.id"));
        return sic;
    }

    public void onLoad() throws Exception {
        if (TrainClientUtil.objectIsNull(SysContext.getSysContext().getCurrentUserInfo().getPerson())) {
            TrainClientUtil.showErrorMessage(RES, "userNoPerson", (CoreUI)this);
        }
        TrainClientUtil.checkValidHRO((CoreUI)this);
        this.initEntryButton();
        this.btnAttachment.setVisible(true);
        super.onLoad();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        this.prmpTrainPlan.setQueryInfo("com.kingdee.eas.hr.train.app.TrainPlanForCourseRecordQuery");
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)40));
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)50));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainPlanActivity.trainType", (Object)"20"));
        filterInfo.setMaskString("(#0 or #1) and #2");
        filterInfo.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"hrOrgUnit.id", (String)"OrgUnit.id"), "AND");
        viewInfo.setFilter(filterInfo);
        this.prmpTrainPlan.setEntityViewInfo(viewInfo);
        this.prmpTrainItem.setQueryInfo("com.kingdee.eas.hr.train.app.TrainItemForCourseRecordQuery");
        TrainClientUtil.setDisableColor(this.kdtEntrys);
        this.initWorkButtonVisible();
        this.initChargeItem();
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            this.prmpTrainItem.setEnabled(this.prmpTrainPlan.getValue() != null);
        }
    }

    private void initChargeItem() {
        ICellEditor ChargeItemEditor = this.kdtEntrys.getColumn("ChargeItem").getEditor();
        KDBizPromptBox promptBox = (KDBizPromptBox)ChargeItemEditor.getComponent();
        promptBox.setEntityViewInfo(TrainUtils.getCurrentHREntityViewInfo());
    }

    private void initWorkButtonVisible() {
        this.btnAuditResult.setVisible(true);
        this.btnAttachment.setVisible(true);
        this.btnAttachment.setEnabled(true);
        this.btnAttach.setVisible(false);
    }

    protected void prmpTrainPlan_dataChanged(DataChangeEvent e) throws Exception {
        super.prmpTrainPlan_dataChanged(e);
        EntityViewInfo viewInfo = null;
        FilterInfo filterInfo = null;
        if (this.prmpTrainPlan.getData() != null) {
            this.prmpTrainItem.setEnabled(true);
            viewInfo = new EntityViewInfo();
            filterInfo = new FilterInfo();
            this.prmpTrainItem.setQueryInfo("com.kingdee.eas.hr.train.app.TrainItemForCourseRecordQuery");
            viewInfo.setFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"hrOrgUnit.id", (String)"adminOrgUnit.id"));
            filterInfo.getFilterItems().add(new FilterItemInfo("trainType", (Object)"20"));
            if (this.prmpTrainPlan.getData() != null) {
                TrainPlanInfo info = (TrainPlanInfo)this.prmpTrainPlan.getData();
                filterInfo.getFilterItems().add(new FilterItemInfo("trainPlan.id", (Object)info.getId().toString(), CompareType.EQUALS));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
            viewInfo.setFilter(filterInfo);
            this.prmpTrainItem.setEntityViewInfo(viewInfo);
        } else {
            this.prmpTrainItem.setData(null);
            this.prmpTrainItem.setEnabled(false);
        }
    }

    private void initEntryButton() {
        this.btnAddRuleNew = this.entryContainer.add((Action)this.actionAddLine);
        this.btnAddRuleNew.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)this.actionAddLine, (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnDelRuleNew = this.entryContainer.add((Action)this.actionRemoveLine);
        this.btnDelRuleNew.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)this.actionRemoveLine, (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnAddRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddRuleNew.setToolTipText(this.btnAddLine.getToolTipText());
        this.btnAddRuleNew.setText(null);
        this.btnAddRuleNew.setSize(22, 19);
        this.btnDelRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelRuleNew.setToolTipText(this.btnRemoveLine.getToolTipText());
        this.btnDelRuleNew.setText(null);
        this.btnDelRuleNew.setSize(22, 19);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtTrainChannel);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtTrainItem);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.combSubmitType);
        if (TrainClientUtil.objectIsNull(this.pkStartDate.getValue())) {
            this.pkStartDate.requestFocus();
            TrainClientUtil.showErrorMessage(RES, "outerTrainApplyStartDateNotNull", (CoreUI)this);
        }
        if (TrainClientUtil.objectIsNull(this.pkEndDate.getValue())) {
            this.pkEndDate.requestFocus();
            TrainClientUtil.showErrorMessage(RES, "outerTrainApplyEndDateNotNull", (CoreUI)this);
        }
        Date start = (Date)this.pkStartDate.getValue();
        Date end = (Date)this.pkEndDate.getValue();
        if ((start = DateTimeUtils.truncateDate((Date)start)).compareTo(end = DateTimeUtils.truncateDate((Date)end)) > 0) {
            this.pkEndDate.requestFocus();
            TrainClientUtil.showErrorMessage(RES, "outerTrainApplyStartSmallThanEnd", (CoreUI)this);
        }
        if (TrainClientUtil.objectIsNull(this.txtReason.getText())) {
            this.txtReason.requestFocus();
            TrainClientUtil.showErrorMessage(RES, "outerTrainApplyReasonNotNull", (CoreUI)this);
        }
        if (TrainClientUtil.objectIsNull(this.txtTrainTarget.getText())) {
            this.txtTrainTarget.requestFocus();
            TrainClientUtil.showErrorMessage(RES, "outerTrainApplyTrainTargetNotNull", (CoreUI)this);
        }
        this.checkEntry();
        if (TrainClientUtil.objectIsNull(this.txtTrainContent.getText())) {
            this.txtTrainContent.requestFocus();
            TrainClientUtil.showErrorMessage(RES, "outerTrainApplyTrainContentNotNull", (CoreUI)this);
        }
    }

    private void checkEntry() {
        this.itemSet = new HashSet();
        OuterTrainApplyEntryInfo info = new OuterTrainApplyEntryInfo();
        KDTEditManager kdtManager = this.kdtEntrys.getEditManager();
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            IObjectValue obj = (IObjectValue)row.getUserObject();
            this.dataBinder.storeLineFields(this.kdtEntrys, row, obj);
            if (ObjectValueUtil.objectValueEquals((AbstractObjectValue)info, (AbstractObjectValue)((AbstractObjectValue)obj))) continue;
            if (TrainClientUtil.objectIsNull(row.getCell(this.ITEM).getValue())) {
                kdtManager.editCellAt(i, this.kdtEntrys.getColumnIndex(this.ITEM));
                TrainClientUtil.showErrorMessage(RES, "outerTrainItemNotNull", (CoreUI)this);
            }
            this.checkLineDup(row, row.getCell(this.ITEM).getValue().toString());
        }
    }

    private void checkLineDup(IRow row, String item) {
        if (this.itemSet.contains(item)) {
            KDTEditManager kdtManager = this.kdtEntrys.getEditManager();
            kdtManager.editCellAt(row.getRowIndex(), this.kdtEntrys.getColumnIndex(this.ITEM));
            TrainClientUtil.showErrorMessage(RES, "outerTrainItemDup", (CoreUI)this);
        } else {
            this.itemSet.add(item);
        }
    }

    private void countItemAmount() {
        BigDecimal amount = new BigDecimal("0.00");
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            BigDecimal value = (BigDecimal)this.kdtEntrys.getRow(i).getCell(this.AMOUNT).getValue();
            if (value == null) continue;
            amount = amount.add(value);
        }
        String message = EASResource.getString((String)RES, (String)"outerTrainItemAmountTotal");
        Object[] variables = new Object[]{TrainClientUtil.formatBigDecimal(amount, this.PRECISION)};
        this.entryContainer.setTitle(MessageFormat.format(message, variables));
    }

    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        super.kdtEntrys_editStopped(e);
        if (e.getColIndex() == this.kdtEntrys.getColumnIndex(this.AMOUNT)) {
            this.countItemAmount();
        }
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        if (this.btnAddRuleNew != null) {
            this.btnAddRuleNew.setEnabled(false);
        }
        if (this.btnDelRuleNew != null) {
            this.btnDelRuleNew.setEnabled(false);
        }
        this.pkStartDate.setEnabled(false);
        this.pkStartDate.setEditable(false);
        this.pkStartDate.setRequired(false);
        this.pkEndDate.setEnabled(false);
        this.pkEndDate.setEnabled(false);
        this.pkEndDate.setRequired(false);
        this.kdtEntrys.setEnabled(false);
        this.txtTrainContent.setEditable(false);
        this.txtRemark.setEditable(false);
    }

    protected void unLockUI() {
        super.unLockUI();
        if (this.btnAddRuleNew != null) {
            this.btnAddRuleNew.setEnabled(true);
        }
        if (this.btnDelRuleNew != null) {
            this.btnDelRuleNew.setEnabled(true);
        }
        this.pkStartDate.setEnabled(true);
        this.pkStartDate.setEditable(true);
        this.pkStartDate.setRequired(true);
        this.pkEndDate.setEnabled(true);
        this.pkEndDate.setEnabled(true);
        this.pkEndDate.setRequired(true);
        this.kdtEntrys.setEnabled(true);
        this.txtTrainContent.setEditable(true);
        this.txtRemark.setEditable(true);
    }

    public IObjectPK runSave() throws Exception {
        IObjectPK objectPK = super.runSave();
        return objectPK;
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK objectPK = super.runSubmit();
        return objectPK;
    }

    public void kdtEntrys_Changed(int rowIndex, int colIndex) throws Exception {
        if (rowIndex < 0) {
            return;
        }
        super.kdtEntrys_Changed(rowIndex, colIndex);
    }

    protected void setAutoNumberByOrg(String orgType) {
        CodingRuleHelper.setAutoNumber((EditUI)this, (CoreBaseInfo)this.editData, this.txtNumber, this.getOprtState());
    }

    public boolean isPrepareInit() {
        return true;
    }
}

