/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.QuestionnaireOptionFactory;
import com.kingdee.eas.hr.train.QuestionnaireOptionInfo;
import com.kingdee.eas.hr.train.QuestionnaireOptionTreeInfo;
import com.kingdee.eas.hr.train.client.AbstractQuestionnaireOptionEditUI;
import com.kingdee.eas.hr.train.client.QuestionnaireOptionTreeF7UI;
import com.kingdee.eas.hr.train.client.TableActionHandler;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.hr.train.client.TreeBasePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class QuestionnaireOptionEditUI
extends AbstractQuestionnaireOptionEditUI {
    private static final Logger logger = CoreUIObject.getLogger(QuestionnaireOptionEditUI.class);
    private ItemAction[] actions;
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainResource";

    public void onLoad() throws Exception {
        this.kdtContentOption.checkParsed();
        this.init();
        super.onLoad();
    }

    private void init() throws Exception {
        TreeBasePromptBox questionnaireOptionTreeF7 = new TreeBasePromptBox((IUIObject)this, QuestionnaireOptionTreeF7UI.class.getName());
        this.prmtTreeid.setSelector((KDPromptSelector)questionnaireOptionTreeF7);
        this.actions = QuestionnaireOptionEditUI.addButtonsToMutilTable(this.contContentOption, this.kdtContentOption, null);
        TrainUtils.setTableCellEditorByCheckBox(this.kdtContentOption, "IsDescription");
        TrainUtils.setTableCellEditorByTextField(this.kdtContentOption, "OptionSymbol", 10);
        TrainUtils.setTableCellEditorByTextField(this.kdtContentOption, "OptDescrip", 100);
    }

    protected IObjectValue createNewData() {
        QuestionnaireOptionInfo objectValue = new QuestionnaireOptionInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setHrOrgUnit(TrainUtils.getCurrentHROrgUnit());
        objectValue.setTreeid((QuestionnaireOptionTreeInfo)this.getUIContext().get("ParentNode"));
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return QuestionnaireOptionFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        if (this.kdtContentOption.getRowCount() != 0) {
            TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtContentOption, "OptionSymbol");
            TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtContentOption, "OptDescrip");
        }
        TrainVerifyUtils.verifyInputByContainer(this.contContentOption, this.kdtContentOption);
    }

    public static ItemAction[] addButtonsToMutilTable(KDContainer container, KDTable table, TableActionHandler handler) {
        QuestionnaireOptionEditUI.setMutilTableFromBIM(container, table);
        class ActionRow
        extends ItemAction {
            private String name;
            private KDTable table;
            private TableActionHandler handler;

            ActionRow(KDTable table, String name, TableActionHandler handler) {
                this.table = table;
                this.name = name;
                this.handler = handler;
            }

            public void actionPerformed(ActionEvent e) {
                if ("ActionAddLine".equals(this.name)) {
                    IRow row = QuestionnaireOptionEditUI.addLine(this.table);
                    if (this.handler != null) {
                        this.handler.afterAddLine(row);
                    }
                } else if ("ActionInsertLine".equals(this.name)) {
                    IRow row = QuestionnaireOptionEditUI.insertLine(this.table);
                    if (this.handler != null) {
                        this.handler.afterInsertLine(row);
                    }
                } else if ("ActionRemoveLine".equals(this.name)) {
                    QuestionnaireOptionEditUI.removeLine(this.table);
                }
            }
        }
        ActionRow actionAddLine = new ActionRow(table, "ActionAddLine", handler);
        ActionRow actionInsertLine = new ActionRow(table, "ActionInsertLine", handler);
        ActionRow actionRemoveLine = new ActionRow(table, "ActionRemoveLine", handler);
        TrainUtils.initMutilTableFromBIM(container, (Action)((Object)actionAddLine), (Action)((Object)actionInsertLine), (Action)((Object)actionRemoveLine));
        ItemAction[] actions = new ItemAction[]{actionAddLine, actionInsertLine, actionRemoveLine};
        return actions;
    }

    public static IRow addLine(KDTable table) {
        if (table == null) {
            return null;
        }
        IRow row = table.addRow();
        row.getCell("IsDescription").setValue((Object)false);
        return row;
    }

    public static IRow insertLine(KDTable table) {
        if (table == null) {
            return null;
        }
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = QuestionnaireOptionEditUI.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        if (row != null) {
            row.getCell("IsDescription").setValue((Object)false);
        }
        return row;
    }

    private static boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public static void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || QuestionnaireOptionEditUI.isTableColumnSelected(table)) {
            return;
        }
        int[] selectRowsIndex = TrainHelper.getSelectedRows(table);
        if (selectRowsIndex.length > 0) {
            int[] selectedColumnIndexs = TrainHelper.getSelectedColumns(table);
            Arrays.sort(selectRowsIndex);
            for (int i = selectRowsIndex.length - 1; i >= 0; --i) {
                QuestionnaireOptionEditUI.removeRow(table, selectRowsIndex[i]);
            }
            if (table.getRowCount() > 0) {
                Arrays.sort(selectedColumnIndexs);
                int columnIndex = 0;
                if (selectedColumnIndexs.length > 0) {
                    columnIndex = selectedColumnIndexs[0];
                }
                table.getSelectManager().select(selectRowsIndex[0], columnIndex);
            }
        }
    }

    public static void removeRow(KDTable table, int rowIndex) {
        IObjectCollection collection;
        int index;
        Object detailData = table.getRow(rowIndex).getUserObject();
        table.removeRow(rowIndex);
        if (detailData != null && (index = QuestionnaireOptionEditUI.getCollectionIndex(collection = (IObjectCollection)table.getUserObject(), (IObjectValue)detailData)) >= 0 && collection.size() > index) {
            collection.removeObject(index);
        }
    }

    private static int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    public static void setMutilTableFromBIM(KDContainer container, KDTable table) {
        container.getContentPane().removeAll();
        container.getContentPane().add((Component)table);
    }

    public void loadFields() {
        super.loadFields();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setActionState(false);
        } else {
            this.setActionState(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isRefered()) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"IsReference_QuestionOpt"));
            return;
        }
        this.setActionState(true);
        super.actionEdit_actionPerformed(e);
    }

    private void setActionState(boolean flag) {
        if (this.actions != null) {
            for (int i = 0; i < this.actions.length; ++i) {
                this.actions[i].setEnabled(flag);
            }
        }
        this.kdtContentOption.getStyleAttributes().setLocked(!flag);
        if (flag) {
            this.kdtContentOption.getColumn("OptionSymbol").getStyleAttributes().setBackground(TrainClientUtil.requiredColor);
            this.kdtContentOption.getColumn("OptDescrip").getStyleAttributes().setBackground(TrainClientUtil.requiredColor);
        } else {
            this.kdtContentOption.getColumn("OptionSymbol").getStyleAttributes().setBackground(Color.WHITE);
            this.kdtContentOption.getColumn("OptDescrip").getStyleAttributes().setBackground(Color.WHITE);
        }
    }

    private boolean isRefered() throws Exception {
        String id = this.editData.getId().toString();
        if (id == null) {
            return false;
        }
        return QuestionnaireOptionFactory.getRemoteInstance().isReferen(id);
    }
}

