/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.train.RequirementConstants;
import com.kingdee.eas.hr.train.RequirementCourseTypeEnum;
import com.kingdee.eas.hr.train.RequirementEntryCollection;
import com.kingdee.eas.hr.train.RequirementEntryInfo;
import com.kingdee.eas.hr.train.RequirementInfo;
import com.kingdee.eas.hr.train.RequirementIssueCollection;
import com.kingdee.eas.hr.train.RequirementIssueEntryCollection;
import com.kingdee.eas.hr.train.RequirementIssueEntryFactory;
import com.kingdee.eas.hr.train.RequirementIssueEntryInfo;
import com.kingdee.eas.hr.train.RequirementIssueFactory;
import com.kingdee.eas.hr.train.RequirementIssueInfo;
import com.kingdee.eas.hr.train.ResponseAppointedCourseInfo;
import com.kingdee.eas.hr.train.ResponseSuggestCourseInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseTreeInfo;
import com.kingdee.eas.hr.train.TrainSurveyPublishCollection;
import com.kingdee.eas.hr.train.TrainSurveyPublishFactory;
import com.kingdee.eas.hr.train.TrainSurveyPublishInfo;
import com.kingdee.eas.hr.train.TrainingMethodInfo;
import com.kingdee.eas.hr.train.client.TrainCourseForReportPromptBox;
import com.kingdee.eas.hr.train.client.TrainItemF7UI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TreeBasePromptBox;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class RequirementClientUtil {
    public static final Logger logger = Logger.getLogger((String)RequirementClientUtil.class.getName());
    public static final String LOADFIELD = "loadField";
    public static final String STOREFIELD = "storeField";
    static final String[] columns = new String[]{"highCount", "middleCount", "lowCount"};

    public static KDBizPromptBox getCoursePromptBox(IUIObject owner, boolean multiSelect) {
        KDBizPromptBox courseBox = new KDBizPromptBox();
        TrainCourseForReportPromptBox box = new TrainCourseForReportPromptBox(owner);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CourseHour"));
        selector.add(new SelectorItemInfo("CourseHourUnit"));
        selector.add(new SelectorItemInfo("CourseJoinner"));
        selector.add(new SelectorItemInfo("courseCost"));
        selector.add(new SelectorItemInfo("treeid.id"));
        selector.add(new SelectorItemInfo("treeid.name"));
        box.setSelector(selector);
        box.setSingleSelect(!multiSelect);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
        box.setFilterInfo(filterInfo);
        courseBox.setSelector((KDPromptSelector)box);
        courseBox.setDisplayFormat("$name$");
        courseBox.setEditFormat("$number$");
        courseBox.setCommitFormat("$number$");
        courseBox.setEnabledMultiSelection(multiSelect);
        courseBox.setEditable(false);
        return courseBox;
    }

    public static KDBizPromptBox getTrainItemPromptBox(IUIObject owner, boolean multiSelect) {
        KDBizPromptBox prmtTrainItem = new KDBizPromptBox();
        prmtTrainItem.setVisible(true);
        prmtTrainItem.setDisplayFormat("$name$");
        prmtTrainItem.setEditFormat("$number$");
        prmtTrainItem.setCommitFormat("$number$");
        String uiName = TrainItemF7UI.class.getName();
        TreeBasePromptBox promptBox = new TreeBasePromptBox(owner, uiName);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isEnable", (Object)1));
        promptBox.setFilterInfo(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("treeid.id"));
        sic.add(new SelectorItemInfo("treeid.name"));
        sic.add(new SelectorItemInfo("courseHour"));
        sic.add(new SelectorItemInfo("courseHourUnit"));
        sic.add(new SelectorItemInfo("trainObject"));
        sic.add(new SelectorItemInfo("trainMethod.id"));
        sic.add(new SelectorItemInfo("trainMethod.name"));
        promptBox.setSelector(sic);
        promptBox.setSingleSelect(!multiSelect);
        prmtTrainItem.setSelector((KDPromptSelector)promptBox);
        prmtTrainItem.setEnabledMultiSelection(multiSelect);
        prmtTrainItem.setEditable(false);
        return prmtTrainItem;
    }

    public static String getIssueId(String requirementId, String personId) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)requirementId));
        filterInfo.getFilterItems().add(new FilterItemInfo("publisher.id", (Object)personId));
        viewInfo.setFilter(filterInfo);
        RequirementIssueCollection collection = RequirementIssueFactory.getRemoteInstance().getRequirementIssueCollection(viewInfo);
        String id = null;
        if (collection != null && collection.size() > 0) {
            id = collection.get(0).getId().toString();
        }
        return id;
    }

    public static RequirementIssueInfo getRootIssueInfo(String requirementId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)requirementId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isRoot", (Object)1));
        viewInfo.setFilter(filterInfo);
        RequirementIssueCollection collection = RequirementIssueFactory.getRemoteInstance().getRequirementIssueCollection(viewInfo);
        RequirementIssueInfo info = null;
        if (collection != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public static String getIssueId(String requirementId, boolean isCreatorOrSameOrg) throws Exception {
        String requirementIssueId = null;
        if (isCreatorOrSameOrg) {
            RequirementIssueInfo issueInfo = RequirementClientUtil.getRootIssueInfo(requirementId);
            if (!TrainCommonUtils.isEmpty((CoreBaseInfo)issueInfo)) {
                requirementIssueId = issueInfo.getId().toString();
            }
        } else {
            String currentPersonId = TrainUtils.getCurrentPersonId();
            requirementIssueId = RequirementClientUtil.getIssueId(requirementId, currentPersonId);
        }
        return requirementIssueId;
    }

    public static RequirementEntryCollection getOuterCourses(RequirementInfo requirementInfo) {
        RequirementEntryCollection outerCourses = null;
        if (requirementInfo.getEntry() != null && requirementInfo.getEntry().size() > 0) {
            int i;
            RequirementEntryCollection collection = requirementInfo.getEntry();
            outerCourses = new RequirementEntryCollection();
            RequirementEntryInfo entry = null;
            int size = collection.size();
            for (i = 0; i < size; ++i) {
                entry = collection.get(i);
                if (TrainCommonUtils.isEmpty(entry.getTrainSubject())) continue;
                outerCourses.add(entry);
            }
            size = outerCourses.size();
            for (i = 0; i < size; ++i) {
                collection.removeObject((IObjectValue)outerCourses.get(i));
            }
        }
        return outerCourses;
    }

    public static void loadOuterCourseFields(KDTable table, RequirementEntryCollection outerCourses) {
        table.removeRows();
        if (outerCourses != null && outerCourses.size() > 0) {
            int size = outerCourses.size();
            for (int i = 0; i < size; ++i) {
                RequirementClientUtil.loadOuterCourseRowFields(table, outerCourses.get(i));
            }
        }
    }

    public static void loadOuterCourseRowFields(KDTable table, RequirementEntryInfo info) {
        IRow row = table.addRow();
        row.setUserObject((Object)info);
        row.getCell("id").setValue((Object)info.getId());
        row.getCell("type").setValue((Object)info.getType());
        row.getCell("trainSubject").setValue((Object)info.getTrainSubject());
        row.getCell("courseType").setValue((Object)info.getCourseType());
        row.getCell("startDate").setValue((Object)info.getStartDate());
        row.getCell("trainMethod").setValue((Object)info.getTrainMethod());
        row.getCell("object").setValue((Object)info.getObject());
        row.getCell("cost").setValue((Object)info.getCost());
        row.getCell("remark").setValue((Object)info.getRemark());
    }

    public static void storeOuterCourse(RequirementInfo editData, KDTable kdtOuterCourse) {
        if (kdtOuterCourse.getRowCount() > 0) {
            RequirementEntryCollection collection = editData.getEntry();
            int count = kdtOuterCourse.getRowCount();
            for (int i = 0; i < count; ++i) {
                RequirementClientUtil.storeRowOuterCourse(collection, kdtOuterCourse.getRow(i));
            }
        }
    }

    private static void storeRowOuterCourse(RequirementEntryCollection collection, IRow row) {
        RequirementCourseTypeEnum type;
        RequirementEntryInfo entry = (RequirementEntryInfo)row.getUserObject();
        if (entry == null) {
            entry = new RequirementEntryInfo();
        }
        if (row.getCell("id").getValue() != null) {
            entry.setId((BOSUuid)row.getCell("id").getValue());
        }
        if ((type = (RequirementCourseTypeEnum)((Object)row.getCell("type").getValue())) != null) {
            entry.setType(type);
        }
        entry.setTrainSubject((String)row.getCell("trainSubject").getValue());
        entry.setCourseType((TrainCourseTreeInfo)row.getCell("courseType").getValue());
        entry.setStartDate((Date)row.getCell("startDate").getValue());
        entry.setTrainMethod((TrainingMethodInfo)row.getCell("trainMethod").getValue());
        entry.setObject((String)row.getCell("object").getValue());
        entry.setCost((BigDecimal)row.getCell("cost").getValue());
        entry.setRemark((String)row.getCell("remark").getValue());
        if (!RequirementClientUtil.checkEntryRepeat(collection, entry)) {
            collection.add(entry);
        }
    }

    private static boolean checkEntryRepeat(RequirementEntryCollection collection, RequirementEntryInfo entry) {
        boolean repeated = false;
        RequirementEntryInfo info = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            info = collection.get(i);
            if (entry.getTrainSubject().equals(info.getTrainSubject())) {
                repeated = true;
                break;
            }
            if (info.getCourse() != null && entry.getTrainSubject().equals(info.getCourse().getName())) {
                repeated = true;
                break;
            }
            if (info.getTrainItem() == null || !entry.getTrainSubject().equals(info.getTrainItem().getName())) continue;
            repeated = true;
            break;
        }
        return repeated;
    }

    public static FilterInfo getRequirementFilterInfo(String currentPersonId, String userOrgUnitId) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)currentPersonId));
        filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)userOrgUnitId));
        filterInfo.getFilterItems().add(new FilterItemInfo("receiver.id", (Object)currentPersonId));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)10, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("issueEntry.state", (Object)20));
        filterInfo.setMaskString("#0 or #1 or (#2 and #3 and #4)");
        try {
            filterInfo.mergeFilter(TrainUtils.getHROrgUnitFilter("hrOrgUnit.id"), "AND");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return filterInfo;
    }

    public static void setRequirementGrade(KDTEditEvent e) {
        KDCheckBox checkBox;
        KDTable table = (KDTable)e.getSource();
        Component component = table.getEditManager().getEditor().getComponent();
        if (component != null && component instanceof KDCheckBox && (checkBox = (KDCheckBox)component).isSelected()) {
            int colIndex = e.getColIndex();
            IRow row = table.getRow(e.getRowIndex());
            for (int i = 0; i < columns.length; ++i) {
                if (table.getColumnIndex(columns[i]) == colIndex) continue;
                row.getCell(columns[i]).setValue((Object)Boolean.FALSE);
            }
        }
    }

    public static void changeRequirementGradeValue(KDTable table, IObjectCollection collection, String flag) {
        if (collection != null && collection.size() > 0) {
            IRow row = null;
            Boolean booleanValue = null;
            IObjectValue objectValue = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                row = table.getRow(i);
                objectValue = RequirementClientUtil.getObjectValue(collection, row);
                if (objectValue == null) continue;
                for (int j = 0; j < columns.length; ++j) {
                    int value;
                    if (LOADFIELD.equals(flag)) {
                        value = objectValue.getInt(columns[j]);
                        booleanValue = value > 0;
                        row.getCell(columns[j]).setValue((Object)booleanValue);
                        continue;
                    }
                    if (!STOREFIELD.equals(flag)) continue;
                    booleanValue = (Boolean)row.getCell(columns[j]).getValue();
                    value = Boolean.TRUE.equals(booleanValue) ? 1 : 0;
                    objectValue.setInt(columns[j], value);
                }
            }
        }
    }

    public static IObjectValue getObjectValue(IObjectCollection collection, IRow row) {
        IObjectValue returnValue = null;
        String requirementEntryId = null;
        String trainSubject = null;
        if (row.getUserObject() instanceof ResponseAppointedCourseInfo) {
            ResponseAppointedCourseInfo value = (ResponseAppointedCourseInfo)row.getUserObject();
            requirementEntryId = value.getRequirementEntry().getId().toString();
        } else if (row.getUserObject() instanceof ResponseSuggestCourseInfo) {
            trainSubject = (String)row.getCell("trainSubject").getValue();
        }
        String infoTrainSubject = null;
        IObjectValue entryInfo = null;
        RequirementEntryInfo requirementEntryInfo = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = collection.getObject(i);
            if (entryInfo instanceof ResponseAppointedCourseInfo) {
                requirementEntryInfo = ((ResponseAppointedCourseInfo)entryInfo).getRequirementEntry();
                if (!requirementEntryId.equals(requirementEntryInfo.getId().toString())) continue;
                returnValue = entryInfo;
                break;
            }
            if (!(entryInfo instanceof ResponseSuggestCourseInfo)) continue;
            infoTrainSubject = ((ResponseSuggestCourseInfo)entryInfo).getTrainSubject();
            if (TrainCommonUtils.isEmpty(trainSubject) || !trainSubject.equals(infoTrainSubject)) continue;
            returnValue = entryInfo;
            break;
        }
        return returnValue;
    }

    public static String transformType(String type) {
        String returnValue = null;
        if ("appointed".equals(type)) {
            returnValue = RequirementConstants.APPOINTED_COURSE;
        } else if ("suggest".equals(type)) {
            returnValue = RequirementConstants.SUGGEST_COURSE;
        }
        return returnValue;
    }

    public static boolean isCreatorOrSameOrg(String requirementId, String createPersonId, String adminOrgUnitId, String currentPersonId, String userOrgUnitId) {
        if (createPersonId.equals(currentPersonId)) {
            return true;
        }
        RequirementIssueEntryCollection entrys = RequirementClientUtil.getRequirementIssueEntry(requirementId, currentPersonId);
        if (entrys != null && entrys.size() > 0) {
            RequirementIssueEntryInfo info = null;
            boolean isReceiver = false;
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                info = entrys.get(i);
                if (info.getParent().isIsRoot() && info.getParent().getPublisher().getId().toString().equals(currentPersonId)) {
                    return true;
                }
                if (!info.getPerson().getId().toString().equals(currentPersonId)) continue;
                isReceiver = true;
            }
            if (adminOrgUnitId.equals(userOrgUnitId) && !isReceiver) {
                return true;
            }
        }
        return false;
    }

    private static RequirementIssueEntryCollection getRequirementIssueEntry(String requirementId, String personId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("parent.isRoot"));
        viewInfo.getSelector().add(new SelectorItemInfo("parent.publisher.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.requirement.id", (Object)requirementId));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)20));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.publisher.id", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.isRoot", (Object)1));
        filterInfo.setMaskString("#0 and #1 and (#2 or (#3 and #4))");
        viewInfo.setFilter(filterInfo);
        RequirementIssueEntryCollection entrys = null;
        try {
            entrys = RequirementIssueEntryFactory.getRemoteInstance().getRequirementIssueEntryCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return entrys;
    }

    public static TrainSurveyPublishInfo getRootSurveyInfo(String requirementId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainSurvey.id", (Object)requirementId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isRoot", (Object)1));
        viewInfo.setFilter(filterInfo);
        TrainSurveyPublishCollection collection = TrainSurveyPublishFactory.getRemoteInstance().getTrainSurveyPublishCollection(viewInfo);
        TrainSurveyPublishInfo info = null;
        if (collection != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public static String getSurveyId(String requirementId) throws Exception {
        String surveyPublishId = null;
        TrainSurveyPublishInfo surveyInfo = RequirementClientUtil.getRootSurveyInfo(requirementId);
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)surveyInfo)) {
            surveyPublishId = surveyInfo.getId().toString();
        }
        return surveyPublishId;
    }
}

