/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.RequirementAssistant;
import com.kingdee.eas.hr.train.RequirementFacadeFactory;
import com.kingdee.eas.hr.train.RequirementResponseEnum;
import com.kingdee.eas.hr.train.RequirementResponseFactory;
import com.kingdee.eas.hr.train.RequirementStateEnum;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.client.AbstractRequirementResponseListUI;
import com.kingdee.eas.hr.train.client.RequirementResponsePersonUI;
import com.kingdee.eas.hr.train.client.RequirementResponsePublisherUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class RequirementResponseListUI
extends AbstractRequirementResponseListUI {
    private static final Logger logger = Logger.getLogger((String)RequirementResponseListUI.class.getName());
    private static final String RESOURCE = "com.kingdee.eas.hr.train.RequirementResource";
    private static final String RESPONSE_STATE = "responseState";
    private static final String RESPONSE_ID = "requirementResponseId";
    private boolean isPublisher;
    private String currentPersonId;
    private boolean startOnLoad = false;
    private Boolean defaultFilterFlag = null;

    public void onLoad() throws Exception {
        this.startOnLoad = true;
        TrainClientUtil.checkValidPerson((CoreUI)this);
        super.onLoad();
        this.currentPersonId = TrainUtils.getCurrentPersonId();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnResponse.setIcon(EASResource.getIcon((String)"imgTbtn_readin"));
        this.menuItemResponse.setIcon(EASResource.getIcon((String)"imgTbtn_readin"));
        this.actionResponse.setEnabled(true);
        this.btnViewResponse.setIcon(EASResource.getIcon((String)"imgTbtn_topview"));
        this.menuItemView.setIcon(EASResource.getIcon((String)"imgTbtn_topview"));
    }

    protected FilterInfo getDefaultFilterForQuery() {
        String curPersonId = TrainUtils.getCurrentPersonId();
        return RequirementAssistant.getRequirementResponseFilter(curPersonId);
    }

    public void actionResponse_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int index = TrainUtils.getCurrentRowIndex(this.tblMain);
        IRow row = this.tblMain.getRow(index);
        String requirementState = row.getCell("state").getValue().toString();
        if (RequirementStateEnum.CLOSED.getAlias().equals(requirementState)) {
            TrainClientUtil.showMessageAndAbort(RESOURCE, "REQUIREMENT_CLOSED", new Object[]{this.btnResponse.getText()}, (CoreUI)this);
        }
        String requirementId = row.getCell("id").getValue().toString();
        boolean parentIsResponsed = RequirementResponseFactory.getRemoteInstance().parentIsResponsed(requirementId, this.currentPersonId);
        if (parentIsResponsed) {
            TrainClientUtil.showMessageAndAbort(RESOURCE, "PARENT_IS_RESPONSED", new Object[]{this.btnResponse.getText()}, (CoreUI)this);
        }
        String responseState = row.getCell(RESPONSE_STATE).getValue().toString();
        if (RequirementResponseEnum.RESPONSED.getAlias().equals(responseState) && !TrainClientUtil.showConfirmMessge(RESOURCE, "RESPONSED", (CoreUI)this)) {
            return;
        }
        this.isPublisher = RequirementFacadeFactory.getRemoteInstance().isAsPublisher(requirementId, this.currentPersonId);
        String requirementResponseId = (String)row.getCell(RESPONSE_ID).getValue();
        if (TrainCommonUtils.isEmpty(requirementResponseId)) {
            this.getUIContext().put("requirement", requirementId);
            this.actionAddNew_actionPerformed(e);
        } else {
            IUIWindow uiWindow = this.showWindow(requirementResponseId, OprtState.EDIT);
            CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
            if (this.isDoRefresh(uiWindow)) {
                this.setLocatePre(false);
                this.refresh(e);
                this.setPreSelecteRow();
                this.setLocatePre(true);
            }
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        super.refresh(e);
    }

    private IUIWindow showWindow(String requirementResponseId, String state) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)requirementResponseId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, state);
        uiWindow.show();
        return uiWindow;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int index = TrainUtils.getCurrentRowIndex(this.tblMain);
        IRow row = this.tblMain.getRow(index);
        String requirementId = row.getCell("id").getValue().toString();
        this.isPublisher = RequirementFacadeFactory.getRemoteInstance().isAsPublisher(requirementId, this.currentPersonId);
        String requirementResponseId = (String)row.getCell(RESPONSE_ID).getValue();
        if (TrainCommonUtils.isEmpty(requirementResponseId)) {
            TrainClientUtil.showMessageAndAbort(RESOURCE, "NO_REQUIREMENTRESPONSE", (CoreUI)this);
        }
        this.showWindow(requirementResponseId, OprtState.VIEW);
    }

    protected String getEditUIName() {
        String editUIName = null;
        editUIName = this.isPublisher ? RequirementResponsePublisherUI.class.getName() : RequirementResponsePersonUI.class.getName();
        return editUIName;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RequirementResponseFactory.getRemoteInstance();
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    public IUIActionPostman prepareInit() {
        TrainClientUtil.checkValidPerson((CoreUI)this);
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), this, this.mainQueryPK);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

