/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.RequirementAssistant;
import com.kingdee.eas.hr.train.RequirementFacadeFactory;
import com.kingdee.eas.hr.train.RequirementResponseEnum;
import com.kingdee.eas.hr.train.RequirementResponseFactory;
import com.kingdee.eas.hr.train.RequirementResponseInfo;
import com.kingdee.eas.hr.train.RequirementStateEnum;
import com.kingdee.eas.hr.train.client.AbstractRequirementResponseSummaryUI;
import com.kingdee.eas.hr.train.client.ReqResponseDetailUI;
import com.kingdee.eas.hr.train.client.RequirementClientUtil;
import com.kingdee.eas.hr.train.client.RequirementResponsePublisherUI;
import com.kingdee.eas.hr.train.client.RequirementResponseSummaryFilterUI;
import com.kingdee.eas.hr.train.client.ResponseSuggestSummaryUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;

public class RequirementResponseSummaryUI
extends AbstractRequirementResponseSummaryUI {
    private static final String RESOURCE = "com.kingdee.eas.hr.train.RequirementResource";
    private static final String orgNumberAlias = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"ORG_NUMBER");
    private static final String orgNameAlias = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"ORG_NAME");
    private static final String HIGH_COUNT = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"HIGH_COUNT");
    private static final String MIDDLE_COUNT = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"MIDDLE_COUNT");
    private static final String LOW_COUNT = EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"LOW_COUNT");
    private static final String COLUMN_ORG_NUMBER = "orgNumber";
    private static final String COLUMN_ORG_NAME = "orgName";
    private static final int HEADROW_COUNT = 4;
    private static final int COLUMN_WIDTH = 30;
    private static final int ORGNUMBER_COLUMNINDEX = 0;
    private static final int ORGNAME_COLUMNINDEX = 1;
    private int startColumn;
    private int endColumn;
    private String requirementId;
    private String publisherId;
    private Set responserIds;
    private CommonQueryDialog dialog = null;
    private FilterInfo mainFilterInfo = null;

    public void onLoad() throws Exception {
        this.setIsNeedDefaultFilter(false);
        this.requirementId = (String)this.getUIContext().get("requirement");
        this.publisherId = (String)this.getUIContext().get("publisherId");
        this.responserIds = RequirementFacadeFactory.getRemoteInstance().getRequirementReceivers(this.requirementId, this.publisherId);
        if (this.responserIds == null || this.responserIds.isEmpty()) {
            TrainClientUtil.showErrorMessage(RESOURCE, "NO_RESPONSE_DATA", (CoreUI)this);
        }
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.mainFilterInfo = this.getDefaultFilterForQuery();
        this.fillTable();
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    private void fillTable() throws Exception {
        this.tblMain.removeHeadRows();
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        IRowSet rowSet = RequirementFacadeFactory.getRemoteInstance().getResponseSummary(this.mainFilterInfo);
        if (rowSet.size() == 0) {
            TrainClientUtil.showErrorMessage(RESOURCE, "NO_RESPONSE_DATA", (CoreUI)this);
        }
        this.initTableHead();
        while (rowSet.next()) {
            int rowIndex = this.getRowIndex(rowSet);
            int columnIndex = this.getColumnIndex(rowSet);
            this.fillRowData(rowSet, rowIndex, columnIndex);
        }
        this.mergeTableHead();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirementId", (Object)this.requirementId));
        filterInfo.getFilterItems().add(new FilterItemInfo("responserId", (Object)this.responserIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)20));
        return filterInfo;
    }

    private void initTableHead() {
        IRow headRow = null;
        IColumn column = this.tblMain.addColumn();
        column.setKey(COLUMN_ORG_NUMBER);
        column = this.tblMain.addColumn();
        column.setKey(COLUMN_ORG_NAME);
        for (int i = 0; i < 4; ++i) {
            headRow = this.tblMain.addHeadRow();
            headRow.getCell(0).setValue((Object)orgNumberAlias);
            headRow.getCell(1).setValue((Object)orgNameAlias);
        }
        KDTMergeManager mm = this.tblMain.getHeadMergeManager();
        mm.mergeBlock(0, 0, 3, 0);
        mm.mergeBlock(0, 1, 3, 1);
    }

    private int getRowIndex(IRowSet rowSet) throws SQLException {
        String orgId = rowSet.getString("adminOrgUnitId");
        IRow row = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            if (!orgId.equals(row.getUserObject())) continue;
            return i;
        }
        row = this.tblMain.addRow();
        row.setUserObject((Object)orgId);
        row.getCell(0).setValue((Object)rowSet.getString("adminOrgUnitNumber"));
        row.getCell(1).setValue((Object)rowSet.getString("adminOrgUnitName"));
        return this.tblMain.getRowCount() - 1;
    }

    private int getColumnIndex(IRowSet rowSet) throws SQLException {
        String type = RequirementClientUtil.transformType(rowSet.getString("type"));
        String contentType = rowSet.getString("contentType");
        String contentName = rowSet.getString("contentName");
        this.startColumn = 2;
        this.endColumn = this.tblMain.getColumnCount();
        boolean flag = this.assertColumnPosition(type, this.tblMain.getHeadRow(0));
        if (!flag) {
            flag = this.assertColumnPosition(contentType, this.tblMain.getHeadRow(1));
        }
        if (!flag) {
            this.assertColumnPosition(contentName, this.tblMain.getHeadRow(2));
        }
        int index = 0;
        for (int i = this.startColumn; i < this.endColumn; ++i) {
            this.tblMain.getHeadRow(0).getCell(i).setValue((Object)type);
            this.tblMain.getHeadRow(1).getCell(i).setValue((Object)contentType);
            this.tblMain.getHeadRow(2).getCell(i).setValue((Object)contentName);
            if (index == 0) {
                this.tblMain.getHeadRow(3).getCell(i).setValue((Object)HIGH_COUNT);
            } else if (index == 1) {
                this.tblMain.getHeadRow(3).getCell(i).setValue((Object)MIDDLE_COUNT);
            } else if (index == 2) {
                this.tblMain.getHeadRow(3).getCell(i).setValue((Object)LOW_COUNT);
            }
            ++index;
        }
        return this.startColumn;
    }

    private boolean assertColumnPosition(String title, IRow headRow) {
        boolean flag = false;
        if (!this.existTableHead(title, headRow)) {
            this.startColumn = this.endColumn;
            this.endColumn += 3;
            IColumn column = null;
            for (int i = this.startColumn; i < this.endColumn; ++i) {
                column = this.tblMain.addColumn(i);
                column.setWidth(30);
                column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            flag = true;
        }
        return flag;
    }

    private boolean existTableHead(String title, IRow headRow) {
        String value = null;
        boolean find = false;
        for (int i = this.startColumn; i < this.endColumn; ++i) {
            value = (String)headRow.getCell(i).getValue();
            if (value.equals(title)) {
                if (find) continue;
                this.startColumn = i;
                find = true;
                continue;
            }
            if (!find) continue;
            this.endColumn = i;
            break;
        }
        return find;
    }

    private void fillRowData(IRowSet rowSet, int rowIndex, int columnIndex) throws SQLException {
        IRow row = this.tblMain.getRow(rowIndex);
        Integer count = rowSet.getInt("highCount") > 0 ? Integer.valueOf(rowSet.getInt("highCount")) : null;
        row.getCell(columnIndex++).setValue((Object)count);
        count = rowSet.getInt("middleCount") > 0 ? Integer.valueOf(rowSet.getInt("middleCount")) : null;
        row.getCell(columnIndex++).setValue((Object)count);
        count = rowSet.getInt("lowCount") > 0 ? Integer.valueOf(rowSet.getInt("lowCount")) : null;
        row.getCell(columnIndex).setValue((Object)count);
    }

    private void mergeTableHead() {
        IRow headRow = null;
        IRow preHeadRow = null;
        String preValue = null;
        String curValue = null;
        String preTopValue = null;
        String curTopValue = null;
        int start = 0;
        int count = this.tblMain.getColumnCount();
        KDTMergeManager mm = this.tblMain.getHeadMergeManager();
        for (int i = 0; i < 3; ++i) {
            headRow = this.tblMain.getHeadRow(i);
            if (i > 0) {
                preHeadRow = this.tblMain.getHeadRow(i - 1);
            }
            preValue = null;
            for (int j = 2; j < count; ++j) {
                curValue = (String)headRow.getCell(j).getValue();
                if (preHeadRow != null) {
                    curTopValue = (String)preHeadRow.getCell(j).getValue();
                }
                if (preValue == null) {
                    preValue = curValue;
                    preTopValue = curTopValue;
                    start = j;
                }
                if (preValue.equals(curValue) && (preTopValue == null || preTopValue.equals(curTopValue))) continue;
                mm.mergeBlock(i, start, i, j - 1);
                preValue = curValue;
                preTopValue = curTopValue;
                start = j;
            }
            mm.mergeBlock(i, start, i, count - 1);
        }
    }

    public void actionGenerate_actionPerformed(ActionEvent e) throws Exception {
        this.checkGenerateCondition();
        RequirementResponsePublisherUI publisherUI = new RequirementResponsePublisherUI();
        SelectorItemCollection sic = publisherUI.getSelectors();
        RequirementResponseInfo requirementResponseInfo = RequirementResponseFactory.getRemoteInstance().getRequirementResponseInfo(this.requirementId, this.publisherId, sic);
        if (requirementResponseInfo == null) {
            requirementResponseInfo = RequirementAssistant.createRequirementResponseInfo(this.requirementId, SysContext.getSysContext().getCurrentUserInfo());
        } else if (RequirementResponseEnum.UN_RESPONSE.equals((Object)requirementResponseInfo.getState()) ? !TrainClientUtil.showConfirmMessge(RESOURCE, "GENERATE_RESPONSE_EXIST", (CoreUI)this) : RequirementResponseEnum.RESPONSED.equals((Object)requirementResponseInfo.getState()) && !TrainClientUtil.showConfirmMessge(RESOURCE, "GENERATE_RESPONSED", (CoreUI)this)) {
            return;
        }
        if (!RequirementAssistant.generateResponse(requirementResponseInfo, this.requirementId, this.responserIds)) {
            TrainClientUtil.showErrorMessage(RESOURCE, "RESPONSED_EMPTY", new Object[]{this.btnGenerate.getToolTipText()}, (CoreUI)this);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"InitDataObject", (Object)requirementResponseInfo);
        String state = null;
        if (requirementResponseInfo.getId() != null) {
            uiContext.put((Object)"ID", (Object)requirementResponseInfo.getId().toString());
            state = OprtState.EDIT;
        } else {
            state = OprtState.ADDNEW;
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RequirementResponsePublisherUI.class.getName(), (Map)uiContext, null, state);
        uiWindow.show();
    }

    private void checkGenerateCondition() throws BOSException, EASBizException {
        boolean parentIsResponsed;
        boolean isCreatorOrSameOrg;
        RequirementStateEnum state = (RequirementStateEnum)((Object)this.getUIContext().get("requirementState"));
        if (RequirementStateEnum.CLOSED.equals((Object)state)) {
            TrainClientUtil.showMessageAndAbort(RESOURCE, "REQUIREMENT_CLOSED", new Object[]{this.btnGenerate.getToolTipText()}, (CoreUI)this);
        }
        if (isCreatorOrSameOrg = ((Boolean)this.getUIContext().get("isCreatorOrSameOrg")).booleanValue()) {
            TrainClientUtil.showMessageAndAbort(RESOURCE, "GENERATE_ROOT", (CoreUI)this);
        }
        if (parentIsResponsed = RequirementResponseFactory.getRemoteInstance().parentIsResponsed(this.requirementId, this.publisherId)) {
            TrainClientUtil.showMessageAndAbort(RESOURCE, "GENERATE_PARENT_RESPONSED", (CoreUI)this);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.dialog == null) {
            this.dialog = this.initCommonQueryDialog();
            this.dialog.setMaxReturnCountVisible(true);
        }
        if (this.dialog.show()) {
            this.tHelper.setDialog(this.dialog);
            this.mainFilterInfo = this.getEntityViewInfo(this.dialog.getEntityViewInfoResult()).getFilter();
            this.fillTable();
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        try {
            this.getUIContext().put("responserIds", this.responserIds);
            RequirementResponseSummaryFilterUI filterUI = new RequirementResponseSummaryFilterUI(this.getUIContext());
            dialog.addUserPanel((KDPanel)filterUI);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "ResponseSuggestCourseQuery"));
        dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        return dialog;
    }

    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"requirement", (Object)this.requirementId);
        uiContext.put((Object)"publisherId", (Object)this.publisherId);
        uiContext.put((Object)"responserIds", (Object)this.responserIds);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReqResponseDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionResponseSuggest_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ResponseSuggestSummaryUI.class.getName(), this.getUIContext(), null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillTable();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnGenerate.setIcon(EASResource.getIcon((String)"imgTbtn_associatecreate"));
        this.btnViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_topview"));
        this.btnResponseSuggest.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.actionViewDetail.setEnabled(true);
        this.actionGenerate.setEnabled(!OprtState.VIEW.equals(this.getOprtState()));
    }

    protected String[] getLocateNames() {
        return new String[]{COLUMN_ORG_NUMBER, COLUMN_ORG_NAME};
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected String getSelectedKeyValue() {
        return null;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    protected void selectFirstRow() {
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

