/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.CodingRuleHelper;
import com.kingdee.eas.hr.train.ISysCate;
import com.kingdee.eas.hr.train.SysCateCourseEntryFactory;
import com.kingdee.eas.hr.train.SysCateFactory;
import com.kingdee.eas.hr.train.SysCateInfo;
import com.kingdee.eas.hr.train.client.AbstractSysCateSimpleEditUI;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class SysCateSimpleEditUI
extends AbstractSysCateSimpleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SysCateSimpleEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSysResource";

    public void loadFields() {
        CodingRuleHelper.setAutoNumber(this, (CoreBaseInfo)this.editData, this.txtNum, this.getOprtState());
        super.loadFields();
    }

    protected IObjectValue createNewData() {
        SysCateInfo ret = new SysCateInfo();
        ret.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        ret.setIsEnabled(true);
        ret.setParent(this.getParentInfo());
        return ret;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("isEnabled"));
        sic.add(new SelectorItemInfo("isLeaf"));
        return sic;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SysCateFactory.getRemoteInstance();
    }

    private SysCateInfo getParentInfo() {
        Object obj = this.getUIContext().get("ParentNode");
        if (obj == null) {
            return null;
        }
        return (SysCateInfo)obj;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNum);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNm);
        BOSUuid id = this.editData.getId();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.txtNum.getText().trim(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
        ISysCate isc = SysCateFactory.getRemoteInstance();
        if (isc.exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"numberNotDup"));
            this.txtNum.requestFocus();
            SysUtil.abort();
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)this.txtNm.getSelectedItem().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
        if (isc.exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nameNotDup"));
            this.txtNm.requestFocus();
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isRefered()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"isReferedGroupDisable"));
            SysUtil.abort();
        }
        if (this.editData.isIsEnabled()) {
            super.actionEdit_actionPerformed(e);
            this.txtDescription.requestFocus();
            this.txtNum.requestFocus();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"disableGroupEdit"));
            SysUtil.abort();
        }
        this.txtNum.setEnabled(false);
    }

    private boolean isRefered() {
        boolean flag = false;
        SysCateInfo sysCateInfo = this.editData;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)sysCateInfo.getId().toString()));
        try {
            flag = SysCateCourseEntryFactory.getRemoteInstance().exists(filterInfo);
        }
        catch (Exception e) {
            super.handleException(e);
        }
        return flag;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        Boolean groupEnable = (Boolean)this.getUIContext().get("group_enabled");
        if (groupEnable != null && groupEnable.booleanValue()) {
            super.actionAddNew_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"groupDisabled"));
            SysUtil.abort();
        }
        SysCateInfo parentInfo = this.getParentInfo();
        if (parentInfo != null && this.haveCourse(parentInfo.getId().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"canNotAddSubType"));
            SysUtil.abort();
        }
    }

    private boolean haveCourse(String id) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)id, CompareType.EQUALS));
        try {
            return SysCateCourseEntryFactory.getRemoteInstance().exists(filter);
        }
        catch (Exception e) {
            this.handleException(e);
            return true;
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (!this.editData.isIsLeaf()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"typeHaveSubType"));
            SysUtil.abort();
        }
        if (this.isRefered()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"sysCateIsReferedNotAllowRemove"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    public boolean isPrepareInit() {
        return true;
    }
}

