/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainActOrgWorkloadQueryPanelUI;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TrainActOrgWorkloadQueryPanelUI
extends AbstractTrainActOrgWorkloadQueryPanelUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActOrgWorkloadQueryPanelUI.class);
    private static String RES = "com.kingdee.eas.hr.train.client.TrainReportResource";

    public String getCurrOUListToString() throws EASBizException, BOSException {
        IHROrgUnit iHRO = HROrgUnitFactory.getRemoteInstance();
        StringBuffer OUstrs = new StringBuffer();
        int counts = 0;
        HROrgUnitInfo hroInfo = SysContext.getSysContext().getCurrentHRUnit();
        AdminOrgUnitCollection adminColl = iHRO.getAdminOrgUnitCollectionWithOrgRangeFilter(hroInfo.getId().toString());
        if (adminColl != null) {
            counts = adminColl.size();
        }
        if (counts == 0) {
            return null;
        }
        for (int i = 0; i < counts; ++i) {
            if (counts == 1) {
                OUstrs.append("'");
                OUstrs.append(adminColl.get(i).getId().toString());
                OUstrs.append("'");
                continue;
            }
            if (i != 0) {
                OUstrs.append(",'" + adminColl.get(i).getId().toString());
                OUstrs.append("'");
                continue;
            }
            OUstrs.append("'");
            OUstrs.append(adminColl.get(i).getId().toString());
            OUstrs.append("'");
        }
        return OUstrs.toString();
    }

    public FilterInfo getFilterInfo() {
        int i;
        HashSet<String> idSet;
        Object[] objs;
        FilterInfo filter = new FilterInfo();
        if (this.prmtOrgUnit.getData() != null && (objs = (Object[])this.prmtOrgUnit.getData()).length != 0 && objs[0] != null) {
            idSet = new HashSet<String>();
            for (i = 0; i < objs.length; ++i) {
                idSet.add(((AdminOrgUnitInfo)objs[i]).getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", idSet, CompareType.INCLUDE));
        }
        if (this.prmtPerson.getValue() != null && (objs = (Object[])this.prmtPerson.getData()).length != 0 && objs[0] != null) {
            idSet = new HashSet();
            for (i = 0; i < objs.length; ++i) {
                idSet.add(((PersonInfo)objs[i]).getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("organiger.id", idSet, CompareType.INCLUDE));
        }
        if (this.prmtTrainAct.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)((TrainActivityInfo)this.prmtTrainAct.getValue()).getId().toString()));
        }
        FilterItemInfo filterItemInfo = null;
        Date beginDate = (Date)this.dateStart.getValue();
        beginDate.setHours(0);
        beginDate.setMinutes(0);
        beginDate.setSeconds(0);
        filterItemInfo = new FilterItemInfo("endDate", (Object)beginDate, CompareType.GREATER_EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        Date endDate = (Date)this.dateEnd.getValue();
        endDate.setHours(23);
        endDate.setMinutes(59);
        endDate.setSeconds(59);
        filterItemInfo = new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        return filter;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initF7();
    }

    public void clear() {
        super.clear();
        this.clearPanel();
    }

    public void initF7() throws Exception {
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        pmt.setIsSingleSelect(false);
        pmt.setModal(true);
        this.prmtPerson.setSelector((KDPromptSelector)pmt);
        this.prmtPerson.setEnabledMultiSelection(true);
        this.prmtPerson.setEditable(false);
        TrainUtils.initOrgUnit(this.prmtOrgUnit, true, (IUIObject)this);
        this.prmtTrainAct.setQueryInfo("com.kingdee.eas.hr.train.app.TrainActivityQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)50));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)40));
        filterInfo.setMaskString("#0 or #1");
        filterInfo.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"HrOrgUnit.id", (String)"belongOrgUnit.id"), "AND");
        viewInfo.setFilter(filterInfo);
        this.prmtTrainAct.setEntityViewInfo(viewInfo);
        Date date = new Date();
        this.dateStart.setValue((Object)this.getTheDate(date));
        this.dateEnd.setValue((Object)date);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CustomerQueryUtil.storeToCustomerParams(cp, this.dateStart);
        CustomerQueryUtil.storeToCustomerParams(cp, this.dateEnd);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtOrgUnit);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtPerson);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmtTrainAct);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        CustomerQueryUtil.loadFromCustomerParams(cp, this.dateStart);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.dateEnd);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtOrgUnit, AdminOrgUnitInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtPerson, PersonInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmtTrainAct, TrainActivityInfo.class.getName());
    }

    public void clearPanel() {
        this.dateStart.setValue(null);
        this.dateEnd.setValue(null);
        this.prmtPerson.setValue(null);
        this.prmtOrgUnit.setValue(null);
        this.prmtTrainAct.setValue(null);
        this.prmtPerson.setEnabled(true);
        this.prmtOrgUnit.setEnabled(true);
        this.prmtTrainAct.setEnabled(true);
    }

    public boolean verify() {
        Date beginDate = (Date)this.dateStart.getValue();
        Date endDate = (Date)this.dateEnd.getValue();
        if (beginDate == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"beginDateCanNotNull"));
            this.dateStart.requestFocus();
            SysUtil.abort();
        }
        if (endDate == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"endDateCanNotNull"));
            this.dateEnd.requestFocus();
            SysUtil.abort();
        }
        if (DateTimeUtils.dayAfter((Date)beginDate, (Date)endDate)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"DATESCOPEERROR"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public Date getTheDate(Date date) {
        Date theDate = null;
        theDate = new Date(date.getYear(), date.getMonth(), 1);
        return theDate;
    }
}

