/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.client.AbstractTrainActOrgWorkloadReportUI;
import com.kingdee.eas.hr.train.client.TrainActOrgWorkloadQueryPanelUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class TrainActOrgWorkloadReportUI
extends AbstractTrainActOrgWorkloadReportUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActOrgWorkloadReportUI.class);
    private static String RES = "com.kingdee.eas.hr.train.client.TrainReportResource";
    private static final String ID = "id";
    private static final String PERSONNUMBER = "organiger.number";
    private static final String PERSONNAME = "organiger.name";
    private static final String ORGUNIT = "adminOrgUnit.displayName";
    private static final String ACTNAME = "trainActivity.name";
    private static final String TRAINSTARTEND = "startEndDate";
    private static final String TRAINOBJECT = "trainActivity.trainObject";
    private Date startDate = null;
    private Date endDate = null;
    private IRowSet rowSet = null;
    private CommonQueryDialog dialog = null;
    private TrainActOrgWorkloadQueryPanelUI trainActOrgWorkloadQueryPanelUI = null;
    private boolean isFirstDefaultQuery = true;
    private EntityViewInfo entityViewInfo = new EntityViewInfo();
    FilterInfo filterInfo = null;
    private BigDecimal mainUnit = null;
    private Map map = new HashMap();

    protected KDTable getTableForCommon() {
        return this.tblTrainActOrgWorkload;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnRefresh.setToolTipText(TrainActOrgWorkloadReportUI.getAlias("refresh"));
        this.btnQuery.setToolTipText(TrainActOrgWorkloadReportUI.getAlias("query"));
        this.btnPrint.setToolTipText(TrainActOrgWorkloadReportUI.getAlias("print"));
        this.btnPrintPreview.setToolTipText(TrainActOrgWorkloadReportUI.getAlias("printPreview"));
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.menuItemPrint.setEnabled(true);
        this.menuItemPrintPreview.setEnabled(true);
        this.menuItemQuery.setEnabled(true);
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    public void loadFilterUI() throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = TrainActOrgWorkloadReportUI.getQueryInfo(this.mainQueryPK).getFullName();
        TrainActOrgWorkloadQueryPanelUI filterUI = new TrainActOrgWorkloadQueryPanelUI();
        filterUI.onLoad();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            this.entityViewInfo = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            if (this.entityViewInfo != null && FilterUtility.hasFilterItem((FilterInfo)this.entityViewInfo.getFilter())) {
                FilterInfo orgHrOrgFilter = TrainUtils.getHROrgUnitFilter("HrOrgUnit.id");
                if (FilterUtility.hasFilterItem((FilterInfo)this.entityViewInfo.getFilter())) {
                    this.entityViewInfo.getFilter().mergeFilter(orgHrOrgFilter, "AND");
                } else {
                    this.entityViewInfo.setFilter(orgHrOrgFilter);
                }
                this.setStartEndDate();
            } else {
                this.showQueryDialog();
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showQueryDialog();
        }
    }

    private void setStartEndDate() {
        FilterInfo filter = this.entityViewInfo.getFilter();
        if (filter != null) {
            FilterItemCollection fiColl = filter.getFilterItems();
            FilterItemInfo filterItemInfo = null;
            int size = fiColl.size();
            for (int i = 0; i < size; ++i) {
                filterItemInfo = fiColl.get(i);
                if (!"endDate".equals(filterItemInfo.getPropertyName())) continue;
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.startDate = (Date)filterItemInfo.getCompareValue();
                    continue;
                }
                if (!CompareType.LESS_EQUALS.equals((Object)filterItemInfo.getCompareType())) continue;
                this.endDate = (Date)filterItemInfo.getCompareValue();
            }
        }
    }

    public void showQueryDialog() throws Exception {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.dialog.setOwner((Component)((Object)this));
            }
            this.dialog.setUiObject((IUIObject)this);
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            TrainClientUtil.setCommonQueryTitle(this, this.dialog);
            this.dialog.setWidth(450);
            this.dialog.setHeight(300);
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(false);
            this.dialog.setDisShowRowCount(true);
            this.dialog.setQueryObjectPK(this.mainQueryPK);
            try {
                this.trainActOrgWorkloadQueryPanelUI = new TrainActOrgWorkloadQueryPanelUI();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.dialog.addUserPanel((KDPanel)this.trainActOrgWorkloadQueryPanelUI);
        }
        if (this.dialog.show()) {
            this.entityViewInfo = this.dialog.getEntityViewInfoResult();
            if (this.entityViewInfo == null) {
                this.entityViewInfo = new EntityViewInfo();
            }
            FilterInfo orgHrOrgFilter = TrainUtils.getHROrgUnitFilter("HrOrgUnit.id");
            if (FilterUtility.hasFilterItem((FilterInfo)this.entityViewInfo.getFilter())) {
                this.entityViewInfo.getFilter().mergeFilter(orgHrOrgFilter, "AND");
            } else {
                this.entityViewInfo.setFilter(orgHrOrgFilter);
            }
            this.setStartEndDate();
        } else {
            SysUtil.abort();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)Boolean.TRUE));
        filter.mergeFilter(TrainUtils.getCurrentHRFilter("hrOrgUnit.id"), "AND");
        viewInfo.setFilter(filter);
        MetaDataPK mainUnitQeryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainMainUnitListQuery");
        IQueryExecutor mainUnitExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainUnitQeryPK);
        mainUnitExec.setObjectView(viewInfo);
        IRowSet mainUnitRowSet = mainUnitExec.executeQuery();
        while (mainUnitRowSet.next()) {
            if (mainUnitRowSet.getBigDecimal("mainUnitType") == null) continue;
            this.mainUnit = mainUnitRowSet.getBigDecimal("mainUnitType");
            if (mainUnitRowSet.getBigDecimal("entry.TrainTransferType") == null) continue;
            this.map.put(mainUnitRowSet.getBigDecimal("entry.TrainTransferType"), mainUnitRowSet.getBigDecimal("entry.TransferFormat"));
        }
        this.btnRefresh.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        this.enableExportExcel(this.tblTrainActOrgWorkload);
        this.loadFilterUI();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainActOrgWorkloadQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(this.entityViewInfo);
        this.rowSet = exec.executeQuery();
        this.tblTrainActOrgWorkload.checkParsed();
        this.initTableColumn();
        this.fillTable();
        this.tblTrainActOrgWorkload.setColumnMoveable(true);
        this.tblTrainActOrgWorkload.getStyleAttributes().setLocked(true);
        this.tblTrainActOrgWorkload.getSelectManager().setSelectMode(2);
        this.mergeTable();
        this.fillTitle();
        this.tHelper.getDisabledTables().add(this.tblTrainActOrgWorkload);
    }

    public void fillTitle() {
        String title = "";
        if (this.startDate != null && this.endDate != null) {
            title = DateFormat.getDateInstance(2).format(this.startDate);
            title = title + TrainActOrgWorkloadReportUI.getAlias("to");
            title = title + DateFormat.getDateInstance(2).format(this.endDate);
        }
        title = title + " " + TrainActOrgWorkloadReportUI.getAlias("orgWorkloadReport");
        this.labTitle.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.labTitle.setText(title);
    }

    public void fillTable() throws SQLException, BOSException {
        this.mainUnit = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)Boolean.TRUE));
        filter.mergeFilter(TrainUtils.getCurrentHRFilter("hrOrgUnit.id"), "AND");
        viewInfo.setFilter(filter);
        MetaDataPK mainUnitQeryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainMainUnitListQuery");
        IQueryExecutor mainUnitExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainUnitQeryPK);
        mainUnitExec.setObjectView(viewInfo);
        try {
            IRowSet mainUnitRowSet = mainUnitExec.executeQuery();
            while (mainUnitRowSet.next()) {
                if (mainUnitRowSet.getBigDecimal("mainUnitType") == null) continue;
                this.mainUnit = mainUnitRowSet.getBigDecimal("mainUnitType");
                if (mainUnitRowSet.getBigDecimal("entry.TrainTransferType") != null) {
                    this.map.put(mainUnitRowSet.getBigDecimal("entry.TrainTransferType"), mainUnitRowSet.getBigDecimal("entry.TransferFormat"));
                }
                if (this.map.keySet().contains(this.mainUnit)) continue;
                this.map.put(this.mainUnit, new BigDecimal("1"));
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        IRow iRow = null;
        BigDecimal format = null;
        CourseHourUnitEnum mainUnitType = null;
        this.rowSet.beforeFirst();
        while (this.rowSet.next()) {
            iRow = this.tblTrainActOrgWorkload.addRow();
            iRow.getCell(ID).setValue((Object)this.rowSet.getString(ID));
            iRow.getCell(PERSONNUMBER).setValue((Object)this.rowSet.getString(PERSONNUMBER));
            iRow.getCell(PERSONNAME).setValue((Object)this.rowSet.getString(PERSONNAME));
            iRow.getCell(ORGUNIT).setValue((Object)this.rowSet.getString(ORGUNIT));
            iRow.getCell(ACTNAME).setValue((Object)this.rowSet.getString(ACTNAME));
            if (this.rowSet.getString("startDate") != null && this.rowSet.getString("endDate") != null) {
                iRow.getCell(TRAINSTARTEND).setValue((Object)(this.rowSet.getString("startDate") + TrainActOrgWorkloadReportUI.getAlias("to") + this.rowSet.getString("endDate")));
            }
            iRow.getCell(TRAINOBJECT).setValue((Object)this.rowSet.getString(TRAINOBJECT));
            if (this.rowSet.getString("workload") == null) continue;
            BigDecimal workload = new BigDecimal(this.rowSet.getString("workload"));
            DecimalFormat df = new DecimalFormat("#.####");
            if (this.mainUnit != null) {
                if (Integer.parseInt(this.mainUnit.toString()) == 1) {
                    mainUnitType = CourseHourUnitEnum.DAY;
                }
                if (Integer.parseInt(this.mainUnit.toString()) == 2) {
                    mainUnitType = CourseHourUnitEnum.HOUR;
                }
                if (Integer.parseInt(this.mainUnit.toString()) == 3) {
                    mainUnitType = CourseHourUnitEnum.SECTOR;
                }
                if (this.rowSet.getString("workloadUnit") != null) {
                    try {
                        format = TrainUtils.transferUnit(this.rowSet.getString("workloadUnit").trim(), this.map);
                    }
                    catch (SQLException e) {
                        this.handUIException(e);
                    }
                    catch (BOSException e) {
                        this.handUIException(e);
                    }
                }
                iRow.getCell(this.rowSet.getString("role.number")).setValue((Object)(df.format(workload.multiply(format)) + mainUnitType.toString()));
                continue;
            }
            iRow.getCell(this.rowSet.getString("role.number")).setValue((Object)(df.format(workload) + this.rowSet.getString("workloadUnit")));
        }
        this.rowSet.beforeFirst();
    }

    public static String getAlias(String name) {
        return EASResource.getString((String)RES, (String)name);
    }

    public void initTableColumn() throws SQLException {
        int i;
        this.tblTrainActOrgWorkload.removeColumns();
        this.tblTrainActOrgWorkload.setRefresh(false);
        IColumn col = null;
        col = this.tblTrainActOrgWorkload.addColumn();
        col.getStyleAttributes().setHided(true);
        col.setKey(ID);
        col = this.tblTrainActOrgWorkload.addColumn();
        col.setWidth(100);
        col.setKey(PERSONNUMBER);
        col = this.tblTrainActOrgWorkload.addColumn();
        col.setWidth(100);
        col.setKey(PERSONNAME);
        col = this.tblTrainActOrgWorkload.addColumn();
        col.setWidth(200);
        col.setKey(ORGUNIT);
        col = this.tblTrainActOrgWorkload.addColumn();
        col.setWidth(150);
        col.setKey(ACTNAME);
        col = this.tblTrainActOrgWorkload.addColumn();
        col.setWidth(200);
        col.setKey(TRAINSTARTEND);
        col = this.tblTrainActOrgWorkload.addColumn();
        col.setWidth(100);
        col.setKey(TRAINOBJECT);
        HashMap<String, String> map = new HashMap<String, String>();
        while (this.rowSet.next()) {
            map.put(this.rowSet.getString("role.number"), this.rowSet.getString("role.name"));
        }
        this.rowSet.beforeFirst();
        Set set = map.keySet();
        Object[] headList = set.toArray();
        TreeSet<Object> ts = new TreeSet<Object>();
        for (i = 0; i < headList.length; ++i) {
            ts.add(headList[i]);
        }
        headList = ts.toArray();
        for (i = 0; i < headList.length; ++i) {
            col = this.tblTrainActOrgWorkload.addColumn();
            col.setWidth(100);
            col.setKey(headList[i].toString());
        }
        IRow iRow = null;
        iRow = this.tblTrainActOrgWorkload.addHeadRow();
        iRow.getCell(ID).setValue((Object)ID);
        iRow.getCell(PERSONNUMBER).setValue((Object)TrainActOrgWorkloadReportUI.getAlias("personNumber"));
        iRow.getCell(PERSONNAME).setValue((Object)TrainActOrgWorkloadReportUI.getAlias("personName"));
        iRow.getCell(ORGUNIT).setValue((Object)TrainActOrgWorkloadReportUI.getAlias("orgUnit"));
        iRow.getCell(ACTNAME).setValue((Object)"\u6d3b\u52a8\u540d\u79f0");
        iRow.getCell(TRAINSTARTEND).setValue((Object)TrainActOrgWorkloadReportUI.getAlias("trainStartEndDate"));
        iRow.getCell(TRAINOBJECT).setValue((Object)TrainActOrgWorkloadReportUI.getAlias("trainObject"));
        for (int i2 = 0; i2 < headList.length; ++i2) {
            iRow.getCell(headList[i2].toString()).setValue((Object)((String)map.get(headList[i2])));
        }
    }

    public void mergeTable() {
        this.tblTrainActOrgWorkload.getColumn(PERSONNUMBER).setGroup(true);
        this.tblTrainActOrgWorkload.getColumn(PERSONNAME).setGroup(true);
        this.tblTrainActOrgWorkload.getColumn(ORGUNIT).setGroup(true);
        this.tblTrainActOrgWorkload.getGroupManager().group();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.dialog != null && this.getUIContext() != null && "report".equals(this.getUIContext().get("UIClassParam"))) {
            this.dialog.changeOwner((Component)((Object)this));
        }
        super.actionQuery_actionPerformed(e);
        this.loadFilterUI();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainActOrgWorkloadQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(this.entityViewInfo);
        this.rowSet = exec.executeQuery();
        this.tblTrainActOrgWorkload.checkParsed();
        this.initTableColumn();
        this.fillTable();
        this.mergeTable();
        this.tblTrainActOrgWorkload.revalidate();
        this.fillTitle();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblTrainActOrgWorkload);
        this.tblTrainActOrgWorkload.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblTrainActOrgWorkload);
        this.tblTrainActOrgWorkload.getPrintManager().printPreview();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblTrainActOrgWorkload;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)Boolean.TRUE));
        viewInfo.setFilter(filter);
        MetaDataPK mainUnitQeryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainMainUnitListQuery");
        IQueryExecutor mainUnitExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainUnitQeryPK);
        mainUnitExec.setObjectView(viewInfo);
        IRowSet mainUnitRowSet = mainUnitExec.executeQuery();
        while (mainUnitRowSet.next()) {
            if (mainUnitRowSet.getBigDecimal("mainUnitType") == null) continue;
            this.mainUnit = mainUnitRowSet.getBigDecimal("mainUnitType");
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainActOrgWorkloadQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(this.entityViewInfo);
        this.rowSet = exec.executeQuery();
        this.tblTrainActOrgWorkload.checkParsed();
        this.initTableColumn();
        this.fillTable();
        this.mergeTable();
        this.tblTrainActOrgWorkload.revalidate();
        this.fillTitle();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"HRO");
    }
}

