/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.message.client.MAGroupF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.train.ITrainActParticipantScope;
import com.kingdee.eas.hr.train.TrainActDeptStudentEntryCollection;
import com.kingdee.eas.hr.train.TrainActDeptStudentEntryInfo;
import com.kingdee.eas.hr.train.TrainActDeptStudentInfo;
import com.kingdee.eas.hr.train.TrainActParticipantScopeCollection;
import com.kingdee.eas.hr.train.TrainActParticipantScopeFactory;
import com.kingdee.eas.hr.train.TrainActParticipantScopeInfo;
import com.kingdee.eas.hr.train.TrainActStateEnum;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainActivityMessageInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainActParticipantScopeListUI;
import com.kingdee.eas.hr.train.client.ProgressManager;
import com.kingdee.eas.hr.train.client.TrainActManagerUI;
import com.kingdee.eas.hr.train.client.TrainActParticipantScopeEditUI;
import com.kingdee.eas.hr.train.client.TrainActSendEmailInfoUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCoursePersonPromptBox;
import com.kingdee.eas.hr.train.client.TrainStudentAllPromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;

public class TrainActParticipantScopeListUI
extends AbstractTrainActParticipantScopeListUI {
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";
    private static final String resource = "com.kingdee.eas.hr.train.TrainHolidayResource";
    private static final String COMMA = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainActivityResource", (String)"Comma");
    private static final String replySendMessage = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"REPLYSENDMESSAGE");
    private final PersonInfo currentPerson = SysContext.getSysContext().getCurrentUserInfo().getPerson();
    private TrainActivityInfo curTrainActivityInfo = null;
    private TrainActivityMessageInfo messageInfo = null;
    private Set publishGroupData = new HashSet();
    private String trainActivityId;
    private List courseIds = null;
    private String ifSend = null;
    private int colIndex;
    private boolean asc = true;

    public void onLoad() throws Exception {
        this.initWorkButton();
        TrainClientUtil.checkValidPerson((CoreUI)this);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.trainActivityId = (String)this.getUIContext().get("ID");
        if (this.getUIContext().get("Send") != null) {
            this.ifSend = this.getUIContext().get("Send").toString();
        }
        this.loadData();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.lockComponents();
        }
        if (this.curTrainActivityInfo != null && this.curTrainActivityInfo.getTrainActState().equals((Object)TrainActStateEnum.NOT_EFFECTIVE)) {
            this.actionPublish.setEnabled(false);
        }
    }

    private void lockComponents() {
        this.actionSubmit.setEnabled(false);
        this.actionPublish.setEnabled(false);
        this.actionAddPerson.setEnabled(false);
        this.actionDelPerson.setEnabled(false);
        this.actionCoursePerson.setEnabled(false);
        this.actionTrainStudent.setEnabled(false);
        this.btnFind.setEnabled(false);
        this.txtContent.setEditable(false);
        TrainClientUtil.lockUI((CoreUI)this, new HashMap());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        JButton btnCoursePerson = this.contPerson.add((Action)((Object)this.actionCoursePerson));
        btnCoursePerson.setText(EASResource.getString((String)resourcePath, (String)"CoursePersonTitle"));
        btnCoursePerson.setToolTipText(EASResource.getString((String)resourcePath, (String)"CoursePersonTitle"));
        JButton btnTrainStudent = this.contPerson.add((Action)((Object)this.actionTrainStudent));
        btnTrainStudent.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        JButton btnAddPerson = this.contPerson.add((Action)((Object)this.actionAddPerson));
        btnAddPerson.setToolTipText(EASResource.getString((String)resource, (String)"ADDTRAINPUBLISHPERSON"));
        btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        JButton btnDelPerson = this.contPerson.add((Action)((Object)this.actionDelPerson));
        btnDelPerson.setToolTipText(EASResource.getString((String)resource, (String)"DELTRAINPUBLISHPERSON"));
        btnDelPerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.actionCoursePerson.setEnabled(true);
        this.btnFind.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnFind.setEnabled(true);
    }

    private void loadData() throws Exception {
        Map dataMap = TrainActivityFacadeFactory.getRemoteInstance().getActPublishData(this.trainActivityId, this.currentPerson.getId().toString());
        this.curTrainActivityInfo = (TrainActivityInfo)dataMap.get("trainActivity");
        this.pkSignUpStartDate.setValue((Object)this.curTrainActivityInfo.getSignStartDate());
        this.pkSignUpEndDate.setValue((Object)this.curTrainActivityInfo.getSignEndDate());
        this.pkPublishStartDate.setValue((Object)this.curTrainActivityInfo.getPubStartDate());
        this.pkPublishEndDate.setValue((Object)this.curTrainActivityInfo.getPubEndDate());
        this.ckIsAcceptSignUp.setSelected(this.curTrainActivityInfo.isCanSignUp());
        IRowSet rowSet = (IRowSet)dataMap.get("participantScope");
        ArrayList list = new ArrayList();
        HashMap<String, String> map = null;
        while (rowSet.next()) {
            map = new HashMap<String, String>();
            map.put("id", rowSet.getString("id"));
            map.put("personId", rowSet.getString("Person.id"));
            map.put("number", rowSet.getString("Person.number"));
            map.put("name", rowSet.getString("Person.name"));
            map.put("position", rowSet.getString("position.name"));
            map.put("orgUnit", rowSet.getString("orgUnit.name"));
            map.put("email", rowSet.getString("Person.email"));
            list.add(map);
        }
        this.fillTable(list);
        this.initMessage(dataMap);
        this.txtPublishRang.setText(this.getPublishGroups(dataMap));
    }

    private void initMessage(Map dataMap) throws Exception {
        this.messageInfo = (TrainActivityMessageInfo)dataMap.get("activityMessage");
        if (this.messageInfo == null || "Yes".equals(this.ifSend)) {
            this.initMessageInfoByAct(dataMap);
            this.ifSend = null;
        }
        this.txtTitle.setText(this.messageInfo.getTitle());
        this.txtContent.setText(this.messageInfo.getContent());
        this.prmtOrgPerson.setValue((Object)this.messageInfo.getSendPerson());
    }

    private void initMessageInfoByAct(Map dataMap) throws BOSException, EASBizException {
        this.messageInfo = new TrainActivityMessageInfo();
        this.messageInfo.setSendPerson(this.currentPerson);
        TrainActivityInfo activityInfo = (TrainActivityInfo)dataMap.get("trainActivity");
        this.messageInfo.setTrainActivity(activityInfo);
        String title = EASResource.getString((String)resourcePath, (String)"TrainNotifyTitle");
        title = title.replaceAll("#0", activityInfo.getOrgUnit() == null ? "" : activityInfo.getOrgUnit().getName());
        title = title.replaceAll("#1", activityInfo.getName());
        title = title.replaceAll("#2", activityInfo.getTrainStartDate() == null ? "" : activityInfo.getTrainStartDate().toString());
        title = title.replaceAll("#3", activityInfo.getTrainEndDate() == null ? "" : activityInfo.getTrainEndDate().toString());
        this.messageInfo.setTitle(title);
        String body = EASResource.getString((String)resourcePath, (String)"TrainNotifyBody");
        String newLine = System.getProperty("line.separator");
        body = body.replaceAll("#00", activityInfo.getName());
        body = body.replaceAll("#01", activityInfo.getTrainAddress() == null ? "" : activityInfo.getTrainAddress());
        body = body.replaceAll("#02", activityInfo.getTrainStartDate() == null ? "" : activityInfo.getTrainStartDate().toString());
        body = body.replaceAll("#03", activityInfo.getTrainEndDate() == null ? "" : activityInfo.getTrainEndDate().toString());
        body = body.replaceAll("#04", activityInfo.getOrgUnit() == null ? "" : activityInfo.getOrgUnit().getName());
        body = body.replaceAll("#05", activityInfo.getOrgPerson() == null ? "" : activityInfo.getOrgPerson().getName());
        body = body.replaceAll("#06", this.getOrgInfo(dataMap));
        body = body.replaceAll("#07", activityInfo.getTrainingCategor() == null ? "" : activityInfo.getTrainingCategor().getName());
        body = body.replaceAll("#08", activityInfo.getTarget() == null ? "" : activityInfo.getTarget());
        body = body.replaceAll("#09", activityInfo.getTrainObject() == null ? "" : activityInfo.getTrainObject());
        body = body.replaceAll("#10", activityInfo.getContactMethod() == null ? "" : activityInfo.getContactMethod());
        body = body.replaceAll("#11", activityInfo.getRoadMap() == null ? "" : activityInfo.getRoadMap());
        body = body.replaceAll("#12", this.getDeptAssignInfo(dataMap));
        try {
            body = body.replaceAll("#13", newLine + this.getRelationInfo(dataMap));
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        body = body.replaceAll("@", newLine);
        this.messageInfo.setContent(body);
    }

    private String getOrgInfo(Map dataMap) {
        IRowSet rowSet = (IRowSet)dataMap.get("actOrgsInfo");
        StringBuffer result = new StringBuffer();
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (rowSet.getString("Entries.organiger.name") == null) continue;
                if (result.length() > 0) {
                    result.append(COMMA);
                }
                result.append(rowSet.getString("Entries.organiger.name"));
                if (rowSet.getString("Entries.role.name") == null) continue;
                result.append("(");
                result.append(rowSet.getString("Entries.role.name"));
                result.append(")");
            }
        }
        catch (SQLException e) {
            this.handleException(e);
        }
        return result.toString();
    }

    private String getRelationInfo(Map dataMap) throws SQLException {
        IRowSet rowSet = (IRowSet)dataMap.get("relationInfo");
        String newLine = System.getProperty("line.separator");
        HashMap<String, ArrayList<String[]>> courseMap = new HashMap<String, ArrayList<String[]>>();
        List relations = null;
        String[] relationArray = null;
        String courseName = null;
        String personName = null;
        StringBuffer result = new StringBuffer();
        rowSet.beforeFirst();
        while (rowSet.next()) {
            courseName = rowSet.getString("trainCourse.name");
            if (courseName == null) continue;
            relationArray = new String[2];
            personName = rowSet.getString("participator.name") != null ? rowSet.getString("participator.name") : (rowSet.getBoolean("Instructor.IsOuter") ? rowSet.getString("Instructor.name") : rowSet.getString("Employee.name"));
            relationArray[0] = personName;
            relationArray[1] = rowSet.getString("role.name");
            relations = (ArrayList<String[]>)courseMap.get(courseName);
            if (relations == null) {
                relations = new ArrayList<String[]>();
            }
            relations.add(relationArray);
            courseMap.put(courseName, (ArrayList<String[]>)relations);
        }
        boolean first = true;
        StringBuffer contentString = null;
        Iterator it = courseMap.entrySet().iterator();
        Iterator itemIterator = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            courseName = (String)entry.getKey();
            if (result.length() > 0) {
                result.append(newLine);
            }
            contentString = new StringBuffer();
            contentString.append("     ");
            contentString.append(courseName);
            contentString.append("\uff1a");
            relations = (List)courseMap.get(courseName);
            if (relations != null) {
                first = true;
                itemIterator = relations.iterator();
                while (itemIterator.hasNext()) {
                    if (!first) {
                        contentString.append(COMMA);
                    }
                    first = false;
                    relationArray = (String[])itemIterator.next();
                    contentString.append(relationArray[0]);
                    contentString.append("(");
                    contentString.append(relationArray[1]);
                    contentString.append(")");
                }
            }
            result.append(contentString);
        }
        return result.toString();
    }

    private String getDeptAssignInfo(Map dataMap) {
        StringBuffer result = new StringBuffer();
        TrainActDeptStudentInfo actDeptStudentInfo = (TrainActDeptStudentInfo)dataMap.get("actDeptAssignInfo");
        if (actDeptStudentInfo != null && actDeptStudentInfo.getEntrys() != null && actDeptStudentInfo.getEntrys().size() > 0) {
            TrainActDeptStudentEntryCollection entrys = actDeptStudentInfo.getEntrys();
            String unit = EASResource.getString((String)resourcePath, (String)"Person");
            String semicolon = EASResource.getString((String)resourcePath, (String)"semicolon");
            String comma = EASResource.getString((String)resourcePath, (String)"Comma");
            for (int i = 0; i < entrys.size(); ++i) {
                TrainActDeptStudentEntryInfo entry = entrys.get(i);
                if (i != 0) {
                    result.append(semicolon);
                }
                result.append(entry.getAdminOrgUnit().getName());
                result.append(entry.getStudentNumber());
                result.append(unit);
                if (entry.getRemark() == null || entry.getRemark().length() <= 0) continue;
                result.append(comma);
                result.append(entry.getRemark());
            }
        }
        return result.toString();
    }

    private String getPublishGroups(Map dataMap) throws SQLException {
        IRowSet rowSetGroup = (IRowSet)dataMap.get("publishGroupScope");
        this.publishGroupData.clear();
        StringBuffer orgsScope = new StringBuffer();
        if (rowSetGroup != null) {
            MAGroupInfo groupInfo = null;
            rowSetGroup.beforeFirst();
            while (rowSetGroup.next()) {
                if (rowSetGroup.getString("MaGroup.name") != null) {
                    if (orgsScope.length() > 0) {
                        orgsScope.append(";");
                    }
                    orgsScope.append(rowSetGroup.getString("MaGroup.name"));
                }
                if (rowSetGroup.getString("MaGroup.id") == null) continue;
                groupInfo = new MAGroupInfo();
                groupInfo.setId(BOSUuid.read((String)rowSetGroup.getString("MaGroup.id")));
                groupInfo.setName(rowSetGroup.getString("MaGroup.name"));
                this.publishGroupData.add(groupInfo);
            }
        }
        return orgsScope.toString();
    }

    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        pmt.setIsSingleSelect(false);
        pmt.setUserOrgRangeFilter(true);
        this.handlePromptBox((KDCommonPromptDialog)pmt);
    }

    private void dealAddPerson(Object[] obj) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        PersonInfo personInfo = null;
        for (int i = 0; i < obj.length; ++i) {
            personInfo = (PersonInfo)obj[i];
            idSet.add(personInfo.getId().toString());
        }
        if (idSet.size() != 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            IRowSet rowSet = TrainActivityHelper.getRowSet("TrainActParticipantAboutQuery", fi);
            ArrayList list = new ArrayList();
            HashMap<String, String> map = null;
            while (rowSet.next()) {
                map = new HashMap<String, String>();
                map.put("personId", rowSet.getString("id"));
                map.put("number", rowSet.getString("number"));
                map.put("name", rowSet.getString("name"));
                map.put("position", rowSet.getString("position.name"));
                map.put("orgUnit", rowSet.getString("orgUnit.displayName"));
                map.put("email", rowSet.getString("email"));
                list.add(map);
            }
            this.fillTable(list);
            this.submit();
        }
    }

    private void fillTable(List list) throws Exception {
        TrainActParticipantScopeInfo participantScopeInfo = null;
        PersonInfo personInfo = null;
        TrainActivityInfo activityInfo = null;
        Map map = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            map = (Map)list.get(i);
            if (this.checkIfRefered((String)map.get("personId"))) continue;
            IRow row = this.tblMain.addRow();
            row.getCell("id").setValue(map.get("id"));
            row.getCell("personId").setValue(map.get("personId"));
            row.getCell("number").setValue(map.get("number"));
            row.getCell("name").setValue(map.get("name"));
            row.getCell("position").setValue(map.get("position"));
            row.getCell("orgUnit").setValue(map.get("orgUnit"));
            row.getCell("email").setValue(map.get("email"));
            participantScopeInfo = new TrainActParticipantScopeInfo();
            personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)((String)map.get("personId"))));
            activityInfo = new TrainActivityInfo();
            activityInfo.setId(BOSUuid.read((String)this.trainActivityId));
            participantScopeInfo.setPerson(personInfo);
            participantScopeInfo.setTrainActivity(activityInfo);
            participantScopeInfo.setSendPerson(this.currentPerson);
            row.setUserObject((Object)participantScopeInfo);
        }
    }

    private boolean checkIfRefered(String personId) {
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            String personIdInTable = (String)row.getCell("personId").getValue();
            if (personIdInTable == null || !personIdInTable.equals(personId)) continue;
            return true;
        }
        return false;
    }

    public void actionCoursePerson_actionPerformed(ActionEvent e) throws Exception {
        TrainCoursePersonPromptBox pmt = new TrainCoursePersonPromptBox((IUIObject)this);
        if (this.courseIds == null) {
            this.courseIds = TrainActivityHelper.getActCourseIds(this.trainActivityId);
        }
        if (this.courseIds == null || this.courseIds.size() == 0) {
            TrainClientUtil.showMessage(resourcePath, "NoCoursePerson", (CoreUI)this);
            return;
        }
        pmt.setCourseIds(this.courseIds);
        pmt.setSource("MessagePublish");
        this.handlePromptBox(pmt);
    }

    private void handlePromptBox(KDCommonPromptDialog pmt) throws Exception {
        pmt.setModal(true);
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            final Object[] obj = (Object[])pmt.getData();
            if (obj.length > 10) {
                ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

                    public void run() throws Exception {
                        TrainActParticipantScopeListUI.this.dealAddPerson(obj);
                    }
                };
                new ProgressManager((CoreUI)this).launchProcess(process, (CoreUIObject)this);
            } else {
                this.dealAddPerson(obj);
            }
        }
    }

    public void actionDelPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelPerson_actionPerformed(e);
        ITrainActParticipantScope participantScope = TrainActParticipantScopeFactory.getRemoteInstance();
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        if (this.confirmRemove()) {
            List selectRowList = TrainUtils.getSelectedRows(this.tblMain);
            Arrays.sort(selectRowList.toArray());
            IRow row = null;
            HashSet<String> idSet = new HashSet<String>();
            for (int i = selectRowList.size() - 1; i >= 0; --i) {
                int rowIndex = (Integer)selectRowList.get(i);
                row = this.tblMain.getRow(rowIndex);
                String id = (String)row.getCell("id").getValue();
                if (id != null) {
                    idSet.add(id);
                }
                this.tblMain.removeRow(rowIndex);
            }
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            participantScope.delete(fi);
        }
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0 && (this.txtPublishRang.getText() == null || "".equals(this.txtPublishRang.getText()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoPerson"));
            return;
        }
        this.verifyInput();
        this.bindFields();
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainActSendEmailInfoUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        TrainActSendEmailInfoUI trainActSendEmailInfoUI = (TrainActSendEmailInfoUI)uiWindow.getUIObject();
        if (this.curTrainActivityInfo.isIsSent()) {
            trainActSendEmailInfoUI.setTitle(replySendMessage);
        }
        uiWindow.show();
        if (trainActSendEmailInfoUI.isSendMessage()) {
            boolean sendMail = trainActSendEmailInfoUI.isSendMail();
            if (sendMail) {
                this.verifyPersonMail();
            }
            this.executePublish(sendMail);
        }
    }

    private void verifyPersonMail() {
        int badEmailCount = 0;
        StringBuffer badEmailName = new StringBuffer();
        HashSet<String> nameBuffer = new HashSet<String>();
        String email = null;
        IRow row = null;
        int rowSize = this.tblMain.getRowCount();
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("name").getValue() == null) {
                nameBuffer.add(String.valueOf(i + 1));
            }
            if (!StringUtils.isEmpty((String)(email = (String)row.getCell("email").getValue())) && email.indexOf("@") >= 0) continue;
            if (badEmailCount++ != 0) {
                badEmailName.append(",");
            }
            badEmailName.append(row.getCell("name").getValue().toString());
        }
        if (nameBuffer.size() > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)resource, (String)"NAMEISUNLL"));
            SysUtil.abort();
        }
        if (badEmailCount > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(badEmailName);
            sb.append(EASResource.getString((String)resource, (String)"etc"));
            sb.append(badEmailCount);
            sb.append(EASResource.getString((String)resource, (String)"sendMailConfirm"));
            if (MsgBox.showConfirm2((String)sb.toString()) != 0) {
                SysUtil.abort();
            }
        }
    }

    private void executePublish(final boolean sendMail) {
        TrainClientUtil.executeWithProcess((CoreUI)this, new IProgTask(){

            public Object exec() throws Exception {
                TrainActParticipantScopeListUI.this.runPublish(sendMail);
                return "";
            }

            public void afterExec(Object result) throws Exception {
                TrainActParticipantScopeListUI.this.afterPublish();
            }
        });
    }

    private void runPublish(boolean sendMail) throws BOSException, EASBizException {
        IObjectPK messagePK = TrainActivityFacadeFactory.getRemoteInstance().publishTrainActivity(this.curTrainActivityInfo, this.messageInfo, this.publishGroupData, sendMail);
        this.messageInfo.setId(BOSUuid.read((String)messagePK.toString()));
    }

    private void afterPublish() throws Exception {
        TrainActManagerUI trainActManagerUI = (TrainActManagerUI)((Object)this.getUIContext().get("ListEditUI"));
        if (trainActManagerUI != null) {
            trainActManagerUI.setPublished(true);
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"PublishSuccess"));
        this.loadData();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        this.bindFields();
        IObjectPK messagePK = TrainActivityFacadeFactory.getRemoteInstance().saveActPublishInfo(this.curTrainActivityInfo, this.messageInfo, this.publishGroupData);
        this.messageInfo.setId(BOSUuid.read((String)messagePK.toString()));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Success"));
    }

    private void verifyInput() {
        if (this.ckIsAcceptSignUp.isSelected()) {
            TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkSignUpStartDate);
            TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkSignUpEndDate);
        }
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkPublishStartDate);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkPublishEndDate);
        TrainVerifyUtils.verifyDateBigOrSmallOrEqual((CoreUIObject)this, this.pkPublishStartDate, this.pkPublishEndDate, EASResource.getString((String)resourcePath, (String)"PublishDateError"));
        TrainVerifyUtils.verifyDateBigOrSmallOrEqual((CoreUIObject)this, this.pkSignUpStartDate, this.pkSignUpEndDate, EASResource.getString((String)resourcePath, (String)"SignUpDateError"));
        TrainVerifyUtils.verifyDateBigOrSmallOrEqual((CoreUIObject)this, this.pkPublishStartDate, this.pkSignUpStartDate, EASResource.getString((String)resourcePath, (String)"SignUpPublishDateError"));
        TrainVerifyUtils.verifyDateBigOrSmallOrEqual((CoreUIObject)this, this.pkSignUpEndDate, this.pkPublishEndDate, EASResource.getString((String)resourcePath, (String)"SignUpPublishDateError"));
    }

    private void bindFields() {
        this.storeActSignupInfo();
        this.storeMessageInfo();
        this.storeOrgsScope();
    }

    private void storeActSignupInfo() {
        this.curTrainActivityInfo.setSignStartDate(DateTimeUtils.truncateDate((Date)((Date)this.pkSignUpStartDate.getValue())));
        this.curTrainActivityInfo.setSignEndDate(DateTimeUtils.truncateDate((Date)((Date)this.pkSignUpEndDate.getValue())));
        this.curTrainActivityInfo.setPubStartDate(DateTimeUtils.truncateDate((Date)((Date)this.pkPublishStartDate.getValue())));
        this.curTrainActivityInfo.setPubEndDate(DateTimeUtils.truncateDate((Date)((Date)this.pkPublishEndDate.getValue())));
        this.curTrainActivityInfo.setCanSignUp(this.ckIsAcceptSignUp.isSelected());
    }

    private void storeMessageInfo() {
        this.messageInfo.setTitle(this.txtTitle.getText());
        this.messageInfo.setContent(this.txtContent.getText());
    }

    private void storeOrgsScope() {
        if (this.txtPublishRang.getText() == null || "".equals(this.txtPublishRang.getText())) {
            this.publishGroupData.clear();
        } else {
            MAGroupInfo groupInfo2 = null;
            String[] txtrang = this.txtPublishRang.getText().toString().split(";");
            HashSet<MAGroupInfo> deleteGroups = new HashSet<MAGroupInfo>();
            for (MAGroupInfo groupInfo2 : this.publishGroupData) {
                boolean exist = false;
                for (String str : txtrang) {
                    if (StringUtils.isEmpty((String)str) || groupInfo2 == null || groupInfo2.getName() == null || !groupInfo2.getName().equals(str)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                deleteGroups.add(groupInfo2);
            }
            if (deleteGroups.size() > 0) {
                this.publishGroupData.removeAll(deleteGroups);
            }
        }
    }

    public void submit() throws Exception {
        TrainActParticipantScopeCollection participantScopeCollection = new TrainActParticipantScopeCollection();
        TrainActParticipantScopeInfo participantScopeInfo = null;
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("id").getValue() != null) continue;
            participantScopeInfo = (TrainActParticipantScopeInfo)row.getUserObject();
            participantScopeCollection.add(participantScopeInfo);
        }
        if (participantScopeCollection.size() != 0) {
            ITrainActParticipantScope iParticipantScope = TrainActParticipantScopeFactory.getRemoteInstance();
            Map idMap = iParticipantScope.batchSubmit(participantScopeCollection);
            int size2 = this.tblMain.getRowCount();
            for (int i = 0; i < size2; ++i) {
                row = this.tblMain.getRow(i);
                if (row.getCell("id").getValue() != null) continue;
                row.getCell("id").setValue(idMap.get((String)row.getCell("personId").getValue()));
            }
        }
    }

    protected void ckIsAcceptSignUp_stateChanged(ChangeEvent e) throws Exception {
        boolean selected = this.ckIsAcceptSignUp.isSelected();
        this.pkSignUpStartDate.setEnabled(selected);
        this.pkSignUpEndDate.setEnabled(selected);
        this.pkSignUpStartDate.setRequired(selected);
        this.pkSignUpEndDate.setRequired(selected);
        if (!selected) {
            this.pkSignUpStartDate.setValue(null);
            this.pkSignUpEndDate.setValue(null);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            String columName = this.tblMain.getColumn(e.getColIndex()).getKey();
            String sortField = null;
            if ("number".equals(columName)) {
                sortField = "Person.number";
            } else if ("name".equals(columName)) {
                sortField = "Person.name";
            } else if ("position".equals(columName)) {
                sortField = "position.name";
            } else if ("orgUnit".equals(columName)) {
                sortField = "orgUnit.name";
            }
            this.asc = this.colIndex == e.getColIndex() ? !this.asc : true;
            this.colIndex = e.getColIndex();
            SorterItemCollection sortItems = new SorterItemCollection();
            SorterItemInfo sorterItemInfo = new SorterItemInfo(sortField);
            sorterItemInfo.setSortType(this.asc ? SortType.ASCEND : SortType.DESCEND);
            sortItems.add(sorterItemInfo);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)this.trainActivityId));
            IRowSet rowSet = this.getPerson("com.kingdee.eas.hr.train.app.TrainActParticipantScopeQuery", filterInfo, sortItems);
            ArrayList list = new ArrayList();
            HashMap<String, String> map = null;
            while (rowSet.next()) {
                map = new HashMap<String, String>();
                map.put("id", rowSet.getString("id"));
                map.put("personId", rowSet.getString("Person.id"));
                map.put("number", rowSet.getString("Person.number"));
                map.put("name", rowSet.getString("Person.name"));
                map.put("position", rowSet.getString("position.name"));
                map.put("orgUnit", rowSet.getString("orgUnit.name"));
                map.put("email", rowSet.getString("Person.email"));
                list.add(map);
            }
            this.tblMain.removeRows();
            this.fillTable(list);
        }
    }

    public void actionAddOrgs_actionPerformed(ActionEvent e) throws Exception {
        MAGroupF7 mAGroupF7 = new MAGroupF7((IUIObject)this);
        mAGroupF7.show();
        if (mAGroupF7.getData() != null) {
            ArrayList array = (ArrayList)mAGroupF7.getData();
            this.publishGroupData.clear();
            MAGroupInfo groupInfo2 = null;
            StringBuffer sb = new StringBuffer();
            for (MAGroupInfo groupInfo2 : array) {
                this.publishGroupData.add(groupInfo2);
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(groupInfo2.getName());
            }
            this.txtPublishRang.setText(sb.toString());
        }
    }

    protected String getEditUIName() {
        return TrainActParticipantScopeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainActParticipantScopeFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainActParticipantScopeInfo objectValue = new TrainActParticipantScopeInfo();
        return objectValue;
    }

    public IUIActionPostman prepareInit() {
        TrainClientUtil.checkValidPerson((CoreUI)this);
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("trainActivityId", this.getUIContext().get("ID"));
        request.put("person.id", (Object)this.currentPerson.getId().toString());
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public boolean isPrepareInit() {
        return true;
    }

    protected void initUserConfig() {
    }

    public void actionTrainStudent_actionPerformed(ActionEvent e) throws Exception {
        super.actionTrainStudent_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"TrainActivityID", (Object)this.trainActivityId);
        TrainStudentAllPromptBox pmt = new TrainStudentAllPromptBox((IUIObject)this, uiContext);
        this.handlePromptBox(pmt);
    }

    private IRowSet getPerson(String queryName, FilterInfo filterInfo, SorterItemCollection sorterItems) throws BOSException {
        MetaDataPK queryPK = new MetaDataPK(queryName);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        if (sorterItems != null && sorterItems.size() > 0) {
            SorterItemCollection temp = evi.getSorter();
            int size = sorterItems.size();
            for (int i = 0; i < size; ++i) {
                temp.add(sorterItems.get(i));
            }
        }
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }
}

