/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.ChargeItemInfo;
import com.kingdee.eas.hr.train.TrainActivityCostInfo;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainPlanActivityCostCollection;
import com.kingdee.eas.hr.train.TrainPlanActivityCostInfo;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityFactory;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainActivityCostUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class TrainActivityCostUI
extends AbstractTrainActivityCostUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActivityCostUI.class);
    private Icon newLineIcon = EASResource.getIcon((String)"imgTbtn_addline");
    private Icon removeLineIcon = EASResource.getIcon((String)"imgTbtn_deleteline");
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private static final String costTitle = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"totalCost");
    private static final String costUnit = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"costUnit");
    private static final String total = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"total");
    private static final String dollar = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"dollar");
    private static final Color YELLOW = new Color(16579551);
    private BigDecimal totalCost = new BigDecimal("0.00");
    private BigDecimal costTotal = new BigDecimal("0.00");
    private boolean isFirst = true;
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainHolidayResource";
    private static final String totalCostMention = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TotalCostItem");

    public void onLoad() throws Exception {
        this.kdtTrainActivityCost.checkParsed();
        if (OprtState.VIEW.equals(this.oprtState)) {
            TrainUtils.disableTable(this.kdtTrainActivityCost);
            this.actionAddLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        }
        if (this.getUIContext().get("costTotal") != null) {
            this.costTotal = new BigDecimal(this.getUIContext().get("costTotal").toString());
        }
        super.onLoad();
        this.setCostTypeEditor();
        this.setCostEditor();
        this.kdtTrainActivityCost.getColumn("chargeItem").getStyleAttributes().setBackground(YELLOW);
        this.kdtTrainActivityCost.getColumn("totalCost").getStyleAttributes().setBackground(YELLOW);
        TrainUtils.setTableCellEditorByTextField(this.kdtTrainActivityCost, "chargeStand", 40);
        TrainUtils.setTableCellEditorByTextField(this.kdtTrainActivityCost, "remark", 80);
        TrainUtils.setTableCellEditorByFormattedTextField(this.kdtTrainActivityCost, "count", 0);
    }

    protected void kdtTrainActivityCost_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtTrainActivityCost.getColumnIndex("totalCost")) {
            this.cacuTotalCostEdit();
        }
        IRow row = this.kdtTrainActivityCost.getRow(e.getRowIndex());
        if (colIndex == this.kdtTrainActivityCost.getColumn("chargeItem").getColumnIndex() && e.getValue() != null && this.isExistChargeItemInTable((ChargeItemInfo)e.getValue(), row)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.TrainActivityResource", (String)"ExistItem"));
            row.getCell("chargeItem").setValue(null);
            row.getCell("chargeStand").setValue(null);
            row.getCell("count").setValue(null);
            row.getCell("totalCost").setValue(null);
            row.getCell("remark").setValue(null);
            SysUtil.abort();
        }
    }

    private boolean isExistChargeItemInTable(ChargeItemInfo info, IRow editRow) {
        if (info == null) {
            return false;
        }
        IRow row = null;
        int count = this.kdtTrainActivityCost.getRowCount() - 1;
        for (int i = 0; i < count; ++i) {
            row = this.kdtTrainActivityCost.getRow(i);
            if (row.getRowIndex() == editRow.getRowIndex() || row.getCell("chargeItem").getValue() == null || !((ChargeItemInfo)row.getCell("chargeItem").getValue()).getId().toString().equals(info.getId().toString())) continue;
            return true;
        }
        return false;
    }

    private void setTitle() {
        StringBuffer sb = new StringBuffer();
        sb.append(costTitle);
        sb.append(this.costTotal.toString());
        sb.append(costUnit);
        this.contMain.setTitle(total + sb.toString() + dollar);
    }

    private void cacuTotalCostEdit() {
        this.totalCost = new BigDecimal("0.00");
        BigDecimal cost = null;
        int n = this.kdtTrainActivityCost.getRowCount();
        for (int i = 0; i < n; ++i) {
            int col = this.kdtTrainActivityCost.getColumnIndex("totalCost");
            cost = (BigDecimal)this.kdtTrainActivityCost.getRow(i).getCell(col).getValue();
            if (cost == null) continue;
            this.totalCost = this.totalCost.add(cost);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(TrainUtils.formatBigDecimal(this.totalCost, 2));
        this.contMain.setTitle(total + sb.toString() + dollar);
    }

    protected boolean confirmRemoveEnable() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)totalCostMention));
    }

    private void cacuTotalCost() {
        this.totalCost = new BigDecimal("0.00");
        BigDecimal cost = null;
        int n = this.kdtTrainActivityCost.getRowCount();
        for (int i = 0; i < n; ++i) {
            int col = this.kdtTrainActivityCost.getColumnIndex("totalCost");
            cost = (BigDecimal)this.kdtTrainActivityCost.getRow(i).getCell(col).getValue();
            if (cost == null) continue;
            this.totalCost = this.totalCost.add(cost);
        }
        if (!(this.totalCost.compareTo(this.costTotal) != 1 && this.totalCost.compareTo(this.costTotal) != -1 || this.confirmRemoveEnable())) {
            SysUtil.abort();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(TrainUtils.formatBigDecimal(this.totalCost, 2));
        this.contMain.setTitle(total + sb.toString() + dollar);
        this.isFirst = false;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setTitle();
        if (this.isFirst) {
            this.cacuTotalCostEdit();
            this.isFirst = false;
        }
    }

    private void setCostTypeEditor() throws Exception {
        EntityViewInfo evi = TrainUtils.getCurrentHREntityViewInfo();
        TrainUtils.setTableCellEditorByF7Query(this.kdtTrainActivityCost, "com.kingdee.eas.hr.train.app.ChargeItemQuery", "chargeItem", evi);
    }

    private void setCostEditor() {
        KDFormattedTextField txtCost = new KDFormattedTextField();
        txtCost.setHorizontalAlignment(2);
        txtCost.setDataType(1);
        txtCost.setPrecision(2);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(txtCost);
        this.kdtTrainActivityCost.getColumn("totalCost").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtCost));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnInputCost.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        if (OprtState.VIEW.equals(this.oprtState)) {
            this.actionInputCost.setEnabled(false);
        } else {
            this.actionInputCost.setEnabled(true);
        }
        JButton btnAddLine = this.contMain.add((Action)((Object)this.actionAddLine));
        btnAddLine.setIcon(this.newLineIcon);
        btnAddLine.setToolTipText(EASResource.getString((String)RES, (String)"add"));
        JButton btnRemoveLine = this.contMain.add((Action)((Object)this.actionRemoveLine));
        btnRemoveLine.setIcon(this.removeLineIcon);
        btnRemoveLine.setToolTipText(EASResource.getString((String)RES, (String)"remove"));
    }

    private void addLine(KDTable table, IObjectValue obj) {
        IRow row = table.addRow();
        this.loadLineFields(table, row, obj);
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        TrainActivityCostInfo info = new TrainActivityCostInfo();
        this.addLine(this.kdtTrainActivityCost, (IObjectValue)info);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine(this.kdtTrainActivityCost);
    }

    protected IObjectValue createNewData() {
        TrainActivityInfo ret = new TrainActivityInfo();
        return ret;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainActivityFactory.getRemoteInstance();
    }

    public TrainActivityInfo getEditDataInfo() {
        return this.editData;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        int chargeItemIndex = this.kdtTrainActivityCost.getColumnIndex("chargeItem");
        int totalCostIndex = this.kdtTrainActivityCost.getColumnIndex("totalCost");
        IRow row = null;
        KDTEditManager km = this.kdtTrainActivityCost.getEditManager();
        int n = this.kdtTrainActivityCost.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.kdtTrainActivityCost.getRow(i);
            if (row.getCell(chargeItemIndex).getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullChargeItem"));
                km.editCellAt(row.getRowIndex(), chargeItemIndex);
                SysUtil.abort();
            }
            if (row.getCell(totalCostIndex).getValue() != null) continue;
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nullTotalCost"));
            km.editCellAt(row.getRowIndex(), totalCostIndex);
            SysUtil.abort();
        }
    }

    public BigDecimal getTotalCost() {
        return this.totalCost;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("Cost"));
        return sic;
    }

    public IObjectPK runSubmit() throws Exception {
        this.cacuTotalCost();
        if (this.totalCost != null && this.totalCost.compareTo(new BigDecimal("0.00")) > 0) {
            this.editData.setBudgetCost(this.totalCost);
        }
        return super.runSave();
    }

    public void actionInputCost_actionPerformed(ActionEvent e) throws Exception {
        String planActivityId = (String)this.getUIContext().get("planActivityId");
        if (!TrainClientUtil.objectIsNull(planActivityId)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("trainPlanActivityCost.chargeStand"));
            sic.add(new SelectorItemInfo("trainPlanActivityCost.count"));
            sic.add(new SelectorItemInfo("trainPlanActivityCost.totalCost"));
            sic.add(new SelectorItemInfo("trainPlanActivityCost.remark"));
            sic.add(new SelectorItemInfo("trainPlanActivityCost.chargeItem.name"));
            TrainPlanTrainPlanActivityInfo trainPlanActivityInfo = TrainPlanTrainPlanActivityFactory.getRemoteInstance().getTrainPlanTrainPlanActivityInfo((IObjectPK)new ObjectUuidPK(planActivityId), sic);
            TrainPlanActivityCostCollection costCol = trainPlanActivityInfo.getTrainPlanActivityCost();
            int size = costCol.size();
            for (int i = 0; i < size; ++i) {
                TrainPlanActivityCostInfo costInfo = costCol.get(i);
                TrainActivityCostInfo info = new TrainActivityCostInfo();
                info.setChargeStand(costInfo.getChargeStand());
                info.setCount(costInfo.getCount());
                info.setTotalCost(costInfo.getTotalCost());
                info.setRemark(costInfo.getRemark());
                info.setChargeItemID(costInfo.getChargeItem());
                this.addLine(this.kdtTrainActivityCost, (IObjectValue)info);
            }
        }
    }
}

