/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.workflow.WorkflowUtils;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActStateEnum;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainStudentCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseFactory;
import com.kingdee.eas.hr.train.TrainStudentFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainActivityListUI;
import com.kingdee.eas.hr.train.client.TrainActManagerUI;
import com.kingdee.eas.hr.train.client.TrainActParticipantScopeListUI;
import com.kingdee.eas.hr.train.client.TrainActSendNotifyUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainActivityListFilterUI;
import com.kingdee.eas.hr.train.client.TrainActivityOrganigerListUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainSignUpInfoListUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TrainActivityListUI
extends AbstractTrainActivityListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainActivityListUI.class);
    private String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";
    private final String formalLessMax = EASResource.getString((String)this.resourcePath, (String)"FORMALLESSMAX");
    private WindowListener listenerForEditWindow = null;
    private boolean startOnLoad = false;
    private Boolean defaultFilterFlag = null;

    public void onLoad() throws Exception {
        this.startOnLoad = true;
        super.onLoad();
        TrainUtils.setTableNumberFormat(this.tblMain, "BudgetCost", 2);
        this.tblMain.setColumnMoveable(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnStart.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.btnFinish.setIcon(EASResource.getIcon((String)"imgTbtn_allfinishinitialize"));
        this.btnModify.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.btnSendMessage.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
        this.btnSignUpInfo.setIcon(EASResource.getIcon((String)"imgTbtn_seesignup"));
        this.btnOrganizer.setIcon(EASResource.getIcon((String)"imgTbtn_organigerlist"));
        this.actionSignUpInfo.setEnabled(true);
        this.actionOrganizer.setEnabled(true);
        this.menuItemModify.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.menuItemViewOrginazer.setIcon(EASResource.getIcon((String)"imgTbtn_organigerlist"));
        this.menuItemViewSignuper.setIcon(EASResource.getIcon((String)"imgTbtn_seesignup"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.menuItemStart.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.menuItemFinish.setIcon(EASResource.getIcon((String)"imgTbtn_allfinishinitialize"));
        this.menuItemSendNotify.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
        this.menuItemWorkFlowG.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.menuItemAuditResult.setIcon(EASResource.getIcon((String)"imgTbtn_multapproveresult"));
        this.actionResultSee.setEnabled(true);
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                rowSet.updateString("trainDate", TrainActivityHelper.getStartDate2EndDateString(rowSet.getDate("trainStartDate"), rowSet.getDate("trainEndDate")));
                String trainPlanName = rowSet.getString("TrainPlan.name");
                String planActivityName = rowSet.getString("planActivity.Name");
                if (planActivityName == null) continue;
                rowSet.updateString("TrainPlan.name", trainPlanName + " - " + planActivityName);
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        super.onGetRowSet(rowSet);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return TrainUtils.getHRAndAdminRangeFilterInfo("HrOrgUnit.id", "belongOrgUnit.id");
    }

    protected String getEditUIName() {
        return TrainActManagerUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainActivityFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainActivityInfo objectValue = new TrainActivityInfo();
        return objectValue;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = TrainUtils.getSelectedRow(this.tblMain);
        BizEnumValueDTO auditstate = (BizEnumValueDTO)this.tblMain.getRow(selectedRow).getCell("AuditState").getValue();
        if (auditstate != null && 20 == auditstate.getInt()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"notDelete"));
        } else {
            BizEnumValueInfo status = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("status").getValue();
            if (status.getInt() != 10) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"OnlyCanDeleteNotEffectiveActivity"));
                SysUtil.abort();
            } else {
                String trainActivityId = this.getSelectedKeyValue();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
                if (TrainActCourseFactory.getRemoteInstance().exists(fi)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ExistTrainActCourse"));
                    SysUtil.abort();
                }
                if (TrainStudentFactory.getRemoteInstance().exists(fi)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ExistTrainStudent"));
                    SysUtil.abort();
                }
                super.actionRemove_actionPerformed(e);
            }
        }
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = TrainUtils.getSelectedRow(this.tblMain);
        TrainActivityHelper.auditTrainActivity(this.getSelectedKeyValue());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"AuditSuccess"));
        BizEnumValueInfo valueInfo = new BizEnumValueInfo();
        valueInfo.setValue((Object)TrainActStateEnum.APPROVED);
        this.tblMain.getRow(selectedRow).getCell("status").setValue((Object)valueInfo);
        this.refreshTable(selectedRow);
        this.setWorkButtonStatus(TrainActStateEnum.APPROVED, null);
    }

    private void setWorkButtonStatus(TrainActStateEnum approved, TrainAuditStateEnum state) {
        if (approved == null) {
            this.actionAudit.setEnabled(false);
            this.actionPublish.setEnabled(false);
            this.actionStart.setEnabled(false);
            this.actionFinish.setEnabled(false);
        } else if (approved.equals((Object)TrainActStateEnum.NOT_EFFECTIVE) && state.equals((Object)TrainAuditStateEnum.UNSUBMIT)) {
            this.btnAudit.setEnabled(true);
            this.actionAudit.setEnabled(true);
            this.actionPublish.setEnabled(false);
            this.actionStart.setEnabled(false);
            this.actionFinish.setEnabled(false);
        } else if (approved.equals((Object)TrainActStateEnum.APPROVED)) {
            this.actionAudit.setEnabled(false);
            this.actionPublish.setEnabled(true);
            this.actionStart.setEnabled(true);
            this.actionFinish.setEnabled(false);
        } else if (approved.equals((Object)TrainActStateEnum.RUNNING)) {
            this.actionAudit.setEnabled(false);
            this.actionPublish.setEnabled(false);
            this.actionStart.setEnabled(false);
            this.actionFinish.setEnabled(true);
        } else if (approved.equals((Object)TrainActStateEnum.CLOSED)) {
            this.actionAudit.setEnabled(false);
            this.actionPublish.setEnabled(false);
            this.actionStart.setEnabled(false);
            this.actionFinish.setEnabled(false);
        }
    }

    public void actionFinish_actionPerformed(ActionEvent e) throws Exception {
        super.actionFinish_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = TrainUtils.getSelectedRow(this.tblMain);
        String id = this.getSelectedKeyValue();
        this.verifyActivityFinishCondition(id);
        TrainActivityHelper.finishTrainActivity(id);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"FinishSuccess"));
        BizEnumValueInfo valueInfo = new BizEnumValueInfo();
        valueInfo.setValue((Object)TrainActStateEnum.CLOSED);
        this.tblMain.getRow(selectedRow).getCell("status").setValue((Object)valueInfo);
        this.refreshTable(selectedRow);
        this.setWorkButtonStatus(TrainActStateEnum.CLOSED, null);
    }

    private void verifyActivityFinishCondition(String id) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("trainEndDate"));
        TrainActivityInfo info = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(id), sic);
        Date currentDate = new Date();
        if (info.getTrainEndDate() != null && currentDate.before(info.getTrainEndDate()) && !TrainClientUtil.showConfirmMessge(this.resourcePath, "Finish_Confirm_Message", (CoreUI)this)) {
            SysUtil.abort();
        }
    }

    private void refreshTable(int selectedRow) {
        this.tblMain.refresh();
        this.tblMain.getSelectManager().select(selectedRow, 0);
    }

    public void actionModify_actionPerformed(ActionEvent e) throws Exception {
        super.actionModify_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = TrainUtils.getSelectedRow(this.tblMain);
        BizEnumValueDTO auditstate = (BizEnumValueDTO)this.tblMain.getRow(selectedRow).getCell("AuditState").getValue();
        if (auditstate != null && 20 == auditstate.getInt()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"notModify"));
        } else {
            this.checkObjectExists();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
            uiContext.put((Object)"IsModifyTrainActivity", (Object)true);
            BizEnumValueInfo status = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("status").getValue();
            uiContext.put((Object)"TrainActivityStatus", (Object)TrainActStateEnum.getEnum(status.getInt()));
            uiContext.put((Object)"isModify", (Object)"modify");
            this.prepareUIContext(uiContext, e);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            if (this.isRefresh(uiWindow)) {
                this.refresh(e);
            }
        }
    }

    protected final boolean isRefresh(IUIWindow uiWindow) {
        if (this.getEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
            return !(uiWindow.getUIObject() instanceof EditUI) || ((EditUI)uiWindow.getUIObject()).isSave();
        }
        Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        if (this.listenerForEditWindow == null) {
            this.listenerForEditWindow = new WindowAdapter(){

                public void windowClosed(WindowEvent event) {
                    try {
                        if (SysContext.getSysContext().getSessionID() != null) {
                            TrainActivityListUI.this.refresh(null);
                        }
                    }
                    catch (Exception e) {
                        TrainActivityListUI.this.handleException(e);
                    }
                }
            };
        }
        window.removeWindowListener(this.listenerForEditWindow);
        window.addWindowListener(this.listenerForEditWindow);
        return false;
    }

    private void checkObjectExists() throws Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublish_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        this.getUIContext().put("ID", this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainActParticipantScopeListUI.class.getName(), this.getUIContext(), null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public void actionSendNotify_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        this.getUIContext().put("TrainActivityID", this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainActSendNotifyUI.class.getName(), this.getUIContext(), null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        super.actionStart_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = TrainUtils.getSelectedRow(this.tblMain);
        BizEnumValueInfo status = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("status").getValue();
        if (status.getInt() != 30) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"OnlyApprovedActivityCanStart"));
            SysUtil.abort();
        }
        String trainActivityId = (String)this.tblMain.getRow(selectedRow).getCell("id").getValue();
        this.checkTrainStudent(trainActivityId);
        TrainActivityHelper.startTrainActivity(this.getSelectedKeyValue());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"StartSuccess"));
        BizEnumValueInfo valueInfo = new BizEnumValueInfo();
        valueInfo.setValue((Object)TrainActStateEnum.RUNNING);
        this.tblMain.getRow(selectedRow).getCell("status").setValue((Object)valueInfo);
        this.refreshTable(selectedRow);
        this.setWorkButtonStatus(TrainActStateEnum.RUNNING, null);
    }

    private void checkTrainStudent(String trainActivityId) throws BOSException, EASBizException {
        BigDecimal maxStudent;
        BigDecimal minStudentCount;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("minStudentCount"));
        sic.add(new SelectorItemInfo("maxStudentCount"));
        sic.add(new SelectorItemInfo("needDivide"));
        sic.add(new SelectorItemInfo("isMustControl"));
        TrainActivityInfo trainActivityInfo = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(trainActivityId), sic);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        AbstractObjectCollection studentColl = null;
        int studentCount = 0;
        if (!trainActivityInfo.isNeedDivide()) {
            fi.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)trainActivityId));
            evi.getSelector().add(new SelectorItemInfo("Person.id"));
            studentColl = TrainStudentCourseFactory.getRemoteInstance().getTrainStudentCourseCollection(evi);
            if (studentColl != null && studentColl.size() > 0) {
                HashSet<String> students = new HashSet<String>();
                for (int i = 0; i < studentColl.size(); ++i) {
                    students.add(((TrainStudentCourseCollection)studentColl).get(i).getPerson().getId().toString());
                }
                studentCount = students.size();
            }
        } else {
            fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
            evi.getSelector().add(new SelectorItemInfo("id"));
            studentColl = TrainStudentFactory.getRemoteInstance().getTrainStudentCollection(evi);
            if (studentColl != null) {
                studentCount = studentColl.size();
            }
        }
        if (studentCount == 0) {
            TrainClientUtil.showErrorMessage(this.resourcePath, "CannotStartNoStudentActively", (CoreUI)this);
        }
        if ((minStudentCount = trainActivityInfo.getMinStudentCount()) != null && studentCount < minStudentCount.intValue() && !TrainClientUtil.showConfirmMessge((CoreUI)this, this.resourcePath, "StudentCount_Less", new Object[]{String.valueOf(minStudentCount)})) {
            SysUtil.abort();
        }
        EntityViewInfo eviFormal = new EntityViewInfo();
        FilterInfo fiFormal = new FilterInfo();
        eviFormal.setFilter(fiFormal);
        TrainStudentCollection studentCollFormal = null;
        int studentCountFormal = 0;
        fiFormal.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        eviFormal.getSelector().add(new SelectorItemInfo("id"));
        studentCollFormal = TrainStudentFactory.getRemoteInstance().getTrainStudentCollection(eviFormal);
        if (studentCollFormal != null) {
            studentCountFormal = studentCollFormal.size();
        }
        if (trainActivityInfo.isIsMustControl() && (maxStudent = trainActivityInfo.getMaxStudentCount()) != null && studentCountFormal > maxStudent.intValue()) {
            MsgBox.showInfo((String)(this.formalLessMax + maxStudent.toString() + "\uff01"));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = TrainUtils.getSelectedRow(this.tblMain);
        BizEnumValueDTO auditstate = (BizEnumValueDTO)this.tblMain.getRow(selectedRow).getCell("AuditState").getValue();
        if (auditstate != null && 20 == auditstate.getInt()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"notEdit"));
        } else {
            BizEnumValueInfo status = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("status").getValue();
            if (status.getInt() != 10) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"OnlyCanEditNotEffectiveActivity"));
                SysUtil.abort();
            } else {
                super.actionEdit_actionPerformed(e);
            }
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        int selectedRow = TrainUtils.getSelectedRow(this.tblMain);
        if (selectedRow < 0) {
            return;
        }
        BizEnumValueDTO auditstate = null;
        auditstate = (BizEnumValueDTO)this.tblMain.getRow(selectedRow).getCell("AuditState").getValue();
        if (auditstate != null && 20 != auditstate.getInt() && 30 != auditstate.getInt()) {
            BizEnumValueInfo status = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("status").getValue();
            this.setWorkButtonStatus(TrainActStateEnum.getEnum(status.getInt()), TrainAuditStateEnum.getEnum(auditstate.getInt()));
        } else {
            this.actionAudit.setEnabled(false);
            this.actionPublish.setEnabled(false);
            this.actionStart.setEnabled(false);
        }
    }

    public KDPanel getFilterUI() {
        try {
            return new TrainActivityListFilterUI();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.addUserPanel(this.getFilterUI());
        return queryDlg;
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    public IUIActionPostman prepareInit() {
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), this, this.mainQueryPK);
    }

    public void actionSignUpInfo_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignUpInfo_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(TrainUtils.getSelectedRow(this.tblMain));
        this.getUIContext().put("trainActivity", this.getSelectedKeyValue());
        this.getUIContext().put("trainActivityName", row.getCell("name").getValue().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainSignUpInfoListUI.class.getName(), this.getUIContext(), null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionOrganizer_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrganizer_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        this.getUIContext().put("TrainActivityID", this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainActivityOrganigerListUI.class.getName(), this.getUIContext(), null, OprtState.VIEW);
        uiWindow.show();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        WorkflowUtils.viewWorkFlowGraph((CoreUIObject)this, (String)id);
    }

    public void actionResultSee_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id == null || id.trim().length() < 1) {
            return;
        }
        MultiApproveUtil.showApproveHis((BOSUuid)BOSUuid.read((String)id), (String)UIModelDialogFactory.class.getName(), (Object)((Object)this));
    }

    public RequestContext prepareActionModify(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionModify(itemAction);
        String id = this.getSelectedKeyValue();
        if (id != null) {
            request.put("id", (Object)id);
        }
        return request;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionModify() {
        return true;
    }

    public boolean isPrepareActionOrganizer() {
        return true;
    }

    public boolean isPrepareActionPublish() {
        return true;
    }

    public boolean isPrepareActionSendNotify() {
        return true;
    }

    public boolean isPrepareActionSignUpInfo() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

