/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.workflow.WorkflowUtils;
import com.kingdee.eas.hr.train.IInnerTrainApply;
import com.kingdee.eas.hr.train.IOuterTrainApply;
import com.kingdee.eas.hr.train.InnerTrainApplyFactory;
import com.kingdee.eas.hr.train.InnerTrainApplyInfo;
import com.kingdee.eas.hr.train.OuterTrainApplyFactory;
import com.kingdee.eas.hr.train.OuterTrainApplyInfo;
import com.kingdee.eas.hr.train.TrainApplyTypeEnum;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.client.AbstractTrainApplyListUI;
import com.kingdee.eas.hr.train.client.InnerTrainApplyEditUI;
import com.kingdee.eas.hr.train.client.OuterTrainApplyEditUI;
import com.kingdee.eas.hr.train.client.TrainApplyFilterUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainQueryProcessor;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class TrainApplyListUI
extends AbstractTrainApplyListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainApplyListUI.class);
    static String AUDITSTATE = "AuditState";
    static String ID = "id";
    static String APPLYTYPE = "applyType";
    TrainApplyTypeEnum trainApplyTypeEnum = TrainApplyTypeEnum.INNERTRAINAPPLY;
    private TrainApplyFilterUI filterUI;
    static String RES = "com.kingdee.eas.hr.train.client.TrainApplyResource";
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainHolidayResource";
    private static final String totalLine = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TOTALLINE");
    private static final String totalRecord = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TOTALRECORD");
    private boolean startOnLoad = false;
    private Boolean defaultFilterFlag = null;

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.trainApplyTypeEnum = TrainApplyTypeEnum.getEnum(BOSUuid.getBOSObjectType((String)this.getSelectedKeyValue(), (boolean)false).toString());
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanUpdate();
        this.checkSelected();
        this.trainApplyTypeEnum = TrainApplyTypeEnum.getEnum(BOSUuid.getBOSObjectType((String)this.getSelectedKeyValue(), (boolean)false).toString());
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanDelete();
        this.checkSelected();
        this.trainApplyTypeEnum = TrainApplyTypeEnum.getEnum(BOSUuid.getBOSObjectType((String)this.getSelectedKeyValue(), (boolean)false).toString());
        super.actionRemove_actionPerformed(e);
    }

    protected String getEditUIName() {
        if (TrainApplyTypeEnum.INNERTRAINAPPLY.equals((Object)this.trainApplyTypeEnum)) {
            return InnerTrainApplyEditUI.class.getName();
        }
        return OuterTrainApplyEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (TrainApplyTypeEnum.INNERTRAINAPPLY.equals((Object)this.trainApplyTypeEnum)) {
            return InnerTrainApplyFactory.getRemoteInstance();
        }
        return OuterTrainApplyFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("HrOrgUnit", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("applyerID", (Object)SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    public void onLoad() throws Exception {
        this.startOnLoad = true;
        TrainClientUtil.checkValidHRO((CoreUI)this);
        TrainClientUtil.checkValidPerson((CoreUI)this);
        super.onLoad();
        this.tblMain.setUserCellDisplayParser(new IUserCellDisplayParser(){

            public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
                int applyTypeColumn = TrainApplyListUI.this.tblMain.getColumnIndex(APPLYTYPE);
                if (colIndex == applyTypeColumn - 1 && rowIndex >= 0) {
                    IRow row = TrainApplyListUI.this.tblMain.getRow(rowIndex);
                    Object obj = row.getCell(ID).getValue();
                    if (!TrainClientUtil.objectIsNull(obj)) {
                        row.getCell(APPLYTYPE).setValue((Object)TrainApplyTypeEnum.getEnum(BOSUuid.getBOSObjectType((String)obj.toString(), (boolean)false).toString()));
                    }
                    return value;
                }
                return value;
            }
        });
        this.tblMain.setColumnMoveable(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn(ID).getStyleAttributes().setHided(true);
        super.setMessageBarText(totalLine + this.tblMain.getRowCount() + totalRecord);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        super.setMessageBarText(totalLine + this.tblMain.getRowCount() + totalRecord);
    }

    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        JMenuItem item = this.btnTrainApplyGroup.addAssistMenuItem((Action)((Object)this.actionInnerTrainApply));
        item.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionInnerTrainApply), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        item = this.btnTrainApplyGroup.addAssistMenuItem((Action)((Object)this.actionOuterTrainApply));
        item.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionOuterTrainApply), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTrainApplyGroup.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.setButtonDefaultStyl(this.btnTrainApplyGroup);
        this.menuNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnWorkFlowG.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
    }

    public void actionInnerTrainApply_actionPerformed(ActionEvent e) throws Exception {
        super.actionInnerTrainApply_actionPerformed(e);
        this.trainApplyTypeEnum = TrainApplyTypeEnum.INNERTRAINAPPLY;
        super.actionAddNew_actionPerformed(e);
    }

    public void actionOuterTrainApply_actionPerformed(ActionEvent e) throws Exception {
        super.actionOuterTrainApply_actionPerformed(e);
        this.trainApplyTypeEnum = TrainApplyTypeEnum.OUTERTRAINAPPLY;
        super.actionAddNew_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.trainApplyTypeEnum = TrainApplyTypeEnum.getEnum(BOSUuid.getBOSObjectType((String)this.getSelectedKeyValue(), (boolean)false).toString());
        this.checkCanSubmit();
        if (TrainApplyTypeEnum.INNERTRAINAPPLY.equals((Object)this.trainApplyTypeEnum)) {
            IInnerTrainApply iit = (IInnerTrainApply)this.getBizInterface();
            iit.submission((InnerTrainApplyInfo)iit.getValue((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), this.getTrainApplySelectors()));
        } else if (TrainApplyTypeEnum.OUTERTRAINAPPLY.equals((Object)this.trainApplyTypeEnum)) {
            IOuterTrainApply iut = (IOuterTrainApply)this.getBizInterface();
            iut.submission((OuterTrainApplyInfo)iut.getValue((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), this.getTrainApplySelectors()));
        } else {
            TrainClientUtil.showErrorMessage(RES, "invalidState", (CoreUI)this);
        }
        TrainClientUtil.showMessage(RES, "submitSuccess", (CoreUI)this);
        this.refresh(e);
    }

    private void checkCanSubmit() {
        if (!this.canUpdateOrDelete()) {
            TrainClientUtil.showErrorMessage(RES, "canNotSubmit", (CoreUI)this);
        }
    }

    private void checkCanUpdate() {
        if (!this.canUpdateOrDelete()) {
            TrainClientUtil.showErrorMessage(RES, "canNotUpdate", (CoreUI)this);
        }
    }

    private void checkCanDelete() {
        if (!this.canUpdateOrDelete()) {
            TrainClientUtil.showErrorMessage(RES, "canNotDelete", (CoreUI)this);
        }
    }

    private boolean canUpdateOrDelete() {
        this.checkSelected();
        TrainAuditStateEnum state = this.getSelectedAuditState();
        if (state == null) {
            return false;
        }
        if (TrainAuditStateEnum.UNSUBMIT.equals((Object)state)) {
            return true;
        }
        return TrainAuditStateEnum.UNPASS.equals((Object)state);
    }

    private TrainAuditStateEnum getSelectedAuditState() {
        IRow row = TrainClientUtil.getSelectedRow(this.tblMain);
        TrainAuditStateEnum state = TrainAuditStateEnum.getEnum(((BizEnumValueInfo)row.getCell(AUDITSTATE).getValue()).getInt());
        return state;
    }

    public SelectorItemCollection getTrainApplySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("Name"));
        sic.add(new SelectorItemInfo("Applier.name"));
        return sic;
    }

    public TrainApplyFilterUI getFilterUI() {
        try {
            if (this.filterUI == null) {
                this.filterUI = new TrainApplyFilterUI();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.filterUI;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.addUserPanel((KDPanel)this.getFilterUI());
        queryDlg.setProcessor((IProcessor)new TrainQueryProcessor());
        return queryDlg;
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        WorkflowUtils.viewWorkFlowGraph((CoreUIObject)this, (String)id);
    }

    public IUIActionPostman prepareInit() {
        TrainClientUtil.checkValidHRO((CoreUI)this);
        TrainClientUtil.checkValidPerson((CoreUI)this);
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), this, this.mainQueryPK);
    }

    public RequestContext prepareActionEdit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionEdit(itemAction);
        if (request == null) {
            request = new RequestContext();
        }
        this.checkCanUpdate();
        this.checkSelected();
        this.trainApplyTypeEnum = TrainApplyTypeEnum.getEnum(BOSUuid.getBOSObjectType((String)this.getSelectedKeyValue(), (boolean)false).toString());
        request.put("type", (Object)this.trainApplyTypeEnum);
        return request;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionInnerTrainApply() {
        return true;
    }

    public boolean isPrepareActionOuterTrainApply() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

