/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.TrainAttendanceCollection;
import com.kingdee.eas.hr.train.TrainAttendanceFactory;
import com.kingdee.eas.hr.train.TrainAttendanceInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainAttendanceEditUI;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;

public class TrainAttendanceEditUI
extends AbstractTrainAttendanceEditUI {
    private String recordId = null;

    public void loadFields() {
        try {
            this.loadInfo();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
        try {
            this.chkIsNoAbsent_stateChanged(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void storeFields() {
        super.storeFields();
        if (this.editData.isIsNoAbsent()) {
            this.editData.put("AbsentType", null);
            this.setDataObject((IObjectValue)this.editData);
        }
    }

    protected String getEditUIName() {
        return TrainAttendanceEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainAttendanceFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainAttendanceInfo objectValue = new TrainAttendanceInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void loadInfo() throws EASBizException, BOSException {
        if (this.getUIContext().get("ID") != null) {
            this.recordId = this.getUIContext().get("ID").toString();
        }
        if (this.recordId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("TrainRecord.id", (Object)this.recordId));
            view.setFilter(filter);
            TrainAttendanceCollection attdCol = TrainAttendanceFactory.getRemoteInstance().getTrainAttendanceCollection(view);
            if (attdCol.size() <= 0) {
                this.editData = (TrainAttendanceInfo)this.createNewData();
                TrainCourseRecordInfo recordInfo = new TrainCourseRecordInfo();
                recordInfo.setId(BOSUuid.read((String)this.recordId));
            } else {
                this.editData = attdCol.get(0);
            }
            this.setDataObject((IObjectValue)this.editData);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.chkIsNoAbsent.setSelected(true);
    }

    protected void chkIsNoAbsent_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkIsNoAbsent.isSelected()) {
            this.setControlsEnabled(false);
            this.clearControlValues();
        } else {
            this.setControlsEnabled(true);
        }
    }

    private void setControlsEnabled(boolean flag) {
        this.cboAbsentType.setEnabled(flag);
        this.txtRealAttendCount.setEnabled(flag);
        this.txtMustAttendCount.setEnabled(flag);
        this.txtAttendInfo.setEnabled(flag);
        this.txtLeaveReason.setEnabled(flag);
        this.txtDescription.setEnabled(flag);
        this.txtRealAttendCount.setRequired(true);
        this.txtMustAttendCount.setRequired(true);
        this.cboAbsentType.setRequired(true);
    }

    private void clearControlValues() {
        this.cboAbsentType.setSelectedIndex(-1);
        this.txtRealAttendCount.setText(null);
        this.txtMustAttendCount.setText(null);
        this.txtAttendInfo.removeAllItems();
        this.txtLeaveReason.removeAllItems();
        this.txtDescription.removeAllItems();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource.Success"));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (!this.chkIsNoAbsent.isSelected()) {
            TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.cboAbsentType);
            TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtRealAttendCount);
            TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtMustAttendCount);
        }
    }
}

