/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.hr.train.AbsentTypeEnum;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.TrainActStateEnum;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordCollection;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.TrainRecordIsPassedEnum;
import com.kingdee.eas.hr.train.TrainTypeEnum;
import com.kingdee.eas.hr.train.client.AbstractTrainAttendenceBatchMgrUI;
import com.kingdee.eas.hr.train.client.LocateAssistant;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TrainAttendenceBatchMgrUI
extends AbstractTrainAttendenceBatchMgrUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainAttendenceBatchMgrUI.class);
    String RES = "com.kingdee.eas.hr.train.client.TrainRecordResource";
    JButton btnAddRuleNew;
    JButton btnDelRuleNew;
    HashMap recordMap;
    boolean isActivity = false;
    HashMap currentMap;
    boolean courseFlag = false;
    boolean activityFlag = false;
    private TrainCourseRecordInfo backRecordInfo = null;
    private LocateAssistant locateAssistant;
    private Set canNotAuditSet = new HashSet();
    private String userID = null;

    public void storeFields() {
        if (this.recordMap == null) {
            this.currentMap = null;
            return;
        }
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        this.currentMap = new HashMap();
        for (Map.Entry entry : this.recordMap.entrySet()) {
            this.currentMap.put(entry.getKey(), ((TrainCourseRecordInfo)entry.getValue()).clone());
        }
        String key = null;
        int n = this.recordTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            TrainCourseRecordInfo courseRecordInfo;
            IRow row = this.recordTable.getRow(i);
            if (this.isActivity) {
                key = row.getCell("person.id").getValue().toString() + row.getCell("trainActivity.id").getValue().toString();
                courseRecordInfo = (TrainCourseRecordInfo)this.currentMap.get(key);
                if (this.txtShouldAttend.getBigDecimalValue() != null) {
                    courseRecordInfo.setActShouldAttend(this.txtShouldAttend.getBigDecimalValue());
                }
                if (row.getCell("isAttendAll").getValue() != null && ((Boolean)row.getCell("isAttendAll").getValue()).booleanValue()) {
                    courseRecordInfo.setActAttendAll(true);
                    if (row.getCell("actAttend").getValue() != null) {
                        courseRecordInfo.setActActualAttend((BigDecimal)row.getCell("actAttend").getValue());
                    } else {
                        courseRecordInfo.setActActualAttend(null);
                    }
                    courseRecordInfo.put("actAbsentType", null);
                    courseRecordInfo.setActAbsent(null);
                    courseRecordInfo.setActAbsentHour(null);
                    courseRecordInfo.put("actAbsHourUnit", null);
                    continue;
                }
                courseRecordInfo.setActAttendAll(false);
                if (row.getCell("actAttend").getValue() != null) {
                    courseRecordInfo.setActActualAttend(new BigDecimal(row.getCell("actAttend").getValue().toString()));
                } else {
                    courseRecordInfo.setActActualAttend(null);
                }
                if (row.getCell("absentType").getValue() != null) {
                    courseRecordInfo.setActAbsentType((AbsentTypeEnum)((Object)row.getCell("absentType").getValue()));
                } else {
                    courseRecordInfo.put("actAbsentType", null);
                }
                if (row.getCell("absentCount").getValue() != null) {
                    courseRecordInfo.setActAbsent((BigDecimal)row.getCell("absentCount").getValue());
                } else {
                    courseRecordInfo.setActAbsent(null);
                }
                if (row.getCell("absentHour").getValue() != null) {
                    courseRecordInfo.setActAbsentHour((BigDecimal)row.getCell("absentHour").getValue());
                } else {
                    courseRecordInfo.setActAbsentHour(null);
                }
                if (row.getCell("absentHourUnit").getValue() != null) {
                    courseRecordInfo.setActAbsHourUnit((CourseHourUnitEnum)((Object)row.getCell("absentHourUnit").getValue()));
                    continue;
                }
                courseRecordInfo.put("actAbsHourUnit", null);
                continue;
            }
            boolean isCourse = false;
            if (this.promptTrainCourse.getValue() != null && this.promptTrainActivity.getValue() == null) {
                isCourse = true;
            }
            if (row.getCell("trainActivity.id").getValue() != null && !isCourse) {
                key = row.getCell("person.id").getValue().toString() + row.getCell("trainActivity.id").getValue().toString() + row.getCell("trainCourse.id").getValue().toString();
            } else {
                key = row.getCell("person.id").getValue().toString();
                key = key + row.getCell("trainCourse.id").getValue().toString();
                if (row.getCell("trainDate").getValue() != null) {
                    key = key + (String)row.getCell("trainDate").getValue();
                }
            }
            courseRecordInfo = (TrainCourseRecordInfo)this.currentMap.get(key);
            if (courseRecordInfo == null) continue;
            if (this.txtShouldAttend.getBigDecimalValue() != null) {
                courseRecordInfo.setShouldAttend(this.txtShouldAttend.getBigDecimalValue());
            }
            if (courseRecordInfo.getActHourUnit() == null) {
                courseRecordInfo.put("actHourUnit", null);
            }
            if (courseRecordInfo.getActAbsentType() == null) {
                courseRecordInfo.put("actAbsentType", null);
            }
            if (courseRecordInfo.getActAbsHourUnit() == null) {
                courseRecordInfo.put("actAbsHourUnit", null);
            }
            if (row.getCell("isAttendAll").getValue() != null && ((Boolean)row.getCell("isAttendAll").getValue()).booleanValue()) {
                courseRecordInfo.setAttendAll(true);
                if (row.getCell("actAttend").getValue() != null) {
                    courseRecordInfo.setActualAttend((BigDecimal)row.getCell("actAttend").getValue());
                } else {
                    courseRecordInfo.setActualAttend(null);
                }
                courseRecordInfo.put("absentType", null);
                courseRecordInfo.setAbsent(null);
                courseRecordInfo.setAbsentHour(null);
                courseRecordInfo.put("absentHourUnit", null);
                continue;
            }
            courseRecordInfo.setAttendAll(false);
            if (row.getCell("actAttend").getValue() != null) {
                courseRecordInfo.setActualAttend((BigDecimal)row.getCell("actAttend").getValue());
            } else {
                courseRecordInfo.setActualAttend(null);
            }
            if (row.getCell("absentType").getValue() != null) {
                courseRecordInfo.setAbsentType((AbsentTypeEnum)((Object)row.getCell("absentType").getValue()));
            } else {
                courseRecordInfo.put("absentType", null);
            }
            if (row.getCell("absentCount").getValue() != null) {
                courseRecordInfo.setAbsent((BigDecimal)row.getCell("absentCount").getValue());
            } else {
                courseRecordInfo.setAbsent(null);
            }
            if (row.getCell("absentHour").getValue() != null) {
                courseRecordInfo.setAbsentHour((BigDecimal)row.getCell("absentHour").getValue());
            } else {
                courseRecordInfo.setAbsentHour(null);
            }
            if (row.getCell("absentHourUnit").getValue() != null) {
                courseRecordInfo.setAbsentHourUnit((CourseHourUnitEnum)((Object)row.getCell("absentHourUnit").getValue()));
                continue;
            }
            courseRecordInfo.put("absentHourUnit", null);
        }
    }

    private boolean isModify() {
        this.storeFields();
        if (this.currentMap == null || this.recordMap == null) {
            return false;
        }
        for (Map.Entry entry : this.currentMap.entrySet()) {
            TrainCourseRecordInfo courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
            if (courseRecordInfo.getId() != null) continue;
            return true;
        }
        if (!this.isActivity) {
            TrainCourseRecordInfo info = null;
            for (Map.Entry entry : this.recordMap.entrySet()) {
                info = (TrainCourseRecordInfo)entry.getValue();
                if (info.getActHourUnit() == null) {
                    info.put("actHourUnit", null);
                }
                if (info.getActAbsentType() == null) {
                    info.put("actAbsentType", null);
                }
                if (info.getActAbsHourUnit() != null) continue;
                info.put("actAbsHourUnit", null);
            }
        }
        for (Map.Entry entry : this.currentMap.entrySet()) {
            TrainCourseRecordInfo info_sourse = (TrainCourseRecordInfo)entry.getValue();
            TrainCourseRecordInfo info_target = (TrainCourseRecordInfo)this.recordMap.get(entry.getKey());
            if (info_target.isActAttendAll()) {
                info_target.put("actAbsentType", null);
                info_target.put("actHourUnit", null);
                info_target.put("actAbsHourUnit", null);
                info_sourse.put("actAbsentType", null);
                info_sourse.put("actHourUnit", null);
                info_sourse.put("actAbsHourUnit", null);
            }
            if (info_target.get("actAbsentType") instanceof Integer && (Integer)info_target.get("actAbsentType") == 0) {
                info_target.put("actAbsentType", null);
            }
            if (info_target.get("actAbsHourUnit") instanceof Integer && (Integer)info_target.get("actAbsHourUnit") == 0) {
                info_target.put("actAbsHourUnit", null);
            }
            if (info_target.get("actHourUnit") instanceof Integer && (Integer)info_target.get("actHourUnit") == 0) {
                info_target.put("actHourUnit", null);
            }
            if (info_sourse.get("actAbsentType") instanceof Integer && (Integer)info_sourse.get("actAbsentType") == 0) {
                info_sourse.put("actAbsentType", null);
            }
            if (info_sourse.get("actAbsHourUnit") instanceof Integer && (Integer)info_sourse.get("actAbsHourUnit") == 0) {
                info_sourse.put("actAbsHourUnit", null);
            }
            if (info_sourse.get("actHourUnit") instanceof Integer && (Integer)info_sourse.get("actHourUnit") == 0) {
                info_sourse.put("actHourUnit", null);
            }
            if (info_target.isAttendAll()) {
                info_target.put("absentType", null);
                info_target.put("absentHour", null);
                info_target.put("absentHourUnit", null);
                info_sourse.put("absentType", null);
                info_sourse.put("absentHour", null);
                info_sourse.put("absentHourUnit", null);
            }
            if (info_target.get("absentType") instanceof Integer && (Integer)info_target.get("absentType") == 0) {
                info_target.put("absentType", null);
            }
            if (info_target.get("absentHourUnit") instanceof Integer && (Integer)info_target.get("absentHourUnit") == 0) {
                info_target.put("absentHourUnit", null);
            }
            if (info_sourse.get("absentType") instanceof Integer && (Integer)info_sourse.get("absentType") == 0) {
                info_sourse.put("absentType", null);
            }
            if (info_sourse.get("absentHourUnit") instanceof Integer && (Integer)info_sourse.get("absentHourUnit") == 0) {
                info_sourse.put("absentHourUnit", null);
            }
            if (ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)info_sourse, (AbstractObjectValue)info_target)) continue;
            return true;
        }
        return false;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSelectedCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
    }

    public void onLoad() throws Exception {
        this.recordTable.checkParsed();
        TrainClientUtil.setDisableColor(this.recordTable);
        TrainActivityHelper.initTrainActivity_By_End_Star(this.promptTrainActivity, TrainActivityHelper.getActSelectors());
        TrainActivityHelper.initTrainCourse(this.promptTrainCourse, false, (IUIObject)this);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtShouldAttend);
        this.txtShouldAttend.setPrecision(0);
        this.txtAttendAll.setRemoveingZeroInDispaly(false);
        TrainUtils.setKDTableSortable(this.recordTable);
        this.recordTable.getViewManager().setFreezeView(0, this.recordTable.getColumnIndex("name") + 1);
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.actionLocate.setEnabled(true);
        super.onLoad();
        this.initEntryButton();
        this.initTableEditor();
        this.initTableView();
        this.userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
        if (this.locateAssistant == null) {
            this.locateAssistant = new LocateAssistant((CoreUIObject)this, this.recordTable, this.getLocateNames());
        }
        this.locateAssistant.actionLocate();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "name", "orgUnit", "position"};
        return locateNames;
    }

    private void initTableView() {
        this.recordTable.checkParsed();
        this.recordTable.getColumn("name").getStyleAttributes().setLocked(true);
        this.recordTable.getColumn("number").getStyleAttributes().setLocked(true);
        this.recordTable.getColumn("orgUnit").getStyleAttributes().setLocked(true);
        this.recordTable.getColumn("position").getStyleAttributes().setLocked(true);
        this.recordTable.getColumn("jobGrade").getStyleAttributes().setLocked(true);
        this.recordTable.getColumn("absentCount").getStyleAttributes().setLocked(true);
    }

    private void initTableEditor() throws Exception {
        KDFormattedTextField formattedTextField2 = new KDFormattedTextField();
        formattedTextField2.setDataType(1);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(formattedTextField2);
        TrainUtils.setTableCellEditorByFormattedTextField(this.recordTable, formattedTextField2, "actAttend", 0);
        TrainUtils.setTableCellEditorByFormattedTextField(this.recordTable, formattedTextField2, "absentCount", 0);
        TrainUtils.setTableCellEditorByComboBox(this.recordTable, "absentType", "com.kingdee.eas.hr.train.AbsentTypeEnum");
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(formattedTextField);
        TrainUtils.setTableCellEditorByFormattedTextField(this.recordTable, formattedTextField, "absentHour", 2);
        TrainUtils.setTableCellEditorByComboBox(this.recordTable, "absentHourUnit", "com.kingdee.eas.hr.train.CourseHourUnitEnum");
    }

    private void loadData() throws Exception {
        this.clearTable();
        this.txtAttendAll.setValue(null);
        this.recordMap = new HashMap();
        FilterInfo filterInfo = this.getFilterInfo();
        TrainCourseRecordCollection courseRecordCollection = this.getRecordCollection(filterInfo, null);
        if (courseRecordCollection != null && courseRecordCollection.size() > 0) {
            this.backRecordInfo = courseRecordCollection.get(0);
            if (this.isActivity) {
                if (courseRecordCollection.get(0).getActShouldAttend() == null) {
                    this.txtShouldAttend.setValue((Object)new BigDecimal("0.00"));
                } else {
                    this.txtShouldAttend.setValue((Object)courseRecordCollection.get(0).getActShouldAttend());
                }
            } else if (courseRecordCollection.get(0).getShouldAttend() == null) {
                this.txtShouldAttend.setValue((Object)new BigDecimal("0.00"));
            } else {
                this.txtShouldAttend.setValue((Object)courseRecordCollection.get(0).getShouldAttend());
            }
        } else {
            this.txtShouldAttend.setValue((Object)new BigDecimal("0.00"));
        }
        HashMap newRecord = this.filterRecord(courseRecordCollection, this.isActivity, false);
        HashSet set = this.getPersonSet(newRecord);
        HashMap personMap = TrainUtils.getPersonProperty(set);
        this.countAttend_tmp(courseRecordCollection);
        this.putDataToTable(newRecord, personMap);
        this.operateIsAttendAll();
    }

    private void clearTable() {
        this.recordTable.checkParsed();
        this.recordTable.removeRows();
    }

    private void putDataToTable(HashMap record, HashMap personMap2) {
        if (record == null || record.size() == 0) {
            return;
        }
        Set recordIDSet = this.getTableID(this.recordTable);
        boolean noTrainActivity = true;
        if (this.promptTrainActivity.getValue() != null) {
            noTrainActivity = false;
        }
        this.recordTable.getColumn("trainDate").getStyleAttributes().setHided(!noTrainActivity);
        Iterator iterator = record.entrySet().iterator();
        while (iterator.hasNext()) {
            HashMap personRef = null;
            Map.Entry entry = iterator.next();
            TrainCourseRecordInfo courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
            if (this.promptTrainActivity.getValue() != null && this.promptTrainCourse.getValue() == null ? recordIDSet.contains(courseRecordInfo.getEmployee().getId().toString()) : recordIDSet.contains(courseRecordInfo.getId().toString())) continue;
            IRow row = this.recordTable.addRow();
            if (courseRecordInfo.getId() != null) {
                row.getCell("id").setValue((Object)courseRecordInfo.getId().toString());
            }
            if (courseRecordInfo.getTrainActivity() != null && courseRecordInfo.getTrainActivity().getId() != null) {
                row.getCell("trainActivity.id").setValue((Object)courseRecordInfo.getTrainActivity().getId().toString());
            }
            if (courseRecordInfo.getTrainCourse() != null && courseRecordInfo.getTrainCourse().getId() != null) {
                row.getCell("trainCourse.id").setValue((Object)courseRecordInfo.getTrainCourse().getId().toString());
            }
            if (courseRecordInfo.getEmployee().getId() != null) {
                row.getCell("person.id").setValue((Object)courseRecordInfo.getEmployee().getId().toString());
                personRef = (HashMap)personMap2.get(courseRecordInfo.getEmployee().getId().toString());
            }
            if (personRef != null) {
                row.getCell("name").setValue(personRef.get("name"));
                row.getCell("number").setValue(personRef.get("number"));
                if (courseRecordInfo.getRecordExtends() != null) {
                    if (courseRecordInfo.getRecordExtends().getOrgStudent().getName() != null) {
                        row.getCell("orgUnit").setValue((Object)courseRecordInfo.getRecordExtends().getOrgStudent().getName());
                    } else {
                        row.getCell("orgUnit").setValue(personRef.get("orgUnit"));
                    }
                    if (courseRecordInfo.getRecordExtends().getPosiStudent().getName() != null) {
                        row.getCell("position").setValue((Object)courseRecordInfo.getRecordExtends().getPosiStudent().getName());
                    } else {
                        row.getCell("position").setValue(personRef.get("position"));
                    }
                } else {
                    row.getCell("orgUnit").setValue(personRef.get("orgUnit"));
                    row.getCell("position").setValue(personRef.get("position"));
                }
                row.getCell("jobGrade").setValue(personRef.get("jobGrade"));
            }
            if (this.isActivity) {
                if (courseRecordInfo.isActAttendAll()) {
                    row.getCell("isAttendAll").setValue((Object)Boolean.TRUE);
                } else {
                    row.getCell("isAttendAll").setValue((Object)Boolean.FALSE);
                }
                row.getCell("actAttend").setValue((Object)courseRecordInfo.getActActualAttend());
                if (courseRecordInfo.getActAbsentType() != null) {
                    row.getCell("absentType").setValue((Object)courseRecordInfo.getActAbsentType());
                } else {
                    courseRecordInfo.put("actAbsentType", null);
                }
                row.getCell("absentCount").setValue((Object)courseRecordInfo.getActAbsent());
                row.getCell("absentHour").setValue((Object)courseRecordInfo.getActAbsentHour());
                if (courseRecordInfo.getActAbsHourUnit() != null) {
                    row.getCell("absentHourUnit").setValue((Object)courseRecordInfo.getActAbsHourUnit());
                    continue;
                }
                courseRecordInfo.put("actAbsHourUnit", null);
                continue;
            }
            if (courseRecordInfo.isAttendAll()) {
                row.getCell("isAttendAll").setValue((Object)Boolean.TRUE);
            } else {
                row.getCell("isAttendAll").setValue((Object)Boolean.FALSE);
            }
            row.getCell("trainDate").setValue((Object)courseRecordInfo.getString("trainDate"));
            row.getCell("actAttend").setValue((Object)courseRecordInfo.getActualAttend());
            if (courseRecordInfo.getAbsentType() != null) {
                row.getCell("absentType").setValue((Object)courseRecordInfo.getAbsentType());
            } else {
                courseRecordInfo.put("absentType", null);
            }
            row.getCell("absentCount").setValue((Object)courseRecordInfo.getAbsent());
            row.getCell("absentHour").setValue((Object)courseRecordInfo.getAbsentHour());
            if (courseRecordInfo.getAbsentHourUnit() != null) {
                row.getCell("absentHourUnit").setValue((Object)courseRecordInfo.getAbsentHourUnit());
                continue;
            }
            courseRecordInfo.put("absentHourUnit", null);
        }
        this.operateIsAttendAll();
    }

    private HashSet getPersonSet(HashMap record) {
        HashSet<String> set = new HashSet<String>();
        if (record == null || record.size() == 0) {
            return set;
        }
        for (Map.Entry entry : record.entrySet()) {
            TrainCourseRecordInfo courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
            set.add(courseRecordInfo.getEmployee().getId().toString());
        }
        return set;
    }

    private HashMap filterRecord(TrainCourseRecordCollection courseRecordCollection, boolean isActivity, boolean isLoadPerson) {
        this.canNotAuditSet.clear();
        TrainCourseRecordCollection col_new = new TrainCourseRecordCollection();
        TrainCourseRecordInfo info = null;
        if (courseRecordCollection == null || courseRecordCollection.size() == 0) {
            return new HashMap();
        }
        for (int i = 0; i < courseRecordCollection.size(); ++i) {
            info = courseRecordCollection.get(i);
            if (isActivity) {
                if (!info.getRecordExtends().isActIsApproved()) {
                    col_new.add(info);
                }
                if (!info.getRecordExtends().isActIsApproved()) continue;
                this.canNotAuditSet.add(info.getEmployee().getId().toString());
                continue;
            }
            if (!info.getRecordExtends().isIsApproved()) {
                col_new.add(info);
            }
            if (!info.getRecordExtends().isIsApproved()) continue;
            this.canNotAuditSet.add(info.getEmployee().getId().toString());
        }
        if (col_new == null || col_new.size() == 0) {
            return new HashMap();
        }
        HashMap<String, TrainCourseRecordInfo> fillMap = new HashMap<String, TrainCourseRecordInfo>();
        HashMap<String, TrainCourseRecordInfo> addMap = new HashMap<String, TrainCourseRecordInfo>();
        if (isActivity) {
            int n = col_new.size();
            for (int i = 0; i < n; ++i) {
                String key = col_new.get(i).getEmployee().getId().toString() + col_new.get(i).getTrainActivity().getId().toString();
                fillMap.put(key, col_new.get(i));
                if (this.recordMap.containsKey(key)) continue;
                this.recordMap.put(key, col_new.get(i));
                addMap.put(key, col_new.get(i));
            }
        } else if (this.promptTrainActivity.getValue() != null) {
            int n = col_new.size();
            for (int i = 0; i < n; ++i) {
                String key = col_new.get(i).getEmployee().getId().toString() + col_new.get(i).getTrainActivity().getId().toString() + col_new.get(i).getTrainCourse().getId().toString();
                fillMap.put(key, col_new.get(i));
                if (this.recordMap.containsKey(key)) continue;
                this.recordMap.put(key, col_new.get(i));
                addMap.put(key, col_new.get(i));
            }
        } else {
            StringBuffer sb = new StringBuffer();
            TrainCourseRecordInfo trainCourseRecordInfo = null;
            String trainDate = null;
            int n = col_new.size();
            for (int i = 0; i < n; ++i) {
                trainCourseRecordInfo = col_new.get(i);
                sb.delete(0, sb.length());
                sb.append(trainCourseRecordInfo.getEmployee().getId().toString());
                sb.append(trainCourseRecordInfo.getTrainCourse().getId().toString());
                trainDate = TrainClientUtil.assembleDate(trainCourseRecordInfo.getBeginDateTime(), trainCourseRecordInfo.getEndDateTime(), "yyyy-MM-dd HH:mm:ss");
                sb.append(trainDate);
                trainCourseRecordInfo.put("trainDate", trainDate);
                fillMap.put(sb.toString(), trainCourseRecordInfo);
                if (this.recordMap.containsKey(sb.toString())) continue;
                this.recordMap.put(sb.toString(), trainCourseRecordInfo);
                addMap.put(sb.toString(), trainCourseRecordInfo);
            }
        }
        if (isLoadPerson) {
            return fillMap;
        }
        return this.recordMap;
    }

    private TrainCourseRecordCollection getRecordCollection(FilterInfo filterInfo, SelectorItemCollection itemCollection) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        if (itemCollection != null && itemCollection.size() > 0) {
            int n = itemCollection.size();
            for (int i = 0; i < n; ++i) {
                viewInfo.getSelector().add(itemCollection.get(i));
            }
        }
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.isApproved"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.actIsApproved"));
        return TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(viewInfo);
    }

    private FilterInfo getFilterInfo() throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        if (this.promptTrainCourse.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)((TrainCourseInfo)this.promptTrainCourse.getValue()).getId().toString()));
        }
        if (this.promptTrainActivity.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
        } else if (this.promptTrainCourse.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", null));
        }
        if (filterInfo.getFilterItems().size() == 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)BOSUuid.create((BOSObjectType)new TrainCourseRecordInfo().getBOSType()).toString()));
        }
        filterInfo.getFilterItems().add(TrainCommonUtils.getAdminRangeFilterItemInfo(this.userID, "recordExtends.OrgStudent.id"));
        return filterInfo;
    }

    private void initEntryButton() {
        this.btnAddRuleNew = this.recordContainer.add((Action)((Object)this.actionAddPerson));
        this.btnAddRuleNew.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionAddPerson), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnDelRuleNew = this.recordContainer.add((Action)((Object)this.actionDelLine));
        this.btnDelRuleNew.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionDelLine), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnAddRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnAddRuleNew.setToolTipText(TrainClientUtil.getResource(this.RES, "addPerson"));
        this.btnAddRuleNew.setText(null);
        this.btnAddRuleNew.setSize(19, 19);
        this.btnDelRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnDelRuleNew.setToolTipText(TrainClientUtil.getResource(this.RES, "delPerson"));
        this.btnDelRuleNew.setText(null);
        this.btnDelRuleNew.setSize(19, 19);
    }

    protected void promptTrainActivity_dataChanged(DataChangeEvent e) throws Exception {
        super.promptTrainActivity_dataChanged(e);
        if (this.activityFlag) {
            this.activityFlag = false;
            return;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.operateYes();
            } else if (result == 2) {
                this.activityFlag = true;
                this.promptTrainActivity.setValue(e.getOldValue());
                SysUtil.abort();
            }
        }
        this.isActivity = e.getNewValue() != null ? this.promptTrainActivity.getValue() != null : false;
        if (this.promptTrainActivity.getValue() != null) {
            if (this.promptTrainCourse.getValue() != null) {
                this.courseFlag = true;
                this.promptTrainCourse.setValue(null);
            }
            TrainActivityHelper.initTrainCourseByActivity_END_AND_STAR(this.promptTrainCourse, ((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString());
            this.isActivity = true;
        } else {
            TrainActivityHelper.initTrainCourse(this.promptTrainCourse, false, (IUIObject)this);
            this.courseFlag = true;
            this.promptTrainCourse.setValue(null);
        }
        this.loadData();
        this.operateUIStatus();
        this.setAddAndEndPersonState();
        this.setEntryButton();
    }

    private void setAddAndEndPersonState() {
        if (this.promptTrainActivity.getValue() != null && this.promptTrainCourse.getValue() == null) {
            TrainActivityInfo info = (TrainActivityInfo)this.promptTrainActivity.getValue();
            if (!TrainActStateEnum.CLOSED.equals((Object)info.getTrainActState())) {
                this.btnAddRuleNew.setEnabled(false);
                this.btnDelRuleNew.setEnabled(false);
                this.clearTable();
            }
        } else {
            this.btnAddRuleNew.setEnabled(true);
            this.btnDelRuleNew.setEnabled(true);
        }
    }

    private void operateUIStatus() {
        if (this.promptTrainActivity.getValue() != null || this.promptTrainCourse.getValue() != null) {
            this.setButtonStatus(true);
        } else {
            this.setButtonStatus(false);
        }
    }

    private void setButtonStatus(boolean flag) {
        this.btnAddNew.setEnabled(flag);
        this.btnSave.setEnabled(flag);
        this.btnSelectedCopy.setEnabled(flag);
        if (this.btnAddRuleNew != null) {
            this.btnAddRuleNew.setEnabled(flag && this.promptTrainActivity.getValue() != null);
        }
        if (this.btnDelRuleNew != null) {
            this.btnDelRuleNew.setEnabled(flag);
        }
    }

    private void checkModifyed() throws Exception {
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.operateYes();
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    private void operateYes() {
        ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
        this.actionSave.actionPerformed(event);
        if (this.actionSave.isInvokeFailed()) {
            SysUtil.abort();
        }
    }

    protected void promptTrainCourse_dataChanged(DataChangeEvent e) throws Exception {
        super.promptTrainCourse_dataChanged(e);
        if (this.courseFlag) {
            this.courseFlag = false;
            return;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.operateYes();
            } else if (result == 2) {
                this.courseFlag = true;
                this.promptTrainCourse.setValue(e.getOldValue());
                SysUtil.abort();
            }
        }
        this.isActivity = e.getNewValue() == null;
        this.loadData();
        this.operateUIStatus();
        this.setAddAndEndPersonState();
        this.setEntryButton();
    }

    protected boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.actionSave.setDaemonRun(false);
                ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                this.actionSave.actionPerformed(event);
                return !this.actionSave.isInvokeFailed();
            }
            return result == 1;
        }
        return true;
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.checkModifyed();
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkModifyed();
        super.actionAddNew_actionPerformed(e);
        this.activityFlag = true;
        this.courseFlag = true;
        this.clearTable();
        this.recordMap = new HashMap();
        this.promptTrainActivity.setValue(null);
        this.promptTrainCourse.setValue(null);
        this.txtShouldAttend.setValue((Object)0);
        this.txtAttendAll.setValue(null);
        this.operateUIStatus();
    }

    public void actionSelectedCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectedCopy_actionPerformed(e);
        IRow row2 = TrainClientUtil.getSelectedRow(this.recordTable);
        if (row2 == null) {
            return;
        }
        KDTSelectBlock sb = null;
        int size = this.recordTable.getSelectManager().size();
        if (size > 0) {
            sb = this.recordTable.getSelectManager().get(0);
            int column = sb.getLeft();
            if (column != this.recordTable.getColumn("isAttendAll").getColumnIndex() && column != this.recordTable.getColumn("actAttend").getColumnIndex() && column != this.recordTable.getColumn("absentType").getColumnIndex() && column != this.recordTable.getColumn("absentCount").getColumnIndex() && column != this.recordTable.getColumn("absentHour").getColumnIndex() && column != this.recordTable.getColumn("absentHourUnit").getColumnIndex()) {
                return;
            }
            TrainUtils.selectedCopy(this.recordTable);
        }
        this.operateIsAttendAll();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.checkValidate();
        this.storeFields();
        if (this.currentMap == null || this.currentMap.size() == 0) {
            TrainClientUtil.showErrorMessage(this.RES, "recordNotNull", this);
        }
        IObjectPK[] pks = TrainCourseRecordFactory.getRemoteInstance().submitRecordBatch(this.currentMap, this.isActivity, "attendence");
        TrainClientUtil.showMessage(this.RES, "batchSaveSuccess", this);
        TrainCourseRecordCollection courseRecordCollection = this.getRecordCollection(pks);
        this.recordMap = new HashMap();
        this.filterRecord(courseRecordCollection, this.isActivity, false);
        this.operateIsAttendAll();
        this.operateUIStatus();
        FilterInfo filterInfo = this.getFilterInfo();
        TrainCourseRecordCollection col = this.getRecordCollection(filterInfo, null);
        this.countAttend_tmp(col);
    }

    private void checkValidate() {
        BigDecimal value = this.getMaxActualAttend();
        if (this.txtShouldAttend.getBigDecimalValue().compareTo(value) == -1) {
            this.txtShouldAttend.requestFocus();
            TrainClientUtil.showErrorMessage(this.RES, "actualAttendNotMoreShouldAttend", this);
        }
    }

    private TrainCourseRecordCollection getRecordCollection(IObjectPK[] pks) throws Exception {
        if (pks == null || pks.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            set.add(pks[i].toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        return this.getRecordCollection(filterInfo, null);
    }

    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        KDCommonPromptDialog dlg = new KDCommonPromptDialog();
        MetaDataPK pk = this.isActivity ? new MetaDataPK("com.kingdee.eas.hr.train.app", this.getActivityRecordQuery()) : new MetaDataPK("com.kingdee.eas.hr.train.app", this.getCourseRecordQuery());
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)pk);
        dlg.setQueryInfo(queryInfo);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (this.isActivity && this.promptTrainActivity.getValue() != null) {
            Set personIDSet = this.getPersonID();
            if (personIDSet == null || personIDSet.size() == 0) {
                TrainClientUtil.showMessage(this.RES, "noExistEmployeeForAct", this);
                SysUtil.abort();
            }
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)personIDSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString(), CompareType.INCLUDE));
        } else {
            Set recordID = this.getTrainCourseRecordID();
            if (recordID == null || recordID.size() == 0) {
                TrainClientUtil.showMessage(this.RES, "noExistEmployeeForCourse", this);
                SysUtil.abort();
            }
            fi.getFilterItems().add(new FilterItemInfo("trainCourseRecord.id", (Object)recordID, CompareType.INCLUDE));
        }
        evi.setFilter(fi);
        dlg.setEntityViewInfo(evi);
        dlg.setEnabledMultiSelection(true);
        dlg.show();
        if (dlg.isCanceled()) {
            return;
        }
        Object[] obj = (Object[])dlg.getData();
        this.dealAddPerson(obj);
    }

    private void dealAddPerson(Object[] obj) throws Exception {
        if (obj == null || obj.length == 0) {
            return;
        }
        HashMap<String, Object> ids = new HashMap<String, Object>();
        int n = obj.length;
        for (int i = 0; i < n; ++i) {
            if (this.canNotAuditSet.contains(((PersonInfo)obj[i]).getId().toString())) continue;
            ids.put(((PersonInfo)obj[i]).getId().toString(), obj[i]);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", new HashSet(ids.keySet()), CompareType.INCLUDE));
        filterInfo.mergeFilter(this.getFilterInfo(), "AND");
        TrainCourseRecordCollection courseRecordCollection = this.getRecordCollection(filterInfo, null);
        HashMap filterMap = this.filterRecord(courseRecordCollection, this.isActivity, true);
        HashSet personSet = this.getPersonSet(filterMap);
        HashMap personMap = TrainUtils.getPersonProperty(personSet);
        this.putDataToTable(filterMap, personMap);
        this.operateIsAttendAll();
    }

    private void handleDefaultValue(TrainCourseRecordInfo info) {
        if (info.getActBeginDate() == null) {
            info.setActBeginDate(this.backRecordInfo.getActBeginDate());
        }
        if (info.getActEndDate() == null) {
            info.setActEndDate(this.backRecordInfo.getActEndDate());
        }
        if (info.getBeginDateTime() == null) {
            info.setBeginDateTime(this.backRecordInfo.getBeginDateTime());
        }
        if (info.getEndDateTime() == null) {
            info.setEndDateTime(this.backRecordInfo.getEndDateTime());
        }
        if (info.getActTrainType() == null) {
            info.setActTrainType(TrainTypeEnum.INNERTRAINTYPE);
        }
        if (info.getTrainType() == null) {
            info.setTrainType(TrainTypeEnum.INNERTRAINTYPE);
        }
        if (info.getActIsPassed() == null) {
            info.setActIsPassed(TrainRecordIsPassedEnum.PASSED);
        }
        if (info.getIsPassed() == null) {
            info.setIsPassed(TrainRecordIsPassedEnum.PASSED);
        }
    }

    private HashSet getPersonIds(TrainCourseRecordCollection courseRecordCollection) {
        HashSet<String> set = new HashSet<String>();
        if (courseRecordCollection == null || courseRecordCollection.size() == 0) {
            return set;
        }
        int n = courseRecordCollection.size();
        for (int i = 0; i < n; ++i) {
            set.add(courseRecordCollection.get(i).getEmployee().getId().toString());
        }
        return set;
    }

    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        TrainActivityHelper.deleteRows(this.recordTable);
    }

    private void operateIsAttendAll() {
        this.recordTable.checkParsed();
        int n = this.recordTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.recordTable.getRow(i);
            this.operateRowAttendAll(row);
        }
    }

    private void operateRowAttendAll(IRow row) {
        BigDecimal bigDecimalValue = this.txtShouldAttend.getBigDecimalValue();
        if (((Boolean)row.getCell("isAttendAll").getValue()).booleanValue()) {
            if (bigDecimalValue != null) {
                row.getCell("actAttend").setValue((Object)bigDecimalValue);
            } else {
                row.getCell("actAttend").setValue((Object)new BigDecimal("0.00"));
            }
            row.getCell("actAttend").getStyleAttributes().setLocked(true);
            row.getCell("absentType").setValue(null);
            row.getCell("absentType").getStyleAttributes().setLocked(true);
            row.getCell("absentCount").setValue(null);
            row.getCell("absentCount").getStyleAttributes().setLocked(true);
            row.getCell("absentHour").setValue(null);
            row.getCell("absentHour").getStyleAttributes().setLocked(true);
            row.getCell("absentHourUnit").setValue(null);
            row.getCell("absentHourUnit").getStyleAttributes().setLocked(true);
        } else {
            row.getCell("actAttend").getStyleAttributes().setLocked(false);
            Integer shouldAttend = (Integer)this.txtShouldAttend.getNumberValue();
            if (shouldAttend != null && shouldAttend >= 0 && row.getCell("actAttend").getValue() != null) {
                row.getCell("absentCount").setValue((Object)bigDecimalValue.subtract((BigDecimal)row.getCell("actAttend").getValue()));
            }
            row.getCell("absentType").getStyleAttributes().setLocked(false);
            row.getCell("absentHour").getStyleAttributes().setLocked(false);
            row.getCell("absentHourUnit").getStyleAttributes().setLocked(false);
        }
    }

    private void countAttend() {
        this.recordTable.checkParsed();
        if (this.recordTable.getRowCount() == 0) {
            this.txtAttendAll.setValue(null);
            return;
        }
        int count = 0;
        int n = this.recordTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.recordTable.getRow(i);
            if (!((Boolean)row.getCell("isAttendAll").getValue()).booleanValue()) continue;
            ++count;
        }
        BigDecimal percent = new BigDecimal("" + count).setScale(6).divide(new BigDecimal("" + this.recordTable.getRowCount()).setScale(6), 0);
        this.txtAttendAll.setValue((Object)percent.multiply(new BigDecimal("100")));
    }

    protected void recordTable_editStopped(KDTEditEvent e) throws Exception {
        if (e.getRowIndex() >= 0) {
            if (e.getColIndex() == this.recordTable.getColumnIndex("isAttendAll")) {
                this.operateRowAttendAll(this.recordTable.getRow(e.getRowIndex()));
            } else if (e.getColIndex() == this.recordTable.getColumnIndex("actAttend")) {
                if (this.recordTable.getCell(e.getRowIndex(), e.getColIndex()).getValue() == null) {
                    this.recordTable.getRow(e.getRowIndex()).getCell("absentCount").setValue(null);
                    return;
                }
                BigDecimal value = this.txtShouldAttend.getBigDecimalValue().subtract((BigDecimal)this.recordTable.getCell(e.getRowIndex(), e.getColIndex()).getValue());
                this.recordTable.getRow(e.getRowIndex()).getCell("absentCount").setValue((Object)value);
            }
        }
    }

    protected void txtShouldAttend_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal value = this.getMaxActualAttend();
        if (new BigDecimal(e.getNewValue().toString()).compareTo(value) == -1) {
            this.txtShouldAttend.requestFocus();
            TrainClientUtil.showErrorMessage(this.RES, "actualAttendNotMoreShouldAttend", this);
        } else {
            this.operateIsAttendAll();
        }
    }

    private BigDecimal getMaxActualAttend() {
        this.recordTable.checkParsed();
        BigDecimal value = new BigDecimal("0.00");
        BigDecimal temp = null;
        int n = this.recordTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.recordTable.getRow(i);
            temp = row.getCell("actAttend").getValue() != null && row.getCell("isAttendAll").getValue() != null && (Boolean)row.getCell("isAttendAll").getValue() == false ? (BigDecimal)row.getCell("actAttend").getValue() : new BigDecimal("0.00");
            if (temp.compareTo(value) != 1) continue;
            value = temp;
        }
        return value;
    }

    private Set getTableID(KDTable recordTable) {
        HashSet<String> idSet = new HashSet<String>();
        if (this.recordTable.getRowCount() > 0) {
            for (int i = 0; i < this.recordTable.getRowCount(); ++i) {
                IRow row = this.recordTable.getRow(i);
                if (this.promptTrainActivity.getValue() != null && this.promptTrainCourse.getValue() == null) {
                    idSet.add(row.getCell("person.id").getValue().toString());
                    continue;
                }
                idSet.add(row.getCell("id").getValue().toString());
            }
        }
        return idSet;
    }

    private String getActivityRecordQuery() {
        return "TrainActivityRecordForBatchQuery";
    }

    private String getCourseRecordQuery() {
        return "TrainCourseRecordForBatchQuery";
    }

    private Set getTrainCourseRecordID() throws Exception {
        HashSet<String> recordIDSet = new HashSet<String>();
        FilterInfo filterInfo = this.getFilterInfo();
        TrainCourseRecordCollection col = TrainActivityHelper.getRecordCollection(filterInfo, null);
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                TrainCourseRecordInfo info = col.get(i);
                recordIDSet.add(info.getId().toString());
            }
        }
        return recordIDSet;
    }

    private Set getPersonID() throws Exception {
        Set personIdSet = null;
        personIdSet = TrainActivityHelper.getPersonIdSet(this.promptTrainActivity, this.promptTrainCourse);
        return personIdSet;
    }

    private void setEntryButton() {
        if (this.promptTrainActivity.getValue() == null && this.promptTrainCourse.getValue() == null) {
            this.btnAddRuleNew.setEnabled(false);
            this.btnDelRuleNew.setEnabled(false);
        }
    }

    private void countAttend_tmp(TrainCourseRecordCollection courseRecordCollection) {
        if (courseRecordCollection == null || courseRecordCollection.size() == 0) {
            this.txtAttendAll.setValue(null);
            return;
        }
        boolean isAct = false;
        HashSet<String> empSet = new HashSet<String>();
        if (this.promptTrainActivity.getValue() != null && this.promptTrainCourse.getValue() == null) {
            isAct = true;
        }
        int count = 0;
        int recordSize = 0;
        for (int i = 0; i < courseRecordCollection.size(); ++i) {
            TrainCourseRecordInfo info = courseRecordCollection.get(i);
            if (isAct) {
                if (empSet.contains(info.getEmployee().getId().toString())) continue;
                empSet.add(info.getEmployee().getId().toString());
                if (info.isActAttendAll()) {
                    ++count;
                }
            } else if (info.isAttendAll()) {
                ++count;
            }
            ++recordSize;
        }
        BigDecimal percent = new BigDecimal("" + count).setScale(6).divide(new BigDecimal("" + recordSize).setScale(6), 0);
        this.txtAttendAll.setValue((Object)percent.multiply(new BigDecimal("100")));
    }
}

