/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.train.ITrainChanne;
import com.kingdee.eas.hr.train.TrainChanneCategoryEnum;
import com.kingdee.eas.hr.train.TrainChanneCategoryFactory;
import com.kingdee.eas.hr.train.TrainChanneCategoryInfo;
import com.kingdee.eas.hr.train.TrainChanneFactory;
import com.kingdee.eas.hr.train.TrainChanneInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainChanneListUI;
import com.kingdee.eas.hr.train.client.TrainChanneCategoryEditUI;
import com.kingdee.eas.hr.train.client.TrainChanneEditUI;
import com.kingdee.eas.hr.train.client.TrainChannelListFilterUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class TrainChanneListUI
extends AbstractTrainChanneListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainChanneListUI.class);
    static String RES = "com.kingdee.eas.hr.train.client.TrainChanneResource";
    private boolean startOnLoad = false;
    private String currentHRId = null;
    private Boolean defaultFilterFlag = null;

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        IRow row = null;
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            row = this.tblMain.getRow(rowIndex);
        }
        if (row != null && row.getCell("id").getValue() != null) {
            String id = row.getCell("id").getValue().toString();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)id));
            fi.getFilterItems().add(new FilterItemInfo("IsEnabled", (Object)Boolean.FALSE));
            if (TrainChanneFactory.getRemoteInstance().exists(fi)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource", (String)"can_not_modify_enabled_data"));
                SysUtil.abort();
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int[] rowNumber = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        HashSet<String> ids = new HashSet<String>();
        int j = rowNumber.length;
        for (int i = 0; i < j; ++i) {
            IRow row = this.tblMain.getRow(rowNumber[i]);
            if (row == null || row.getCell("id").getValue() == null) continue;
            ids.add(row.getCell("id").getValue().toString());
        }
        if (ids.size() > 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("IsEnabled", (Object)false));
            if (TrainChanneFactory.getRemoteInstance().exists(fi)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource", (String)"can_not_modify_enabled_data"));
                SysUtil.abort();
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    private boolean canRemove() {
        int[] rowNumber = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        boolean canRemove = true;
        int j = rowNumber.length;
        for (int i = 0; i < j; ++i) {
            Boolean flag;
            IRow row = this.tblMain.getRow(rowNumber[i]);
            if (row == null || (flag = (Boolean)row.getCell("IsEnabled").getValue()) == null || !flag.booleanValue()) continue;
            canRemove = false;
            break;
        }
        return canRemove;
    }

    protected String getEditUIName() {
        return TrainChanneEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainChanneFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainChanneInfo objectValue = new TrainChanneInfo();
        return objectValue;
    }

    public void onLoad() throws Exception {
        this.menuItemGroupAddNew.setAccelerator(KeyStroke.getKeyStroke("ctrl alt N"));
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        this.startOnLoad = true;
        this.currentHRId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        this.menuBiz.setVisible(true);
        this.menuItemCancelCancel.setVisible(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                TrainChanneListUI.this.initButtonState(e);
                TrainChanneListUI.this.initButtonStateByIsShare();
            }
        });
    }

    private void initButtonState(KDTSelectEvent e) {
        String select = this.getSelectedIsEnable();
        if ("true".equals(select)) {
            this.btnCancelCancel.setEnabled(false);
            this.btnCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(true);
            this.actionEdit.setEnabled(false);
        }
        if ("false".equals(select)) {
            this.btnCancelCancel.setEnabled(true);
            this.btnCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(false);
            this.actionEdit.setEnabled(true);
        }
        if (this.canRemove()) {
            this.actionRemove.setEnabled(true);
        } else {
            this.actionRemove.setEnabled(false);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        Set ids = TrainUtils.getHRByParamNumber("hr_train_005");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        return filterInfo;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEnabled.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuDisEnable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnSetEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuSetEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
    }

    public void actionEnabled_actionPerformed(ActionEvent e) throws Exception {
        super.actionEnabled_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (((ITrainChanne)this.getBizInterface()).setDisnable(id)) {
            this.tblMain.removeRows();
        }
    }

    public void actionSetEnable_actionPerformed(ActionEvent e) throws Exception {
        super.actionSetEnable_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (((ITrainChanne)this.getBizInterface()).setEnable(id)) {
            this.tblMain.removeRows();
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            boolean isEnabled = false;
            while (rowSet.next()) {
                isEnabled = rowSet.getBoolean("IsEnabled");
                if (isEnabled) {
                    rowSet.updateString("IsEnabled", "0");
                    continue;
                }
                rowSet.updateString("IsEnabled", "1");
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    private boolean checkCanModify() throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.tblMain.getRow(this.tblMain.getSelectManager().get().getTop()).getCell("id").getValue().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("IsEnabled", (Object)1));
        return !TrainChanneFactory.getRemoteInstance().exists(filterInfo);
    }

    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.tblMain_activeCellChanged(e);
    }

    protected String getSelectedIsEnable() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("IsEnabled");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    public KDPanel getFilterUI() {
        try {
            return new TrainChannelListFilterUI();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.addUserPanel(this.getFilterUI());
        return queryDlg;
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    public IUIActionPostman prepareInit() {
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), (ListUI)this, this.mainQueryPK);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (this.confirmDialog(cancelMsg)) {
            String id = this.getSelectedKeyValue();
            if (((ITrainChanne)this.getBizInterface()).setDisnable(id)) {
                this.tblMain.removeRows();
            }
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg) && ((ITrainChanne)this.getBizInterface()).setEnable(id)) {
            this.tblMain.removeRows();
        }
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected String getGroupEditUIName() {
        return TrainChanneCategoryEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "channeCategory.id";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return TrainChanneCategoryFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo fi = TrainUtils.getCurrentHRFilter("hrOrgUnit.id");
        fi.getFilterItems().add(new FilterItemInfo("property", (Object)10));
        Set ids = TrainUtils.getHRByParamNumber("hr_train_005");
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        fi.setMaskString("#0 or #1 or #2");
        return fi;
    }

    protected String getRootName() {
        return EASResource.getString((String)RES, (String)"TREE_TITLE");
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode node = this.getSelectedTreeNode();
        if (node != null && this.tblMain.getRowCount() > 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"ChanneCategoryByCitation"));
            SysUtil.abort();
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode node = (KDTreeNode)this.treeMain.getSelectionPath().getLastPathComponent();
        if (node.getUserObject() == null || !(node.getUserObject() instanceof TrainChanneCategoryInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"RootNotAdd"));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        super.actionRefresh_actionPerformed(e);
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        super.treeMain_valueChanged(e);
        if (this.treeMain.getSelectionPath() == null) {
            return;
        }
        KDTreeNode node = (KDTreeNode)this.treeMain.getSelectionPath().getLastPathComponent();
        if (node.getUserObject() != null && node.getUserObject() instanceof TrainChanneCategoryInfo) {
            TrainChanneCategoryInfo category = (TrainChanneCategoryInfo)node.getUserObject();
            if (category.getHrOrgUnit() != null && !this.currentHRId.equals(category.getHrOrgUnit().getId().toString())) {
                this.actionAddNew.setEnabled(false);
                this.actionGroupRemove.setEnabled(false);
                this.actionGroupAddNew.setEnabled(false);
                this.actionGroupEdit.setEnabled(false);
            } else {
                this.actionAddNew.setEnabled(true);
                this.actionGroupRemove.setEnabled(true);
                this.actionGroupAddNew.setEnabled(true);
                this.actionGroupEdit.setEnabled(true);
            }
        } else {
            this.actionAddNew.setEnabled(true);
            this.actionGroupRemove.setEnabled(true);
            this.actionGroupAddNew.setEnabled(true);
            this.actionGroupEdit.setEnabled(true);
        }
    }

    protected SelectorItemCollection getSelectorForTree() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("property"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("displayName"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        return sic;
    }

    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        TrainChanneCategoryInfo categoryInfo;
        KDTreeNode node = (KDTreeNode)this.treeMain.getSelectionPath().getLastPathComponent();
        if (!(node.getUserObject() instanceof TrainChanneCategoryInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Root_CannotSelected"));
            SysUtil.abort();
        }
        if ((categoryInfo = (TrainChanneCategoryInfo)node.getUserObject()) != null && (categoryInfo.getProperty() == null || categoryInfo.getProperty().equals((Object)TrainChanneCategoryEnum.INNER))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"ChanneCategoryNotEdit"));
            return;
        }
        super.actionGroupEdit_actionPerformed(e);
    }

    private void initButtonStateByIsShare() {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String hrID = null;
        boolean isShare = false;
        if (rows != null && rows.length > 0 && rows[0] >= 0) {
            int len = rows.length;
            for (int i = 0; i < len; ++i) {
                hrID = this.tblMain.getRow(rows[i]).getCell("hrOrgUnit.id").getValue().toString();
                if (this.currentHRId.equals(hrID)) continue;
                isShare = true;
                break;
            }
        }
        if (isShare) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }
}

