/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.train.TrainActCourseCollection;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainActStateEnum;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordCollection;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainCostBatchMgrUI;
import com.kingdee.eas.hr.train.client.LocateAssistant;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TrainCostBatchMgrUI
extends AbstractTrainCostBatchMgrUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainCostBatchMgrUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainRecordResource";
    private static final String TRAINCOURSERECORD = "trainCourseRecord";
    private static final String TRAINCOST = "trainCost";
    private String recordContainerTitle;
    private TrainCourseRecordCollection historyRecords;
    private LocateAssistant locateAssistant;
    private JButton btnAddPerson;
    private JButton btnDeletePerson;
    private Set canNotAuditSet = new HashSet();
    private String userID = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.promptTrainCourse.setRequired(false);
        TrainActivityHelper.initTrainActivity_By_End_Star(this.promptTrainActivity, TrainActivityHelper.getActSelectors());
        TrainActivityHelper.initTrainCourse(this.promptTrainCourse, false, (IUIObject)this);
        this.recordTable.checkParsed();
        TrainClientUtil.setDisableColor(this.recordTable);
        this.recordTable.checkParsed();
        KDFormattedTextField formattedTextField = TrainUtils.setTableCellEditorByFormattedTextField(this.recordTable, TRAINCOST, TrainClientUtil.PRECISION);
        formattedTextField.setMaximumValue((Comparable)TrainClientUtil.maxPrecision);
        this.initButtonIcon();
        this.setRecordContainerTitle();
        TrainUtils.setKDTableSortable(this.recordTable);
        this.recordTable.getViewManager().setFreezeView(0, this.recordTable.getColumnIndex("name") + 1);
        this.userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
    }

    private void setRecordContainerTitle() {
        this.recordContainerTitle = this.recordContainer.getTitle();
        this.recordContainer.setTitle(this.recordContainerTitle + "0.00");
    }

    private void initButtonIcon() {
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnColumnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.btnSelectedCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btnColumnCopy.setEnabled(true);
        this.btnSelectedCopy.setEnabled(true);
        this.btnAddPerson = this.recordContainer.add((Action)((Object)this.actionAddPerson));
        this.btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnAddPerson.setToolTipText(TrainClientUtil.getResource(RESOURCE, "addPerson"));
        this.btnDeletePerson = this.recordContainer.add((Action)((Object)this.actionDelLine));
        this.btnDeletePerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnDeletePerson.setToolTipText(TrainClientUtil.getResource(RESOURCE, "delPerson"));
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.actionLocate.setEnabled(true);
    }

    public void actionColumnCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.recordTable.getRowCount() == 0) {
            return;
        }
        int size = this.recordTable.getSelectManager().size();
        if (size > 0) {
            KDTSelectBlock sb = this.recordTable.getSelectManager().get(0);
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.recordTable.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.recordTable.getCell(row, column).getValue();
            int length = this.recordTable.getRowCount();
            for (int i = 0; i < length; ++i) {
                if (i == row) continue;
                this.recordTable.getCell(i, column).setValue(value);
            }
        }
    }

    public void actionSelectedCopy_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.selectedCopy(this.recordTable);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.recordTable, TRAINCOST);
        if (this.promptTrainCourse.getValue() != null) {
            HashMap currentCourseRecords = this.getCurrentRecords(false);
            this.removeNoModifiedRecord(currentCourseRecords, false);
            TrainCourseRecordFactory.getRemoteInstance().submitRecordBatch(currentCourseRecords, false, null);
            TrainClientUtil.showMessage(RESOURCE, "batchSaveSuccess", this);
            this.updateTableData(currentCourseRecords, false);
        } else {
            HashMap currentCourseRecords = this.getCurrentRecords(true);
            this.removeNoModifiedRecord(currentCourseRecords, true);
            TrainCourseRecordFactory.getRemoteInstance().submitRecordBatch(currentCourseRecords, true, null);
            TrainClientUtil.showMessage(RESOURCE, "batchSaveSuccess", this);
            this.updateTableData(currentCourseRecords, true);
        }
        this.updateCourseCost();
        this.setButtonState();
    }

    private void updateTableData(HashMap currentCourseRecords, boolean isActivity) {
        TrainCourseRecordInfo info_source = null;
        TrainCourseRecordInfo info_target = null;
        int size = this.historyRecords.size();
        for (int i = 0; i < size; ++i) {
            info_source = this.historyRecords.get(i);
            if (!currentCourseRecords.containsKey(info_source.getId().toString())) continue;
            info_target = (TrainCourseRecordInfo)currentCourseRecords.get(info_source.getId().toString());
            if (isActivity) {
                if (info_source.getActCost() == null && info_target.getActCost() == null) continue;
                if (info_source.getActCost() == null || info_target.getActCost() == null) {
                    info_source.setActCost(info_target.getActCost());
                }
                if (info_source.getActCost().compareTo(info_target.getActCost()) == 0) continue;
                info_source.setActCost(info_target.getActCost());
                continue;
            }
            if (info_source.getCourseCost() == null && info_target.getCourseCost() == null) continue;
            if (info_source.getCourseCost() == null || info_target.getCourseCost() == null) {
                info_source.setCourseCost(info_target.getCourseCost());
            }
            if (info_source.getCourseCost().compareTo(info_target.getCourseCost()) == 0) continue;
            info_source.setCourseCost(info_target.getCourseCost());
        }
    }

    private HashMap getCurrentRecords(boolean isActivity) {
        HashMap<String, TrainCourseRecordInfo> currentRecords = null;
        if (this.recordTable.getRowCount() > 0) {
            currentRecords = new HashMap<String, TrainCourseRecordInfo>();
            TrainCourseRecordInfo courseRecordInfo = null;
            IRow row = null;
            int count = this.recordTable.getRowCount();
            for (int i = 0; i < count; ++i) {
                row = this.recordTable.getRow(i);
                courseRecordInfo = (TrainCourseRecordInfo)row.getCell(TRAINCOURSERECORD).getValue();
                if (courseRecordInfo == null) continue;
                if (isActivity) {
                    courseRecordInfo.setActCost((BigDecimal)row.getCell(TRAINCOST).getValue());
                } else {
                    courseRecordInfo.setCourseCost((BigDecimal)row.getCell(TRAINCOST).getValue());
                }
                currentRecords.put(courseRecordInfo.getId().toString(), courseRecordInfo);
            }
        }
        return currentRecords;
    }

    private void removeNoModifiedRecord(HashMap currentCourseRecords, boolean isActivity) {
        TrainCourseRecordInfo info_source = null;
        TrainCourseRecordInfo info_target = null;
        int size = this.historyRecords.size();
        for (int i = 0; i < size; ++i) {
            info_source = this.historyRecords.get(i);
            if (!currentCourseRecords.containsKey(info_source.getId().toString())) continue;
            info_target = (TrainCourseRecordInfo)currentCourseRecords.get(info_source.getId().toString());
            if (isActivity) {
                if (info_source.getActCost() == null || info_target.getActCost() == null) {
                    if (info_source.getActCost() != null || info_target.getActCost() != null) continue;
                    currentCourseRecords.remove(info_target.getId().toString());
                    continue;
                }
                if (info_source.getActCost().compareTo(info_target.getActCost()) != 0) continue;
                currentCourseRecords.remove(info_target.getId().toString());
                continue;
            }
            if (info_source.getCourseCost() == null || info_target.getCourseCost() == null) {
                if (info_source.getCourseCost() != null || info_target.getCourseCost() != null) continue;
                currentCourseRecords.remove(info_target.getId().toString());
                continue;
            }
            if (info_source.getCourseCost().compareTo(info_target.getCourseCost()) != 0) continue;
            currentCourseRecords.remove(info_target.getId().toString());
        }
    }

    protected void promptTrainActivity_dataChanged(DataChangeEvent e) throws Exception {
        super.promptTrainActivity_dataChanged(e);
        if (this.promptTrainActivity.getValue() != null) {
            this.promptTrainCourse.setValue(null);
            TrainActivityHelper.initTrainCourseByActivity_END_AND_STAR(this.promptTrainCourse, ((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString());
        } else {
            TrainActivityHelper.initTrainCourse(this.promptTrainCourse, false, (IUIObject)this);
        }
        this.loadData();
        this.setButtonState();
        this.setAddAndEndPersonState();
    }

    protected void promptTrainCourse_dataChanged(DataChangeEvent e) throws Exception {
        super.promptTrainCourse_dataChanged(e);
        this.checkModify(null);
        BigDecimal courseCost = null;
        if (this.promptTrainCourse.getValue() != null) {
            TrainCourseInfo trainCourseInfo = (TrainCourseInfo)this.promptTrainCourse.getValue();
            courseCost = trainCourseInfo.getCourseCost();
        }
        this.txtCourseCost.setValue(courseCost);
        this.loadData();
        this.setButtonState();
    }

    private void loadData() throws Exception {
        this.recordTable.removeRows();
        this.canNotAuditSet.clear();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(this.getFilterInfo());
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.actIsApproved"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.isApproved"));
        TrainCourseRecordCollection collection = TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(viewInfo);
        this.updateRecordContainerTitle_tmp(collection);
        this.historyRecords = (TrainCourseRecordCollection)((Object)collection.clone());
        HashSet personIds = this.assemblePersonsByCourseRecord(collection);
        TrainCourseRecordCollection col_new = new TrainCourseRecordCollection();
        TrainCourseRecordInfo info = null;
        if (collection.size() == 0) {
            return;
        }
        for (int i = 0; i < collection.size(); ++i) {
            info = collection.get(i);
            if (!info.getRecordExtends().isIsApproved()) {
                col_new.add(info);
            }
            if (!info.getRecordExtends().isIsApproved()) continue;
            this.canNotAuditSet.add(info.getEmployee().getId().toString());
        }
        this.putDataToTable(col_new, TrainUtils.getPersonProperty(personIds));
    }

    private HashSet assemblePersonsByCourseRecord(TrainCourseRecordCollection courseRecords) {
        HashSet<String> persons = null;
        if (courseRecords != null && courseRecords.size() > 0) {
            persons = new HashSet<String>();
            int size = courseRecords.size();
            for (int i = 0; i < size; ++i) {
                TrainCourseRecordInfo info = courseRecords.get(i);
                persons.add(info.getEmployee().getId().toString());
            }
        }
        return persons;
    }

    private void putDataToTable(TrainCourseRecordCollection courseRecords, HashMap personInfos) {
        if (courseRecords == null || courseRecords.size() == 0) {
            return;
        }
        IRow row = null;
        HashMap personPropertys = null;
        TrainCourseRecordInfo courseRecordInfo = null;
        String trainDate = null;
        int size = courseRecords.size();
        for (int i = 0; i < size; ++i) {
            row = this.recordTable.addRow();
            courseRecordInfo = courseRecords.get(i);
            row.getCell(TRAINCOURSERECORD).setValue((Object)courseRecordInfo);
            if (this.promptTrainCourse.getValue() == null) {
                row.getCell(TRAINCOST).setValue((Object)courseRecordInfo.getActCost());
            } else {
                row.getCell(TRAINCOST).setValue((Object)courseRecordInfo.getCourseCost());
            }
            trainDate = TrainClientUtil.assembleDate(courseRecordInfo.getBeginDateTime(), courseRecordInfo.getEndDateTime(), "yyyy-MM-dd HH:mm:ss");
            row.getCell("trainDate").setValue((Object)trainDate);
            if (courseRecordInfo.getId() != null) {
                row.getCell("id").setValue((Object)courseRecordInfo.getId().toString());
            }
            if (courseRecordInfo.getEmployee().getId() == null) continue;
            personPropertys = (HashMap)personInfos.get(courseRecordInfo.getEmployee().getId().toString());
            if (personPropertys != null) {
                row.getCell("name").setValue(personPropertys.get("name"));
                row.getCell("number").setValue(personPropertys.get("number"));
                if (courseRecordInfo.getRecordExtends() != null) {
                    if (courseRecordInfo.getRecordExtends().getOrgStudent() != null && courseRecordInfo.getRecordExtends().getOrgStudent().getName() != null) {
                        row.getCell("orgUnit").setValue((Object)courseRecordInfo.getRecordExtends().getOrgStudent().getName());
                    } else {
                        row.getCell("orgUnit").setValue(personPropertys.get("orgUnit"));
                    }
                    if (courseRecordInfo.getRecordExtends().getPosiStudent() != null && courseRecordInfo.getRecordExtends().getPosiStudent().getName() != null) {
                        row.getCell("position").setValue((Object)courseRecordInfo.getRecordExtends().getPosiStudent().getName());
                    } else {
                        row.getCell("position").setValue(personPropertys.get("position"));
                    }
                } else {
                    row.getCell("orgUnit").setValue(personPropertys.get("orgUnit"));
                    row.getCell("position").setValue(personPropertys.get("position"));
                }
                row.getCell("jobGrade").setValue(personPropertys.get("jobGrade"));
                continue;
            }
            this.recordTable.removeRow(this.recordTable.getRowCount() - 1);
        }
    }

    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        KDCommonPromptDialog dlg = new KDCommonPromptDialog();
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.train.app", this.getCourseRecordQuery());
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)pk);
        dlg.setQueryInfo(queryInfo);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        Set recordID = this.getTrainCourseRecordID();
        if (recordID == null || recordID.size() == 0) {
            TrainClientUtil.showMessage(RESOURCE, "noExistEmployeeForCourse", this);
            SysUtil.abort();
        }
        fi.getFilterItems().add(new FilterItemInfo("trainCourseRecord.id", (Object)this.getTrainCourseRecordID(), CompareType.INCLUDE));
        evi.setFilter(fi);
        dlg.setEntityViewInfo(evi);
        dlg.setEnabledMultiSelection(true);
        dlg.show();
        if (dlg.isCanceled()) {
            return;
        }
        Object[] obj = (Object[])dlg.getData();
        this.dealAddPerson(obj);
    }

    private void dealAddPerson(Object[] objs) throws Exception {
        if (objs == null || objs.length == 0) {
            return;
        }
        Set currentEmployeeIds = this.assembleCurrentEmployeeIds();
        HashSet<String> addEmployeeIds = new HashSet<String>();
        int size = objs.length;
        for (int i = 0; i < size; ++i) {
            PersonInfo employeeInfo;
            if (this.canNotAuditSet.contains(((PersonInfo)objs[i]).getId().toString()) || TrainCommonUtils.isEmpty((CoreBaseInfo)(employeeInfo = (PersonInfo)objs[i])) || currentEmployeeIds.contains(employeeInfo.getId().toString())) continue;
            addEmployeeIds.add(employeeInfo.getId().toString());
        }
        TrainCourseRecordCollection addCourseRecords = this.assembleTrainCourseRecordInfo(addEmployeeIds);
        this.putDataToTable(addCourseRecords, TrainActivityHelper.getPropertyForRecordPerson(addEmployeeIds));
    }

    private TrainActCourseInfo getTrainActCourseInfo(TrainActivityInfo trainActivityInfo, TrainCourseInfo trainCourseInfo) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)trainCourseInfo.getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        TrainActCourseCollection collection = TrainActCourseFactory.getRemoteInstance().getTrainActCourseCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    private Set assembleCurrentEmployeeIds() {
        HashSet<String> employeeIds = new HashSet<String>();
        IRow row = null;
        TrainCourseRecordInfo trainCourseRecordInfo = null;
        for (int i = 0; i < this.recordTable.getRowCount(); ++i) {
            row = this.recordTable.getRow(i);
            trainCourseRecordInfo = (TrainCourseRecordInfo)row.getCell(TRAINCOURSERECORD).getValue();
            if (trainCourseRecordInfo == null || TrainCommonUtils.isEmpty((CoreBaseInfo)trainCourseRecordInfo.getEmployee())) continue;
            employeeIds.add(trainCourseRecordInfo.getEmployee().getId().toString());
        }
        return employeeIds;
    }

    private TrainCourseRecordCollection assembleTrainCourseRecordInfo(Set employeeIds) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)employeeIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)((TrainCourseInfo)this.promptTrainCourse.getValue()).getId().toString()));
        if (this.promptTrainActivity.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", null));
        }
        TrainCourseRecordCollection col = TrainActivityHelper.getRecordCollection(filterInfo, null);
        return col;
    }

    private FilterInfo getFilterInfo() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        if (this.promptTrainCourse.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)((TrainCourseInfo)this.promptTrainCourse.getValue()).getId().toString()));
        }
        if (this.promptTrainActivity.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
        } else if (this.promptTrainCourse.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", null));
        }
        if (filterInfo.getFilterItems().size() == 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)BOSUuid.create((BOSObjectType)new TrainCourseRecordInfo().getBOSType()).toString()));
        }
        filterInfo.getFilterItems().add(TrainCommonUtils.getAdminRangeFilterItemInfo(this.userID, "recordExtends.OrgStudent.id"));
        return filterInfo;
    }

    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        TrainActivityHelper.deleteRows(this.recordTable);
    }

    private void setButtonState() {
        boolean flag = this.hasRecord();
        this.actionSave.setEnabled(flag);
        this.actionDelLine.setEnabled(flag);
        flag = this.promptTrainActivity.getValue() != null && this.promptTrainCourse.getValue() != null;
        this.actionAddPerson.setEnabled(flag);
    }

    private boolean hasRecord() {
        return this.recordTable.getRowCount() > 0;
    }

    protected void recordTable_editStopped(KDTEditEvent e) throws Exception {
        super.recordTable_editStopped(e);
        if (this.recordTable.getColumnIndex(TRAINCOST) == e.getColIndex()) {
            // empty if block
        }
    }

    private void updateRecordContainerTitle() {
        BigDecimal total = new BigDecimal("0.00");
        int count = this.recordTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            BigDecimal value = (BigDecimal)this.recordTable.getRow(i).getCell(TRAINCOST).getValue();
            if (value == null) continue;
            total = total.add(value);
        }
        this.recordContainer.setTitle(this.recordContainerTitle + total.setScale(TrainClientUtil.PRECISION));
    }

    private void updateRecordContainerTitle_tmp(TrainCourseRecordCollection courseRecordCollection) {
        BigDecimal total = new BigDecimal("0.00");
        if (courseRecordCollection == null || courseRecordCollection.size() == 0) {
            this.recordContainer.setTitle(this.recordContainerTitle + total.setScale(TrainClientUtil.PRECISION));
        } else {
            for (int i = 0; i < courseRecordCollection.size(); ++i) {
                BigDecimal value;
                TrainCourseRecordInfo info = courseRecordCollection.get(i);
                if (this.promptTrainCourse.getValue() == null) {
                    if (info.getActCost() == null || (value = info.getActCost()) == null) continue;
                    total = total.add(value);
                    continue;
                }
                if (info.getCourseCost() == null || (value = info.getCourseCost()) == null) continue;
                total = total.add(value);
            }
            this.recordContainer.setTitle(this.recordContainerTitle + total.setScale(TrainClientUtil.PRECISION, 4));
        }
    }

    protected boolean checkBeforeWindowClosing() {
        this.checkModify(null);
        return super.checkBeforeWindowClosing();
    }

    private void checkModify(PreChangeEvent event) {
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.operateYes();
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    private void operateYes() {
        ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
        this.actionSave.actionPerformed(event);
        if (this.actionSave.isInvokeFailed()) {
            SysUtil.abort();
        }
    }

    private boolean isModify() {
        HashMap currentRecords = new HashMap();
        currentRecords = this.promptTrainCourse.getValue() == null ? this.getCurrentRecords(true) : this.getCurrentRecords(false);
        if (currentRecords == null) {
            return false;
        }
        if (this.historyRecords == null || this.historyRecords.size() == 0) {
            return false;
        }
        TrainCourseRecordInfo info_source = null;
        TrainCourseRecordInfo info_target = null;
        int size = this.historyRecords.size();
        for (int i = 0; i < size; ++i) {
            info_source = this.historyRecords.get(i);
            if (!currentRecords.containsKey(info_source.getId().toString())) continue;
            info_target = (TrainCourseRecordInfo)currentRecords.get(info_source.getId().toString());
            if (this.promptTrainCourse.getValue() == null) {
                if (info_source.getActCost() == null && info_target.getActCost() != null) {
                    return true;
                }
                if (info_source.getActCost() != null && info_target.getActCost() == null) {
                    return true;
                }
                if (info_source.getActCost() == null && info_target.getActCost() == null || info_source.getActCost().compareTo(info_target.getActCost()) == 0) continue;
                return true;
            }
            if (info_source.getCourseCost() == null && info_target.getCourseCost() != null) {
                return true;
            }
            if (info_source.getCourseCost() != null && info_target.getCourseCost() == null) {
                return true;
            }
            if (info_source.getCourseCost() == null && info_target.getCourseCost() == null || info_source.getCourseCost().compareTo(info_target.getCourseCost()) == 0) continue;
            return true;
        }
        return false;
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
        if (this.locateAssistant == null) {
            this.locateAssistant = new LocateAssistant((CoreUIObject)this, this.recordTable, this.getLocateNames());
        }
        this.locateAssistant.actionLocate();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "name"};
        return locateNames;
    }

    private void clearTable() {
        this.recordTable.checkParsed();
        this.recordTable.removeRows();
    }

    private void setAddAndEndPersonState() {
        if (this.promptTrainActivity.getValue() != null && this.promptTrainCourse.getValue() == null) {
            TrainActivityInfo info = (TrainActivityInfo)this.promptTrainActivity.getValue();
            if (!TrainActStateEnum.CLOSED.equals((Object)info.getTrainActState())) {
                this.btnAddPerson.setEnabled(false);
                this.btnDeletePerson.setEnabled(false);
                this.clearTable();
            }
        } else {
            this.btnAddPerson.setEnabled(true);
            this.btnDeletePerson.setEnabled(true);
        }
    }

    private String getCourseRecordQuery() {
        return "TrainCourseRecordForBatchQuery";
    }

    private Set getTrainCourseRecordID() throws Exception {
        HashSet<String> recordIDSet = new HashSet<String>();
        FilterInfo filterInfo = this.getFilterInfo();
        TrainCourseRecordCollection col = TrainActivityHelper.getRecordCollection(filterInfo, null);
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                TrainCourseRecordInfo info = col.get(i);
                recordIDSet.add(info.getId().toString());
            }
        }
        return recordIDSet;
    }

    private void updateCourseCost() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(this.getFilterInfo());
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        TrainCourseRecordCollection collection = TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(viewInfo);
        this.updateRecordContainerTitle_tmp(collection);
    }
}

