/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.ITrainCourseResearch;
import com.kingdee.eas.hr.train.TrainCourseResearchFactory;
import com.kingdee.eas.hr.train.TrainCourseResearchInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainCourseResearchListUI;
import com.kingdee.eas.hr.train.client.PreLectureListUI;
import com.kingdee.eas.hr.train.client.TrainCourseResearchEditUI;
import com.kingdee.eas.hr.train.client.TrainCourseResearchRoundEditUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class TrainCourseResearchListUI
extends AbstractTrainCourseResearchListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainCourseResearchListUI.class);
    protected static final String SCHEDULE = "SCHEDULE";
    private String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";

    public void onLoad() throws Exception {
        super.onLoad();
        TrainUtils.setTableNumberFormat(this.tblMain, "intendWorkLoad", 2);
        TrainUtils.setTableNumberFormat(this.tblMain, "actualWorkLoad", 2);
    }

    private void initTabelRender() {
        this.tblMain.setUserCellDisplayParser(new IUserCellDisplayParser(){

            public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
                int coreColumn = TrainCourseResearchListUI.this.tblMain.getColumnIndex("status");
                if (colIndex == coreColumn && rowIndex >= 0 && value != null) {
                    if (value instanceof BizEnumValueInfo && ((BizEnumValueInfo)value).getInt() == 20) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                return value;
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPreLecture.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.btnSchedule.setIcon(EASResource.getIcon((String)"imgTbtn_flux"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        JMenuItem item = this.btnAddNew.addAssistMenuItem((Action)this.actionAddNew);
        item.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)this.actionAddNew, (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        item = this.btnAddNew.addAssistMenuItem((Action)((Object)this.actionRound));
        item.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionRound), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            HashSet<String> ids = new HashSet<String>();
            while (rowSet.next()) {
                if (((BizEnumValueInfo)rowSet.getObject("researchType")).getInt() == 10) {
                    String trainCourseName = rowSet.getString("trainCourse.name");
                    String trainCourseNumber = rowSet.getString("trainCourse.number");
                    if (trainCourseName != null && trainCourseNumber != null) {
                        rowSet.updateString("name", trainCourseName);
                        rowSet.updateString("number", trainCourseNumber);
                    }
                }
                ids.add(rowSet.getString("id"));
            }
            ITrainCourseResearch trainCourseResearch = TrainCourseResearchFactory.getRemoteInstance();
            Map intendDates = trainCourseResearch.getIntendDateByCurrentSchedule(ids);
            rowSet.beforeFirst();
            while (rowSet.next()) {
                String id = rowSet.getString("id");
                rowSet.updateDate("intendDate", intendDates.get(id) == null ? null : new Date(((java.util.Date)intendDates.get(id)).getTime()));
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return TrainCourseResearchEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainCourseResearchFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainCourseResearchInfo objectValue = new TrainCourseResearchInfo();
        return objectValue;
    }

    public void actionPreLecture_actionPerformed(ActionEvent e) throws Exception {
        super.actionPreLecture_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(PreLectureListUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
    }

    public void actionSchedule_actionPerformed(ActionEvent e) throws Exception {
        super.actionSchedule_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TrainCourseResearchEditUI.class.getName(), (Map)uiContext, null, SCHEDULE);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        ITrainCourseResearch trainCourseResearch = TrainCourseResearchFactory.getRemoteInstance();
        trainCourseResearch.audit(TrainUtils.getSelectedValues(this.tblMain));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"AuditCourseSuccess"));
        this.refresh(null);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        ITrainCourseResearch trainCourseResearch = TrainCourseResearchFactory.getRemoteInstance();
        trainCourseResearch.unAudit(TrainUtils.getSelectedValues(this.tblMain));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"UnAuditCourseSuccess"));
        this.refresh(null);
    }

    public void actionRound_actionPerformed(ActionEvent e) throws Exception {
        super.actionRound_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TrainCourseResearchRoundEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        List list = TrainUtils.getSelectedRows(this.tblMain);
        HashSet<String> idSet = new HashSet<String>();
        IRow row = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            int rowIndex = (Integer)list.get(i);
            row = this.tblMain.getRow(rowIndex);
            if (((Boolean)row.getCell("status").getValue()).booleanValue()) continue;
            idSet.add(row.getCell("id").getValue().toString());
        }
        if (this.confirmRemove(idSet.size())) {
            TrainCourseResearchFactory.getRemoteInstance().delete(idSet);
            this.refresh(null);
        }
    }

    private boolean confirmRemove(int count) {
        if (count == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CanNotDelAuditRecord"));
            return false;
        }
        String message = EASResource.getString((String)this.resourcePath, (String)"CanDelUnAuditRecord");
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)(message = message.replaceAll("#0", String.valueOf(count)))));
    }
}

