/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.train.TrainEquipmentFactory;
import com.kingdee.eas.hr.train.TrainEquipmentInfo;
import com.kingdee.eas.hr.train.TrainEquipmentTreeFactory;
import com.kingdee.eas.hr.train.TrainEquipmentTreeInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainEquipmentListUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainEquipmentEditUI;
import com.kingdee.eas.hr.train.client.TrainEquipmentListFilterUI;
import com.kingdee.eas.hr.train.client.TrainEquipmentTreeEditUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TreeDetailHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TrainEquipmentListUI
extends AbstractTrainEquipmentListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainEquipmentListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainResource";
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainEquipmentResource";
    private boolean startOnLoad = false;
    private String currentHRId = null;
    private Boolean defaultFilterFlag = null;

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeAddNew();
        super.actionAddNew_actionPerformed(e);
    }

    private void checkBeforeAddNew() {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            if (!((TreeBaseInfo)treeNode.getUserObject()).isIsLeaf()) {
                TrainClientUtil.showErrorMessage(RES, "notLeafNotAddNew", (CoreUI)this);
            }
        } else {
            TrainClientUtil.showErrorMessage(RES, "virtualRootNotAddNew", (CoreUI)this);
        }
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        TreeDetailHelper.checkGroupAddNew(this, this.treeMain, this.getBizInterface());
        super.actionGroupAddNew_actionPerformed(e);
    }

    public RequestContext prepareActionGroupAddNew(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionGroupAddNew(itemAction);
        TreeDetailHelper.prepareCheckGroupAddNew(this, this.treeMain, request);
        return request;
    }

    protected String getEditUIName() {
        return TrainEquipmentEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainEquipmentFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return TrainEquipmentTreeFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        return TrainEquipmentTreeEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return TrainClientUtil.getResource(RES, "trainEquipmentRoot");
    }

    protected IObjectValue createNewData() {
        TrainEquipmentInfo objectValue = new TrainEquipmentInfo();
        return objectValue;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        Set ids = TrainUtils.getHRByParamNumber("hr_train_007");
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        return filterInfo;
    }

    protected FilterInfo getDefaultFilterForTree() {
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        FilterInfo filterInfo = new FilterInfo();
        Set ids = TrainUtils.getHRByParamNumber("hr_train_007");
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        return filterInfo;
    }

    protected void initGroupButton() {
        super.initGroupButton();
        this.treeView.getControlPane().remove((Component)this.btnGroupMoveTree);
    }

    public void onLoad() throws Exception {
        this.menuItemGroupAddNew.setAccelerator(KeyStroke.getKeyStroke("ctrl alt N"));
        this.startOnLoad = true;
        TrainClientUtil.checkValidHRO((CoreUI)this);
        this.currentHRId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        this.tblMain.setUserCellDisplayParser(new IUserCellDisplayParser(){

            public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
                int coreColumn = TrainEquipmentListUI.this.tblMain.getColumnIndex("TrainChannel");
                if (colIndex == coreColumn && rowIndex >= 0) {
                    String var;
                    String supplierType = "";
                    if (!TrainClientUtil.objectIsNull(TrainEquipmentListUI.this.tblMain.getRow(rowIndex).getCell("SupplierType").getValue())) {
                        supplierType = TrainEquipmentListUI.this.tblMain.getRow(rowIndex).getCell("SupplierType").getValue().toString();
                    }
                    if (!TrainClientUtil.objectIsNull(var = (String)TrainEquipmentListUI.this.tblMain.getRow(rowIndex).getCell("TrainChannel").getValue())) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(var);
                        buffer.append("(");
                        buffer.append(supplierType);
                        buffer.append(")");
                        return buffer.toString();
                    }
                    return value;
                }
                return value;
            }
        });
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getColumn("Count").getStyleAttributes().setNumberFormat("%r-[=]{#,##0}f");
        this.tblMain.setColumnMoveable(true);
    }

    protected String getGroupEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    public KDPanel getFilterUI() {
        try {
            return new TrainEquipmentListFilterUI();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.addUserPanel(this.getFilterUI());
        return queryDlg;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected void moveTreeNode(MoveTreeEvent e) {
        TreeDetailHelper.checkMoveTreeNode(e, (CoreUI)this);
        super.moveTreeNode(e);
    }

    protected void moveGroupTreeNode(MoveTreeEvent e) {
        try {
            if (TreeDetailHelper.checkMoveGroupTreeNode(e, this.getBizInterface(), (CoreUI)this)) {
                super.moveGroupTreeNode(e);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
    }

    public IUIActionPostman prepareInit() {
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), (ListUI)this, this.mainQueryPK);
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionGroupAddNew() {
        return true;
    }

    public boolean isPrepareActionGroupEdit() {
        return true;
    }

    public boolean isPrepareActionGroupRemove() {
        return true;
    }

    public boolean isPrepareActionRemove() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String hrID = null;
        boolean isShare = false;
        if (rows != null && rows.length > 0 && rows[0] >= 0) {
            int len = rows.length;
            for (int i = 0; i < len; ++i) {
                hrID = this.tblMain.getRow(rows[i]).getCell("hrOrgUnit.id").getValue().toString();
                if (this.currentHRId.equals(hrID)) continue;
                isShare = true;
                break;
            }
        }
        if (isShare) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        if (this.treeMain.getSelectionPath() == null) {
            return;
        }
        KDTreeNode node = (KDTreeNode)this.treeMain.getSelectionPath().getLastPathComponent();
        if (node.getUserObject() != null && node.getUserObject() instanceof TrainEquipmentTreeInfo) {
            TrainEquipmentTreeInfo treeInfo = (TrainEquipmentTreeInfo)node.getUserObject();
            if (treeInfo.getHrOrgUnit() != null && !this.currentHRId.equals(treeInfo.getHrOrgUnit().getId().toString())) {
                this.actionAddNew.setEnabled(false);
                this.actionGroupAddNew.setEnabled(false);
                this.actionGroupEdit.setEnabled(false);
                this.actionGroupRemove.setEnabled(false);
            } else {
                this.actionAddNew.setEnabled(true);
                this.actionGroupAddNew.setEnabled(true);
                this.actionGroupEdit.setEnabled(true);
                this.actionGroupRemove.setEnabled(true);
            }
        } else {
            this.actionAddNew.setEnabled(true);
            this.actionGroupAddNew.setEnabled(true);
            this.actionGroupEdit.setEnabled(true);
            this.actionGroupRemove.setEnabled(true);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        ItemAction action = null;
        if (e != null) {
            action = this.getActionFromActionEvent(e);
        }
        if (action == null) {
            return;
        }
        if (action.equals(this.actionGroupEdit)) {
            TreePath oldPath = this.treeMain.getSelectionPath();
            this.initTree();
            this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath));
        } else {
            super.refresh(e);
        }
    }
}

