/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import java.util.Iterator;
import java.util.TreeSet;

public class TrainHelper {
    public static int[] getSelectedRows(KDTable table) {
        if (table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                if (j < 0) continue;
                set.add(j);
            }
        }
        int[] rows = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            rows[k++] = (Integer)iter.next();
        }
        return rows;
    }

    public static int[] getSelectedColumns(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getLeft(); j <= block.getRight(); ++j) {
                set.add(j);
            }
        }
        int[] columns = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            columns[k++] = (Integer)iter.next();
        }
        return columns;
    }

    public static int getSelectedRowCount(KDTable table) {
        int[] rows = TrainHelper.getSelectedRows(table);
        return rows.length;
    }

    public static TrainActivityInfo getTrainActivityInfo(String activityId) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("TrainPlan.*"));
        sic.add(new SelectorItemInfo("planActivity.*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("belongOrgUnit.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("trainChanne.*"));
        sic.add(new SelectorItemInfo("orgPerson.*"));
        sic.add(new SelectorItemInfo("trainType"));
        sic.add(new SelectorItemInfo("trainingCategor.*"));
        sic.add(new SelectorItemInfo("trainCatagory.*"));
        sic.add(new SelectorItemInfo("trainItem.*"));
        sic.add(new SelectorItemInfo("trainStartDate"));
        sic.add(new SelectorItemInfo("trainEndDate"));
        sic.add(new SelectorItemInfo("BudgetCost"));
        sic.add(new SelectorItemInfo("minStudentCount"));
        sic.add(new SelectorItemInfo("maxStudentCount"));
        sic.add(new SelectorItemInfo("trainMethod.*"));
        sic.add(new SelectorItemInfo("roadMap"));
        sic.add(new SelectorItemInfo("assessMethod.*"));
        sic.add(new SelectorItemInfo("passStand"));
        sic.add(new SelectorItemInfo("certificateName"));
        sic.add(new SelectorItemInfo("isMustControl"));
        sic.add(new SelectorItemInfo("needDivide"));
        sic.add(new SelectorItemInfo("needCertifcate"));
        sic.add(new SelectorItemInfo("needContract"));
        sic.add(new SelectorItemInfo("needAssess"));
        sic.add(new SelectorItemInfo("trainContent"));
        sic.add(new SelectorItemInfo("trainObject"));
        sic.add(new SelectorItemInfo("target"));
        sic.add(new SelectorItemInfo("contactMethod"));
        sic.add(new SelectorItemInfo("trainAddress"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("trainExePriod.*"));
        sic.add(new SelectorItemInfo("trainActState"));
        TrainActivityInfo trainActivityInfo = null;
        trainActivityInfo = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(activityId), sic);
        return trainActivityInfo;
    }
}

