/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.train.TrainException;
import com.kingdee.eas.hr.train.TrainFacadeFactory;
import com.kingdee.eas.hr.train.TrainItemCourseCollection;
import com.kingdee.eas.hr.train.TrainItemCourseInfo;
import com.kingdee.eas.hr.train.TrainItemFactory;
import com.kingdee.eas.hr.train.TrainItemInfo;
import com.kingdee.eas.hr.train.TrainItemTreeFactory;
import com.kingdee.eas.hr.train.TrainItemTreeInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainItemListUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainItemCourseEditUI;
import com.kingdee.eas.hr.train.client.TrainItemEditUI;
import com.kingdee.eas.hr.train.client.TrainItemListFilterUI;
import com.kingdee.eas.hr.train.client.TrainItemTreeEditUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TreeDetailHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class TrainItemListUI
extends AbstractTrainItemListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainItemListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainResource";
    private static final String IS_ENABLE = "isEnable";
    private boolean startOnLoad = false;
    private String pubBtnState = null;
    private Set ids = new HashSet();
    private Set hrOrgUintIdSet = new HashSet();
    private Boolean defaultFilterFlag = null;

    public void onLoad() throws Exception {
        this.menuItemGroupAddNew.setAccelerator(KeyStroke.getKeyStroke("ctrl alt N"));
        this.startOnLoad = true;
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSetEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnSetDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnCourses.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.menuSetEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuDisEnable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuTrainCourse.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.actionSetEnable.setEnabled(true);
        this.actionSetDisable.setEnabled(true);
        this.actionCourses.setEnabled(true);
        this.tblMain.setColumnMoveable(true);
        this.treeView.getControlPane().remove((Component)this.btnGroupMoveTree);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode node = (KDTreeNode)this.treeMain.getSelectionPath().getLastPathComponent();
        if (node == null || !(node.getUserObject() instanceof TrainItemTreeInfo) || !node.isLeaf()) {
            throw new TrainException(TrainException.TRAINITEM_ROOT_CANNOTADD);
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        IRow row = null;
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            row = this.tblMain.getRow(rowIndex);
        }
        if (row != null && row.getCell("id").getValue() != null) {
            String id = row.getCell("id").getValue().toString();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)id));
            fi.getFilterItems().add(new FilterItemInfo(IS_ENABLE, (Object)Boolean.TRUE));
            if (this.getBizInterface().exists(fi)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource", (String)"can_not_modify_enabled_data"));
                SysUtil.abort();
            }
        }
        if (this.checkInnerOrgUnit(null)) {
            super.actionEdit_actionPerformed(e);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String notRemove;
        Set ids = TrainUtils.getSelectedValues(this.tblMain);
        if (ids.size() > 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo(IS_ENABLE, (Object)Boolean.TRUE));
            if (this.getBizInterface().exists(fi)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource", (String)"can_not_modify_enabled_data"));
                SysUtil.abort();
            }
        }
        if (this.checkInnerOrgUnit(notRemove = "true")) {
            super.actionRemove_actionPerformed(e);
        }
    }

    private boolean checkInnerOrgUnit(String notRemove) throws EASBizException, BOSException {
        if (this.pubBtnState != null && this.pubBtnState.equals("false")) {
            return true;
        }
        List rowList = TrainUtils.getSelectedRows(this.tblMain);
        IRow row = null;
        HashSet<Object> ids = new HashSet<Object>();
        for (int i = 0; i < rowList.size(); ++i) {
            row = this.tblMain.getRow(Integer.parseInt(rowList.get(i).toString()));
            if (row.getCell("adminOrgUnitId") == null || row.getCell("adminOrgUnitId").getValue() == null) continue;
            ids.add(row.getCell("adminOrgUnitId").getValue());
        }
        if (ids != null && ids.size() > 0) {
            if (notRemove == null) {
                if (!TrainFacadeFactory.getRemoteInstance().isInAdminRange(ids)) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notCurrentOrg"));
                    return false;
                }
            } else if (!TrainFacadeFactory.getRemoteInstance().isIncludeRange_Modify(ids)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notCurrentOrg"));
                return false;
            }
        }
        return true;
    }

    public void actionCourses_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String trainItemId = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)trainItemId);
        String state = null;
        state = this.isTrainItemEnable() ? OprtState.VIEW : OprtState.EDIT;
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainItemCourseEditUI.class.getName(), (Map)uiContext, null, state);
        uiWindow.show();
    }

    public void actionSetEnable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String trainItemId = this.getSelectedKeyValue();
        this.checkCourseState(trainItemId);
        TrainItemFactory.getRemoteInstance().setEnable((IObjectPK)new ObjectUuidPK(trainItemId));
        this.tblMain.removeRows();
    }

    private void checkCourseState(String trainItemId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("Course.course.name"));
        sic.add(new SelectorItemInfo("Course.course.IsEnable"));
        TrainItemInfo itemInfo = TrainItemFactory.getRemoteInstance().getTrainItemInfo((IObjectPK)new ObjectUuidPK(trainItemId), sic);
        TrainItemCourseCollection itemCourses = itemInfo.getCourse();
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < itemCourses.size(); ++i) {
            TrainItemCourseInfo itemCourseInfo = itemCourses.get(i);
            if (itemCourseInfo.getCourse().isIsEnable()) continue;
            if (msg.length() > 0) {
                msg.append(", ");
            }
            msg.append(itemCourseInfo.getCourse().getName());
        }
        if (msg.length() > 0) {
            TrainClientUtil.showErrorMessage(RESOURCE, "TrainItemCannotEnable", new Object[]{msg.toString()}, (CoreUI)this);
        }
    }

    public void actionSetDisable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String trainItemId = this.getSelectedKeyValue();
        TrainItemFactory.getRemoteInstance().setDisable((IObjectPK)new ObjectUuidPK(trainItemId));
        this.tblMain.removeRows();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.isTrainItemEnable()) {
            this.setActionsState(false);
        } else {
            this.setActionsState(true);
        }
    }

    private boolean isTrainItemEnable() {
        int curIndex = TrainUtils.getCurrentRowIndex(this.tblMain);
        if (curIndex >= 0) {
            Boolean state = (Boolean)this.tblMain.getRow(curIndex).getCell(IS_ENABLE).getValue();
            return state != null ? state : false;
        }
        return false;
    }

    private void setActionsState(boolean flag) {
        this.actionRemove.setEnabled(flag);
        this.actionEdit.setEnabled(flag);
        this.actionSetEnable.setEnabled(flag);
        this.actionSetDisable.setEnabled(!flag);
    }

    protected FilterInfo getDefaultFilterForTree() {
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        this.hrOrgUintIdSet = TrainUtils.getHRByParamNumber("hr_train_004");
        FilterInfo returnFilter = new FilterInfo();
        try {
            returnFilter = TrainUtils.getTrianItemTreeFilter(this.hrOrgUintIdSet);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return returnFilter;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = TrainUtils.getAdminRangeFilterInfo("adminOrgUnit.id");
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("rangeOrgUnit.id", (Object)TrainUtils.getAdminRangeSql(), CompareType.INNER));
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.hrOrgUintIdSet, CompareType.INCLUDE));
        try {
            filter.mergeFilter(fi, "OR");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return filter;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.addUserPanel(this.getFilterUI());
        return queryDlg;
    }

    public KDPanel getFilterUI() {
        try {
            return new TrainItemListFilterUI();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected String getEditUIName() {
        return TrainItemEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainItemFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return TrainItemTreeFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        return TrainItemTreeEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return EASResource.getString((String)RESOURCE, (String)"TrainItemTreeRootName");
    }

    protected IObjectValue createNewData() {
        TrainItemInfo objectValue = new TrainItemInfo();
        return objectValue;
    }

    protected String getGroupEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        TreeDetailHelper.checkGroupAddNew(this, this.treeMain, this.getBizInterface());
        super.actionGroupAddNew_actionPerformed(e);
    }

    protected void moveTreeNode(MoveTreeEvent e) {
        TreeDetailHelper.checkMoveTreeNode(e, (CoreUI)this);
        super.moveTreeNode(e);
    }

    protected void moveGroupTreeNode(MoveTreeEvent e) {
        try {
            if (TreeDetailHelper.checkMoveGroupTreeNode(e, this.getBizInterface(), (CoreUI)this)) {
                super.moveGroupTreeNode(e);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
    }

    public IUIActionPostman prepareInit() {
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), (ListUI)this, this.mainQueryPK);
    }

    public RequestContext prepareActionGroupAddNew(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionGroupAddNew(itemAction);
        KDTreeNode node = (KDTreeNode)this.treeMain.getSelectionPath().getLastPathComponent();
        if (node != null && node.getUserObject() instanceof TrainItemTreeInfo) {
            TrainItemTreeInfo itemTree = (TrainItemTreeInfo)node.getUserObject();
            request.put("treeId", (Object)itemTree.getId().toString());
        }
        return request;
    }

    public RequestContext prepareActionRemove(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionRemove(itemAction);
        request.put("idSet", (Object)TrainUtils.getSelectedValues(this.tblMain));
        return request;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionGroupAddNew() {
        return true;
    }

    public boolean isPrepareActionGroupEdit() {
        return true;
    }

    public boolean isPrepareActionGroupRemove() {
        return true;
    }

    public boolean isPrepareActionRemove() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }
}

