/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.hr.train.ITrainMaterial;
import com.kingdee.eas.hr.train.TrainMaterialCollection;
import com.kingdee.eas.hr.train.TrainMaterialFactory;
import com.kingdee.eas.hr.train.TrainMaterialInfo;
import com.kingdee.eas.hr.train.TrainMaterialTreeFactory;
import com.kingdee.eas.hr.train.TrainMaterialTreeInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainMaterialMultiF7UI;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.hr.train.client.TrainMaterialEditUI;
import com.kingdee.eas.hr.train.client.TrainMaterialTreeEditUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class TrainMaterialMultiF7UI
extends AbstractTrainMaterialMultiF7UI {
    private static final Logger logger = CoreUIObject.getLogger(TrainMaterialMultiF7UI.class);
    private String resourcePath = "com.kingdee.eas.hr.train.TrainResource";
    private String RES = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private static final String resPath = "com.kingdee.eas.hr.train.TrainActivityResource";
    protected boolean isCanceled = true;
    private boolean isSingleSelect = true;
    private boolean isShare = false;
    protected TrainMaterialCollection selectedMaterialColl = new TrainMaterialCollection();

    protected IObjectPK getSelectedTreeKeyValue() {
        try {
            return new ObjectUuidPK(this.getSelectedNodeKeyValue());
        }
        catch (Exception ex) {
            this.handUIException(ex);
            return null;
        }
    }

    protected String getGroupEditUIName() {
        return TrainMaterialTreeEditUI.class.toString();
    }

    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return TrainMaterialTreeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return TrainMaterialEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainMaterialFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.isSingleSelect = (Boolean)this.getUIContext().get("IsSingleSelect");
        if (this.isSingleSelect) {
            this.contSelected.setVisible(false);
            this.splitRight.setDividerSize(0);
        }
        super.onLoad();
        this.initOperateButton();
        this.tblSelected.checkParsed();
        if (this.isSingleSelect) {
            this.tblMain.getSelectManager().setSelectMode(2);
        } else {
            this.tblSelected.getSelectManager().setSelectMode(10);
        }
    }

    protected String getRootName() {
        return EASResource.getString((String)this.resourcePath, (String)"TrainMaterial");
    }

    protected void btnSelect_actionPerformed(ActionEvent e) throws Exception {
        if (this.isSingleSelect) {
            int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
            if (rowIndex < 0) {
                return;
            }
            this.selectedMaterialColl = this.getTopSelectedTrainMaterial();
        } else {
            int size = this.tblSelected.getRowCount();
            if (size > 0) {
                this.selectedMaterialColl = this.getAllSelectedTrainMaterial();
            }
        }
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    private TrainMaterialCollection getTopSelectedTrainMaterial() throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowIndex);
        String strId = row.getCell("id").getValue().toString();
        TrainMaterialCollection materialColl = new TrainMaterialCollection();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        materialColl.add(((ITrainMaterial)this.getBizInterface()).getTrainMaterialInfo((IObjectPK)new ObjectUuidPK(strId), sic));
        return materialColl;
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    private TrainMaterialCollection getAllSelectedTrainMaterial() throws Exception {
        int size = this.tblSelected.getRowCount();
        if (size <= 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer strMask = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblSelected.getRow(i);
            String strId = row.getCell("id").getValue().toString();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)strId));
            if (i != 0) {
                strMask.append(" or ");
            }
            strMask.append("#").append(i);
        }
        if (!"".equals(strMask.toString())) {
            filter.setMaskString(strMask.toString());
        }
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        return ((ITrainMaterial)this.getBizInterface()).getTrainMaterialCollection(view);
    }

    protected void btnDelAll_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        int count = this.tblSelected.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblSelected.getRow(i);
            this.removeMaterialInfoFromSelectedColl(row.getCell("id").getValue().toString());
        }
        this.tblSelected.removeRows();
        this.refresh();
    }

    protected void btnDownAll_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow fromRow = this.tblMain.getRow(i);
            this.insertRowFromTopTable(fromRow);
        }
        this.refresh();
    }

    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        int[] indexs = TrainHelper.getSelectedRows(this.tblSelected);
        int size = indexs.length;
        IRow row = null;
        for (int i = size - 1; i >= 0; --i) {
            row = this.tblSelected.getRow(i);
            String materialId = row.getCell("id").getValue().toString();
            this.removeMaterialInfoFromSelectedColl(materialId);
            this.tblSelected.removeRow(indexs[i]);
        }
        if (indexs.length > 0) {
            this.refresh();
        }
    }

    private void removeMaterialInfoFromSelectedColl(String materialId) {
        for (int i = 0; i < this.selectedMaterialColl.size(); ++i) {
            if (!this.selectedMaterialColl.get(i).getId().toString().equals(materialId)) continue;
            this.selectedMaterialColl.removeObject(i);
        }
    }

    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        int[] indexs = TrainHelper.getSelectedRows(this.tblMain);
        int size = indexs.length;
        for (int i = 0; i < size; ++i) {
            IRow fromRow = this.tblMain.getRow(indexs[i]);
            this.insertRowFromTopTable(fromRow);
        }
        if (indexs.length > 0) {
            this.refresh();
        }
    }

    private void insertRowFromTopTable(IRow fromRow) {
        String strId = fromRow.getCell("id").getValue().toString();
        if (!TrainUtils.isExistSameRowInTable("id", strId, this.tblSelected)) {
            this.tblSelected.addRow(this.tblSelected.getRowCount(), fromRow);
            TrainMaterialInfo trainMaterialInfo = new TrainMaterialInfo();
            trainMaterialInfo.setId(BOSUuid.read((String)fromRow.getCell("id").getValue().toString()));
            this.selectedMaterialColl.add(trainMaterialInfo);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            if (this.isSingleSelect) {
                this.btnSelect_actionPerformed(null);
            } else {
                this.btnDown_actionPerformed(null);
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected void tblSelected_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.btnDel_actionPerformed(null);
        }
    }

    private void initOperateButton() {
        this.contSelected.addButton((JButton)this.btnDown);
        this.contSelected.addButton((JButton)this.btnDel);
        this.contSelected.addButton((JButton)this.btnDownAll);
        this.contSelected.addButton((JButton)this.btnDelAll);
        this.btnDown.setText(EASResource.getString((String)this.RES, (String)"addLine"));
        this.btnDel.setText(EASResource.getString((String)this.RES, (String)"removeLine"));
        this.btnDownAll.setText(EASResource.getString((String)this.RES, (String)"addAll"));
        this.btnDelAll.setText(EASResource.getString((String)this.RES, (String)"removeAll"));
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
    }

    private void refresh() throws Exception {
        this.execQuery();
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            IRow row = this.tblMain.getRow(i);
            if (!this.isContainTrainMaterial(row.getCell("id").getValue().toString())) continue;
            this.tblMain.removeRow(i);
        }
    }

    private boolean isContainTrainMaterial(String id) {
        for (int i = 0; i < this.selectedMaterialColl.size(); ++i) {
            if (!this.selectedMaterialColl.get(i).getId().toString().equals(id)) continue;
            return true;
        }
        return false;
    }

    public TrainMaterialCollection getMaterialCollection() {
        return this.selectedMaterialColl;
    }

    protected FilterInfo getDefaultFilterForTree() {
        return this.getDefaultFilterForQuery();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        Set ids = TrainUtils.getHRByParamNumber("hr_train_006");
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        if (this.selectedMaterialColl != null && this.selectedMaterialColl.size() > 0) {
            HashSet<String> idsSet = new HashSet<String>();
            int size = this.selectedMaterialColl.size();
            for (int i = 0; i < size; ++i) {
                idsSet.add(this.selectedMaterialColl.get(i).getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", idsSet, CompareType.NOTINCLUDE));
        }
        return filter;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        CoreBaseInfo obj = null;
        if (this.getSelectedTreeKeyValue() != null) {
            obj = this.getTreeInterface().getValue(this.getSelectedTreeKeyValue());
        }
        TrainMaterialTreeInfo info = null;
        if (obj != null && obj instanceof TrainMaterialTreeInfo) {
            info = (TrainMaterialTreeInfo)obj;
        }
        if (info == null || !info.isIsLeaf()) {
            MsgBox.showInfo((String)EASResource.getString((String)resPath, (String)"PleaseChooseLeafNode"));
            return;
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }
}

