/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.IRewardPunishType;
import com.kingdee.eas.hr.base.RewardPunishTypeCollection;
import com.kingdee.eas.hr.base.RewardPunishTypeFactory;
import com.kingdee.eas.hr.base.RewardPunishTypeInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.TrainRewardsCollection;
import com.kingdee.eas.hr.train.TrainRewardsFactory;
import com.kingdee.eas.hr.train.TrainRewardsInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainRewardsEditUI;
import com.kingdee.eas.hr.train.client.TrainActivityRecordEditUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseRecordEditUI;
import java.io.Serializable;
import java.util.HashMap;

public class TrainRewardsEditUI
extends AbstractTrainRewardsEditUI {
    private String recordId = null;
    private boolean fromActRecordEditUI = false;
    private boolean fromCourseRecordEditUI = false;
    private HashMap hmUIState = new HashMap();

    public void onLoad() throws Exception {
        this.initType();
        this.initComeFrom();
        this.loadRecordId();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            TrainClientUtil.lockUI((CoreUI)this, this.hmUIState);
        }
        super.onLoad();
    }

    private void initType() throws Exception {
        IRewardPunishType punishType = RewardPunishTypeFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        RewardPunishTypeCollection coll = punishType.getRewardPunishTypeCollection(evi);
        this.cboType.removeAllItems();
        this.cboType.addItems(coll.toArray());
    }

    public void loadFields() {
        super.loadFields();
        RewardPunishTypeInfo typeInfo = null;
        if (this.editData.getType() != null) {
            int size = this.cboType.getItemCount();
            for (int i = 0; i < size; ++i) {
                typeInfo = (RewardPunishTypeInfo)this.cboType.getItemAt(i);
                if (!typeInfo.getId().toString().equals(this.editData.getType().getId().toString())) continue;
                this.cboType.setSelectedIndex(i);
            }
        } else {
            this.cboType.setSelectedItem(null);
        }
    }

    private void initComeFrom() {
        String comeFrom = (String)this.getUIContext().get("come_from");
        if (TrainActivityRecordEditUI.class.getName().equals(comeFrom)) {
            this.fromActRecordEditUI = true;
        } else if (TrainCourseRecordEditUI.class.getName().equals(comeFrom)) {
            this.fromCourseRecordEditUI = true;
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return TrainRewardsEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainRewardsFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainRewardsInfo objectValue = new TrainRewardsInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        TrainRewardsInfo rewardsInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String recordColumnName = null;
        if (this.fromActRecordEditUI) {
            recordColumnName = "trainActRecord.id";
        } else if (this.fromCourseRecordEditUI) {
            recordColumnName = "trainCouRecord.id";
        }
        filter.getFilterItems().add(new FilterItemInfo(recordColumnName, (Object)this.recordId));
        view.setFilter(filter);
        view.setSelector(this.getMergedSelector());
        TrainRewardsCollection rewardCol = TrainRewardsFactory.getRemoteInstance().getTrainRewardsCollection(view);
        if (rewardCol.size() <= 0) {
            rewardsInfo = (TrainRewardsInfo)this.createNewData();
            TrainCourseRecordInfo recordInfo = new TrainCourseRecordInfo();
            recordInfo.setId(BOSUuid.read((String)this.recordId));
            if (this.fromActRecordEditUI) {
                rewardsInfo.setTrainActRecord(recordInfo);
            } else if (this.fromCourseRecordEditUI) {
                rewardsInfo.setTrainCouRecord(recordInfo);
            }
        } else {
            rewardsInfo = rewardCol.get(0);
        }
        return rewardsInfo;
    }

    private void loadRecordId() {
        if (this.getUIContext().get("ID") != null) {
            this.recordId = this.getUIContext().get("ID").toString();
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("Type.id"));
        sic.add(new SelectorItemInfo("Type.name"));
        sic.add(new SelectorItemInfo("Type.number"));
        return sic;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        this.initComeFrom();
        this.loadRecordId();
        request.put("fromActRecordEditUI", (Object)this.fromActRecordEditUI);
        request.put("fromCourseRecordEditUI", (Object)this.fromCourseRecordEditUI);
        request.put("selectors", (Object)this.getSelectors());
        request.put("trainRecordId", (Object)this.recordId);
        handler.setRequestContext((Serializable)request);
        return handler;
    }
}

