/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainSignUpFormForManageFilterUI;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TrainSignUpFormForManageFilterUI
extends AbstractTrainSignUpFormForManageFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainSignUpFormForManageFilterUI.class);
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainHolidayResource";
    private static final String endDateMustAfterFrom = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"ENDDATEMUSTAFTERFROM");

    public void onLoad() throws Exception {
        super.onLoad();
        TrainUtils.initOrgUnit(this.prmpBelongOrgUnit, true, (IUIObject)this);
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        pmt.setUserOrgRangeFilter(true);
        pmt.setIsSingleSelect(true);
        pmt.setModal(true);
        this.prmpApplyPerson.setSelector((KDPromptSelector)pmt);
        this.prmpApplyPerson.setEnabledMultiSelection(false);
        this.prmpApplyPerson.setEditable(false);
        this.prmpBelongOrgUnit.setEditable(false);
        this.setStatus();
        this.setTrainActivityFilter(this.prmpName);
        this.setTrainActivityFilter(this.prmpNumber);
    }

    private void setTrainActivityFilter(KDBizPromptBox promptBox) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainActState", (Object)10, CompareType.NOTEQUALS));
        fi.mergeFilter(TrainUtils.getHRAndAdminRangeFilterInfo("HrOrgUnit.id", "belongOrgUnit.id"), "AND");
        viewInfo.setFilter(fi);
        promptBox.setEntityViewInfo(viewInfo);
    }

    public void setStatus() {
        this.conTxtName.setVisible(false);
        this.txtName.setVisible(false);
        this.conName.setVisible(true);
        this.prmpName.setVisible(true);
    }

    public FilterInfo getFilterInfo() {
        Object[] objs;
        FilterInfo fi = new FilterInfo();
        if (this.chkLookUp.isSelected()) {
            if (this.txtName.getSelectedItem() != null) {
                fi.getFilterItems().add(new FilterItemInfo("TrainAct.name", (Object)("%" + this.txtName.getSelectedItem().toString().trim() + "%"), CompareType.LIKE));
            }
        } else if (this.prmpName.getData() != null) {
            fi.getFilterItems().add(new FilterItemInfo("TrainAct.id", (Object)((TrainActivityInfo)this.prmpName.getData()).getId().toString()));
        }
        if (this.prmpNumber.getData() != null) {
            fi.getFilterItems().add(new FilterItemInfo("TrainAct.id", (Object)((TrainActivityInfo)this.prmpNumber.getData()).getId().toString()));
        }
        if (this.prmpApplyPerson.getData() != null) {
            fi.getFilterItems().add(new FilterItemInfo("Attendee.id", (Object)((PersonInfo)this.prmpApplyPerson.getData()).getId().toString()));
        }
        if (this.prmpBelongOrgUnit.getData() != null && (objs = (Object[])this.prmpBelongOrgUnit.getData()).length != 0 && objs[0] != null) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < objs.length; ++i) {
                idSet.add(((AdminOrgUnitInfo)objs[i]).getId().toString());
            }
            fi.getFilterItems().add(new FilterItemInfo("orgUnit.id", idSet, CompareType.INCLUDE));
        }
        if (this.pkTrainSignUpDateFrom.getValue() != null) {
            fi.getFilterItems().add(new FilterItemInfo("ApplyDate", (Object)((Date)this.pkTrainSignUpDateFrom.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.pkTrainSignUpDateTo.getValue() != null) {
            fi.getFilterItems().add(new FilterItemInfo("ApplyDate", (Object)((Date)this.pkTrainSignUpDateTo.getValue()), CompareType.LESS_EQUALS));
        }
        return fi;
    }

    protected void chkLookUp_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkLookUp.isSelected()) {
            this.conTxtName.setVisible(true);
            this.txtName.setVisible(true);
            this.conName.setVisible(false);
            this.prmpName.setVisible(false);
        } else {
            this.setStatus();
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmpNumber);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmpBelongOrgUnit);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmpApplyPerson);
        CustomerQueryUtil.storeToCustomerParams(cp, this.chkLookUp);
        CustomerQueryUtil.storeToCustomerParams(cp, this.pkTrainSignUpDateFrom);
        CustomerQueryUtil.storeToCustomerParams(cp, this.pkTrainSignUpDateTo);
        if (this.chkLookUp.isSelected()) {
            this.txtName.setVisible(true);
            this.conTxtName.setVisible(true);
            this.conName.setVisible(false);
            this.prmpName.setVisible(false);
            CustomerQueryUtil.storeToCustomerParams(cp, this.txtName);
        } else {
            this.setStatus();
            CustomerQueryUtil.storeToCustomerParams(cp, this.prmpName);
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmpNumber, TrainActivityInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmpBelongOrgUnit, AdminOrgUnitInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmpApplyPerson, PersonInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.chkLookUp);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkTrainSignUpDateFrom);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkTrainSignUpDateTo);
        if (this.chkLookUp.isSelected()) {
            this.txtName.setVisible(true);
            this.conTxtName.setVisible(true);
            this.conName.setVisible(false);
            this.prmpName.setVisible(false);
            CustomerQueryUtil.loadFromCustomerParams(cp, this.txtName);
        } else {
            this.setStatus();
            CustomerQueryUtil.loadFromCustomerParams(cp, this.prmpName, TrainActivityInfo.class.getName());
        }
    }

    public void clear() {
        super.clear();
        this.prmpName.setData(null);
        this.prmpNumber.setData(null);
        this.prmpApplyPerson.setData(null);
        this.prmpBelongOrgUnit.setData(null);
        this.txtName.setSelectedItem(null);
        this.chkLookUp.setSelected(false);
        this.pkTrainSignUpDateFrom.setValue(null);
        this.pkTrainSignUpDateTo.setValue(null);
        this.setStatus();
    }

    public boolean verify() {
        if (!super.verify()) {
            return false;
        }
        TrainVerifyUtils.verifyDateBigOrSmallOrEqual((CoreUIObject)this, this.pkTrainSignUpDateFrom, this.pkTrainSignUpDateTo, endDateMustAfterFrom);
        return true;
    }
}

