/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.train.client.AbstractTreeBaseF7UI;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JButton;

public abstract class TreeBaseF7UI
extends AbstractTreeBaseF7UI {
    private boolean canceled = true;
    private boolean singleSelect = true;
    private Collection selectedCollection;
    private SelectorItemCollection selector;
    private FilterInfo filterInfo;
    private String RESOURCE = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private HROrgUnitInfo hrOrgUnitInfo = null;

    public void onLoad() throws Exception {
        this.singleSelect = (Boolean)this.getUIContext().get("singleSelect");
        this.selector = (SelectorItemCollection)this.getUIContext().get("selector");
        this.filterInfo = (FilterInfo)this.getUIContext().get("filterInfo");
        this.hrOrgUnitInfo = (HROrgUnitInfo)this.getUIContext().get("hrOrgUnitInfo");
        this.initOperateButton();
        this.kdtSelected.checkParsed();
        if (!StringUtils.isEmpty((String)this.getSelectedPanelTitle())) {
            this.contSelected.setTitle(this.getSelectedPanelTitle());
        }
        if (this.singleSelect) {
            this.contSelected.setVisible(false);
            this.pnlRight.setDividerSize(0);
        }
        if (this.singleSelect) {
            this.tblMain.getSelectManager().setSelectMode(2);
        } else {
            this.kdtSelected.getSelectManager().setSelectMode(10);
        }
        super.onLoad();
    }

    private void initOperateButton() {
        this.contSelected.addButton((JButton)this.btnDown);
        this.contSelected.addButton((JButton)this.btnDel);
        this.contSelected.addButton((JButton)this.btnDownAll);
        this.contSelected.addButton((JButton)this.btnDelAll);
        this.btnDown.setText(EASResource.getString((String)this.RESOURCE, (String)"addLine"));
        this.btnDel.setText(EASResource.getString((String)this.RESOURCE, (String)"removeLine"));
        this.btnDownAll.setText(EASResource.getString((String)this.RESOURCE, (String)"addAll"));
        this.btnDelAll.setText(EASResource.getString((String)this.RESOURCE, (String)"removeAll"));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            if (this.singleSelect) {
                this.btnSelect_actionPerformed(null);
            } else {
                this.btnDown_actionPerformed(null);
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected void kdtSelected_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.btnDel_actionPerformed(null);
        }
    }

    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        int[] indexs = TrainHelper.getSelectedRows(this.kdtSelected);
        int size = indexs.length;
        for (int i = 0; i < size; ++i) {
            this.kdtSelected.removeRow(indexs[i]);
        }
    }

    protected void btnDelAll_actionPerformed(ActionEvent e) throws Exception {
        this.kdtSelected.removeRows();
    }

    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        int[] ids = TrainHelper.getSelectedRows(this.tblMain);
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            IRow fromRow = this.tblMain.getRow(ids[i]);
            this.insertRowFromTopTable(fromRow);
        }
    }

    protected void btnDownAll_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            this.insertRowFromTopTable(row);
        }
    }

    private void insertRowFromTopTable(IRow row) {
        String strId = row.getCell("id").getValue().toString();
        if (!TrainUtils.isExistSameRowInTable("id", strId, this.kdtSelected)) {
            this.kdtSelected.addRow(this.kdtSelected.getRowCount(), row);
        }
    }

    protected void btnSelect_actionPerformed(ActionEvent e) throws Exception {
        if (this.singleSelect) {
            int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
            if (rowIndex < 0) {
                return;
            }
            this.selectedCollection = this.getTopSelectedTrainCourse();
        } else {
            int size = this.kdtSelected.getRowCount();
            if (size > 0) {
                this.selectedCollection = this.getAllSelectedTrainCourse();
            }
        }
        this.canceled = this.selectedCollection == null || this.selectedCollection.size() <= 0;
        this.getUIWindow().close();
    }

    private Collection getTopSelectedTrainCourse() throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowIndex);
        String strId = row.getCell("id").getValue().toString();
        ArrayList<CoreBaseInfo> collection = new ArrayList<CoreBaseInfo>();
        if (this.selector != null && this.selector.size() > 0) {
            collection.add(this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(strId), this.selector));
        } else {
            collection.add(this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(strId)));
        }
        return collection;
    }

    private Collection getAllSelectedTrainCourse() throws Exception {
        int size = this.kdtSelected.getRowCount();
        if (size <= 0) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        IRow row = null;
        for (int i = 0; i < size; ++i) {
            row = this.kdtSelected.getRow(i);
            idSet.add(row.getCell("id").getValue().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        if (this.selector != null) {
            Iterator it = this.selector.iterator();
            while (it.hasNext()) {
                viewInfo.getSelector().add((SelectorItemInfo)it.next());
            }
        }
        CoreBaseCollection collection = this.getBizInterface().getCollection(viewInfo);
        ArrayList result = null;
        if (collection != null && collection.size() > 0) {
            result = new ArrayList();
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                result.add(it.next());
            }
        }
        return result;
    }

    protected void btnCancelOP_actionPerformed(ActionEvent e) throws Exception {
        this.canceled = true;
        this.getUIWindow().close();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = null;
        try {
            filterInfo = this.getAdminOrgUnitName() != null ? (this.hrOrgUnitInfo != null ? TrainUtils.getHRAndAdminRangeFilterInfo(this.getHROrgUnitName(), this.getAdminOrgUnitName(), this.hrOrgUnitInfo.getId().toString()) : TrainUtils.getHRAndAdminRangeFilterInfo(this.getHROrgUnitName(), this.getAdminOrgUnitName())) : (this.hrOrgUnitInfo != null ? TrainUtils.getHRFilter(this.getHROrgUnitName(), this.hrOrgUnitInfo.getId().toString()) : TrainUtils.getCurrentHRFilter(this.getHROrgUnitName()));
            if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
                if (FilterUtility.hasFilterItem((FilterInfo)this.getFilterInfo())) {
                    filterInfo.mergeFilter(this.getFilterInfo(), "AND");
                }
            } else {
                filterInfo = this.getFilterInfo();
            }
        }
        catch (Exception e) {
            super.handleException(e);
        }
        return filterInfo;
    }

    protected FilterInfo getDefaultFilterForTree() {
        if (this.hrOrgUnitInfo != null) {
            return TrainUtils.getHRFilter(this.getTreeHROrgUnitName(), this.hrOrgUnitInfo.getId().toString());
        }
        return TrainUtils.getCurrentHRFilter(this.getTreeHROrgUnitName());
    }

    protected String getSelectedPanelTitle() {
        return null;
    }

    public String getHROrgUnitName() {
        return null;
    }

    public String getTreeHROrgUnitName() {
        return null;
    }

    public String getAdminOrgUnitName() {
        return null;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return new ObjectUuidPK(this.getSelectedNodeKeyValue());
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Collection getSelectedCollection() {
        return this.selectedCollection;
    }

    public void setSelector(SelectorItemCollection selector) {
        this.selector = selector;
    }

    public void setSingleSelect(boolean singleSelect) {
        this.singleSelect = singleSelect;
    }

    public boolean isSingleSelect() {
        return this.singleSelect;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    public IUIActionPostman prepareInit() {
        this.singleSelect = (Boolean)this.getUIContext().get("singleSelect");
        this.selector = (SelectorItemCollection)this.getUIContext().get("selector");
        this.filterInfo = (FilterInfo)this.getUIContext().get("filterInfo");
        this.hrOrgUnitInfo = (HROrgUnitInfo)this.getUIContext().get("hrOrgUnitInfo");
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("hrOrgUnit.id", (Object)this.hrOrgUnitInfo);
        request.put("filter", (Object)this.filterInfo);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    protected String getQueryFieldName() {
        return null;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

