/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.hr.train.TrainExePeriodCollection;
import com.kingdee.eas.hr.train.TrainExePeriodFactory;
import com.kingdee.eas.hr.train.TrainExePeriodInfo;
import com.kingdee.eas.hr.train.TrainPlanCourseCollection;
import com.kingdee.eas.hr.train.TrainPlanCourseFactory;
import com.kingdee.eas.hr.train.TrainPlanCourseInfo;
import com.kingdee.eas.hr.train.TrainPlanFactory;
import com.kingdee.eas.hr.train.TrainPlanInfo;
import com.kingdee.eas.hr.train.TrainPlanParticipantScopeCollection;
import com.kingdee.eas.hr.train.TrainPlanParticipantScopeFactory;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityCollection;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityFactory;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityInfo;
import com.kingdee.eas.hr.train.web.TrainWebUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class TrainPlanUtil {
    private static final Logger logger = Logger.getLogger(TrainPlanUtil.class);
    private static final String RES = "com.kingdee.eas.hr.train.TrainWebResource";

    public static String getTrainPlanListDataXML(HttpServletRequest request) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        int COLS = 8;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        TrainPlanParticipantScopeCollection coll = null;
        try {
            coll = TrainPlanParticipantScopeFactory.getLocalInstance(ctx).getTrainPlanParticipantScopeCollection(viewInfo);
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getCause());
            return TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        if (coll == null || coll.size() < 1) {
            return TrainWebUtils.makeProcDataToXMLData(null, COLS);
        }
        HashSet<String> idSet = new HashSet<String>();
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            idSet.add(coll.get(i).getTrainPlan().getId().toString());
        }
        filter = new FilterInfo();
        viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        String xmlData = null;
        int pageCount = Integer.parseInt(request.getParameter("pageCount"));
        int pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
        int start = (pageNumber - 1) * pageCount;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainPlanQuery"));
            iqec.option().isAutoIgnoreZero = false;
            iqec.option().isAutoTranslateBoolean = true;
            iqec.option().isAutoTranslateEnum = true;
            iqec.setObjectView(viewInfo);
            list.add("" + iqec.getRowCount());
            IRowSet rowSet = iqec.executeQuery(start, pageCount);
            SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
            String to = ResourceBase.getString((String)RES, (String)"to", (Locale)ctx.getLocale());
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            Date planDate = null;
            Date endDate = null;
            while (rowSet.next()) {
                String[] array = new String[COLS];
                array[0] = rowSet.getString("id");
                array[1] = rowSet.getString("number");
                array[2] = rowSet.getString("name");
                array[3] = rowSet.getString("planCategory.name");
                planDate = rowSet.getDate("PlanDate");
                endDate = rowSet.getDate("endDate");
                array[4] = planDate != null && endDate != null ? formater.format(planDate) + to + formater.format(endDate) : "";
                array[5] = "";
                if (rowSet.getBigDecimal("TotalCost") != null) {
                    array[5] = decimalFormat.format(rowSet.getBigDecimal("TotalCost"));
                }
                array[6] = rowSet.getString("AuditState");
                array[7] = rowSet.getString("OrgUnit.displayName");
                list.add(array);
            }
            xmlData = TrainWebUtils.makeProcDataToXMLData(list, COLS);
        }
        catch (Exception e) {
            logger.error((Object)e.getCause());
            return TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        return xmlData;
    }

    public static TrainPlanInfo getTrainPlan(Context ctx, String id) {
        if (id == null) {
            return null;
        }
        TrainPlanInfo info = null;
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("planCategory.name"));
            selector.add(new SelectorItemInfo("aboutDate"));
            selector.add(new SelectorItemInfo("TotalCost"));
            selector.add(new SelectorItemInfo("PlanDate"));
            selector.add(new SelectorItemInfo("endDate"));
            selector.add(new SelectorItemInfo("OrgUnit.displayName"));
            selector.add(new SelectorItemInfo("description"));
            info = TrainPlanFactory.getLocalInstance(ctx).getTrainPlanInfo((IObjectPK)new ObjectUuidPK(id), selector);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)e.getCause());
            return null;
        }
        return info;
    }

    public static String getTrainPlanActivityDataXML(HttpServletRequest request, String trainPlanId) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        int COLS = 26;
        if (trainPlanId == null) {
            return TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        String xmlData = null;
        ArrayList<Object> list = new ArrayList<Object>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("trainPlan.id", (Object)trainPlanId));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("trainItem.name"));
        selector.add(new SelectorItemInfo("trainItem.treeid.name"));
        selector.add(new SelectorItemInfo("Name"));
        selector.add(new SelectorItemInfo("type.name"));
        selector.add(new SelectorItemInfo("trainMethod.name"));
        selector.add(new SelectorItemInfo("needExam"));
        selector.add(new SelectorItemInfo("assessMethod.name"));
        selector.add(new SelectorItemInfo("passStand"));
        selector.add(new SelectorItemInfo("certificateName"));
        selector.add(new SelectorItemInfo("Cost"));
        selector.add(new SelectorItemInfo("OrgUnit.name"));
        selector.add(new SelectorItemInfo("TrainObject"));
        selector.add(new SelectorItemInfo("Responser.name"));
        selector.add(new SelectorItemInfo("Target"));
        selector.add(new SelectorItemInfo("periodCount"));
        selector.add(new SelectorItemInfo("TrainStartDate"));
        selector.add(new SelectorItemInfo("TrainAddress"));
        selector.add(new SelectorItemInfo("examTime"));
        selector.add(new SelectorItemInfo("examAddress"));
        selector.add(new SelectorItemInfo("invigilator.name"));
        selector.add(new SelectorItemInfo("trainPlanPersonCount"));
        selector.add(new SelectorItemInfo("trainType"));
        selector.add(new SelectorItemInfo("trainCatagory.name"));
        selector.add(new SelectorItemInfo("remark"));
        TrainPlanTrainPlanActivityCollection coll = null;
        try {
            coll = TrainPlanTrainPlanActivityFactory.getLocalInstance(ctx).getTrainPlanTrainPlanActivityCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getCause());
            return TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        if (coll == null || coll.size() < 1) {
            return TrainWebUtils.makeProcDataToXMLData(null, COLS);
        }
        int size = coll.size();
        list.add("" + size);
        TrainPlanTrainPlanActivityInfo info = null;
        DecimalFormat format = new DecimalFormat("0.00");
        DecimalFormat format1 = new DecimalFormat("0");
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < size; ++i) {
            String[] array = new String[COLS];
            info = coll.get(i);
            array[0] = info.getId().toString();
            array[1] = info.getTrainItem() != null ? info.getTrainItem().getName() : "";
            array[2] = info.getTrainItem() != null && info.getTrainItem().getTreeid() != null ? info.getTrainItem().getTreeid().getName() : "";
            array[3] = info.getName();
            array[4] = info.getTrainType() != null ? info.getTrainType().toString() : "";
            array[5] = info.getTrainCatagory() != null ? info.getTrainCatagory().getName() : "";
            array[6] = info.getType() != null ? info.getType().getName() : "";
            array[7] = info.getTrainObject();
            array[8] = info.getTrainPlanPersonCount() != null ? format.format(info.getTrainPlanPersonCount()) : "";
            array[9] = info.getRemark();
            array[10] = info.getExamAddress();
            array[11] = info.getTrainMethod() != null ? info.getTrainMethod().getName() : "";
            array[12] = info.getPeriodCount() != null ? format1.format(info.getPeriodCount()) : "";
            array[13] = info.isNeedExam() ? ResourceBase.getString((String)RES, (String)"yes", (Locale)ctx.getLocale()) : ResourceBase.getString((String)RES, (String)"no", (Locale)ctx.getLocale());
            array[14] = info.getAssessMethod() != null ? info.getAssessMethod().getName() : "";
            array[15] = info.getPassStand() != null ? format.format(info.getPassStand()) : "";
            array[16] = info.getCertificateName();
            if (info.getCost() != null) {
                array[17] = format.format(info.getCost());
                array[18] = info.getPeriodCount() != null ? format.format(info.getCost().multiply(info.getPeriodCount())) : "";
            } else {
                array[17] = "";
                array[18] = "";
            }
            array[19] = info.getOrgUnit() != null ? info.getOrgUnit().getName() : "";
            array[20] = info.getResponser() != null ? info.getResponser().getName() : "";
            array[21] = info.getTarget();
            array[22] = info.getTrainStartDate() != null ? formater.format(info.getTrainStartDate()) : "";
            array[23] = info.getTrainAddress();
            array[24] = info.getExamTime() != null ? formater.format(info.getExamTime()) : "";
            array[25] = info.getInvigilator() != null ? info.getInvigilator().getName() : "";
            list.add(array);
        }
        xmlData = TrainWebUtils.makeProcDataToXMLData(list, COLS);
        return xmlData;
    }

    public static String getTrainCourseDataXML(HttpServletRequest request, String trainPlanActivityId) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        int COLS = 14;
        if (trainPlanActivityId == null || "".equals(trainPlanActivityId)) {
            return TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        String xmlData = null;
        ArrayList<Object> list = new ArrayList<Object>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("trainPlanActivity.id", (Object)trainPlanActivityId));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("StartDate"));
        selector.add(new SelectorItemInfo("EndDate"));
        selector.add(new SelectorItemInfo("TrainAddress"));
        selector.add(new SelectorItemInfo("Cost"));
        selector.add(new SelectorItemInfo("TrainCourse.number"));
        selector.add(new SelectorItemInfo("TrainCourse.name"));
        selector.add(new SelectorItemInfo("TrainCourse.treeid.name"));
        selector.add(new SelectorItemInfo("TrainCourse.CourseKind.name"));
        selector.add(new SelectorItemInfo("TrainingMethod.name"));
        selector.add(new SelectorItemInfo("LessonHour"));
        selector.add(new SelectorItemInfo("timeUnit"));
        selector.add(new SelectorItemInfo("chanelE1.trainChannel.name"));
        selector.add(new SelectorItemInfo("chanelE1.Instructor.name"));
        TrainPlanCourseCollection coll = null;
        try {
            coll = TrainPlanCourseFactory.getLocalInstance(ctx).getTrainPlanCourseCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getCause());
            return TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        if (coll == null || coll.size() < 1) {
            return TrainWebUtils.makeProcDataToXMLData(null, COLS);
        }
        int size = coll.size();
        list.add("" + size);
        TrainPlanCourseInfo info = null;
        DecimalFormat format = new DecimalFormat("0.00");
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < size; ++i) {
            String[] array = new String[COLS];
            info = coll.get(i);
            array[0] = info.getId().toString();
            if (info.getTrainCourse() != null) {
                array[1] = info.getTrainCourse().getNumber();
                array[2] = info.getTrainCourse().getName();
                array[3] = info.getTrainCourse().getTreeid() != null ? info.getTrainCourse().getTreeid().getName() : "";
                array[4] = info.getTrainCourse().getCourseKind() != null ? info.getTrainCourse().getCourseKind().getName() : "";
            } else {
                array[1] = "";
                array[2] = "";
                array[3] = "";
                array[4] = "";
            }
            if (info.getChanelE1() != null) {
                array[5] = info.getChanelE1().getTrainChannel().getName();
                array[6] = info.getChanelE1().getInstructor() != null ? info.getChanelE1().getInstructor().getName() : "";
            } else {
                array[5] = "";
                array[6] = "";
            }
            array[7] = info.getTrainAddress();
            array[8] = info.getTrainingMethod() != null ? info.getTrainingMethod().getName() : "";
            array[9] = info.getCost() != null ? format.format(info.getCost()) : "";
            array[10] = info.getStartDate() != null ? formater.format(info.getStartDate()) : "";
            array[11] = info.getEndDate() != null ? formater.format(info.getEndDate()) : "";
            array[12] = info.getLessonHour() != null ? format.format(info.getLessonHour()) : "";
            array[13] = info.getTimeUnit() != null ? info.getTimeUnit().toString() : "";
            list.add(array);
        }
        xmlData = TrainWebUtils.makeProcDataToXMLData(list, COLS);
        return xmlData;
    }

    public static String getPlanPeriodsDataXML(HttpServletRequest request, String trainPlanActivityId) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        int COLS = 14;
        if (trainPlanActivityId == null || "".equals(trainPlanActivityId)) {
            return TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        String xmlData = null;
        ArrayList<Object> list = new ArrayList<Object>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("planActivity.id", (Object)trainPlanActivityId));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("description"));
        selector.add(new SelectorItemInfo("StartDate"));
        selector.add(new SelectorItemInfo("EndDate"));
        selector.add(new SelectorItemInfo("IsExeuted"));
        selector.add(new SelectorItemInfo("responser.name"));
        selector.add(new SelectorItemInfo("examTime"));
        selector.add(new SelectorItemInfo("examAddress"));
        selector.add(new SelectorItemInfo("trainAddress"));
        selector.add(new SelectorItemInfo("invigilator.name"));
        TrainExePeriodCollection coll = null;
        try {
            coll = TrainExePeriodFactory.getLocalInstance(ctx).getTrainExePeriodCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getCause());
            return TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        if (coll == null || coll.size() < 1) {
            return TrainWebUtils.makeProcDataToXMLData(null, COLS);
        }
        int size = coll.size();
        list.add("" + size);
        TrainExePeriodInfo info = null;
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < size; ++i) {
            String[] array = new String[COLS];
            info = coll.get(i);
            array[0] = info.getId().toString();
            array[1] = info.isIsExeuted() ? ResourceBase.getString((String)RES, (String)"yes", (Locale)ctx.getLocale()) : ResourceBase.getString((String)RES, (String)"no", (Locale)ctx.getLocale());
            array[2] = info.getName();
            array[3] = info.getStartDate() != null ? formater.format(info.getStartDate()) : "";
            array[4] = info.getEndDate() != null ? formater.format(info.getEndDate()) : "";
            array[5] = info.getResponser() != null ? info.getResponser().getName() : "";
            array[6] = info.getTrainAddress();
            array[7] = info.getExamTime() != null ? formater.format(info.getExamTime()) : "";
            array[8] = info.getExamAddress();
            array[9] = info.getInvigilator() != null ? info.getInvigilator().getName() : "";
            array[10] = info.getDescription(ctx.getLocale());
            list.add(array);
        }
        xmlData = TrainWebUtils.makeProcDataToXMLData(list, COLS);
        return xmlData;
    }
}

