/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.web;

import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class TrainWebUtils {
    private static final String procCatalogResource = "com.kingdee.eas.hr.train.TrainWebResource";

    public static String makeErrorProcDataToXMLData(int nCols) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<root>");
        buffer.append("<reccordcount>");
        buffer.append(-1);
        buffer.append("</reccordcount>");
        buffer.append("<data>");
        buffer.append(EASResource.getString((String)procCatalogResource, (String)"fetchDataError"));
        buffer.append("</data>");
        buffer.append("</root>");
        return buffer.toString();
    }

    public static String makeProcDataToXMLData(ArrayList list, int nCols) {
        StringBuffer buffer = new StringBuffer();
        if (list == null || list.size() == 0 || list.size() == 1) {
            buffer.append("<root>");
            buffer.append("<reccordcount>");
            buffer.append(0);
            buffer.append("</reccordcount>");
            buffer.append("<data>");
            for (int j = 0; j < nCols; ++j) {
                buffer.append("");
                buffer.append("|");
            }
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~!~");
            buffer.append("</data>");
            buffer.append("</root>");
            return buffer.toString();
        }
        return TrainWebUtils.makeProcDataToXMLData(list);
    }

    public static String makeProcDataToXMLData(ArrayList list) {
        StringBuffer buffer = new StringBuffer();
        if (list == null) {
            buffer.append("<root>");
            buffer.append("<reccordcount>");
            buffer.append(0);
            buffer.append("</reccordcount>");
            buffer.append("<data>");
            buffer.append("</data>");
            buffer.append("</root>");
            return buffer.toString();
        }
        int nSize = list.size();
        int nNum = 0;
        String[] dataArray = null;
        buffer.append("<root>");
        buffer.append("<reccordcount>");
        buffer.append(list.get(0));
        buffer.append("</reccordcount>");
        buffer.append("<data>");
        String tempData = "";
        for (int i = 1; i < nSize; ++i) {
            dataArray = (String[])list.get(i);
            nNum = dataArray.length;
            for (int j = 0; j < nNum; ++j) {
                tempData = TrainWebUtils.encodeHtmlEpecialChar(dataArray[j]);
                buffer.append(tempData);
                buffer.append("|");
            }
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~!~");
        }
        buffer.append("</data>");
        buffer.append("</root>");
        return buffer.toString();
    }

    public static String encodeHtmlEpecialChar(String html) {
        if (html == null) {
            return "";
        }
        if (html.indexOf("&") >= 0) {
            html = html.replaceAll("&", "&amp;");
        }
        if (html.indexOf("<") >= 0) {
            html = html.replaceAll("<", "&lt;");
        }
        if (html.indexOf(">") >= 0) {
            html = html.replaceAll(">", "&gt;");
        }
        if (html.indexOf("\"") >= 0) {
            html = html.replaceAll("\"", "&quot;");
        }
        if (html.indexOf("'") >= 0) {
            html = html.replaceAll("'", "&apos;");
        }
        if (html.indexOf("\uffe0") >= 0) {
            html = html.replaceAll("\uffe0", "&cent;");
        }
        if (html.indexOf("?") >= 0) {
            html = html.replaceAll("?", "&pound;");
        }
        if (html.indexOf("\u00a7") >= 0) {
            html = html.replaceAll("\u00a7", "&sect;");
        }
        if (html.indexOf("\u00d7") >= 0) {
            html.replaceAll("\u00d7", "&times;");
        }
        if (html.indexOf("\u00f7") >= 0) {
            html.replaceAll("\u00f7", "&divide;");
        }
        if (html.indexOf(" ") >= 0) {
            html.replaceAll(" ", "&nbsp;");
        }
        return html;
    }

    public static String makeAllProcDataToXMLData(ArrayList list, int nCols) {
        StringBuffer buffer = new StringBuffer();
        int nSize = 0;
        if (list != null) {
            nSize = list.size();
        }
        if (list == null || nSize == 1) {
            buffer.append("<root>");
            buffer.append("<reccordcount>");
            buffer.append(0);
            buffer.append("</reccordcount>");
            buffer.append("<data>");
            for (int j = 0; j < nCols; ++j) {
                buffer.append("");
                buffer.append("|");
            }
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~!~");
            buffer.append("</data>");
            buffer.append("</root>");
            return buffer.toString();
        }
        int nNum = 0;
        String[] dataArray = null;
        buffer.append("<root>");
        buffer.append("<reccordcount>");
        buffer.append(list.get(0));
        buffer.append("</reccordcount>");
        buffer.append("<data>");
        String tempData = "";
        for (int i = 1; i < nSize; ++i) {
            dataArray = (String[])list.get(i);
            nNum = dataArray.length;
            for (int j = 0; j < nNum; ++j) {
                tempData = TrainWebUtils.encodeHtmlEpecialChar(dataArray[j]);
                buffer.append(tempData);
                buffer.append("|");
            }
            buffer.append("~#~");
            buffer.append("");
            buffer.append("~#~");
            if (dataArray[5] != null && dataArray[5].length() > 0) {
                buffer.append("#FFFDDF");
            } else {
                buffer.append("");
            }
            buffer.append("~!~");
        }
        buffer.append("</data>");
        buffer.append("</root>");
        return buffer.toString();
    }

    public static ArrayList sortStringArray(ArrayList array, int index, String sortType, int colNumber) {
        int i;
        ArrayList<Object> list = new ArrayList<Object>();
        HashSet<Object> set = new HashSet<Object>();
        DecimalFormat format = new DecimalFormat("0.00");
        list.add(array.get(0).toString());
        Object[] sArray = null;
        Object[] indexArray = null;
        String[] newArray = null;
        int size = array.size();
        for (int i2 = 1; i2 < size; ++i2) {
            sArray = (Object[])array.get(i2);
            if (sArray[index] == null) {
                sArray[index] = index == 5 ? new BigDecimal("-1") : "";
            }
            set.add(sArray[index]);
        }
        indexArray = set.toArray();
        Arrays.sort(indexArray);
        int newIndex = 1;
        if ("desc".equalsIgnoreCase(sortType)) {
            for (i = indexArray.length - 1; i >= 0; --i) {
                int size2 = array.size();
                for (int j = 1; j < size2; ++j) {
                    sArray = (Object[])array.get(j);
                    if (!indexArray[i].equals(sArray[index])) continue;
                    newArray = new String[colNumber];
                    newArray[0] = "" + newIndex++;
                    for (int m = 1; m < colNumber; ++m) {
                        if (m == 5) {
                            if (((BigDecimal)sArray[5]).compareTo(new BigDecimal("-1")) != 0) {
                                newArray[m] = format.format(sArray[5]);
                                continue;
                            }
                            newArray[m] = "";
                            continue;
                        }
                        newArray[m] = sArray[m].toString();
                    }
                    list.add(newArray);
                }
            }
        } else {
            int length = indexArray.length;
            for (i = 0; i < length; ++i) {
                int size3 = array.size();
                for (int j = 1; j < size3; ++j) {
                    sArray = (Object[])array.get(j);
                    if (!indexArray[i].equals(sArray[index])) continue;
                    newArray = new String[colNumber];
                    newArray[0] = "" + newIndex++;
                    for (int m = 1; m < colNumber; ++m) {
                        if (m == 5) {
                            if (((BigDecimal)sArray[5]).compareTo(new BigDecimal("-1")) != 0) {
                                newArray[m] = format.format(sArray[5]);
                                continue;
                            }
                            newArray[m] = "";
                            continue;
                        }
                        newArray[m] = sArray[m].toString();
                    }
                    list.add(newArray);
                }
            }
        }
        return list;
    }
}

