/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.DecimalFormatEx;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class BgNationalFormatUIUtil {
    public static DateFormat getNationalDateFormat() {
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        if (dtformat == null) {
            dtformat = new SimpleDateFormat();
            ((SimpleDateFormat)dtformat).setDateFormatSymbols(CtrlFormatUtilities.getDateFormatSymbols());
        }
        return dtformat;
    }

    public static DateFormat getNationalDateTimeFormat() {
        DateFormat dtformat = CtrlFormatUtilities.getDateTimeFormat();
        if (dtformat == null) {
            dtformat = new SimpleDateFormat();
            ((SimpleDateFormat)dtformat).setDateFormatSymbols(CtrlFormatUtilities.getDateFormatSymbols());
        }
        return dtformat;
    }

    public static String getNationalDateFormatString() {
        String dtformat = CtrlFormatUtilities.getDateFormatString();
        return dtformat;
    }

    public static String getNationalDateTimeFormatString() {
        String dtformat = CtrlFormatUtilities.getDateTimeFormatString();
        return dtformat;
    }

    public static NumberFormat getNationalDataFormat() {
        NumberFormat dtformat = CtrlFormatUtilities.getDecimalFormat();
        return dtformat;
    }

    public static DecimalFormatEx getNationalDataFormatEx() {
        DecimalFormat dtformat = (DecimalFormat)BgNationalFormatUIUtil.getNationalDataFormat();
        return new DecimalFormatEx(dtformat.toPattern(), dtformat.getDecimalFormatSymbols());
    }

    public static String getNationalDataFormatString() {
        return CtrlFormatUtilities.getDecimalFormatString();
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        return CtrlFormatUtilities.getDecimalFormatSymbols();
    }

    public static String getFormatStringForTable(int precision) {
        if (precision == 0) {
            return "%r-{#,##0}f";
        }
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static String getNumberFormat(int precision) {
        StringBuffer str = new StringBuffer("#,##0");
        if (precision <= 0) {
            return str.toString();
        }
        str.append(".");
        for (int i = 0; i < precision; ++i) {
            str.append("0");
        }
        return str.toString();
    }

    public static void setNumberFormat(KDTable tbl, IColumn column, boolean isRight) {
        BgNationalFormatUIUtil.setNumberEditor(tbl, column, isRight);
        BgNationalFormatUIUtil.setNumberDisplayFormat(column);
    }

    public static void setNumberEditor(KDTable tbl, IColumn column, boolean isRight) {
        if (column != null) {
            KDFormattedTextField formatField = new KDFormattedTextField();
            BgNationalFormatUIUtil.setNumberFormatField(formatField, isRight);
            KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((JTextField)formatField);
            column.setEditor((ICellEditor)itemEditor);
        }
    }

    public static void setNumberFormatField(KDFormattedTextField formatField, boolean isRight) {
        formatField.setDataType(1);
        formatField.setSupportedEmpty(true);
        NumberFormatter format = new NumberFormatter(new DecimalFormat(BgNationalFormatUIUtil.getNationalDataFormatString(), BgNationalFormatUIUtil.getDecimalFormatSymbols()));
        DefaultFormatterFactory dff = new DefaultFormatterFactory(format);
        dff.setDisplayFormatter(format);
        dff.setEditFormatter(format);
        formatField.setFormatterFactory((JFormattedTextField.AbstractFormatterFactory)dff);
        formatField.reInstallEditFormater();
        if (isRight) {
            formatField.setHorizontalAlignment(4);
        }
    }

    public static DecimalFormat getDecimalFormat(int precision) {
        return new DecimalFormat(BgNationalFormatUIUtil.getNumberFormat(precision), BgNationalFormatUIUtil.getDecimalFormatSymbols());
    }

    public static void setNumberDisplayFormat(IColumn column) {
        if (column != null) {
            column.getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDataFormatString());
        }
    }

    public static void setNumberDisplayFormat(ICell cell) {
        if (cell != null) {
            cell.getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDataFormatString());
        }
    }

    public static BigDecimal getBigDecimal(ICell cell) {
        try {
            if (cell == null || cell.getValue() == null) {
                return null;
            }
            return BgNationalFormatUIUtil.parseToBigDecimal(cell.getValue());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BigDecimal getBigDecimal(Cell cell) {
        try {
            if (cell == null || cell.getValue() == null || cell.getValue().getValue() == null) {
                return null;
            }
            return BgNationalFormatUIUtil.parseToBigDecimal(cell.getValue().getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols(Context ctx) throws BOSException, EASBizException {
        DecimalFormat numberFormat = BgNationalFormatUIUtil.getNumberFormat(ctx);
        if (numberFormat != null) {
            return numberFormat.getDecimalFormatSymbols();
        }
        return null;
    }

    public static DecimalFormat getNumberFormat(Context ctx) throws BOSException, EASBizException {
        Map nationmap = BgNationalFormatUIUtil.getNationalMap(ctx);
        return (DecimalFormat)nationmap.get("numberFormat");
    }

    public static DateFormat getNationalDateFormat(Context ctx) throws BOSException, EASBizException {
        Map nationmap = BgNationalFormatUIUtil.getNationalMap(ctx);
        return (DateFormat)nationmap.get("dateFormat");
    }

    public static DateFormat getNationalDateTimeFormat(Context ctx) throws BOSException, EASBizException {
        Map nationmap = BgNationalFormatUIUtil.getNationalMap(ctx);
        return (DateFormat)nationmap.get("dateTimeFormat");
    }

    public static Map getNationalMap(Context ctx) throws BOSException, EASBizException {
        String languagename = BOSLocaleUtil.getOriginalLocale((Locale)ctx.getLocale()).toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String ouId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        HashMap nationmap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(userId, ouId, languagename);
        return nationmap;
    }

    public static DecimalFormat getNumberFormat(Context ctx, int precision) throws BOSException, EASBizException {
        DecimalFormatSymbols dfs = BgNationalFormatUIUtil.getDecimalFormatSymbols(ctx);
        if (dfs != null) {
            return new DecimalFormat(BgNationalFormatUIUtil.getNumberFormat(precision), dfs);
        }
        return new DecimalFormat(BgNationalFormatUIUtil.getNumberFormat(precision));
    }

    public static BigDecimal parseToBigDecimal(Object obj) throws ParseException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        String text = obj.toString();
        if (text.isEmpty()) {
            return null;
        }
        DecimalFormatSymbols dfs = BgNationalFormatUIUtil.getDecimalFormatSymbols();
        text = text.replaceAll("\\" + dfs.getGroupingSeparator(), "");
        text = text.replaceAll("\\" + dfs.getDecimalSeparator(), "\\.");
        return new BigDecimal(text);
    }

    public static void setDateTimeColumnFormat(IColumn col) {
        col.getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateTimeFormatString());
    }

    public static void setDateTimeOrNumberFormat(KDTable table) {
        if (table != null) {
            table.checkParsed();
            for (int i = 0; i < table.getColumnCount(); ++i) {
                IColumn col = table.getColumn(i);
                String format = col.getStyleAttributes().getNumberFormat();
                if (StringUtils.isEmpty((String)format)) continue;
                boolean isDate = false;
                boolean isTime = false;
                if ((format = format.toLowerCase()).indexOf("yyyy-mm-dd h:mm:ss") >= 0) {
                    isTime = true;
                } else if (format.indexOf("yyyy-mm-dd hh:mm:ss") >= 0) {
                    isTime = true;
                } else if (format.indexOf("yyyy-mm-dd") >= 0) {
                    isDate = true;
                } else if (format.indexOf("yyyy-m-d") >= 0) {
                    isDate = true;
                }
                if (isDate) {
                    col.getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
                    continue;
                }
                if (!isTime) continue;
                col.getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateTimeFormatString());
            }
        }
    }
}

