/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountGroupFactory;
import com.kingdee.eas.ma.base.BgAccountGroupInfo;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.IBgAccountGroup;
import com.kingdee.eas.ma.base.RptSrcTypeEnum;
import com.kingdee.eas.ma.base.client.AbstractBgAccountGroupEdit;
import com.kingdee.eas.ma.base.client.BgAccountListUI;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class BgAccountGroupEdit
extends AbstractBgAccountGroupEdit {
    private static final long serialVersionUID = -9196761587813234340L;
    private boolean isRelease = false;
    private static final Logger logger = CoreUIObject.getLogger(BgAccountGroupEdit.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtOrgunit.setEnabled(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.isRelease = true;
    }

    protected void loadData() throws Exception {
        super.loadData();
        this.initPrmtOrgUnit();
        this.disEnabelTxtNumber();
        if ("ACG".equals(this.txtNumber.getText())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
    }

    private void disEnabelTxtNumber() throws Exception {
        if (OprtState.EDIT.equals(this.getOprtState()) || this.editData.getId() != null) {
            if (this.getBizInterface().isHasAccount((IObjectPK)new ObjectUuidPK(this.editData.getId()))) {
                this.txtNumber.setEditable(false);
                this.txtNumber.setEnabled(false);
            }
        } else {
            this.txtNumber.setEditable(true);
            this.txtNumber.setEnabled(true);
        }
    }

    private void initPrmtOrgUnit() throws EASBizException, BOSException {
        CostCenterOrgUnitInfo unitInfo = null;
        String curUnitID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        String optState = this.getOprtState();
        if (OprtState.ADDNEW.equals(optState)) {
            unitInfo = (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        } else if (OprtState.EDIT.equals(optState) || OprtState.VIEW.equals(optState)) {
            unitInfo = this.editData.getOrgunit();
        }
        if (unitInfo != null && unitInfo.getId() != null) {
            unitInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getId()));
            BgCommCHelper.initOrgUnit((CoreUIObject)this, this.prmtOrgunit, unitInfo, curUnitID);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            BgCommCHelper.disableAction((JButton)this.btnSubmit, null);
            this.prmtOrgunit.setEnabled(false);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getGroupEditPermission());
        this.checkViewIsDistribute(false);
        super.actionEdit_actionPerformed(e);
        this.disEnabelTxtNumber();
    }

    private OrgUnitInfo getOrgUnit() {
        CostCenterOrgUnitInfo unitInfo = null;
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            unitInfo = (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        } else if ((OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) && (unitInfo = this.editData.getOrgunit()) == null) {
            unitInfo = (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        }
        return unitInfo;
    }

    private void checkViewIsDistribute(boolean isDelete) {
        BgAccountGroupInfo group = this.editData;
        if (group != null) {
            String distribute;
            String id = group.getId().toString();
            String number = group.getNumber();
            if ("ACG".equals(number)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)(isDelete ? "DefaultAccGroupDelete" : "DefaultAccGroupEdit")));
                SysUtil.abort();
            }
            if (group.getDistributeViewRootId() != null && !id.equals(distribute = group.getDistributeViewRootId().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)(isDelete ? "cannotSuperGoupDelete" : "cannotSuperGoupEdit")));
                SysUtil.abort();
            }
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getGroupAddNewPermission());
        super.actionAddNew_actionPerformed(e);
        this.disEnabelTxtNumber();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getGroupDeletePermission());
        this.checkViewIsDistribute(true);
        BgAccountGroupInfo selectGroupInfo = this.editData;
        BgAccountCollection bgAccountCollection = BgAccountFactory.getRemoteInstance().getBgAccountCollection("where group.id='" + selectGroupInfo.getId() + "'");
        if (bgAccountCollection.size() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"groupHasChild"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        Object object = this.getUIContext().get("Owner");
        if (object instanceof BgAccountListUI) {
            ((BgAccountListUI)((Object)object)).newAccViewNum = this.txtNumber.getText();
        }
        super.actionSubmit_actionPerformed(e);
        if (object instanceof BgAccountListUI) {
            ((BgAccountListUI)((Object)object)).initTree();
            ((BgAccountListUI)((Object)object)).setSelectTreeNode();
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Object selectedItem;
        Object data;
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NumberIsNull"));
                SysUtil.abort();
            } else if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "haveEspecial"));
                SysUtil.abort();
            }
        }
        String text = this.txtNumber.getText();
        if (!StringUtils.isEmpty((String)this.txtNumber.getText()) && "ACG".equals(text)) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "defaultGroupNumber"));
            SysUtil.abort();
        }
        if (BgDBUtils.length(this.txtNumber.getText()) > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NumberIsOverMax", (Object[])new Object[]{80}));
            SysUtil.abort();
        }
        if ((data = ((MultiLangItem)(selectedItem = this.txtName.getModel().getSelectedItem())).getData()) == null || StringUtils.isEmpty((String)data.toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NameIsNull"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        BgAccountGroupInfo info = new BgAccountGroupInfo();
        info.setOrgunit((CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        info.setIsLeaf(true);
        info.setSourceType((RptSrcTypeEnum)((Object)this.getUIContext().get("sourceType")));
        Object data = this.getUIContext().get("ACCVIEWID");
        if (data instanceof BgAccountViewInfo) {
            BgAccountViewInfo bgAccViewInfo = (BgAccountViewInfo)data;
            info.setViewId(bgAccViewInfo);
        }
        return info;
    }

    private void checkCanEdit() {
        String distributeId;
        BgAccountGroupInfo curDataObject = (BgAccountGroupInfo)this.getDataObject();
        if (curDataObject.getId() == null) {
            return;
        }
        String id = curDataObject.getId().toString();
        if (!id.equals(distributeId = curDataObject.getDistributeViewRootId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"cantUpdateViewRootDistribute", (Object[])new Object[]{curDataObject.getNumber()}));
            SysUtil.abort();
        }
    }

    protected IBgAccountGroup getBizInterface() throws Exception {
        return BgAccountGroupFactory.getRemoteInstance();
    }

    public boolean checkBeforeWindowClosing() {
        boolean bclose = super.checkBeforeWindowClosing();
        if (bclose && this.isRelease) {
            BgAccountGroupInfo obj = null;
            if (this.getDataObject() != null) {
                obj = (BgAccountGroupInfo)this.getDataObject();
            }
            if (obj != null && obj.getId() != null) {
                BgAccountHelper.releaseMutexService(obj.getId().toString());
            }
        }
        return bclose;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnAddNew);
        this.toolBar.add((Component)this.btnEdit);
        this.toolBar.add((Component)this.btnSubmit);
        this.toolBar.add((Component)this.btnRemove);
    }

    protected String getGroupAddNewPermission() {
        return "mbg_bgAccountGroup_AddNew";
    }

    protected String getGroupEditPermission() {
        return "mbg_bgAccountGroup_Edit";
    }

    protected String getGroupViewPermission() {
        return "mbg_bgAccountView004_View";
    }

    protected String getGroupDeletePermission() {
        return "mbg_bgAccountGroup_Delete";
    }

    protected String getBgAccountViewPermission() {
        return "mbg_bgAccountGroup_View";
    }
}

