/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountException;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountGroupFactory;
import com.kingdee.eas.ma.base.BgAccountGroupInfo;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgAccountViewCollection;
import com.kingdee.eas.ma.base.BgAccountViewFactory;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertySortCollection;
import com.kingdee.eas.ma.base.BgPropertySortFactory;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.IBgPropertySort;
import com.kingdee.eas.ma.base.IPropertyRefSource;
import com.kingdee.eas.ma.base.PropertyRefSourceFactory;
import com.kingdee.eas.ma.base.RptSrcTypeEnum;
import com.kingdee.eas.ma.base.client.AbstractBgAccountListUI;
import com.kingdee.eas.ma.base.client.BgAccountDistributeUI;
import com.kingdee.eas.ma.base.client.BgAccountEditUI;
import com.kingdee.eas.ma.base.client.BgAccountGroupEdit;
import com.kingdee.eas.ma.base.client.BgAccountSysImportUI;
import com.kingdee.eas.ma.base.client.BgAccountViewDialog;
import com.kingdee.eas.ma.base.client.BgOrgViewF7;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.client.RefDimMemberQueryUI;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgAccountListUI
extends AbstractBgAccountListUI {
    private static final long serialVersionUID = 3542524520945506754L;
    private static final Logger logger = CoreUIObject.getLogger(BgAccountListUI.class);
    protected NumberExpendRender render = new NumberExpendRender(1);
    private boolean isFirstLoadData = true;
    private Color disableColor = BgAccountHelper.disableColor;
    private boolean isTreeChang = true;
    private Map<String, BgPropertyCollection> propertyInfoMap = null;
    private final Map<String, CostCenterOrgUnitInfo> ccMap = new HashMap<String, CostCenterOrgUnitInfo>();
    public String newAccViewNum = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        this.initOrgUnit();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        super.onLoad();
        this.initAccountView();
        this.addPopMenu();
    }

    private void initAccountView() throws BOSException {
        BgAccountViewDialog bgAccountViewDialog = new BgAccountViewDialog();
        bgAccountViewDialog.setOrgUnit((OrgUnitInfo)this.prmtOrgUnit.getData());
        bgAccountViewDialog.setSourceType(this.getSourceType());
        this.prmtBgAccountView.setSelector((KDPromptSelector)bgAccountViewDialog);
        this.prmtBgAccountView.setEditable(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = super.getDefaultFilterForTree();
        if (this.getOrgUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getOrgUnit().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)this.getSourceType().getValue(), CompareType.EQUALS));
            view.setFilter(filter);
            SorterItemInfo sort = new SorterItemInfo("number");
            sort.setSortType(SortType.ASCEND);
            view.getSorter().add(sort);
            BgAccountViewCollection bgAccountViewCollection = BgAccountViewFactory.getRemoteInstance().getBgAccountViewCollection(view);
            if (bgAccountViewCollection != null && bgAccountViewCollection.size() > 0) {
                this.prmtBgAccountView.setData((Object)bgAccountViewCollection.get(0));
            }
        }
    }

    @Override
    protected void prmtBgAccountView_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgAccountView_dataChanged(e);
        this.reSetIsFirstLoadData();
        if (e.getNewValue() == null) {
            this.prmtBgAccountView.setDataNoNotify(e.getOldValue());
            return;
        }
        if (e.getOldValue() != null) {
            this.refreshList();
        }
    }

    public void reSetIsFirstLoadData() {
        this.isFirstLoadData = true;
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        try {
            this.beforeTableFillData();
            IRow row = null;
            String bgPropertyName = null;
            for (int index = e.getFirstRow(); index <= e.getLastRow(); ++index) {
                row = this.tblMain.getRow(index);
                BgPropertyCollection propCol = null;
                if (row.getCell("id").getValue() != null && this.propertyInfoMap != null) {
                    String accountId = row.getCell("id").getValue().toString();
                    int level = (Integer)row.getCell("level").getValue();
                    propCol = this.propertyInfoMap.get(accountId);
                }
                String string = bgPropertyName = row.getCell("bgProperty.name").getValue() == null ? null : row.getCell("bgProperty.name").getValue().toString();
                if (bgPropertyName == null) {
                    row.getCell("bgProperty.name").setValue(propCol);
                }
                if (!(row.getCell("isEnabled").getValue() instanceof Boolean) || !row.getCell("isEnabled").getValue().equals(Boolean.FALSE)) continue;
                row.getStyleAttributes().setBackground(this.disableColor);
            }
            HashSet<String> rootIdSet = new HashSet<String>();
            for (int index = e.getFirstRow(); index <= e.getLastRow(); ++index) {
                row = this.tblMain.getRow(index);
                if (row.getCell("distributeRootID").getValue() == null) continue;
                rootIdSet.add(row.getCell("distributeRootID").getValue().toString());
            }
            EntityViewInfo evi = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("orgUnit.name");
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", rootIdSet, CompareType.INCLUDE));
            evi.setSelector(sic);
            evi.setFilter(filterInfo);
            BgAccountCollection colls = BgAccountFactory.getRemoteInstance().getBgAccountCollection(evi);
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < colls.size(); ++i) {
                map.put(colls.get(i).getId().toString(), colls.get(i).getOrgUnit().getName());
            }
            for (int index = e.getFirstRow(); index <= e.getLastRow(); ++index) {
                row = this.tblMain.getRow(index);
                if (row.getCell("distributeRootID").getValue() == null || row.getCell("id").getValue() == null || row.getCell("distributeRootID").getValue().toString().equals(row.getCell("id").getValue().toString())) continue;
                row.getCell("orgUnit.name").setValue(map.get(row.getCell("distributeRootID").getValue().toString()));
            }
        }
        catch (EASBizException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        catch (BOSException e2) {
            this.handUIExceptionAndAbort((Exception)((Object)e2));
        }
    }

    private void renderGreyColorForRootMember(IRow row) {
        if (row == null) {
            return;
        }
        row.getCell("periodAlgorithm").getStyleAttributes().setBackground(this.disableColor);
        row.getCell("polAlgorithm").getStyleAttributes().setBackground(this.disableColor);
    }

    private void beforeTableFillData() throws EASBizException, BOSException {
        if (this.isFirstLoadData) {
            if (this.getSelectViewInfo() != null && this.getSelectViewInfo().getId() != null) {
                this.propertyInfoMap = this.getPropertyRefSourceInterface().queryPropertysByViewId(this.getSelectViewInfo().getId().toString());
            }
            this.isFirstLoadData = false;
        }
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getGroupAddNewPermission());
        BgAccountViewInfo selectViewInfo = this.getSelectViewInfo();
        if (selectViewInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"notNullAccountView"));
            SysUtil.abort();
        }
        this.checkSealUpOrg();
        super.actionGroupAddNew_actionPerformed(e);
        this.actionRefresh_actionPerformed(e);
    }

    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getGroupEditPermission());
        this.checkSealUpOrg();
        this.checkViewIsDistribute(false);
        if (this.getSelectGroupInfo() != null) {
            BgAccountHelper.isMutex_throwException(this.getSelectGroupInfo().getId().toString(), null);
        }
        super.actionGroupEdit_actionPerformed(e);
    }

    public void actionGroupView_actionPerformed(ActionEvent e) throws Exception {
        BgAccountGroupInfo selectGroupInfo = this.getSelectGroupInfo();
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getGroupViewPermission());
        super.actionGroupView_actionPerformed(e);
        if (selectGroupInfo != null) {
            this.setSelectTreeNode(selectGroupInfo.getNumber());
        }
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getGroupDeletePermission());
        this.checkViewIsDistribute(true);
        if (this.getSelectGroupInfo() != null) {
            BgAccountHelper.isMutex_throwException(this.getSelectGroupInfo().getId().toString(), null);
            BgAccountGroupInfo selectGroupInfo = this.getSelectGroupInfo();
            BgAccountCollection bgAccountCollection = this.getBizInterface().getBgAccountCollection("where group.id='" + selectGroupInfo.getId() + "'");
            if (bgAccountCollection.size() > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"groupHasChild"));
                SysUtil.abort();
            }
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    private void setMessageBarValue(String value) {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)value));
        this.showMessage();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.reSetIsFirstLoadData();
        super.actionRefresh_actionPerformed(e);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.getOrgUnit() != null) {
            return new ObjectUuidPK(this.getOrgUnit().getId());
        }
        return super.getOrgPK(action);
    }

    private OrgUnitInfo getOrgUnit() {
        return (OrgUnitInfo)(this.prmtOrgUnit.getData() instanceof OrgUnitInfo ? this.prmtOrgUnit.getData() : null);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter = viewInfo.getFilter();
        if (filter == null) {
            filter = new FilterInfo();
            viewInfo.setFilter(filter);
        }
        FilterItemInfo itemInfo = new FilterItemInfo("orgUnit.id", (Object)this.getOrgUnit().getId().toString(), CompareType.EQUALS);
        BgCommCHelper.replaceFilterItems(filter, itemInfo);
        FilterInfo treeFilter = this.getTreeFilter(viewInfo);
        try {
            filter.mergeFilter(treeFilter, "and");
        }
        catch (BOSException e) {
            this.handUIException(e);
            logger.error((Object)"", (Throwable)e);
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = super.getDefaultFilterForTree();
        if (this.getOrgUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgunit.id", (Object)this.getOrgUnit().getId().toString(), CompareType.EQUALS));
            BgAccountViewInfo selectViewInfo = this.getSelectViewInfo();
            if (selectViewInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("viewId.id", (Object)selectViewInfo.getId().toString(), CompareType.EQUALS));
                if (this.getSourceType() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)this.getSourceType().getValue(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)"ACG", CompareType.EQUALS));
                    filter.setMaskString("#0 and #1 and #2 or #3");
                }
            } else if (this.getSourceType() != null) {
                filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)this.getSourceType().getValue(), CompareType.EQUALS));
            }
        }
        return filter;
    }

    protected RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    public void checkTreeNodeSelected(ActionEvent e) {
        boolean isNotGroupAddNew;
        KDTreeNode treeNode = this.getSelectedTreeNode();
        ItemAction action = this.getActionFromActionEvent(e);
        boolean bl = isNotGroupAddNew = !action.equals(this.actionGroupAddNew);
        if (this.getSelectViewInfo() == null && isNotGroupAddNew) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"selectView"));
            SysUtil.abort();
        }
        if (isNotGroupAddNew && treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            try {
                this.checkTreeObjectExists(e);
            }
            catch (Exception e1) {
                logger.error((Object)e1);
                SysUtil.abort();
            }
        }
    }

    private void checkTreeObjectExists(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode.getUserObject() == null) {
            return;
        }
        if (!this.getTreeInterface().exists((IObjectPK)new ObjectUuidPK(((TreeBaseInfo)treeNode.getUserObject()).getId().toString()))) {
            this.refresh(e);
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        this.reSetIsFirstLoadData();
        Object newValue = e.getNewValue();
        Object oldValue = e.getOldValue();
        if (oldValue != null && newValue == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"CostCenterIsNull"));
            this.prmtOrgUnit.setValue(e.getOldValue());
            return;
        }
        if (!newValue.equals(oldValue) && newValue instanceof OrgUnitInfo && this.getOrgUnit() != null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getOrgUnit().getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("sourceType", (Object)this.getSourceType().getValue(), CompareType.EQUALS));
            SorterItemCollection sort = new SorterItemCollection();
            sort.add(new SorterItemInfo("number"));
            evi.setSorter(sort);
            BgAccountViewCollection bgAccountViewCollection = BgAccountViewFactory.getRemoteInstance().getBgAccountViewCollection(evi);
            KDPromptSelector selector = this.prmtBgAccountView.getSelector();
            if (selector instanceof BgAccountViewDialog) {
                ((BgAccountViewDialog)selector).setOrgUnit(this.getOrgUnit());
                ((BgAccountViewDialog)selector).setSourceType(this.getSourceType());
            }
            if (!bgAccountViewCollection.isEmpty()) {
                this.prmtBgAccountView.setDataNoNotify((Object)bgAccountViewCollection.get(0));
            } else {
                this.prmtBgAccountView.setDataNoNotify(null);
            }
            if (e.getOldValue() != null) {
                BgAccountGroupInfo group = this.getSelectGroupInfo();
                this.refreshList();
                if (group != null) {
                    this.setSelectTreeNode(group.getNumber());
                }
            }
        }
    }

    protected void initOrgUnit() {
        OrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        CtrlUnitInfo CU = SysContext.getSysContext().getCurrentCtrlUnit();
        this.prmtOrgUnit.setEditable(false);
        BgCommCHelper.initOrgUnit((CoreUIObject)this, this.prmtOrgUnit, (Object)unitInfo, CU.getId().toString(), this.getListPermission());
        if (this.prmtOrgUnit.getSelector() instanceof BgOrgViewF7) {
            ((BgOrgViewF7)this.prmtOrgUnit.getSelector()).setContainSealUp(true);
        }
    }

    protected void initPopmenu() {
        JPopupMenu menu = this.treeMain.getPopupMenu();
        EventListener[] ls = this.treeMain.getListeners(TreePopupMenuListener.class);
        if (ls == null || ls.length == 0) {
            menu.removeAll();
        }
        super.initPopmenu();
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        CostCenterOrgUnitInfo selectOrgUnitInfo = this.getPrmptOrgUnitData();
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)selectOrgUnitInfo);
        uiContext.put((Object)"sourceType", (Object)this.getSourceType());
        uiContext.put((Object)"ACCVIEWID", (Object)this.getSelectViewInfo());
        super.prepareGroupUIContext(uiContext, e);
    }

    protected CostCenterOrgUnitInfo getPrmptOrgUnitData() {
        CostCenterOrgUnitInfo selectOrgUnitInfo = null;
        Object obj = this.prmtOrgUnit.getData();
        if (obj instanceof CostCenterOrgUnitInfo) {
            selectOrgUnitInfo = (CostCenterOrgUnitInfo)obj;
        } else if (obj instanceof FullOrgUnitInfo) {
            String orgID = ((FullOrgUnitInfo)obj).getId().toString();
            try {
                if (this.ccMap.containsKey(orgID)) {
                    return this.ccMap.get(orgID);
                }
                selectOrgUnitInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
                this.ccMap.put(orgID, selectOrgUnitInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                this.handUIException(e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
                this.handUIException(e);
            }
        }
        return selectOrgUnitInfo;
    }

    protected void initTree() throws Exception {
        super.initTree();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        BgCommCHelper.disableVisible((JButton)this.btnGroupMoveTree, (JMenuItem)this.menuItemGroupMoveTree, (ItemAction)this.actionGroupMoveTree);
    }

    protected IBgAccount getBizInterface() throws Exception {
        return BgAccountFactory.getRemoteInstance();
    }

    protected IPropertyRefSource getPropertyRefSourceInterface() throws BOSException {
        return PropertyRefSourceFactory.getRemoteInstance();
    }

    protected String getGroupEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isIgnoreTreeCUFilter() {
        return true;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    protected void refresh(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        ItemAction action = null;
        if (e != null) {
            action = this.getActionFromActionEvent(e);
        }
        if (action == null) {
            this.execQuery();
            return;
        }
        if (action.equals(this.actionView) && this.isModify) {
            this.execQuery();
            return;
        }
        if (action.equals(this.actionGroupEdit)) {
            TreePath oldPath = this.treeMain.getSelectionPath();
            this.initTree();
            this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath));
        } else {
            super.refresh(e);
        }
        if ((this.treeMain.getSelectionPath() == null || this.treeMain.getSelectionPath().getLastPathComponent() == this.treeMain.getModel().getRoot()) && this.treeMain.getRowCount() > 0) {
            this.treeMain.setSelectionRow(0);
        } else if (this.treeMain.getSelectionPath() == null) {
            this.tblMain.removeRows();
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                BgAccountListUI.this.setTableDisplayStyle(start, end);
            }
        });
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo, expandInfo.isExpandStatus());
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo, boolean isExpandStatus) {
        int rowIndex;
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = parentExpandInfo.getLongNumber();
        NumberExpandInfo expandInfo = null;
        int rowCount = this.tblMain.getRowCount3();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            for (rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                child = this.tblMain.getRow(rowIndex);
                if (child == null || child.getCell("number") == null) {
                    return;
                }
                expandInfo = (NumberExpandInfo)child.getCell("number").getValue();
                if (expandInfo == null) continue;
                longNumber = expandInfo.getLongNumber();
                if (longNumber.startsWith(parentLongNumber + "!")) {
                    expandInfo.setExpandStatus(false);
                    child.getStyleAttributes().setHided(true);
                    continue;
                }
                break;
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            while (rowIndex < rowCount) {
                child = this.tblMain.getRow(rowIndex);
                expandInfo = (NumberExpandInfo)child.getCell("number").getValue();
                if (expandInfo != null) {
                    longNumber = expandInfo.getLongNumber();
                    if (!longNumber.startsWith(parentLongNumber + "!")) break;
                    if (expandInfo.getLevel() - parentLevel == 1) {
                        child.getStyleAttributes().setHided(false);
                        if (!expandInfo.isLeaf()) {
                            expandInfo.setExpandStatus(false);
                        }
                    }
                }
                ++rowIndex;
            }
        }
    }

    private void setTableDisplayStyle(int startup, int end) {
        IRow row = null;
        int level = 0;
        Object obj = null;
        NumberExpandInfo expandInfo = null;
        int count = end;
        for (int i = startup; i <= count; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            String id = (String)row.getCell("id").getValue();
            obj = row.getCell("number").getValue();
            if (!(obj instanceof String)) {
                return;
            }
            String number = (String)obj;
            String longNumber = row.getCell("longNumber").getValue().toString();
            level = (Integer)row.getCell("level").getValue();
            boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setName(number);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)expandInfo);
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.render);
    }

    protected void addPopMenu() {
        AbstractAction levelOutAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow row = BgAccountListUI.this.tblMain.getRow(0);
                NumberExpandInfo expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
                BgAccountListUI.this.expandTable(row, expandInfo, false);
                BgAccountListUI.this.tblMain.refresh();
            }
        };
        AbstractAction levelInAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HashSet<Integer> rootIndex = new HashSet<Integer>();
                int count = BgAccountListUI.this.tblMain.getRowCount3();
                for (int i = 0; i < count; ++i) {
                    Integer level;
                    IRow row1 = BgAccountListUI.this.tblMain.getRow(i);
                    Integer n = level = row1.getCell("level").getValue() instanceof Integer ? row1.getCell("level").getValue() : Integer.valueOf(1);
                    if (level != 1) continue;
                    rootIndex.add(i);
                }
                for (Integer index : rootIndex) {
                    IRow row = BgAccountListUI.this.tblMain.getRow(index.intValue());
                    NumberExpandInfo expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
                    BgAccountListUI.this.expandTable(row, expandInfo, true);
                }
            }
        };
        KDTMenuManager menuManager = this.getMenuManager(this.tblMain);
        KDMenuItem levelOut = new KDMenuItem();
        levelOut.setAction((Action)levelOutAction);
        levelOutAction.putValue("Name", EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"levelOut"));
        menuManager.getMenu().add((JMenuItem)levelOut, 0);
        KDMenuItem levelIn = new KDMenuItem();
        levelIn.setAction((Action)levelInAction);
        levelInAction.putValue("Name", EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"levelIn"));
        menuManager.getMenu().add((JMenuItem)levelIn, 1);
        JPopupMenu.Separator kdsp = new JPopupMenu.Separator();
        menuManager.getMenu().add((Component)kdsp, 2);
    }

    private BgPropertySortCollection getAllSortsByType(String type) throws BOSException, EASBizException {
        if (type == null) {
            return null;
        }
        IBgPropertySort iPropertySort = BgPropertySortFactory.getRemoteInstance();
        BgPropertySortCollection sortCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourcetype", (Object)type, CompareType.EQUALS));
        view.setFilter(filter);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        view.setSorter(sort);
        sortCol = iPropertySort.getBgPropertySortCollection(view);
        return sortCol;
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getExportPermission());
        BgFileUtil bgFileUtil = new BgFileUtil();
        KDFileChooser fileChooser = bgFileUtil.getFileChooserForExp((Object)this);
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"outTitle"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        String filePath = BgAccountHelper.fileSelect(fileChooser, (CoreUI)this);
        if (filePath == null) {
            SysUtil.abort();
        }
        Boolean isCreatorHide = this.tblMain.getColumn("creator.name").getStyleAttributes().isHided();
        Boolean isCreateTimeHide = this.tblMain.getColumn("createTime").getStyleAttributes().isHided();
        int addIndex = 1;
        KDSBook kdsBook = new KDSBook("001");
        KDSSheet kdsSheet = new KDSSheet(kdsBook, "001");
        kdsSheet.getSheetStyleAttributes().setFont(new Font(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"font"), 0, 9));
        kdsSheet.getSheetStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        kdsSheet.getSheetStyleAttributes().setNumberFormat("@");
        kdsSheet.setCellValue(0, 0, (Object)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"number") + "*"));
        kdsSheet.setCellValue(0, 1, (Object)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"name") + "*"));
        kdsSheet.setCellValue(0, 2, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"parent.number"));
        kdsSheet.setCellValue(0, 3, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"parent.name"));
        kdsSheet.setCellValue(0, 4, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"level"));
        kdsSheet.setCellValue(0, 5, (Object)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"polAlgorithm") + "*"));
        kdsSheet.setCellValue(0, 6, (Object)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"periodAlgorithm") + "*"));
        kdsSheet.setCellValue(0, 7, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgAccountType"));
        kdsSheet.setCellValue(0, 8, (Object)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgAccountDataType") + "*"));
        kdsSheet.setCellValue(0, 9, (Object)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgDecreditAlgorithm") + "*"));
        kdsSheet.setCellValue(0, 10, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgAccountSort.number"));
        kdsSheet.setCellValue(0, 11, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgAccountSort.name"));
        kdsSheet.setCellValue(0, 12, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"group.number"));
        kdsSheet.setCellValue(0, 13, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"group.name"));
        BgPropertySortCollection propertySortCol = this.getAllSortsByType("E68E9293");
        String sortName = null;
        int step = 0;
        int sortColSize = 0;
        if (propertySortCol != null) {
            sortColSize = propertySortCol.size();
            for (int index = 0; index < sortColSize; ++index) {
                sortName = propertySortCol.get(index).getName();
                kdsSheet.setCellValue(0, 14 + step, (Object)(sortName + EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"propertyNum")));
                kdsSheet.setCellValue(0, 15 + step, (Object)(sortName + EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"propertyName")));
                step += 2;
            }
        }
        if (!isCreatorHide.booleanValue()) {
            kdsSheet.setCellValue(0, 13 + addIndex + step, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"creator.name"));
            ++addIndex;
        }
        if (!isCreateTimeHide.booleanValue()) {
            kdsSheet.setCellValue(0, 13 + addIndex + step, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"createTime"));
            ++addIndex;
        }
        kdsSheet.setCellValue(0, 13 + addIndex + step, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"description"));
        kdsSheet.setCellValue(0, 13 + addIndex + step + 1, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"isEnabled"));
        kdsSheet.setCellValue(0, 13 + addIndex + step + 2, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"disabledDate"));
        kdsSheet.setCellValue(0, 13 + addIndex + step + 3, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"orgUnit.name"));
        step = 0;
        IRow row = null;
        BgPropertyCollection propertyCol = null;
        int n = this.tblMain.getRowCount3();
        for (int i = 0; i < n; ++i) {
            int addIndexx;
            row = this.tblMain.getRow(i);
            if (row.getCell("number").getValue() != null) {
                kdsSheet.setCellValue(i + 1, 0, (Object)row.getCell("number").getValue().toString());
                kdsSheet.setCellValue(i + 1, 1, (Object)((String)row.getCell("name").getValue()));
                if (row.getCell("parent.name").getValue() != null) {
                    if (row.getCell("parent.name").getValue() instanceof String) {
                        kdsSheet.setCellValue(i + 1, 2, row.getCell("parent.number").getValue());
                        kdsSheet.setCellValue(i + 1, 3, row.getCell("parent.name").getValue());
                    } else if (row.getCell("parent.name").getValue() instanceof BgAccountInfo) {
                        kdsSheet.setCellValue(i + 1, 2, (Object)((BgAccountInfo)row.getCell("parent.name").getValue()).getNumber().toString());
                        kdsSheet.setCellValue(i + 1, 3, (Object)((BgAccountInfo)row.getCell("parent.name").getValue()).getName().toString());
                    }
                }
                kdsSheet.setCellValue(i + 1, 4, row.getCell("level").getValue() != null ? row.getCell("level").getValue().toString() : null);
                kdsSheet.setCellValue(i + 1, 5, row.getCell("polAlgorithm").getValue() != null ? row.getCell("polAlgorithm").getValue().toString() : null);
                kdsSheet.setCellValue(i + 1, 6, row.getCell("periodAlgorithm").getValue() != null ? row.getCell("periodAlgorithm").getValue().toString() : null);
                kdsSheet.setCellValue(i + 1, 7, row.getCell("bgAccountType").getValue() != null ? row.getCell("bgAccountType").getValue().toString() : null);
                kdsSheet.setCellValue(i + 1, 8, row.getCell("bgAccountDataType").getValue() != null ? row.getCell("bgAccountDataType").getValue().toString() : null);
                kdsSheet.setCellValue(i + 1, 9, row.getCell("bgDecreditAlgorithm").getValue() != null ? row.getCell("bgDecreditAlgorithm").getValue().toString() : null);
                kdsSheet.setCellValue(i + 1, 10, row.getCell("bgAccountSort.number").getValue() != null ? row.getCell("bgAccountSort.number").getValue().toString() : null);
                kdsSheet.setCellValue(i + 1, 11, row.getCell("bgAccountSort.name").getValue() != null ? row.getCell("bgAccountSort.name").getValue().toString() : null);
                kdsSheet.setCellValue(i + 1, 12, row.getCell("group.number").getValue() != null ? row.getCell("group.number").getValue().toString() : null);
                kdsSheet.setCellValue(i + 1, 13, row.getCell("group.name").getValue() != null ? row.getCell("group.name").getValue().toString() : null);
                propertyCol = row.getCell("bgProperty.name").getValue() != null ? (BgPropertyCollection)((Object)row.getCell("bgProperty.name").getValue()) : null;
                String sortId = null;
                step = 0;
                for (int in = 0; in < sortColSize && propertySortCol != null; ++in) {
                    sortId = propertySortCol.get(in).getId().toString();
                    boolean isExist = false;
                    if (propertyCol != null) {
                        for (int index = 0; index < propertyCol.size(); ++index) {
                            String propertyName = propertyCol.get(index).getName();
                            String propertyNum = propertyCol.get(index).getNumber();
                            String propertySort = propertyCol.get(index).getBgPropertySort().getId().toString();
                            if (!sortId.equals(propertySort)) continue;
                            kdsSheet.setCellValue(i + 1, 14 + step, (Object)propertyNum);
                            kdsSheet.setCellValue(i + 1, 15 + step, (Object)propertyName);
                            isExist = true;
                            break;
                        }
                    }
                    if (!isExist) {
                        kdsSheet.setCellValue(i + 1, 14 + step, null);
                        kdsSheet.setCellValue(i + 1, 15 + step, null);
                    }
                    step += 2;
                }
                addIndexx = 1;
                if (!isCreatorHide.booleanValue()) {
                    kdsSheet.setCellValue(i + 1, 13 + addIndexx + step, row.getCell("creator.name").getValue() != null ? row.getCell("creator.name").getValue().toString() : null);
                    ++addIndexx;
                }
                if (!isCreateTimeHide.booleanValue()) {
                    kdsSheet.setCellValue(i + 1, 13 + addIndexx + step, row.getCell("createTime").getValue() instanceof Timestamp ? String.valueOf(new Date(((Timestamp)row.getCell("createTime").getValue()).getTime())) : null);
                    ++addIndexx;
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgAccountResource", "errorValue", new Integer[]{i + 1}));
                return;
            }
            kdsSheet.setCellValue(i + 1, 13 + addIndexx + step, row.getCell("description").getValue() != null ? row.getCell("description").getValue().toString() : null);
            kdsSheet.setCellValue(i + 1, 13 + addIndex + step + 1, row.getCell("isEnabled").getValue() != null ? row.getCell("isEnabled").getValue() : null);
            kdsSheet.setCellValue(i + 1, 13 + addIndex + step + 2, row.getCell("disabledDate").getValue() != null ? new SimpleDateFormat("yyyy-MM-dd").format(row.getCell("disabledDate").getValue()).toString() : null);
            kdsSheet.setCellValue(i + 1, 13 + addIndexx + step + 3, row.getCell("orgUnit.name").getValue() != null ? row.getCell("orgUnit.name").getValue().toString() : null);
        }
        File file = new File(filePath);
        if (file.exists()) {
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.tools.datatask.DatataskResource", "fileHasExisted"));
            if (result == 0) {
                if (file.delete()) {
                    file = new File(filePath);
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.tools.datatask.DatataskResource", "openedfile"));
                }
            } else {
                SysUtil.abort();
            }
        }
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            String sen = GlobalFunction.getFileExtension((String)filePath);
            Book temBook = null;
            if (sen.equals("xlsx")) {
                temBook = KDSBookToBook.traslate((KDSBook)kdsBook);
                BookDataWrapper bookDataWrapper = new BookDataWrapper(temBook);
                SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                if (filePath != null) {
                    booksc.write(filePath.replaceAll(" ", ""));
                }
            } else {
                export.exportToExcel(kdsBook, filePath);
            }
            bgFileUtil.storeDefaultPathForEXP(filePath, this.getUIContext());
        }
        catch (RuntimeException e1) {
            SysUtil.abort();
        }
        BgAccountListUI.addLog(null, "mbg_bgAccount_Export");
        this.setMessageBarValue("exportSuccess");
    }

    public static void addLog(Context ctx, String logItem) {
        String logName = " ";
        IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"updateInfo", (BOSObjectType)new BgAccountInfo().getBOSType(), null, (String)logName, (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getImportPermission());
        super.actionImport_actionPerformed(e);
        this.checkSealUpOrg();
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"template", (Object)this.loadTempTable());
        ctx.put((Object)"sourceType", (Object)this.getSourceType());
        if (this.getSelectViewInfo() != null) {
            ctx.put((Object)"viewID", (Object)this.getSelectViewInfo().getId().toString());
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"selectView"));
            SysUtil.abort();
        }
        if (this.getOrgUnit().getId() != null) {
            ctx.put((Object)"orgUnitID", (Object)this.getOrgUnit().getId().toString());
        }
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.base.client.BgAccountImportUI", (Map)ctx, null, OprtState.VIEW);
        window.getUIObject().setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"importTitle"));
        window.show();
        this.actionRefresh_actionPerformed(e);
    }

    private KDTable loadTempTable() throws EASBizException, BOSException {
        KDTable tbl = new KDTable();
        ArrayList<String> tempHeadNumber = new ArrayList<String>();
        tempHeadNumber.add("number");
        tempHeadNumber.add("name");
        tempHeadNumber.add("parent.number");
        tempHeadNumber.add("parent.name");
        tempHeadNumber.add("level");
        tempHeadNumber.add("polAlgorithm");
        tempHeadNumber.add("periodAlgorithm");
        tempHeadNumber.add("bgAccountType");
        tempHeadNumber.add("bgAccountDataType");
        tempHeadNumber.add("bgDecreditAlgorithm");
        tempHeadNumber.add("bgAccountSort.number");
        tempHeadNumber.add("bgAccountSort.name");
        tempHeadNumber.add("group.number");
        tempHeadNumber.add("group.name");
        ArrayList<String> tempHeadName = new ArrayList<String>();
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"number") + "*");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"name") + "*");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"parent.number"));
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"parent.name"));
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"level"));
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"polAlgorithm") + "*");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"periodAlgorithm") + "*");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgAccountType"));
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgAccountDataType") + "*");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgDecreditAlgorithm") + "*");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgAccountSort.number"));
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgAccountSort.name"));
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"group.number"));
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"group.name"));
        BgPropertySortCollection propertySortCol = this.getAllSortsByType("E68E9293");
        String sortName = null;
        int sortColSize = 0;
        if (propertySortCol != null) {
            sortColSize = propertySortCol.size();
            for (int index = 0; index < sortColSize; ++index) {
                sortName = propertySortCol.get(index).getName();
                tempHeadName.add(sortName + EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"propertyNum"));
                tempHeadName.add(sortName + EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"propertyName"));
                tempHeadNumber.add(sortName + EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"propertyNum"));
                tempHeadNumber.add(sortName + EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"propertyName"));
            }
        }
        Boolean isCreatorHide = this.tblMain.getColumn("creator.name").getStyleAttributes().isHided();
        Boolean isCreateTimeHide = this.tblMain.getColumn("createTime").getStyleAttributes().isHided();
        if (!isCreatorHide.booleanValue()) {
            tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"creator.name"));
        }
        if (!isCreateTimeHide.booleanValue()) {
            tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"createTime"));
        }
        tempHeadNumber.add("description");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"description"));
        tempHeadNumber.add("isEnabled");
        tempHeadNumber.add("disabledDate");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"isEnabled"));
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"disabledDate"));
        tempHeadNumber.add("orgUnit.name");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"orgUnit.name"));
        IRow head = tbl.addHeadRow();
        for (int i = 0; i < tempHeadNumber.size(); ++i) {
            IColumn column = tbl.addColumn();
            column.setKey((String)tempHeadNumber.get(i));
            head.getCell(column.getColumnIndex()).setValue(tempHeadName.get(i));
        }
        return tbl;
    }

    @Override
    public void actionSysImport_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node;
        Object userObject2;
        DefaultKingdeeTreeNode root;
        BgAccountGroupInfo group = null;
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof BgAccountGroupInfo) {
            group = (BgAccountGroupInfo)this.getSelectedTreeNode().getUserObject();
        } else if (group == null && (root = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot()) != null && root.getChildCount() != 0 && (userObject2 = (node = (DefaultKingdeeTreeNode)root.getChildAt(0)).getUserObject()) instanceof BgAccountGroupInfo) {
            group = (BgAccountGroupInfo)userObject2;
        }
        if (group == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"selectLeafGroup"));
            SysUtil.abort();
        }
        this.checkSealUpOrg();
        this.reSetIsFirstLoadData();
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getSysImportPermission());
        super.actionSysImport_actionPerformed(e);
        if (this.getSelectViewInfo() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"selectView"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"viewInfo", (Object)this.getSelectViewInfo());
        uiContext.put((Object)"unitInfo", this.prmtOrgUnit.getData());
        uiContext.put((Object)"ACCGROUP", (Object)group);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getSysImportUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.tblMain.refresh();
    }

    @Override
    public void actionDistribute_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getBgAccountDistributePermission());
        this.checkSealUpOrg();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"viewInfo", (Object)this.getSelectViewInfo());
        uiContext.put((Object)"unitInfo", this.prmtOrgUnit.getData());
        uiContext.put((Object)"sourceType", (Object)this.getSourceType());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgAccountDistributeUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getSysImportUIName() {
        return BgAccountSysImportUI.class.getName();
    }

    protected String getListPermission() {
        return "mbg_bgAccount001_list";
    }

    protected String getBgAccountAddNewPermission() {
        return "mbg_bgAccountMem001_addNew";
    }

    protected String getBgAccountEditPermission() {
        return "mbg_bgAccountMem002_edit";
    }

    protected String getBgAccountDeletePermission() {
        return "mbg_bgAccountMem003_delete";
    }

    protected String getBgAccountDistributePermission() {
        return "mbg_bgAccountMem005_distribute";
    }

    protected String getImportPermission() {
        return "mbg_bgAccount007_import";
    }

    protected String getExportPermission() {
        return "mbg_bgAccount008_export";
    }

    protected String getSysImportPermission() {
        return "mbg_bgAccount009_sysImport";
    }

    protected String getPrintPermission() {
        return "mbg_bgAccount010_print";
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getBgAccountAddNewPermission());
        this.checkTreeNodeSelected(e);
        this.checkSealUpOrg();
        super.actionAddNew_actionPerformed(e);
        IUIWindow uiWindow = super.getUIController().getNavigator().getUIWindow();
        if (uiWindow != null && uiWindow.getUIObject() instanceof BgAccountEditUI) {
            ((BgAccountEditUI)uiWindow.getUIObject()).afterShow();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getBgAccountEditPermission());
        this.checkSealUpOrg();
        this.checkMemberIsDistribute();
        super.actionEdit_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        Map resultMap = this.getBizInterface().cancelCancel(ids);
        int locateIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        this.refreshList();
        this.locateTbl(locateIndex);
        BgAccountHelper.showCancelCancelFailMsg((CoreUI)this, resultMap, false, ids);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        Map resultMap = this.getBizInterface().cancel(ids);
        int locateIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        this.refreshList();
        this.locateTbl(locateIndex);
    }

    private void checkMemberIsDistribute() {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        String id = row.getCell("id").getValue().toString();
        String number = row.getCell("number").getValue().toString();
        String selectRootId = row.getCell("distributeRootID").getValue().toString();
        if (!id.equals(selectRootId)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"cantUpdateRootDistribute", (Object[])new Object[]{rowIndex + 1, number}));
            SysUtil.abort();
        }
    }

    private void checkSealUpOrg() {
        CostCenterOrgUnitInfo curOrgUnit = this.getPrmptOrgUnitData();
        if (curOrgUnit != null && curOrgUnit.isIsOUSealUp()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"sealUPOrgCantOper"));
            SysUtil.abort();
        }
    }

    protected String getEditUIName() {
        return BgAccountEditUI.class.getName();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)this.getOrgUnit());
        uiContext.put((Object)"viewInfo", (Object)this.getSelectViewInfo());
        uiContext.put((Object)"costCenterInfo", (Object)this.getPrmptOrgUnitData());
        String id = this.getSelectedKeyValue();
        if (id != null) {
            try {
                uiContext.put((Object)"SELECTED_ACCOUNT", (Object)BgAccountFactory.getRemoteInstance().getDataBaseInfo("select id, number, name, isEnabled, isLeaf, displayName, group.* where id = '" + id + "'"));
            }
            catch (Exception e1) {
                this.handUIExceptionAndAbort(e1);
            }
        } else {
            uiContext.put((Object)"SELECTED_ACCOUNT", null);
        }
        int selectedRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        Object proObj = null;
        Object accType = null;
        if (selectedRowIndex != -1 && this.tblMain.getRow(selectedRowIndex).getCell("bgProperty.name") != null) {
            proObj = this.tblMain.getRow(selectedRowIndex).getCell("bgProperty.name").getValue();
            accType = this.tblMain.getRow(selectedRowIndex).getCell("bgAccountType").getValue();
        }
        uiContext.put((Object)"propertyInfo", proObj);
        uiContext.put((Object)"bgAccountType", accType);
        uiContext.put((Object)"ACCGROUP", (Object)this.getSelectGroupInfo());
    }

    protected void Remove() throws Exception {
        BgPermissionUtil.checkPermission(this.getOrgUnit(), this.getBgAccountDeletePermission());
        ArrayList ids = this.getSelectedIdValues();
        HashSet selectedIds = new HashSet();
        this.deleteMutexAccountIds(ids);
        selectedIds.addAll(ids);
        this.checkSealUpOrg();
        if (!selectedIds.isEmpty()) {
            Map map = this.getBizInterface().deleteBatch(selectedIds);
            if (map.get("delete_result").equals("delete_success")) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"membersDeleteSuccess"));
            } else if (map.get("delete_result").equals("delete_fail")) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"membersDeleteFail"), (String)map.get("delete_fail").toString(), (int)1);
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"membersDeletePartialSuccess"), (String)map.get("delete_result").toString(), (int)1);
            }
        }
    }

    private void checkAccountsHasRefData(Set<String> selectedIds) {
        if (selectedIds == null || selectedIds.isEmpty()) {
            return;
        }
        HashSet refDataIds = null;
        try {
            refDataIds = (HashSet)BgAccountFactory.getRemoteInstance().checkRef(selectedIds, true).get("ref_data");
        }
        catch (Exception e) {
            logger.error((Object)"get refData error", (Throwable)e);
        }
        if (refDataIds != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"accHasRefData"));
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMutexAccountIds(ArrayList ids) throws BgAccountException {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        HashMap<String, EASBizException> exceptionMap = new HashMap<String, EASBizException>();
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)ids);
            Iterator lt = ids.iterator();
            while (lt.hasNext()) {
                String id = (String)lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
                exceptionMap.put(id, mutexException);
                lt.remove();
            }
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)ids);
        }
        if (!exceptionMap.isEmpty()) {
            throw new BgAccountException(BgAccountException.LOCK);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int clickCount;
        super.tblMain_tableClicked(e);
        if (e.getType() == 1) {
            NumberExpandInfo expandInfo;
            IRow row;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount2 = e.getClickCount();
            if (clickCount2 == 1 && (row = this.tblMain.getRow(rowIndex)) != null && colIndex == this.tblMain.getColumn("number").getColumnIndex() && this.render.inRect(expandInfo = (NumberExpandInfo)row.getCell("number").getValue(), e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row, expandInfo);
            }
        }
        if (e.getType() == 0 && (clickCount = e.getClickCount()) == 1) {
            return;
        }
    }

    protected boolean isCanOrderTable() {
        return false;
    }

    public void locateTbl(int locateIndex) {
        if (locateIndex > 0) {
            this.tblMain.getSelectManager().setActiveRowIndex(locateIndex);
            this.tblMain.getSelectManager().select(locateIndex, -1);
        }
        if (this.getTableLocate() != null) {
            this.getTableLocate().locate();
        }
    }

    private BgAccountViewInfo getSelectViewInfo() {
        BgAccountViewInfo bgAccViewInfo = null;
        Object data = this.prmtBgAccountView.getData();
        if (data instanceof BgAccountViewInfo) {
            bgAccViewInfo = (BgAccountViewInfo)data;
        }
        return bgAccViewInfo;
    }

    private BgAccountGroupInfo getSelectGroupInfo() {
        BgAccountGroupInfo group = null;
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof BgAccountGroupInfo) {
            group = (BgAccountGroupInfo)this.getSelectedTreeNode().getUserObject();
        }
        return group;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    private void checkViewIsDistribute(boolean isDelete) {
        BgAccountGroupInfo group = this.getSelectGroupInfo();
        if (group != null) {
            String distribute;
            String id = group.getId().toString();
            String number = group.getNumber();
            if ("ACG".equals(number)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)(isDelete ? "DefaultAccGroupDelete" : "DefaultAccGroupEdit")));
                SysUtil.abort();
            }
            if (group.getDistributeViewRootId() != null && !id.equals(distribute = group.getDistributeViewRootId().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)(isDelete ? "cannotSuperGoupDelete" : "cannotSuperGoupEdit")));
                SysUtil.abort();
            }
        }
    }

    protected String getGroupAddNewPermission() {
        return "mbg_bgAccountGroup_AddNew";
    }

    protected String getGroupEditPermission() {
        return "mbg_bgAccountGroup_Edit";
    }

    protected String getGroupViewPermission() {
        return "mbg_bgAccountGroup_View";
    }

    protected String getGroupDeletePermission() {
        return "mbg_bgAccountGroup_Delete";
    }

    protected String getBgAccountViewPermission() {
        return "mbg_bgAccountView004_View";
    }

    public void setSelectTreeNode() throws Exception {
        KDTreeNode root = (KDTreeNode)this.treeMain.getModel().getRoot();
        BgAccountGroupInfo info = null;
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            KDTreeNode childAt = (KDTreeNode)root.getChildAt(i);
            if (childAt == null || !(childAt.getUserObject() instanceof BgAccountGroupInfo) || !(info = (BgAccountGroupInfo)childAt.getUserObject()).getNumber().toString().equals(this.newAccViewNum)) continue;
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)childAt);
            break;
        }
    }

    public void setSelectTreeNode(String newAccViewNum) throws Exception {
        KDTreeNode root = (KDTreeNode)this.treeMain.getModel().getRoot();
        BgAccountGroupInfo info = null;
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            KDTreeNode childAt = (KDTreeNode)root.getChildAt(i);
            if (childAt == null || !(childAt.getUserObject() instanceof BgAccountGroupInfo) || !(info = (BgAccountGroupInfo)childAt.getUserObject()).getNumber().toString().equals(newAccViewNum)) continue;
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)childAt);
            break;
        }
    }

    protected String getQueryFieldName() {
        return "group.id";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return BgAccountGroupFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        return BgAccountGroupEdit.class.getName();
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        String rootName = this.getRootName();
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof String) {
            String nodeName = (String)this.getSelectedTreeNode().getUserObject();
            if (rootName != null && rootName.equals(nodeName)) {
                this.actionGroupEdit.setEnabled(false);
                this.actionGroupRemove.setEnabled(false);
                this.actionGroupView.setEnabled(false);
            }
        } else {
            this.actionGroupEdit.setEnabled(true);
            this.actionGroupRemove.setEnabled(true);
            this.actionGroupView.setEnabled(true);
        }
        this.reSetIsFirstLoadData();
        super.treeMain_valueChanged(e);
    }

    protected FilterInfo getTreeFilter(EntityViewInfo viewInfo) {
        FilterItemInfo itemInfo = null;
        FilterInfo filter = viewInfo.getFilter();
        BgAccountGroupInfo group = this.getSelectGroupInfo();
        itemInfo = group != null ? new FilterItemInfo(this.getQueryFieldName(), (Object)group.getId().toString(), CompareType.EQUALS) : new FilterItemInfo(this.getQueryFieldName(), null, CompareType.ISNOT);
        BgCommCHelper.replaceFilterItems(filter, itemInfo);
        BgAccountViewInfo selectViewInfo = this.getSelectViewInfo();
        itemInfo = selectViewInfo != null ? new FilterItemInfo("bgAccountView.id", (Object)selectViewInfo.getId().toString(), CompareType.EQUALS) : new FilterItemInfo("bgAccountView.id", (Object)BgBaseConstants.noFindStr, CompareType.EQUALS);
        BgCommCHelper.replaceFilterItems(filter, itemInfo);
        return filter;
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgAccoutGroup");
    }

    protected FilterItemInfo getSingleNodeFilter(TreeBaseInfo treeNode) {
        if (treeNode == null) {
            return null;
        }
        return new FilterItemInfo(this.getQueryFieldName(), (Object)treeNode.getId().toString());
    }

    @Override
    public void actionRefDimMember_actionPerformed(ActionEvent e) throws Exception {
        this.checkSealUpOrg();
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"viewInfo", (Object)this.getSelectViewInfo());
        uiContext.put((Object)"unitInfo", this.prmtOrgUnit.getData());
        uiContext.put((Object)"sourceType", (Object)this.getSourceType());
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex > -1) {
            String memberId = this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
            uiContext.put((Object)"id", (Object)memberId);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(RefDimMemberQueryUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

