/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgAccountSortFactory;
import com.kingdee.eas.ma.base.BgAccountSortInfo;
import com.kingdee.eas.ma.base.IBgAccountSort;
import com.kingdee.eas.ma.base.client.AbstractBgAccountSortEditUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BgAccountSortEditUI
extends AbstractBgAccountSortEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgAccountSortEditUI.class);
    public static final String res = "com.kingdee.eas.ma.base.client.BgAccountSortResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkMenuItemSubmitAndAddNew.setSelected(true);
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
    }

    protected LanguageInfo getCurrentLanguage() {
        return new LanguageInfo(this.getCurrentLocale());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        LanguageInfo currLang = this.getCurrentLanguage();
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr(res, "noNumber"));
                SysUtil.abort();
            } else if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "haveEspecial"));
                SysUtil.abort();
            }
        }
        if (this.txtName.getItemBy(currLang).getData() == null || StringUtils.isEmpty((String)this.txtName.getItemBy(currLang).getData().toString())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr(res, "noName"));
            SysUtil.abort();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setVisible(false);
        this.btnSave.setEnabled(false);
        this.btnCopy.setVisible(false);
        this.btnCopy.setEnabled(false);
        this.btnPageSetup.setVisible(false);
        this.btnPageSetup.setEnabled(false);
        this.btnPrint.setVisible(false);
        this.btnPrint.setEnabled(false);
        this.btnPrintPreview.setVisible(false);
        this.btnPrintPreview.setEnabled(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancelCancel.setEnabled(false);
        this.btnCancel.setVisible(false);
        this.btnCancel.setEnabled(false);
    }

    protected void loadData() throws Exception {
        super.loadData();
    }

    protected IObjectValue createNewData() {
        BgAccountSortInfo bgAccountSortInfo = new BgAccountSortInfo();
        bgAccountSortInfo.setId(BOSUuid.create((BOSObjectType)bgAccountSortInfo.getBOSType()));
        return bgAccountSortInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgAccountSortFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        String number = this.editData.getNumber().toString();
        if (id == null || number == null) {
            return;
        }
        IBgAccountSort iBgAccountSort = BgAccountSortFactory.getRemoteInstance();
        if (iBgAccountSort.isRefByAccount(id)) {
            MsgBox.showWarning((String)EASResource.getString((String)res, (String)"isRefByIndex", (Object[])new String[]{number}));
            return;
        }
        if (iBgAccountSort.isRefByOrgEntrust(id)) {
            MsgBox.showWarning((String)EASResource.getString((String)res, (String)"isRefByOrgEntrust", (Object[])new String[]{number}));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }
}

