/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.POIExportException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.Excel2007Reader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.bos.ctrl.kdf.table.KDTIOManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.client.AbstractBgBaseImportUI;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public abstract class BgBaseImportUI
extends AbstractBgBaseImportUI {
    private static final long serialVersionUID = 7752404031872184038L;
    private static final Logger logger = CoreUIObject.getLogger(BgBaseImportUI.class);
    public static final String IMPORT_RES = "com.kingdee.eas.tools.datatask.DatataskResource";
    private boolean isCheckTempalte = true;
    private Integer errorNum = null;
    private String viewID = null;
    private String orgUnitId = null;

    public Integer getErrorNum() {
        return this.errorNum;
    }

    public void setErrorNum(Integer errorNum) {
        this.errorNum = errorNum;
    }

    public String getViewID() {
        return this.viewID;
    }

    public void setViewID(String viewID) {
        this.viewID = viewID;
    }

    public String getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnOpenFile.setIcon((Icon)((ImageIcon)ResourceBase.getIcon((String)"com.kingdee.eas.tools.datatask.ui.ImageResource.tbtn_open", (Locale)new Locale("L1"))));
        this.panelProgress.setVisible(false);
        this.setBtnState(true);
        this.comboError.removeAllItems();
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
        this.comboError.setSelectedItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        if (this.getUIContext().get("viewID") != null && this.getUIContext().get("viewID") instanceof String) {
            this.setViewID(this.getUIContext().get("viewID").toString());
        }
        if (this.getUIContext().get("orgUnitID") != null && this.getUIContext().get("orgUnitID") instanceof String) {
            this.setOrgUnitId(this.getUIContext().get("orgUnitID").toString());
        }
    }

    private void setBtnState(boolean state) {
        this.btnCancel.setEnabled(state);
        this.btnConfirm.setEnabled(state);
        this.btnOpenFile.setEnabled(state);
        this.btnExportTemplate.setEnabled(state);
        this.btnExportTemplate.setVisible(true);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtFile.getText())) {
            return;
        }
        ProgressThread process = new ProgressThread();
        process.start();
    }

    @Override
    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        BgFileUtil bgFileUtil = new BgFileUtil();
        KDFileChooser fileChooser = bgFileUtil.getFileChooserForImp(this.getUIContext());
        fileChooser.setDialogTitle(this.getImportTitle());
        String filePath = this.fileSelect(fileChooser);
        if (!StringUtils.isEmpty((String)filePath)) {
            this.txtFile.setText(filePath.toString());
            this.txtFile.setUserObject((Object)fileChooser.getSelectedFile());
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().hide();
    }

    protected abstract String getImportTitle();

    @Override
    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        boolean isSuccess;
        BgFileUtil bgFileUtil = new BgFileUtil();
        KDFileChooser fileChooser = bgFileUtil.getFileChooserForExp(this.getUIContext(), "TEMP");
        fileChooser.setDialogTitle(this.getTemplateTitle());
        if (StringUtils.isEmpty((String)this.getTemplateTitle())) {
            fileChooser.setSelectedFile(new File(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgAccountResource", "memOut")));
        } else {
            fileChooser.setSelectedFile(new File(this.getTemplateTitle()));
        }
        String filePath = this.fileSelect(fileChooser);
        KDTable tbl = (KDTable)this.getUIContext().get("template");
        if (!StringUtils.isEmpty((String)filePath) && (isSuccess = this.appendToExcel(filePath, tbl))) {
            bgFileUtil.storeDefaultPathForEXP(filePath, this.getUIContext(), "TEMP");
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgAccountResource", "templetExportSuccess"));
        }
    }

    protected abstract String getTemplateTitle();

    private String fileSelect(KDFileChooser fileChooser) throws BOSException {
        String filePath = null;
        ExcelFile xlsFilter = new ExcelFile();
        Excel2007FileFilter xlsxFilter = new Excel2007FileFilter();
        fileChooser.setFileFilter((FileFilter)xlsxFilter);
        fileChooser.setFileFilter((FileFilter)xlsFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setBounds(10, 10, 200, 200);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            FileFilter fileFilter = fileChooser.getFileFilter();
            if (filePath.lastIndexOf(".") == -1) {
                filePath = fileFilter == xlsxFilter ? filePath + ".xlsx" : filePath + ".xls";
            } else {
                String formatStr = filePath.subSequence(filePath.lastIndexOf("."), filePath.length()).toString();
                if (!formatStr.equals(".xlsx") && !formatStr.equals(".xls")) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"importErrorFormat"));
                    this.destroyWindow();
                    SysUtil.abort();
                }
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        return filePath;
    }

    protected boolean isCheckTemplate() {
        return this.isCheckTempalte;
    }

    private boolean validateTemplate(KDSSheet sheet) {
        if (!this.isCheckTemplate()) {
            return true;
        }
        KDTable tbl = (KDTable)this.getUIContext().get("template");
        String cell = "";
        String tcell = "";
        for (int i = 0; i < tbl.getColumnCount(); ++i) {
            if (sheet.getCell(0, i, false).getValue() != null) {
                cell = tbl.getHeadRow(0).getCell(i).getValue().toString();
                if (cell.equals((tcell = sheet.getCell(0, i, false).getValue().toString()).trim())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean appendToExcel(String filePath, KDTable tbl) throws Exception {
        File file = new File(filePath);
        KDTIOManager ioManager = tbl.getIOManager();
        KDSBook book = null;
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(5);
        try {
            block9: {
                this.progressBar.setValue(1);
                if (file.exists()) {
                    int result = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr(IMPORT_RES, "fileHasExisted"));
                    if (result != 0) return false;
                    if (!file.delete()) {
                        MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr(IMPORT_RES, "openedfile"));
                        this.disableButtons();
                        return false;
                    }
                    file = new File(filePath);
                    book = new KDSBook(file.getName());
                } else {
                    book = new KDSBook(file.getName());
                }
                this.progressBar.setValue(2);
                book.addSheet(null, ioManager.saveToKDSSheet(book, true, false, "Sheet1"));
                this.progressBar.setValue(3);
                ExportManager man = new ExportManager();
                this.progressBar.setValue(4);
                try {
                    String sen = GlobalFunction.getFileExtension((String)filePath);
                    Book temBook = null;
                    if (sen.equals("xlsx")) {
                        temBook = KDSBookToBook.traslate((KDSBook)book);
                        BookDataWrapper bookDataWrapper = new BookDataWrapper(temBook);
                        SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                        if (filePath != null) {
                            booksc.write(filePath.replaceAll(" ", ""));
                        }
                        break block9;
                    }
                    man.exportToExcel(book, filePath);
                }
                catch (POIExportException ex) {
                    MsgBox.showInfo((String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgAccountResource", "importError"));
                }
            }
            this.progressBar.setValue(5);
            return true;
        }
        catch (Exception err) {
            logger.error((Object)"BgBase import error:", (Throwable)err);
            this.handUIException(err);
        }
        return true;
    }

    protected void enableButtons() {
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnOpenFile.setEnabled(true);
        this.txtFile.setEnabled(true);
        this.btnExportTemplate.setEnabled(true);
        this.panelProgress.setVisible(false);
    }

    protected void disableButtons() {
        this.btnConfirm.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.btnOpenFile.setEnabled(false);
        this.txtFile.setEnabled(false);
        this.btnExportTemplate.setEnabled(false);
        this.panelProgress.setVisible(true);
    }

    public Icon getImage() {
        return EASResource.getIcon((String)"imgTransfers_pic260");
    }

    protected abstract void importData(KDSSheet var1);

    public String getNumber(Object value) {
        return value != null ? BgNumberHelper.trimNumber(value.toString().trim()) : null;
    }

    class ProgressThread
    extends Thread {
        ProgressThread() {
        }

        @Override
        public void run() {
            KDSSheet sheet;
            BgBaseImportUI.this.disableButtons();
            BgBaseImportUI.this.setErrorNum(((ErrorHandleModeEnum)BgBaseImportUI.this.comboError.getSelectedItem()).getValue());
            String fileName = BgBaseImportUI.this.txtFile.getText();
            KDSBook book = null;
            try {
                String sen = GlobalFunction.getFileExtension((String)fileName);
                if (sen.equals("xlsx")) {
                    book = POIXlsxReader.parse((String)fileName);
                    if (book == null) {
                        book = new Excel2007Reader().parse(fileName);
                    }
                } else {
                    book = POIXlsReader.parse((String)fileName);
                }
            }
            catch (Exception e1) {
                SysUtil.abort();
            }
            if (book == null) {
                MsgBox.showInfo((String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgAccountResource", "noFile"));
                BgBaseImportUI.this.enableButtons();
                SysUtil.abort();
            }
            if (!BgBaseImportUI.this.validateTemplate(sheet = book.getSheet((Object)new Integer(0)))) {
                MsgBox.showInfo((String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.MbgDimResource", "importErrorFormat"));
                BgBaseImportUI.this.destroyWindow();
                return;
            }
            try {
                BgBaseImportUI.this.importData(sheet);
                BgFileUtil bgFileUtil = new BgFileUtil();
                bgFileUtil.storeDefaultPathForIMP(BgBaseImportUI.this.txtFile, BgBaseImportUI.this.getUIContext());
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
            BgBaseImportUI.this.getUIWindow().hide();
            BgBaseImportUI.this.enableButtons();
        }
    }
}

