/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementDataTypeEnum;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.BGReportUI;
import com.kingdee.eas.ma.base.client.BgBaseImportUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgElementImportUI
extends BgBaseImportUI {
    private static final long serialVersionUID = -2034525193057517865L;
    private static final Logger logger = CoreUIObject.getLogger(BgElementImportUI.class);
    public static final String RESOURCE = "com.kingdee.eas.ma.base.BgScenarioResource";
    Map<Integer, List<String>> errorMap = new HashMap<Integer, List<String>>();

    @Override
    protected String getImportTitle() {
        return BgCommCHelper.getMessageStr(RESOURCE, "tileElement");
    }

    @Override
    protected String getTemplateTitle() {
        return BgCommCHelper.getMessageStr(RESOURCE, "elementTemplate");
    }

    private boolean isNull(Object obj) {
        return obj == null || obj.toString().equals("");
    }

    protected BgElementInfo createNewData() {
        BgElementInfo itemInfo = new BgElementInfo();
        itemInfo.setId(BOSUuid.create((BOSObjectType)itemInfo.getBOSType()));
        itemInfo.setShowData(true);
        return itemInfo;
    }

    @Override
    protected void importData(KDSSheet sheet) {
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        int row_0 = 0;
        int row_1 = 1;
        int row_2 = 2;
        int row_3 = 3;
        int row_4 = 4;
        String number = null;
        String name = null;
        String type = null;
        String isShowData = null;
        String description = null;
        ArrayList<BgElementInfo> elementList = new ArrayList<BgElementInfo>();
        CoreBaseCollection colls = new CoreBaseCollection();
        int errorNum = this.getErrorNum();
        ArrayList errorLst = new ArrayList();
        List<Object> errorItem = new ArrayList();
        BgElementInfo elementInfo = null;
        int forCount = 0;
        this.progressBar.setMaximum(sheet.getRowCount());
        HashMap numberRowMap = new HashMap();
        try {
            int i;
            BgElementCollection bgElementCollection = BgElementFactory.getRemoteInstance().getBgElementCollection();
            HashSet existActNumnbers = new HashSet();
            HashMap<String, BgElementInfo> existsMember = new HashMap<String, BgElementInfo>();
            HashMap<String, BgElementInfo> existsName = new HashMap<String, BgElementInfo>();
            for (int i2 = 0; i2 < bgElementCollection.size(); ++i2) {
                String num = bgElementCollection.get(i2).getNumber();
                String ename = bgElementCollection.get(i2).getName();
                if (!existsMember.containsKey(num)) {
                    existsMember.put(num, bgElementCollection.get(i2));
                }
                if (existsName.containsKey(ename)) continue;
                existsName.put(ename, bgElementCollection.get(i2));
            }
            HashSet<String> failNumberSet = new HashSet<String>();
            HashSet<String> sucessNumberSet = new HashSet<String>();
            HashSet<String> sucessNameSet = new HashSet<String>();
            int in = sheet.getRowCount();
            for (i = 1; i < in; ++i) {
                number = this.getNumber(sheet.getCell(i, row_0, false).getValue());
                name = this.getNumber(sheet.getCell(i, row_1, false).getValue());
                type = this.getNumber(sheet.getCell(i, row_2, false).getValue());
                isShowData = this.getNumber(sheet.getCell(i, row_3, false).getValue());
                if (existsMember.containsKey(number)) {
                    BgElementInfo bgEleInfo = (BgElementInfo)existsMember.get(number);
                    type = bgEleInfo.getDataType().getAlias();
                }
                if (!this.isLegalType(type)) {
                    failNumberSet.add(number);
                } else if (!this.isNull(number) && !BgNumberHelper.checkNumber(number)) {
                    failNumberSet.add(number);
                } else if (this.isNull(number) || this.isNull(name)) {
                    failNumberSet.add(number);
                }
                sucessNumberSet.add(number);
                sucessNameSet.add(name);
            }
            failNumberSet.retainAll(existActNumnbers);
            in = sheet.getRowCount();
            for (i = 1; i < in; ++i) {
                this.progressBar.setValue(i);
                ++forCount;
                number = this.getNumber(sheet.getCell(i, row_0, false).getValue());
                name = this.getNumber(sheet.getCell(i, row_1, false).getValue());
                type = this.getNumber(sheet.getCell(i, row_2, false).getValue());
                isShowData = this.getNumber(sheet.getCell(i, row_3, false).getValue());
                description = this.getNumber(sheet.getCell(i, row_4, false).getValue());
                if (existsName.containsKey(name)) {
                    boolean isSameName = false;
                    if (existsMember.containsKey(number)) {
                        elementInfo = (BgElementInfo)existsMember.get(number);
                        if (!elementInfo.getName().equals(name)) {
                            isSameName = true;
                        }
                    } else {
                        isSameName = true;
                    }
                    if (isSameName && !"01".equals(number)) {
                        errorItem = new ArrayList();
                        errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(RESOURCE, "sameName"), i + 1, name));
                        this.addError(errorItem, i);
                        if (this.getErrorNum() != 1) continue;
                        break;
                    }
                }
                elementInfo = existsMember.containsKey(number) ? (BgElementInfo)existsMember.get(number) : this.createNewData();
                elementInfo.setDescription(description);
                elementInfo.setNumber(number);
                elementInfo.setName(name);
                if (!this.isLegalType(type)) {
                    errorItem = new ArrayList();
                    errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(RESOURCE, "dataTypeUnExists"), i + 1, number));
                    this.addError(errorItem, i);
                    if (this.getErrorNum() != 1) continue;
                    break;
                }
                if (!this.isNull(number) && !BgNumberHelper.checkNumber(number)) {
                    errorItem = new ArrayList();
                    errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(RESOURCE, "specialChar"), i + 1, number));
                    this.addError(errorItem, i);
                    if (errorNum != 1) continue;
                    break;
                }
                if (this.isNull(number) || this.isNull(name)) {
                    errorItem = new ArrayList();
                    errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(RESOURCE, "isNull4NameOrNumber"), i + 1));
                    this.addError(errorItem, i);
                    if (errorNum != 1) continue;
                    break;
                }
                if ("01".equals(number)) {
                    errorItem = new ArrayList();
                    errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(RESOURCE, "notdefEle"), i + 1, number));
                    this.addError(errorItem, i);
                    if (errorNum != 1) continue;
                    break;
                }
                existsMember.put(number, elementInfo);
                existsName.put(name, elementInfo);
                if (BgElementDataTypeEnum.AMOUNT.getAlias().equals(type)) {
                    elementInfo.setDataType(BgElementDataTypeEnum.AMOUNT);
                } else if (BgElementDataTypeEnum.MONEY.getAlias().equals(type)) {
                    elementInfo.setDataType(BgElementDataTypeEnum.MONEY);
                } else if (BgElementDataTypeEnum.PRICE.getAlias().equals(type)) {
                    elementInfo.setDataType(BgElementDataTypeEnum.PRICE);
                } else if (BgElementDataTypeEnum.RATE.getAlias().equals(type)) {
                    elementInfo.setDataType(BgElementDataTypeEnum.RATE);
                }
                if (this.isAmount(type) || this.isTotal(type)) {
                    elementInfo.setShowData(true);
                } else {
                    elementInfo.setShowData(!this.isNot(isShowData));
                }
                elementList.add(elementInfo);
            }
            if (!elementList.isEmpty()) {
                BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[elementList.size()];
                for (int i3 = 0; i3 < elementList.size(); ++i3) {
                    BatchExecuteParamsEntry entry;
                    if (elementList.get(i3) == null) continue;
                    paramEntries[i3] = entry = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{elementList.get(i3)});
                }
                BatchExecuteResult batchExecuteResult = BgElementFactory.getRemoteInstance().batchExecute("import4element", new Class[]{IObjectValue.class}, paramEntries);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        ArrayList txtlst = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(" ", MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgAccountResource", "importMsg_1"), forCount - this.errorMap.keySet().size()));
        txtlst.add(map);
        if (sheet.getRowCount() - colls.size() != 1 || !this.errorMap.isEmpty()) {
            map = new HashMap();
            if (errorNum == 1) {
                map.put(" ", BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgAccountResource", "importMsg_2", new String[]{String.valueOf(forCount - colls.size())}));
            } else if (this.errorMap.size() > 0) {
                map.put(" ", BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgAccountResource", "importMsg_2", new String[]{String.valueOf(this.errorMap.keySet().size())}));
            }
            txtlst.add(map);
        }
        if (this.errorMap.keySet() != null) {
            Object[] array = this.errorMap.keySet().toArray();
            Arrays.sort(array);
            for (int i = 0; i < array.length; ++i) {
                errorItem = this.errorMap.get(array[i]);
                if (errorItem == null) continue;
                for (int j = 0; j < errorItem.size(); ++j) {
                    map = new HashMap();
                    map.put(" ", errorItem.get(j));
                    errorLst.add(map);
                }
            }
        }
        txtlst.addAll(errorLst);
        ArrayList<String> listHeadTitle = new ArrayList<String>();
        listHeadTitle.add(" ");
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"LIST_CONTENT", txtlst);
        ctx.put((Object)"LIST_HEAD_TITLE", listHeadTitle);
        String invokeTime = BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date());
        ctx.put((Object)"INVOKE_TIME", (Object)invokeTime);
        ctx.put((Object)"UI_OWNER_TITLE", (Object)BgCommCHelper.getMessageStr(RESOURCE, "importEle"));
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BGReportUI.class.getName(), (Map)ctx);
            uiWindow.show();
        }
        catch (UIException e) {
            logger.error((Object)e);
        }
    }

    private boolean isLegalShowData(String isShowData) {
        return this.isYes(isShowData) || this.isNot(isShowData);
    }

    private boolean isLegalType(String type) {
        return this.isAmount(type) || this.isPrice(type) || this.isTotal(type) || this.isRate(type);
    }

    private boolean isRate(String type) {
        return BgCommCHelper.getMessageStr(RESOURCE, "Rate").equals(type);
    }

    private boolean isPrice(String type) {
        return BgCommCHelper.getMessageStr(RESOURCE, "Price").equals(type);
    }

    private boolean isTotal(String type) {
        return BgCommCHelper.getMessageStr(RESOURCE, "Total").equals(type);
    }

    private boolean isAmount(String type) {
        return BgCommCHelper.getMessageStr(RESOURCE, "Amount").equals(type);
    }

    private boolean isYes(String isShowData) {
        return BgCommCHelper.getMessageStr(RESOURCE, "isYes").equals(isShowData);
    }

    private boolean isNot(String isShowData) {
        return BgCommCHelper.getMessageStr(RESOURCE, "isNot").equals(isShowData);
    }

    private void addError(List<String> errorItem, int i) {
        if (this.errorMap.containsKey(i + 1)) {
            this.errorMap.get(i + 1).addAll(errorItem);
        } else {
            this.errorMap.put(i + 1, errorItem);
        }
    }
}

