/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgFiscalYearMonth;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgPeriodYearEnum;
import com.kingdee.eas.ma.base.IBgPeriodType;
import com.kingdee.eas.ma.base.client.AbstractBgFiscalYearSetUI;
import com.kingdee.eas.ma.base.client.BgPeriodTreeListUI;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class BgFiscalYearSetUI
extends AbstractBgFiscalYearSetUI {
    private static final long serialVersionUID = 7685611737413019284L;
    private static final String descStr = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"fiscalYearDesc01") + "\n" + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"fiscalYearDesc02") + "\n   " + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"fiscalYearDesc03") + "\n   " + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"fiscalYearDesc04") + "\n   " + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"fiscalYearDesc05") + "\n   " + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"fiscalYearDesc06");
    private static final Logger logger = CoreUIObject.getLogger(BgFiscalYearSetUI.class);

    public BgFiscalYearSetUI() throws Exception {
        this.desc.setText(descStr);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (BgPeriodYearEnum.lastYear.equals((Object)this.editData.getBelongYear())) {
            this.radioBtnLast.setSelected(true);
        } else {
            this.radioBtnThis.setSelected(true);
        }
        this.startMonth.setEnabled(((Boolean)this.getUIContext().get("ISENABLED")).booleanValue());
        this.radioBtnThis.setEnabled(((Boolean)this.getUIContext().get("ISENABLED")).booleanValue());
        this.radioBtnLast.setEnabled(((Boolean)this.getUIContext().get("ISENABLED")).booleanValue());
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.startYear.getValue() == null && this.endYear.getValue() == null) {
            this.showErrorMsg("budgetYearIsNull");
        } else {
            int end;
            int start = Integer.valueOf(this.startYear.getValue().toString());
            if (start > (end = Integer.valueOf(this.endYear.getValue().toString()).intValue())) {
                this.showErrorMsg("startY_compare_endY");
            }
        }
        if (!this.radioBtnThis.isSelected() && !this.radioBtnLast.isSelected()) {
            this.showErrorMsg("startPeriodYearIsnull");
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        int currYear = new CalendarHelper().getCurrentlyYear() + 1;
        this.startYear.setModel((SpinnerModel)new SpinnerNumberModel(currYear, 1900, 2050, 1));
        this.endYear.setModel((SpinnerModel)new SpinnerNumberModel(currYear, 1900, 2050, 1));
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        BgPeriodTypeInfo model = (BgPeriodTypeInfo)this.getUIContext().get("InitDataObject");
        model.setStartMonth((BgFiscalYearMonth)((Object)this.startMonth.getSelectedItem()));
        model.setStartYear((Integer)this.startYear.getValue());
        model.setEndYear((Integer)this.endYear.getValue());
        if (this.radioBtnThis.isSelected()) {
            model.setBelongYear(BgPeriodYearEnum.thisYear);
        } else {
            model.setBelongYear(BgPeriodYearEnum.lastYear);
        }
        String msg = ((IBgPeriodType)this.getBizInterface()).setFiscalYear(model);
        String info = null;
        String detailInfo = null;
        if (!StringUtils.isEmpty((String)msg) && msg.contains("&")) {
            String[] split = msg.split("&");
            info = split[0];
            detailInfo = split[1];
            MsgBox.showDetailAndOK((Component)((Object)this), (String)info, (String)detailInfo, (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)msg);
        }
        this.getUIWindow().close();
        if (this.getUIContext().get("Owner") instanceof BgPeriodTreeListUI) {
            ((BgPeriodTreeListUI)((Object)this.getUIContext().get("Owner"))).actionRefresh_leftTable();
        }
    }

    public boolean isModify() {
        return false;
    }

    protected void showSubmitSuccess() {
        this.getUIWindow().close();
        if (this.getUIContext().get("Owner") instanceof BgPeriodTreeListUI) {
            try {
                ((BgPeriodTreeListUI)((Object)this.getUIContext().get("Owner"))).actionRefresh_leftTable();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.radioBtnThis.isSelected()) {
            this.editData.setBelongYear(BgPeriodYearEnum.thisYear);
        } else if (this.radioBtnLast.isSelected()) {
            this.editData.setBelongYear(BgPeriodYearEnum.lastYear);
        } else {
            this.editData.setFiscalYear(null);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgPeriodTypeFactory.getRemoteInstance();
    }

    protected boolean isContinueAddNew() {
        return false;
    }

    private void showErrorMsg(String key) {
        String msg = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)key);
        MsgBox.showInfo((Component)((Object)this), (String)msg);
        SysUtil.abort();
    }
}

