/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgBaseFacadeFactory;
import com.kingdee.eas.ma.base.BgItemAllocationParameter;
import com.kingdee.eas.ma.base.BgItemFactory;
import com.kingdee.eas.ma.base.BgItemGroupInfo;
import com.kingdee.eas.ma.base.BgItemInfo;
import com.kingdee.eas.ma.base.BgItemRelationInfo;
import com.kingdee.eas.ma.base.BgOrgTypeViewEnum;
import com.kingdee.eas.ma.base.IBgItem;
import com.kingdee.eas.ma.base.client.AbstractBgItemAllocationUI;
import com.kingdee.eas.ma.base.client.BgItemGroupDialog;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.client.SearchKeyEnum;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.OrgUnitUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgItemAllocationUI
extends AbstractBgItemAllocationUI {
    private static final long serialVersionUID = -7650825983910313008L;
    private static final Logger logger = CoreUIObject.getLogger(BgItemAllocationUI.class);
    private Color disableColor = Color.RED;
    public static String DISTRIBUTION = "DISTRIBUTION";
    private boolean isDistribution = true;
    private NumberExpendRender render = null;
    private String orgUnitId = null;
    private BgItemGroupInfo itemGroupInfo = null;
    private Set<String> allOrgUnitIds = new HashSet<String>();
    private Set<String> selCompanyIds = new HashSet<String>();
    private TreeWillExpandListener listener = null;
    private TreeModel oldTree = null;
    private KDPopupMenu popTreeMenu = new KDPopupMenu();
    private Set<String> selNums = new HashSet<String>();
    private boolean isRefeshOrgUnitTree = false;
    private LongTimeDialog dialog = null;

    public Color getDisableColor() {
        return this.disableColor;
    }

    public void setDistribution(boolean isDistribution) {
        this.isDistribution = isDistribution;
    }

    public boolean isDistribution() {
        return this.isDistribution;
    }

    public void setRender(NumberExpendRender render) {
        this.render = render;
    }

    public NumberExpendRender getRender() {
        return this.render;
    }

    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    public String getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setItemGroupInfo(BgItemGroupInfo itemGroupInfo) {
        this.itemGroupInfo = itemGroupInfo;
    }

    public BgItemGroupInfo getItemGroupInfo() {
        return this.itemGroupInfo;
    }

    public Set<String> getAllOrgUnitIds() {
        return this.allOrgUnitIds;
    }

    public Set<String> getSelCompanyIds() {
        return this.selCompanyIds;
    }

    public void setListener(TreeWillExpandListener listener) {
        this.listener = listener;
    }

    public TreeWillExpandListener getListener() {
        return this.listener;
    }

    public void setOldTree(TreeModel oldTree) {
        this.oldTree = oldTree;
    }

    public TreeModel getOldTree() {
        return this.oldTree;
    }

    public KDPopupMenu getPopTreeMenu() {
        return this.popTreeMenu;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    public void onShow() throws Exception {
        super.onShow();
        if (!this.isDistribution()) {
            this.btnAllocation.setText(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "unAllocation"));
            this.setUITitle(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "unAllocationTitle"));
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgItemFactory.getRemoteInstance();
    }

    protected void init() {
        String orgUnitId = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        this.setOrgUnitId(orgUnitId);
        Boolean _isDistribution = (Boolean)this.getUIContext().get(DISTRIBUTION);
        if (_isDistribution instanceof Boolean) {
            this.setDistribution(_isDistribution);
        }
        this.initUI();
        this.initData();
    }

    protected void initUI() {
        IColumn column3;
        IColumn column2;
        this.toolBar.setVisible(false);
        this.menuBar.setVisible(false);
        this.bgItemSelPanel.setVisible(true);
        this.allocationPanel.setVisible(false);
        this.selTable.getSelectManager().setSelectMode(10);
        this.setRender(new NumberExpendRender(1));
        IColumn column = this.tblMain.getColumn("number");
        if (column != null) {
            column.setRenderer((IBasicRender)this.getRender());
        }
        if ((column2 = this.selTable.getColumn("number")) != null) {
            column2.setRenderer((IBasicRender)this.getRender());
        }
        if ((column3 = this.itemTable.getColumn("number")) != null) {
            column3.setRenderer((IBasicRender)this.getRender());
        }
        BgItemGroupDialog dialog = new BgItemGroupDialog((IUIObject)this);
        dialog.setShowGlobal(false);
        if (!StringUtils.isEmpty((String)this.getOrgUnitId())) {
            dialog.setOrgUnitId(this.getOrgUnitId());
        }
        this.prmtBgItemGroup.setSelector((KDPromptSelector)dialog);
    }

    protected void initData() {
        BgItemGroupInfo itemGroupInfo = (BgItemGroupInfo)this.getUIContext().get(BgBaseConstants.BGITEMGROUP_INFO);
        if (itemGroupInfo != null) {
            this.prmtBgItemGroup.setData((Object)itemGroupInfo);
        }
        this.comOrgSerach.addItem((Object)SearchKeyEnum.orgName);
        this.comOrgSerach.addItem((Object)SearchKeyEnum.orgNumber);
        this.comOrgSerach.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        });
        KDMenuItem menu = new KDMenuItem();
        menu = new KDMenuItem();
        menu.setText(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "popMenuItemDirect"));
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgItemAllocationUI.this.actionPopMenuItem_SelDirect(e);
                }
                catch (Exception ex) {
                    BgItemAllocationUI.this.handUIException(ex);
                }
            }
        });
        this.getPopTreeMenu().add((JMenuItem)menu);
        menu = new KDMenuItem();
        menu.setText(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "popMenuItemAll"));
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgItemAllocationUI.this.actionPopMenuItem_SelAll(e);
                }
                catch (Exception ex) {
                    BgItemAllocationUI.this.handUIException(ex);
                }
            }
        });
        this.getPopTreeMenu().add((JMenuItem)menu);
        menu = new KDMenuItem();
        menu.setText(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "popMenuItemCompany"));
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgItemAllocationUI.this.actionPopMenuItem_SelCompany(e);
                }
                catch (Exception ex) {
                    BgItemAllocationUI.this.handUIException(ex);
                }
            }
        });
        this.getPopTreeMenu().add((JMenuItem)menu);
        menu = new KDMenuItem();
        menu.setText(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "popMenuItemAllocation"));
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgItemAllocationUI.this.actionPopMenuItem_SelAllocation(e);
                }
                catch (Exception ex) {
                    BgItemAllocationUI.this.handUIException(ex);
                }
            }
        });
        this.getPopTreeMenu().add((JMenuItem)menu);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.toolBar.setEnabled(false);
        this.toolBar.setVisible(false);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnSelect.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnDeleteAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnSerach.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    BgItemAllocationUI.this.afterDataFill_actionEvent(e);
                }
                catch (Exception ex) {
                    BgItemAllocationUI.this.handUIExceptionAndAbort(ex);
                }
            }
        });
    }

    protected void afterDataFill_actionEvent(KDTDataRequestEvent e) throws Exception {
        int beginIndex = e.getFirstRow();
        int endIndex = e.getLastRow();
        int level = 0;
        Object numberValue = null;
        Object longnumberValue = null;
        String id = null;
        String number = null;
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int index = beginIndex; index <= endIndex; ++index) {
            row = this.tblMain.getRow(index);
            id = (String)row.getCell("id").getValue();
            numberValue = row.getCell("number").getValue();
            longnumberValue = row.getCell("longNumber").getValue();
            level = (Integer)row.getCell("level").getValue();
            boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            boolean isEffective = (Boolean)row.getCell("rel.isEffective").getValue();
            if (!(numberValue instanceof String)) {
                return;
            }
            number = numberValue.toString();
            String longNumber = longnumberValue.toString();
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setEffective(isEffective);
            expandInfo.setName(number);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)expandInfo);
            if (isEffective) {
                row.getStyleAttributes().setBackground(null);
                continue;
            }
            row.getStyleAttributes().setBackground(this.getDisableColor());
        }
    }

    @Override
    protected void prmtBgItemGroup_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgItemGroup_dataChanged(e);
        if (this.prmtBgItemGroup.getData() instanceof BgItemGroupInfo) {
            this.itemGroupInfo = (BgItemGroupInfo)this.prmtBgItemGroup.getData();
            this.execQuery();
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("longnumber");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("bgItemGroup.id");
        sic.add("bgItemGroup.name");
        sic.add("relation.id");
        sic.add("relation.isEffective");
        sic.add("relation.parentId");
        sic.add("relation.rootId");
        return sic;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("relation.orgUnitID", (Object)this.getOrgUnitId(), CompareType.EQUALS));
        if (this.getItemGroupInfo() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bgItemGroup.id", (Object)this.getItemGroupInfo().getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("bgItemGroup.id", (Object)BgBaseConstants.nullID, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("relation.isEffective", (Object)Boolean.TRUE, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IQueryExecutor query = super.getQueryExecutor(queryPK, viewInfo);
        return query;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        IRow selRow = null;
        int in = this.tblMain.getRowCount3();
        for (int i = 0; i < in; ++i) {
            selRow = this.tblMain.getRow(i);
            this.addSelectedInfo(selRow);
        }
    }

    @Override
    public void actionSelect_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelect_actionPerformed(e);
        if (this.prmtBgItemGroup.getText().isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "BgItemEmpty"));
            SysUtil.abort();
        }
        this.checkSelected();
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        if (blocks != null && !blocks.isEmpty()) {
            IRow selRow = null;
            KDTSelectBlock block = null;
            int in = blocks.size();
            for (int i = 0; i < in; ++i) {
                block = (KDTSelectBlock)blocks.get(i);
                if (block == null) continue;
                int jn = block.getEndRow();
                for (int j = block.getBeginRow(); j <= jn; ++j) {
                    selRow = this.tblMain.getRow(j);
                    this.addSelectedInfo(selRow);
                }
            }
        }
    }

    public Set<String> getSelNums() {
        return this.selNums;
    }

    private void addSelectedInfo(IRow selRow) {
        if (selRow == null) {
            return;
        }
        if (this.selTable.getRowCount() > 0) {
            String rowId = selRow.getCell("id").getValue().toString();
            IRow row = null;
            for (int rowindex = 0; rowindex < this.selTable.getRowCount(); ++rowindex) {
                row = this.selTable.getRow(rowindex);
                if (!rowId.equals((String)row.getCell("id").getValue())) continue;
                return;
            }
        }
        BgItemInfo itemInfo = new BgItemInfo();
        itemInfo.setId(BOSUuid.read((String)selRow.getCell("id").getValue().toString()));
        if (selRow.getCell("number").getValue() instanceof NumberExpandInfo) {
            itemInfo.setNumber(((NumberExpandInfo)selRow.getCell("number").getValue()).getNumber());
        } else {
            itemInfo.setNumber(selRow.getCell("number").getValue().toString());
        }
        itemInfo.setName(selRow.getCell("name").getValue().toString());
        itemInfo.setLevel((Integer)selRow.getCell("level").getValue());
        itemInfo.setIsLeaf((Boolean)selRow.getCell("isLeaf").getValue());
        itemInfo.setLongNumber((String)selRow.getCell("longNumber").getValue());
        BgItemRelationInfo relationInfo = new BgItemRelationInfo();
        relationInfo.setOrgUnitID(BOSUuid.read((String)this.getOrgUnitId()));
        itemInfo.getRelation().add(relationInfo);
        IRow row = null;
        if (this.isDistribution()) {
            NumberExpandInfo expandInfo = null;
            if (itemInfo.getLongNumber().indexOf(BgBaseConstants.SEP_ONE_STR) > 0) {
                int i;
                String[] numbers = itemInfo.getLongNumber().split(BgBaseConstants.SEP_ONE_STR);
                ArrayList<String> checkNums = new ArrayList<String>();
                int in = numbers.length - 1;
                for (i = 0; i < in; ++i) {
                    checkNums.add(numbers[i]);
                }
                if (!this.getSelNums().containsAll(checkNums)) {
                    in = checkNums.size();
                    for (i = 0; i < in; ++i) {
                        if (this.getSelNums().contains(checkNums.get(i))) continue;
                        for (int j = selRow.getRowIndex() - 1; j >= 0; --j) {
                            row = this.tblMain.getRow(j);
                            expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
                            if (!expandInfo.getNumber().equals(numbers[i])) continue;
                            this.addSelectedInfo(row);
                        }
                    }
                }
            }
        } else {
            for (int i = selRow.getRowIndex() + 1; i < this.tblMain.getRowCount(); ++i) {
                row = this.tblMain.getRow(i);
                int nextRowLevel = Integer.parseInt(row.getCell("level").getValue().toString());
                if (itemInfo.getLevel() < nextRowLevel) {
                    this.addSelectedInfo(row);
                    continue;
                }
                break;
            }
        }
        BgItemGroupInfo bgItemGroupInfo = (BgItemGroupInfo)this.prmtBgItemGroup.getData();
        row = this.selTable.addRow();
        row.getCell("itemGroup").setValue((Object)bgItemGroupInfo.getName().toString());
        row.getCell("id").setValue((Object)itemInfo.getId().toString());
        row.getCell("number").setValue((Object)itemInfo.getNumber());
        row.getCell("name").setValue((Object)itemInfo.getName());
        row.setUserObject((Object)itemInfo);
        this.getSelNums().add(itemInfo.getNumber());
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        ArrayList blocks = this.selTable.getSelectManager().getBlocks();
        if (blocks != null && !blocks.isEmpty()) {
            KDTSelectBlock block = null;
            ArrayList<Integer> rowIndex = new ArrayList<Integer>();
            int in = blocks.size();
            for (int i = 0; i < in; ++i) {
                block = (KDTSelectBlock)blocks.get(i);
                int jn = block.getEndRow();
                for (int j = block.getBeginRow(); j <= jn; ++j) {
                    rowIndex.add(new Integer(j));
                }
            }
            Collections.sort(rowIndex, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o2 - o1;
                }
            });
            IRow row = null;
            int in2 = rowIndex.size();
            for (int i = 0; i < in2; ++i) {
                row = this.selTable.getRow(((Integer)rowIndex.get(i)).intValue());
                this.getSelNums().remove(row.getCell("number").getValue());
                this.selTable.removeRow(((Integer)rowIndex.get(i)).intValue());
            }
        }
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "removeAllItem"));
        if (re == 0) {
            this.selTable.removeRows();
            this.getSelNums().clear();
        }
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.checkSelectedItem();
        this.allocationPanel.setVisible(true);
        this.bgItemSelPanel.setVisible(false);
        this.AllocationPanel_onShow();
    }

    protected void checkSelectedItem() throws Exception {
        if (this.selTable.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "selAllocationItems"));
            SysUtil.abort();
        }
        if (this.isDistribution()) {
            String[] numbers = null;
            IRow row = null;
            BgItemInfo itemInfo = null;
            int in = this.selTable.getRowCount();
            for (int i = 0; i < in; ++i) {
                row = this.selTable.getRow(i);
                itemInfo = (BgItemInfo)row.getUserObject();
                if (itemInfo == null || (numbers = itemInfo.getLongNumber().split(BgBaseConstants.SEP_ONE_STR)) == null || numbers.length <= 1) continue;
                int jn = numbers.length - 1;
                for (int j = 0; j < jn; ++j) {
                    if (this.getSelNums().contains(numbers[j])) continue;
                    MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "allocationNoParent", new Object[]{itemInfo.getNumber(), numbers[j]}));
                    SysUtil.abort();
                }
            }
        }
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
        this.getUIWindow().close();
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionSelect_actionPerformed(null);
            return;
        }
        super.tblMain_tableClicked(e);
        if (e.getType() == 1) {
            IRow row;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount = e.getClickCount();
            if (clickCount == 1 && (row = this.tblMain.getRow(rowIndex)) != null && colIndex == this.tblMain.getColumn("number").getColumnIndex()) {
                NumberExpandInfo expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
                if (this.getRender().inRect(expandInfo, e.getX(), e.getY())) {
                    this.setTreeDisplayStyle(row, expandInfo);
                }
            }
        }
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) throws Exception {
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = null;
        NumberExpandInfo expandInfo = null;
        parentLongNumber = parentExpandInfo.getLongNumber();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                if (expandInfo.getLevel() - parentLevel != 1) continue;
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                expandInfo.setExpandStatus(false);
            }
        }
    }

    public void AllocationPanel_onShow() throws Exception {
        this.init_itemTableData();
        this.init_orgUnitTreeData();
    }

    protected void init_itemTableData() {
        this.itemTable.getSelectManager().setSelectMode(10);
        IRow row = null;
        IRow selRow = null;
        BgItemInfo itemInfo = null;
        final ArrayList<String> bgItemIds = new ArrayList<String>();
        this.itemTable.removeRows();
        int in = this.selTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            selRow = this.selTable.getRow(i);
            String itemGroupName = selRow.getCell("itemGroup").getValue().toString();
            itemInfo = (BgItemInfo)selRow.getUserObject();
            row = this.itemTable.addRow();
            row.getCell("itemGroup").setValue((Object)itemGroupName);
            row.getCell("number").setValue(selRow.getCell("number").getValue());
            row.getCell("name").setValue((Object)itemInfo.getName());
            row.setUserObject((Object)itemInfo);
            bgItemIds.add(itemInfo.getId().toString());
        }
        this.itemTable.getSelectManager().select(0, 0);
        this.getAllOrgUnitIds().clear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List orgUnitIds = null;
                try {
                    orgUnitIds = BgItemFactory.getRemoteInstance().checkAllocation(bgItemIds);
                }
                catch (Exception ex) {
                    logger.error((Object)"init_itemTableData Error", (Throwable)ex);
                }
                finally {
                    if (orgUnitIds != null) {
                        BgItemAllocationUI.this.getAllOrgUnitIds().addAll(orgUnitIds);
                        BgItemAllocationUI.this.refeshAllOrgUnit();
                    }
                }
            }
        });
    }

    protected void init_orgUnitTreeData() throws Exception {
        if (this.getListener() == null) {
            this.setListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                    try {
                        OrgUnitUtils.addChildNode(node, BgItemAllocationUI.this.getAllOrgUnitIds());
                    }
                    catch (Exception ex) {
                        BgItemAllocationUI.this.handUIException(ex);
                    }
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                }
            });
            this.kDOrgTree.setShowCheckBox(true);
            this.kDOrgTree.removeTreeWillExpandListener(this.getListener());
            this.setOldTree(OrgUnitUtils.getOrgTreeModel(this.kDOrgTree, this.getOrgUnitId(), this.getListener()));
            this.kDOrgTree.setModel(this.getOldTree());
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kDOrgTree.getModel().getRoot();
            if (root != null) {
                root.setCheckBoxEnabled(false);
                root.setCheckBoxVisible(false);
                root.setChecked(false);
            }
            this.kDOrgTree.addMouseListener((MouseListener)new TreePopupMenuListener());
        }
    }

    public void refeshAllOrgUnit() {
        if (this.getAllOrgUnitIds().isEmpty()) {
            return;
        }
        TreePath tp = null;
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        FullOrgUnitInfo unitInfo = null;
        int in = this.kDOrgTree.getRowCount();
        for (int i = 0; i < in; ++i) {
            tp = this.kDOrgTree.getPathForRow(i);
            if (tp == null || tp.getLastPathComponent() == null || (node = (DefaultKingdeeTreeNode)tp.getLastPathComponent()) == null || node.getUserObject() == null || node == this.kDOrgTree.getModel().getRoot()) continue;
            oui = (OrgStructureInfo)node.getUserObject();
            unitInfo = oui.getUnit();
            if (this.getAllOrgUnitIds().contains(unitInfo.getId().toString())) {
                node.setTextColor(OrgUnitUtils.getCOLOR_SELECT());
                continue;
            }
            node.setTextColor(OrgUnitUtils.getCOLOR_DEFAULT());
        }
        this.kDOrgTree.repaint();
    }

    public void setRefeshOrgUnitTree(boolean isRefeshOrgUnitTree) {
        this.isRefeshOrgUnitTree = isRefeshOrgUnitTree;
    }

    public boolean isRefeshOrgUnitTree() {
        return this.isRefeshOrgUnitTree;
    }

    public void refeshOrgUnitTree() {
        if (!this.isRefeshOrgUnitTree()) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getOldTree().getRoot();
            this.refeshOrgUnitTree(root);
            this.setRefeshOrgUnitTree(true);
        }
    }

    private void refeshOrgUnitTree(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        if (root.getChildCount() == 1) {
            try {
                OrgUnitUtils.addChildNode(root, this.getAllOrgUnitIds());
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        DefaultKingdeeTreeNode node = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.refeshOrgUnitTree(node);
        }
    }

    private void loadOrgUnitTree() {
        if (!this.isRefeshOrgUnitTree()) {
            this.loadOrgUnitTree(null);
        }
    }

    private void loadOrgUnitTree(final BgOrgTypeViewEnum orgType) {
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
            if (this.dialog == null) {
                return;
            }
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgItemAllocationUI.this.refeshOrgUnitTree();
                if (orgType != null && orgType.getValue() == 1 && BgItemAllocationUI.this.getSelCompanyIds().isEmpty()) {
                    BgItemAllocationUI.this.getSelCompanyIds().addAll(BgBaseFacadeFactory.getRemoteInstance().getCompanyIds());
                }
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        this.dialog.show();
    }

    @Override
    public void actionPrevious_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrevious_actionPerformed(e);
        this.bgItemSelPanel.setVisible(true);
        this.allocationPanel.setVisible(false);
        this.itemTable.removeRows();
    }

    @Override
    protected void btnSerach_actionPerformed(ActionEvent e) throws Exception {
        super.btnSerach_actionPerformed(e);
        String txt = this.txtSerach.getText();
        if (StringUtils.isEmpty((String)txt)) {
            this.kDOrgTree.setModel(this.getOldTree());
            OrgUnitUtils.selectOrgUnit(this.kDOrgTree, false);
            return;
        }
        this.loadOrgUnitTree();
        TreeModel model = null;
        SearchKeyEnum keyEnum = (SearchKeyEnum)((Object)this.comOrgSerach.getSelectedItem());
        if (keyEnum.getValue() == 10) {
            model = NewOrgUtils.clipAndCloneTreeModel((TreeModel)this.getOldTree(), (String)"name", (String)txt, (boolean)true);
        } else if (keyEnum.getValue() == 0) {
            model = NewOrgUtils.clipAndCloneTreeModel((TreeModel)this.getOldTree(), (String)"number", (String)txt, (boolean)true);
        }
        this.kDOrgTree.setModel(model);
        OrgUnitUtils.selectOrgUnit(this.kDOrgTree, false);
    }

    @Override
    public void actionAllocation_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllocation_actionPerformed(e);
        List<BgItemInfo> selBgItems = this.getSelectBgItemInfo();
        List<OrgStructureInfo> selOrgUnits = OrgUnitUtils.getSelectOrgUnitInfo(this.kDOrgTree);
        if (selOrgUnits.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "selAllocationOrgUnit"));
            return;
        }
        ItemAllocationThread thread = new ItemAllocationThread();
        thread.setItemInfos(selBgItems);
        thread.setOrgUnits(selOrgUnits);
        thread.start();
    }

    private List<BgItemInfo> getSelectBgItemInfo() {
        IRow row = null;
        BgItemInfo itemInfo = null;
        ArrayList<BgItemInfo> selBgItems = new ArrayList<BgItemInfo>();
        int in = this.itemTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.itemTable.getRow(i);
            itemInfo = (BgItemInfo)row.getUserObject();
            selBgItems.add(itemInfo);
        }
        return selBgItems;
    }

    protected IBgItem getItemInterface() throws BOSException {
        return BgItemFactory.getRemoteInstance();
    }

    public void actionPopMenuItem_SelectAll(ActionEvent e) throws Exception {
        this.loadOrgUnitTree();
        OrgUnitUtils.selectOrgUnit(this.kDOrgTree, true);
    }

    public void actionPopMenuItem_CleanAll(ActionEvent e) throws Exception {
        this.loadOrgUnitTree();
        OrgUnitUtils.selectOrgUnit(this.kDOrgTree, false);
    }

    public void actionPopMenuItem_SelCompany(ActionEvent e) throws Exception {
        this.loadOrgUnitTree(BgOrgTypeViewEnum.company);
        OrgUnitUtils.selectOrgUnit(this.kDOrgTree.getSelectionPath() == null ? (DefaultKingdeeTreeNode)this.kDOrgTree.getModel().getRoot() : (DefaultKingdeeTreeNode)this.kDOrgTree.getSelectionPath().getLastPathComponent(), this.getSelCompanyIds());
        this.kDOrgTree.repaint();
    }

    public void actionPopMenuItem_SelDirect(ActionEvent e) throws Exception {
        this.loadOrgUnitTree();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.kDOrgTree.getLastSelectedPathComponent();
        try {
            OrgUnitUtils.addChildNode(node, this.getAllOrgUnitIds());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        OrgUnitUtils.selectDirectOrgUnit(node, true);
        this.kDOrgTree.repaint();
    }

    public void actionPopMenuItem_SelAll(ActionEvent e) throws Exception {
        this.loadOrgUnitTree();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.kDOrgTree.getLastSelectedPathComponent();
        OrgUnitUtils.selectOrgUnit(node, true);
        this.kDOrgTree.repaint();
    }

    public void actionPopMenuItem_SelAllocation(ActionEvent e) throws Exception {
        this.loadOrgUnitTree();
        OrgUnitUtils.selectOrgUnit(this.kDOrgTree, this.getAllOrgUnitIds());
    }

    @Override
    protected void btnOrgSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnOrgSelectAll_actionPerformed(e);
        this.loadOrgUnitTree();
        OrgUnitUtils.selectOrgUnit(this.kDOrgTree, true);
        this.kDOrgTree.repaint();
    }

    @Override
    protected void btnOrgDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnOrgDeleteAll_actionPerformed(e);
        this.loadOrgUnitTree();
        OrgUnitUtils.selectOrgUnit(this.kDOrgTree, false);
        this.kDOrgTree.repaint();
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgItemAllocationUI.this.getPopTreeMenu().show((Component)BgItemAllocationUI.this.kDOrgTree, e.getX(), e.getY());
            }
        }
    }

    class ItemAllocationThread
    extends Thread {
        private int DELAY = 100;
        private List<BgItemInfo> itemInfos = null;
        private List<OrgStructureInfo> orgUnits = null;

        public void setItemInfos(List<BgItemInfo> itemInfos) {
            this.itemInfos = itemInfos;
        }

        public List<BgItemInfo> getItemInfos() {
            return this.itemInfos;
        }

        public void setOrgUnits(List<OrgStructureInfo> orgUnits) {
            this.orgUnits = orgUnits;
        }

        public List<OrgStructureInfo> getOrgUnits() {
            return this.orgUnits;
        }

        @Override
        public synchronized void start() {
            super.start();
            BgItemAllocationUI.this.btnPrevious.setEnabled(false);
            BgItemAllocationUI.this.btnAllocation.setEnabled(false);
            int count = this.getItemInfos().size();
            BgItemAllocationUI.this.kDProgressBar.setValue(0);
            BgItemAllocationUI.this.kDProgressBar.setMaximum(count);
            LinkedHashMap<String, List> result = new LinkedHashMap<String, List>();
            BgItemInfo itemInfo = null;
            BgItemAllocationParameter parameter = new BgItemAllocationParameter();
            List<BOSUuid> orgUnitIds = parameter.transOrgUnit(this.getOrgUnits());
            if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
                int in = this.getItemInfos().size();
                for (int i = 0; i < in; ++i) {
                    itemInfo = this.getItemInfos().get(i);
                    parameter.setItemInfo(itemInfo);
                    parameter.setOrgUnits(orgUnitIds);
                    try {
                        if (BgItemAllocationUI.this.isDistribution()) {
                            List list = (List)BgItemAllocationUI.this.getItemInterface().allocation(parameter);
                            if (list != null && !list.isEmpty()) {
                                result.put(itemInfo.getName(), list);
                            }
                        } else {
                            BgItemAllocationUI.this.getItemInterface().unAllocation(parameter);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)("bgItem " + itemInfo.getNumber() + " Allocation Error:"), (Throwable)ex);
                    }
                    BgItemAllocationUI.this.kDProgressBar.setValue(i);
                    try {
                        Thread.sleep(this.DELAY);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                BgItemAllocationUI.this.kDProgressBar.setValue(count);
            }
            BgItemAllocationUI.this.getUIWindow().close();
            if (BgItemAllocationUI.this.isDistribution()) {
                StringBuffer detail = new StringBuffer();
                String msg = EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"alloctionOrgExists");
                for (String bgItemName : result.keySet()) {
                    List list = (List)result.get(bgItemName);
                    if (list == null || list.isEmpty()) continue;
                    for (int i = 0; i < list.size(); ++i) {
                        CostCenterOrgUnitInfo org = (CostCenterOrgUnitInfo)list.get(i);
                        if (detail.length() > 0) {
                            detail.append("\r\n");
                        }
                        detail.append(MessageFormat.format(msg, org.getName(), bgItemName));
                    }
                }
                if (detail.length() > 0) {
                    MsgBox.showDetailAndOK((Component)((Object)BgItemAllocationUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"allocationFail"), (String)detail.toString(), (int)1);
                } else {
                    MsgBox.showInfo((Component)((Object)BgItemAllocationUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"allocationSuccess"));
                }
            } else {
                MsgBox.showInfo((Component)((Object)BgItemAllocationUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"unalloctionSuccess"));
            }
        }
    }
}

