/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.base.BgDataRelationEnum;
import com.kingdee.eas.ma.base.BgElimTypeEnum;
import com.kingdee.eas.ma.base.BgItemException;
import com.kingdee.eas.ma.base.BgItemFactory;
import com.kingdee.eas.ma.base.BgItemGroupInfo;
import com.kingdee.eas.ma.base.BgItemInfo;
import com.kingdee.eas.ma.base.BgItemRelationCollection;
import com.kingdee.eas.ma.base.BgItemRelationFactory;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.FpCashDirectionEnum;
import com.kingdee.eas.ma.base.client.AbstractBgItemEditUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCodeNumberCHelper;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BgItemEditUI
extends AbstractBgItemEditUI {
    private static final long serialVersionUID = -3460537619834453706L;
    private static final Logger logger = CoreUIObject.getLogger(BgItemEditUI.class);
    private boolean hasCodeNumber = false;
    private boolean hasShowCodeNumber = false;
    private boolean hasUseIntermitNumber = false;
    private boolean selDataRelation = false;
    private String itemNum = null;

    public void setHasCodeNumber(boolean hasCodeNumber) {
        this.hasCodeNumber = hasCodeNumber;
    }

    public boolean isHasCodeNumber() {
        return this.hasCodeNumber;
    }

    public void setHasShowCodeNumber(boolean hasShowCodeNumber) {
        this.hasShowCodeNumber = hasShowCodeNumber;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public void setHasUseIntermitNumber(boolean hasUseIntermitNumber) {
        this.hasUseIntermitNumber = hasUseIntermitNumber;
    }

    public boolean isHasUseIntermitNumber() {
        return this.hasUseIntermitNumber;
    }

    protected LanguageInfo getCurrentLanguage() {
        return new LanguageInfo(this.getCurrentLocale());
    }

    public OrgUnitInfo getOrgUnitInfo() {
        return (OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
    }

    public BgItemEditUI() throws Exception {
        this.initDefault();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.selDataRelation = true;
        if (this.editData.getDataRelation().equals((Object)BgDataRelationEnum.DebitAdd)) {
            this.rbDebtor.setSelected(true);
        } else if (this.editData.getDataRelation().equals((Object)BgDataRelationEnum.DebitMinus)) {
            this.rbCreditor.setSelected(true);
        } else if (this.editData.getDataRelation().equals((Object)BgDataRelationEnum.DebitDefault)) {
            this.rbDebtor.setSelected(true);
            this.selDataRelation = false;
        }
    }

    public void onLoad() throws Exception {
        this.initBase();
        super.onLoad();
        this.chkMenuItemSubmitAndAddNew.setSelected(true);
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
        this.init();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.kDTabbedPane.setSelectedIndex(0);
        this.kDTabbedPane.remove((Component)this.kdEilmPanel);
        this.kdDataPicker.setDatePattern(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.txtNumber.setSelectAllOnFocus(true);
        this.txtNumber.requestFocus(true);
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
        this.txtNumber.requestFocus(true);
        if (!this.isHasCodeNumber()) {
            try {
                this.autoGetNumber();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort(e);
            }
        }
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        if (this.editData != null && this.editData.getNumber() != null) {
            this.itemNum = this.editData.getNumber();
        }
        super.doAfterSubmit(pk);
    }

    protected void init() throws Exception {
        if (!this.isHasCodeNumber()) {
            this.autoGetNumber();
        }
        BgItemGroupInfo itemGroupInfo = (BgItemGroupInfo)this.prmtBgItemGroup.getData();
        String _bgItemGroupId = itemGroupInfo.getId().toString();
        String number = this.txtNumber.getText();
        boolean hasChild = BgItemFactory.getRemoteInstance().checkHasChild(number, _bgItemGroupId);
        if (OprtState.EDIT.equals(this.getOprtState()) && hasChild) {
            this.txtNumber.setEnabled(false);
        }
    }

    private void autoGetNumber() throws Exception {
        if (!StringUtils.isEmpty((String)this.itemNum)) {
            int lastIndex = this.itemNum.lastIndexOf(".");
            if (lastIndex > 0) {
                String frist = this.itemNum.substring(0, lastIndex + 1);
                this.itemNum = BgItemFactory.getRemoteInstance().getMaxNumber(frist);
                String newEndStr = this.itemNum.substring(lastIndex + 1);
                int iEndStr = newEndStr.indexOf(".");
                if (iEndStr > 0) {
                    this.itemNum = this.itemNum.substring(0, lastIndex + 1) + newEndStr.substring(0, iEndStr);
                }
                lastIndex = this.itemNum.lastIndexOf(".");
                String last = this.itemNum.substring(lastIndex + 1);
                try {
                    Integer lastInt = Integer.valueOf(last);
                    int val = lastInt + 1;
                    int lenLast = last.length();
                    String sVal = String.valueOf(val);
                    int len = sVal.length();
                    String zero = "";
                    for (int i = 0; i < lenLast - len; ++i) {
                        zero = zero + "0";
                    }
                    this.itemNum = frist + zero + sVal;
                }
                catch (Exception e1) {
                    this.itemNum = "";
                }
            } else {
                this.itemNum = BgItemFactory.getRemoteInstance().getNumber(this.itemNum);
            }
            this.txtNumber.setText(this.itemNum);
            this.queryParnetItem();
        }
    }

    protected void initDefault() {
        this.comFpDirection.addItems(FpCashDirectionEnum.getEnumList().toArray());
        this.comFpDirection.setSelectedItem((Object)FpCashDirectionEnum.other);
        this.comElimType.addItems(BgElimTypeEnum.getEnumList().toArray());
        this.comElimType.setSelectedItem((Object)BgElimTypeEnum.None);
    }

    protected void initBase() {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        BgCommCHelper.disableVisible((JButton)this.btnAddNew, (JMenuItem)this.menuItemAddNew);
        BgCommCHelper.disableVisible((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit);
        BgCommCHelper.disableVisible((JButton)this.btnSave, (JMenuItem)this.menuItemSave);
        BgCommCHelper.disableVisible((JButton)this.btnCopy, (JMenuItem)this.menuItemCopy);
        BgCommCHelper.disableVisible((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove);
        BgCommCHelper.disableVisible((JButton)this.btnPrint, (JMenuItem)this.menuItemPrint);
        BgCommCHelper.disableVisible((JButton)this.btnPrintPreview, (JMenuItem)this.menuItemPrintPreview);
        BgCommCHelper.disableVisible((JButton)this.btnCancel, (JMenuItem)this.menuItemCancel);
        BgCommCHelper.disableVisible((JButton)this.btnCancelCancel, (JMenuItem)this.menuItemCancelCancel);
        BgCommCHelper.disableVisible((JButton)this.btnFirst, (JMenuItem)this.menuItemFirst);
        BgCommCHelper.disableVisible((JButton)this.btnPre, (JMenuItem)this.menuItemPre);
        BgCommCHelper.disableVisible((JButton)this.btnNext, (JMenuItem)this.menuItemNext);
        BgCommCHelper.disableVisible((JButton)this.btnLast, (JMenuItem)this.menuItemLast);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            BgCommCHelper.enableVisible((JButton)this.btnAddNew, null);
            BgCommCHelper.enableVisible((JButton)this.btnEdit, null);
            BgCommCHelper.enableVisible((JButton)this.btnSubmit, null);
            BgCommCHelper.disableAction((JButton)this.btnSubmit);
        }
    }

    protected IObjectValue createNewData() {
        OrgUnitInfo orgObject;
        BgItemInfo itemInfo = new BgItemInfo();
        itemInfo.setId(BOSUuid.create((BOSObjectType)itemInfo.getBOSType()));
        itemInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        itemInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        itemInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        Object userObject = this.getUIContext().get("ParentNode");
        if (userObject != null && userObject instanceof BgItemGroupInfo) {
            itemInfo.setBgItemGroup((BgItemGroupInfo)userObject);
        }
        if ((orgObject = this.getOrgUnitInfo()) instanceof OrgUnitInfo) {
            itemInfo.setOrgUnit(orgObject.castToFullOrgUnitInfo());
        }
        return itemInfo;
    }

    protected void applyDefaultValue(IObjectValue vo) {
        super.applyDefaultValue(vo);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            BgItemInfo itemInfo = (BgItemInfo)vo;
            Object obj = this.getUIContext().get(BgBaseConstants.BGITEMGROUP_INFO);
            if (obj instanceof BgItemGroupInfo) {
                itemInfo.setBgItemGroup((BgItemGroupInfo)obj);
            }
            if ((obj = this.getUIContext().get(BgBaseConstants.BGITEM_INFO)) instanceof BgItemInfo) {
                itemInfo.setParent((BgItemInfo)obj);
                this.itemNum = ((BgItemInfo)obj).getNumber();
            }
            if ((obj = this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO)) instanceof OrgUnitInfo) {
                itemInfo.setOrgUnit(((OrgUnitInfo)obj).castToFullOrgUnitInfo());
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgItemFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("bgItemGroup.id");
        sic.add("bgItemGroup.number");
        sic.add("bgItemGroup.name");
        sic.add("parent.id");
        sic.add("parent.number");
        sic.add("parent.name");
        sic.add("creator.id");
        sic.add("creator.number");
        sic.add("creator.name");
        sic.add("createTime");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("isForFP");
        sic.add("fpDirection");
        sic.add("elimType");
        sic.add("dataRelation");
        sic.add("description");
        sic.add("relation.id");
        sic.add("relation.orgUnitID");
        sic.add("relation.isEffective");
        return sic;
    }

    protected void loadData() throws Exception {
        super.loadData();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String OUID = ((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO)).getId().toString();
            this.setHasCodeNumber(BgCodeNumberCHelper.hasCodeNumber((IObjectValue)this.editData, OUID));
            if (this.isHasCodeNumber()) {
                this.setHasShowCodeNumber(BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)this.editData, OUID));
            }
            this.getNumberByCodingRule((IObjectValue)this.editData, OUID);
        }
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        if (this.isHasCodeNumber() && this.isHasShowCodeNumber()) {
            BgCodeNumberCHelper.applyNumber(this.txtNumber, (IObjectValue)this.editData, orgId, this.isHasCodeNumber(), this.isHasShowCodeNumber());
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        LanguageInfo currLang = this.getCurrentLanguage();
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "noNum"));
                SysUtil.abort();
            } else if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "haveEspecial"));
                SysUtil.abort();
            }
        }
        if (this.txtName.getItemBy(currLang).getData() == null || StringUtils.isEmpty((String)this.txtName.getItemBy(currLang).getData().toString())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "noName"));
            SysUtil.abort();
        }
    }

    @Override
    protected void txtNumber_focusLost(FocusEvent e) throws Exception {
        super.txtNumber_focusLost(e);
        this.queryParnetItem();
    }

    protected void queryParnetItem() throws Exception {
        String number;
        int index;
        this.prmtParent.setData(null);
        if (!StringUtils.isEmpty((String)this.txtNumber.getText()) && (index = (number = this.txtNumber.getText()).lastIndexOf(".")) >= 0) {
            String _pNumber = number.substring(0, number.lastIndexOf("."));
            BgItemGroupInfo itemGroupInfo = (BgItemGroupInfo)this.prmtBgItemGroup.getData();
            String _bgItemGroupId = itemGroupInfo.getId().toString();
            if (_pNumber != null && _bgItemGroupId != null) {
                String _ksql = "select bgItem.id, bgItem.name, bgItem.number, bgItem.longnumber, bgItem.level where bgItem.number = '" + _pNumber + "' and bgItem.bgItemGroup.id = '" + _bgItemGroupId + "' and (orgUnitID = '" + this.getOrgUnitInfo().getId().toString() + "' or bgItem.bgItemGroup.global = 1)";
                BgItemRelationCollection itemInfos = BgItemRelationFactory.getRemoteInstance().getBgItemRelationCollection(_ksql);
                if (itemInfos != null && itemInfos.size() > 0) {
                    this.prmtParent.setData((Object)itemInfos.get(0).getBgItem());
                } else {
                    MsgBox.showWarning((String)new BgItemException(BgItemException.PARENTNOTEXIST, new String[]{_pNumber}).getMessage());
                    SysUtil.abort();
                }
            }
        }
    }

    @Override
    protected void chkIsFp_stateChanged(ChangeEvent e) throws Exception {
        super.chkIsFp_stateChanged(e);
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            if (this.chkIsFp.isSelected()) {
                this.comFpDirection.setEnabled(true);
            } else {
                this.comFpDirection.setEnabled(false);
                this.comFpDirection.setSelectedItem((Object)FpCashDirectionEnum.other);
                this.editData.setFpDirection(FpCashDirectionEnum.other);
            }
        }
    }

    @Override
    protected void comElimType_itemStateChanged(ItemEvent e) throws Exception {
        super.comElimType_itemStateChanged(e);
        if (e.getItem().equals((Object)BgElimTypeEnum.None)) {
            this.rbDebtor.setSelected(true);
            this.selDataRelation = false;
        } else {
            this.selDataRelation = true;
        }
    }

    @Override
    protected void rbDebtor_actionPerformed(ActionEvent e) throws Exception {
        super.rbDebtor_actionPerformed(e);
        this.selDataRelation = true;
    }

    @Override
    protected void rbCreditor_actionPerformed(ActionEvent e) throws Exception {
        super.rbCreditor_actionPerformed(e);
        this.selDataRelation = true;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.txtNumber.setEnabled(true);
        this.getNumberByCodingRule((IObjectValue)this.editData, this.getOrgUnitInfo().getId().toString());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.txtNumber.setEnabled(false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        this.queryParnetItem();
    }

    protected void doBeforeSubmit(ActionEvent e) throws Exception {
        super.doBeforeSubmit(e);
        if (this.selDataRelation) {
            if (this.rbDebtor.isSelected()) {
                this.editData.setDataRelation(BgDataRelationEnum.DebitAdd);
            }
            if (this.rbCreditor.isSelected()) {
                this.editData.setDataRelation(BgDataRelationEnum.DebitMinus);
            }
        }
        if (this.comElimType.getSelectedItem().equals((Object)BgElimTypeEnum.None)) {
            this.editData.setDataRelation(BgDataRelationEnum.DebitDefault);
        }
    }

    protected boolean isContinueAddNew() {
        return false;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put(BgBaseConstants.ORGUNIT_INFO, (Object)this.getOrgUnitInfo());
        }
        return handler;
    }
}

